/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.AccountBillStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.CreditStatementStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.FreeGiftSummaryReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrderDetailStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.RebateDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrderDetailStatisticsRespDto;
import com.dtyunxi.tcbj.api.query.IBrandReportQueryApi;
import com.dtyunxi.tcbj.api.query.IDistributorReportQueryApi;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.utils.ThreadPoolUtil;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.AccountBillOfBrandVo;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.AccountBillVo;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.CreditOfBrandVo;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.CreditVo;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.DiscountOfBrandVo;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.DiscountVo;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.FreeGiftSummaryVo;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.OrderDetailStatisticsExportVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="operationAnalyseExportService")
public class OperationAnalyseExportService {
    private static final Logger logger = LoggerFactory.getLogger(OperationAnalyseExportService.class);
    private static final Integer totalMax = 100000;
    private static final Integer batchNum = 5000;
    @Resource
    private ExportService exportService;
    @Resource
    private IDistributorReportQueryApi distributorReportQueryApi;
    @Resource
    private IBrandReportQueryApi brandReportQueryApi;
    @Resource
    private IContext context;
    @Resource
    private HttpServletRequest request;

    @Deprecated
    public RestResponse<Object> exportOrderDetailStatistics(OrderDetailStatisticsReqDto reqDto) {
        logger.info("\u5bfc\u5165\u8ba2\u5355\u660e\u7ec6\u6c47\u603b\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setPageNum(1);
        reqDto.setPageSize(1);
        PageInfo pageInfoOne = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.orderDetailStatistics(reqDto));
        this.checkExportRestriction(pageInfoOne);
        String orgId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        String fileName = "\u8fd0\u8425\u5206\u6790\u62a5\u8868_\u8ba2\u5355\u660e\u7ec6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.OA_ORDER_DETAIL);
        Long uesrId = this.context.userId();
        ThreadPoolUtil.executorService.submit(() -> {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
            this.context.userId(uesrId);
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{},UUID:{}", (Object)fileName, (Object)uuid);
            try {
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                ArrayList list = Lists.newArrayList();
                while (total == null || (double)pageNum.intValue() <= num) {
                    reqDto.setPageNum(pageNum.intValue());
                    reqDto.setPageSize(pageSize.intValue());
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u6c47\u603b\u53c2\u6570:{},UUID:{}", (Object)JSONObject.toJSONString((Object)reqDto), (Object)uuid);
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.orderDetailStatistics(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u6c47\u603b\u7ed3\u679c:{},UUID:{}", (Object)pageInfo.getList().size(), (Object)uuid);
                        list.addAll(pageInfo.getList());
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{uuid, total, num});
                    }
                    pageNum = pageNum + 1;
                }
                logger.info("\u8ba2\u5355\u660e\u7ec6\u6c47\u603b\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{},UUID:{}", (Object)list.size(), (Object)uuid);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    ArrayList rList = Lists.newArrayList();
                    for (OrderDetailStatisticsRespDto govern : list) {
                        OrderDetailStatisticsExportVo vo = new OrderDetailStatisticsExportVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)govern, (String[])new String[0]);
                        rList.add(vo);
                    }
                    String excelName = "cube/" + fileName;
                    try {
                        String exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, OrderDetailStatisticsExportVo.class, null, (String)excelName, (String)"xls");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u5bfc\u51fa\u8ba2\u5355\u660e\u7ec6\u6c47\u603b-\u9519\u8bef:{}", (Object)e.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u8ba2\u5355\u660e\u7ec6\u6c47\u603b-\u9519\u8bef1:" + e);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u8ba2\u5355\u660e\u7ec6\u6c47\u603b,\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa\u8ba2\u5355\u660e\u7ec6\u6c47\u603b-\u9519\u8bef2:{}", (Object)e.toString());
                this.exportService.fail(id, "\u5bfc\u51fa\u8ba2\u5355\u660e\u7ec6\u6c47\u603b-\u9519\u8bef2:" + e);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u8ba2\u5355\u660e\u7ec6\u6c47\u603b\u64cd\u4f5c\u6210\u529f");
    }

    @Deprecated
    public RestResponse<Object> exportFreeGiftSummaryStatistics(FreeGiftSummaryReqDto reqDto) {
        logger.info("\u514d\u8d39\u8d60\u54c1\u6c47\u603b\uff08\u5927B\u7aef\uff09\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setPageNum(1);
        reqDto.setPageSize(1);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.freeGiftSummaryStatistics(reqDto));
        this.checkExportRestriction(pageInfo);
        String fileName = "\u8fd0\u8425\u5206\u6790\u62a5\u8868_\u514d\u8d39\u8d60\u54c1\u6c47\u603b_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.GIFT_COLLECT);
        Long userId = this.context.userId();
        String orgId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        ThreadPoolUtil.executorService.submit(() -> {
            try {
                ServiceContext.getContext().setAttachment("yes-req-cus-b2b-organizationId", orgId);
                logger.info("\u5f02\u6b65\u6267\u884c\u514d\u8d39\u8d60\u54c1\u6c47\u603b\uff08\u5927B\u7aef\uff09");
                String uuid = UUID.randomUUID().toString().replace("-", "");
                ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
                this.context.userId(userId);
                List pageList = pageInfo.getList();
                ArrayList exportDtoList = new ArrayList(pageList);
                reqDto.setPageSize(batchNum.intValue());
                while (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    reqDto.setPageNum(reqDto.getPageNum() + 1);
                    PageInfo batchPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.freeGiftSummaryStatistics(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)batchPageInfo.getList())) {
                        exportDtoList.addAll(batchPageInfo.getList());
                    }
                    pageList = batchPageInfo.getList();
                }
                List exportVoList = exportDtoList.stream().map(dto -> {
                    FreeGiftSummaryVo vo = new FreeGiftSummaryVo();
                    CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                    return vo;
                }).collect(Collectors.toList());
                String excelName = "cube/" + fileName;
                String exportUrl = EasyPoiExportUtil.getExportUrl(exportVoList, FreeGiftSummaryVo.class, null, (String)excelName, (String)"xls");
                this.exportService.success(id, exportUrl);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Object)(fileName + "-" + id));
                this.exportService.fail(id, "\u5bfc\u51fa\u5931\u8d25\uff1a\u7a0b\u5e8f\u5f02\u5e38");
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u64cd\u4f5c\u6210\u529f");
    }

    @Deprecated
    public RestResponse<Object> exportFreeGiftSummaryStatisticsOfBrand(FreeGiftSummaryReqDto reqDto) {
        logger.info("\u514d\u8d39\u8d60\u54c1\u6c47\u603b\uff08\u54c1\u724c\u7aef\uff09\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setPageNum(1);
        reqDto.setPageSize(1);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.brandReportQueryApi.freeGiftSummaryStatistics(reqDto));
        this.checkExportRestriction(pageInfo);
        String fileName = "\u8fd0\u8425\u5206\u6790\u62a5\u8868_\u514d\u8d39\u8d60\u54c1\u6c47\u603b_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.GIFT_COLLECT);
        Long userId = this.context.userId();
        ThreadPoolUtil.executorService.submit(() -> {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
            this.context.userId(userId);
            List pageList = pageInfo.getList();
            ArrayList exportDtoList = new ArrayList(pageList);
            reqDto.setPageSize(batchNum.intValue());
            while (CollectionUtils.isNotEmpty((Collection)pageList)) {
                reqDto.setPageNum(reqDto.getPageNum() + 1);
                PageInfo batchPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.freeGiftSummaryStatistics(reqDto));
                if (CollectionUtils.isNotEmpty((Collection)batchPageInfo.getList())) {
                    exportDtoList.addAll(batchPageInfo.getList());
                }
                pageList = batchPageInfo.getList();
            }
            List exportVoList = exportDtoList.stream().map(dto -> {
                FreeGiftSummaryVo vo = new FreeGiftSummaryVo();
                CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                return vo;
            }).collect(Collectors.toList());
            String excelName = "cube/" + fileName;
            String exportUrl = EasyPoiExportUtil.getExportUrl(exportVoList, FreeGiftSummaryVo.class, null, (String)excelName, (String)"xls");
            this.exportService.success(id, exportUrl);
        });
        return new RestResponse("0", "\u5bfc\u51fa\u64cd\u4f5c\u6210\u529f");
    }

    @Deprecated
    public RestResponse<Object> exportDiscountStatistics(RebateDetailReqDto reqDto) {
        logger.info("\u6298\u6263\u6c47\u603b\uff08\u5927B\u7aef\uff09\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setPageNum(1);
        reqDto.setPageSize(1);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.discountStatistics(reqDto));
        this.checkExportRestriction(pageInfo);
        String fileName = "\u8fd0\u8425\u5206\u6790\u62a5\u8868_\u6298\u6263\u6c47\u603b_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.DISCOUNT_COLLECT);
        Long userId = this.context.userId();
        ThreadPoolUtil.executorService.submit(() -> {
            try {
                logger.info("\u5f02\u6b65\u6267\u884c\u6298\u6263\u6c47\u603b\uff08\u5927B\u7aef\uff09");
                String uuid = UUID.randomUUID().toString().replace("-", "");
                ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
                this.context.userId(userId);
                List pageList = pageInfo.getList();
                ArrayList exportDtoList = new ArrayList(pageList);
                reqDto.setPageSize(batchNum.intValue());
                while (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    reqDto.setPageNum(reqDto.getPageNum() + 1);
                    PageInfo batchPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.discountStatistics(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)batchPageInfo.getList())) {
                        exportDtoList.addAll(batchPageInfo.getList());
                    }
                    pageList = batchPageInfo.getList();
                }
                List exportVoList = exportDtoList.stream().map(dto -> {
                    DiscountVo vo = new DiscountVo();
                    CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                    return vo;
                }).collect(Collectors.toList());
                String excelName = "cube/" + fileName;
                String exportUrl = EasyPoiExportUtil.getExportUrl(exportVoList, DiscountVo.class, null, (String)excelName, (String)"xls");
                this.exportService.success(id, exportUrl);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(id, "\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u64cd\u4f5c\u6210\u529f");
    }

    @Deprecated
    public RestResponse<Object> exportDiscountStatisticsOfBrand(RebateDetailReqDto reqDto) {
        logger.info("\u6298\u6263\u6c47\u603b\uff08\u54c1\u724c\u7aef\uff09\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setPageNum(1);
        reqDto.setPageSize(1);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.brandReportQueryApi.discountStatistics(reqDto));
        this.checkExportRestriction(pageInfo);
        String fileName = "\u8fd0\u8425\u5206\u6790\u62a5\u8868_\u6298\u6263\u6c47\u603b_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.DISCOUNT_COLLECT);
        Long userId = this.context.userId();
        ThreadPoolUtil.executorService.submit(() -> {
            try {
                logger.info("\u5f02\u6b65\u6267\u884c\u6298\u6263\u6c47\u603b\uff08\u54c1\u724c\u7aef\uff09");
                String uuid = UUID.randomUUID().toString().replace("-", "");
                ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
                this.context.userId(userId);
                List pageList = pageInfo.getList();
                ArrayList exportDtoList = new ArrayList(pageList);
                reqDto.setPageSize(batchNum.intValue());
                while (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    reqDto.setPageNum(reqDto.getPageNum() + 1);
                    PageInfo batchPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.brandReportQueryApi.discountStatistics(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)batchPageInfo.getList())) {
                        exportDtoList.addAll(batchPageInfo.getList());
                    }
                    pageList = batchPageInfo.getList();
                }
                List exportVoList = exportDtoList.stream().map(dto -> {
                    DiscountOfBrandVo vo = new DiscountOfBrandVo();
                    CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                    return vo;
                }).collect(Collectors.toList());
                String excelName = "cube/" + fileName;
                String exportUrl = EasyPoiExportUtil.getExportUrl(exportVoList, DiscountOfBrandVo.class, null, (String)excelName, (String)"xls");
                this.exportService.success(id, exportUrl);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(id, "\u5bfc\u51fa\u5931\u8d25\uff1a\u7a0b\u5e8f\u5f02\u5e38");
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u64cd\u4f5c\u6210\u529f");
    }

    @Deprecated
    public RestResponse<Object> exportCreditStatistics(CreditStatementStatisticsReqDto reqDto) {
        logger.info("\u6388\u4fe1\u8d26\u5355\u6c47\u603b\uff08\u5927B\u7aef\uff09\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setPageNum(1);
        reqDto.setPageSize(1);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.creditStatementStatistics(reqDto));
        this.checkExportRestriction(pageInfo);
        String fileName = "\u8fd0\u8425\u5206\u6790\u62a5\u8868_\u6388\u4fe1\u8d26\u5355\u6c47\u603b_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.CREDIT_COLLECT);
        Long userId = this.context.userId();
        ThreadPoolUtil.executorService.submit(() -> {
            try {
                logger.info("\u5f02\u6b65\u6267\u884c\u6388\u4fe1\u8d26\u5355\u6c47\u603b\uff08\u5927B\u7aef\uff09");
                String uuid = UUID.randomUUID().toString().replace("-", "");
                ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
                this.context.userId(userId);
                List pageList = pageInfo.getList();
                ArrayList exportDtoList = new ArrayList(pageList);
                reqDto.setPageSize(batchNum.intValue());
                while (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    reqDto.setPageNum(reqDto.getPageNum() + 1);
                    PageInfo batchPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.creditStatementStatistics(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)batchPageInfo.getList())) {
                        exportDtoList.addAll(batchPageInfo.getList());
                    }
                    pageList = batchPageInfo.getList();
                }
                List exportVoList = exportDtoList.stream().map(dto -> {
                    CreditVo vo = new CreditVo();
                    CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                    return vo;
                }).collect(Collectors.toList());
                String excelName = "cube/" + fileName;
                String exportUrl = EasyPoiExportUtil.getExportUrl(exportVoList, CreditVo.class, null, (String)excelName, (String)"xls");
                this.exportService.success(id, exportUrl);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(id, "\u5bfc\u51fa\u5931\u8d25\uff1a\u7a0b\u5e8f\u5f02\u5e38");
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u64cd\u4f5c\u6210\u529f");
    }

    @Deprecated
    public RestResponse<Object> exportCreditStatisticsOfBrand(CreditStatementStatisticsReqDto reqDto) {
        logger.info("\u6388\u4fe1\u8d26\u5355\u6c47\u603b\uff08\u54c1\u724c\u7aef\uff09\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setPageNum(1);
        reqDto.setPageSize(1);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.brandReportQueryApi.creditStatementStatistics(reqDto));
        this.checkExportRestriction(pageInfo);
        String fileName = "\u8fd0\u8425\u5206\u6790\u62a5\u8868_\u6388\u4fe1\u8d26\u5355\u6c47\u603b_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.DISCOUNT_COLLECT);
        Long userId = this.context.userId();
        ThreadPoolUtil.executorService.submit(() -> {
            try {
                logger.info("\u5f02\u6b65\u6267\u884c\u6388\u4fe1\u8d26\u5355\u6c47\u603b\uff08\u54c1\u724c\u7aef\uff09");
                String uuid = UUID.randomUUID().toString().replace("-", "");
                ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
                this.context.userId(userId);
                List pageList = pageInfo.getList();
                ArrayList exportDtoList = new ArrayList(pageList);
                reqDto.setPageSize(batchNum.intValue());
                while (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    reqDto.setPageNum(reqDto.getPageNum() + 1);
                    PageInfo batchPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.brandReportQueryApi.creditStatementStatistics(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)batchPageInfo.getList())) {
                        exportDtoList.addAll(batchPageInfo.getList());
                    }
                    pageList = batchPageInfo.getList();
                }
                List exportVoList = exportDtoList.stream().map(dto -> {
                    CreditOfBrandVo vo = new CreditOfBrandVo();
                    CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                    return vo;
                }).collect(Collectors.toList());
                String excelName = "cube/" + fileName;
                String exportUrl = EasyPoiExportUtil.getExportUrl(exportVoList, CreditOfBrandVo.class, null, (String)excelName, (String)"xls");
                this.exportService.success(id, exportUrl);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(id, "\u5bfc\u51fa\u5931\u8d25\uff1a\u7a0b\u5e8f\u5f02\u5e38");
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u64cd\u4f5c\u6210\u529f");
    }

    @Deprecated
    public RestResponse<Object> exportAccountBillStatistics(AccountBillStatisticsReqDto reqDto) {
        logger.info("\u8d26\u671f\u6c47\u603b\uff08\u5927B\u7aef\uff09\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setPageNum(1);
        reqDto.setPageSize(1);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.accountBillStatistics(reqDto));
        this.checkExportRestriction(pageInfo);
        String fileName = "\u8fd0\u8425\u5206\u6790\u62a5\u8868_\u8d26\u671f\u6c47\u603b_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.ACCOUNT_BILL_COLLECT);
        Long userId = this.context.userId();
        ThreadPoolUtil.executorService.submit(() -> {
            try {
                logger.info("\u5f02\u6b65\u6267\u884c\u8d26\u671f\u6c47\u603b\uff08\u5927B\u7aef\uff09");
                String uuid = UUID.randomUUID().toString().replace("-", "");
                ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
                this.context.userId(userId);
                List pageList = pageInfo.getList();
                ArrayList exportDtoList = new ArrayList(pageList);
                reqDto.setPageSize(batchNum.intValue());
                while (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    reqDto.setPageNum(reqDto.getPageNum() + 1);
                    PageInfo batchPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.accountBillStatistics(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)batchPageInfo.getList())) {
                        exportDtoList.addAll(batchPageInfo.getList());
                    }
                    pageList = batchPageInfo.getList();
                }
                List exportVoList = exportDtoList.stream().map(dto -> {
                    AccountBillVo vo = new AccountBillVo();
                    CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                    return vo;
                }).collect(Collectors.toList());
                String excelName = "cube/" + fileName;
                String exportUrl = EasyPoiExportUtil.getExportUrl(exportVoList, AccountBillVo.class, null, (String)excelName, (String)"xls");
                this.exportService.success(id, exportUrl);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(id, "\u5bfc\u51fa\u5931\u8d25\uff1a\u7a0b\u5e8f\u5f02\u5e38");
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u64cd\u4f5c\u6210\u529f");
    }

    @Deprecated
    public RestResponse<Object> exportAccountBillStatisticsOfBrand(AccountBillStatisticsReqDto reqDto) {
        logger.info("\u8d26\u671f\u6c47\u603b\uff08\u54c1\u724c\u7aef\uff09\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setPageNum(1);
        reqDto.setPageSize(1);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.brandReportQueryApi.accountBillStatistics(reqDto));
        this.checkExportRestriction(pageInfo);
        String fileName = "\u8fd0\u8425\u5206\u6790\u62a5\u8868_\u8d26\u671f\u6c47\u603b_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.ACCOUNT_BILL_COLLECT);
        Long userId = this.context.userId();
        ThreadPoolUtil.executorService.submit(() -> {
            try {
                logger.info("\u5f02\u6b65\u6267\u884c\u8d26\u671f\u6c47\u603b\uff08\u54c1\u724c\u7aef\uff09");
                String uuid = UUID.randomUUID().toString().replace("-", "");
                ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
                this.context.userId(userId);
                List pageList = pageInfo.getList();
                ArrayList exportDtoList = new ArrayList(pageList);
                reqDto.setPageSize(batchNum.intValue());
                while (CollectionUtils.isNotEmpty((Collection)pageList)) {
                    reqDto.setPageNum(reqDto.getPageNum() + 1);
                    PageInfo batchPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.distributorReportQueryApi.accountBillStatistics(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)batchPageInfo.getList())) {
                        exportDtoList.addAll(batchPageInfo.getList());
                    }
                    pageList = batchPageInfo.getList();
                }
                List exportVoList = exportDtoList.stream().map(dto -> {
                    AccountBillOfBrandVo vo = new AccountBillOfBrandVo();
                    CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                    return vo;
                }).collect(Collectors.toList());
                String excelName = "cube/" + fileName;
                String exportUrl = EasyPoiExportUtil.getExportUrl(exportVoList, AccountBillOfBrandVo.class, null, (String)excelName, (String)"xls");
                this.exportService.success(id, exportUrl);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(id, "\u5bfc\u51fa\u5931\u8d25\uff1a\u7a0b\u5e8f\u5f02\u5e38");
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u64cd\u4f5c\u6210\u529f");
    }

    private void checkExportRestriction(PageInfo pageInfo) {
        if (ObjectUtils.isEmpty((Object)pageInfo) || ObjectUtils.isEmpty((Object)pageInfo.getTotal())) {
            throw new BizException("-1", "\u6570\u636e\u67e5\u8be2\u5f02\u5e38");
        }
        if (pageInfo.getTotal() <= 0L) {
            throw new BizException("-1", "\u65e0\u6570\u636e\u53ef\u5bfc\u51fa");
        }
        if (pageInfo.getTotal() > (long)totalMax.intValue()) {
            throw new BizException("-1", "\u5bfc\u51fa\u6570\u636e\u7684\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7" + totalMax + "\u6761");
        }
    }
}

