/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ControlExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.StoreExtExportVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizSystemEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryReqDto;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StoreExportService {
    private static final Logger logger = LoggerFactory.getLogger(ControlExportService.class);
    @Resource
    private ExportService exportService;
    @Resource
    private IStoreQueryApi storeQueryApi;

    public RestResponse<Object> exportStore(StoreQueryReqDto storeQueryReqDto) {
        logger.info("export store data req params : {} .", (Object)JSON.toJSONString((Object)storeQueryReqDto));
        BaseExportService baseExportService = new BaseExportService(ExportTypeEnum.STORE_EXT.getName(), ExportTypeEnum.STORE_EXT);
        baseExportService.executor(req -> {
            storeQueryReqDto.setPageNum(1);
            storeQueryReqDto.setPageSize(Integer.MAX_VALUE);
            PageInfo storeRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.storeQueryApi.queryPage(storeQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)storeRespDtoPageInfo.getList())) {
                List storeExtExportVoList = storeRespDtoPageInfo.getList().stream().map(c -> {
                    StoreExtExportVo storeExtExportVo = new StoreExtExportVo();
                    CubeBeanUtils.copyProperties((Object)storeExtExportVo, (Object)c, (String[])new String[0]);
                    storeExtExportVo.setIsCustomer(YesOrNoEnum.YES.getCode().equals(c.getIsCustomer()) ? YesOrNoEnum.YES.getValue() : YesOrNoEnum.YES.getValue());
                    storeExtExportVo.setBizChannel(StringUtils.join((Iterable)Arrays.stream(c.getBizChannel().split(",")).map(channelCode -> BizChannelEnum.enumOfChannelCode((String)channelCode).getChannelName()).collect(Collectors.toList()), (String)","));
                    storeExtExportVo.setIsFlag(YesOrNoEnum.YES.getCode().equals(c.getIsFlag()) ? YesOrNoEnum.YES.getValue() : YesOrNoEnum.NO.getValue());
                    storeExtExportVo.setIsFirstPartner(YesOrNoEnum.YES.getCode().equals(c.getIsFirstPartner()) ? YesOrNoEnum.YES.getValue() : YesOrNoEnum.NO.getValue());
                    storeExtExportVo.setIsReplenish(YesOrNoEnum.YES.getCode().equals(c.getIsReplenish()) ? YesOrNoEnum.YES.getValue() : YesOrNoEnum.NO.getValue());
                    storeExtExportVo.setCustomerSystem(null != BizSystemEnum.enumOfBizSystemCode((Integer)c.getCustomerSystem()) ? BizSystemEnum.enumOfBizSystemCode((Integer)c.getCustomerSystem()).getName() : "");
                    return storeExtExportVo;
                }).collect(Collectors.toList());
                baseExportService.exportUrl(storeExtExportVoList, StoreExtExportVo.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.STORE_EXT.getName() + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + ExportTypeEnum.STORE_EXT.getName() + "\u6210\u529f");
    }
}

