/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportInfoReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.CreditApplyImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportService;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditAccountApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditApplyApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyAuditSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyDetailsSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyQuotaItemSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplySaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditDownSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRecordBatchSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditTermModelSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PageDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PolicySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditTermModelRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.PolicyInfoRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.AllowAddEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditAccountStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditApplyStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRecordStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.QuotaTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditAccountQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditEntityQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditTermModelQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.IPolicyQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="creditApplyImportService")
public class CreditApplyImportService
extends ImportService {
    private static final String APPROVE_RESULT = "\u5bfc\u5165\u6388\u4fe1\u7533\u8bf7\u5355\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7";
    private static final String DEFAULT_MODEL_NAME = "\u9ed8\u8ba4\u8d26\u671f\u6a21\u578b";
    private static final String DEFAULT_EDJY_RULE_NAME = "\u9ed8\u8ba4\u989d\u5ea6\u6821\u9a8c\u7b56\u7565";
    private static final String DEFAULT_YQ_RULE_NAME = "\u9ed8\u8ba4\u903e\u671f\u6821\u9a8c\u7b56\u7565";
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICreditEntityQueryApi creditEntityQueryApi;
    @Resource
    private ICreditApplyApi creditApplyApi;
    @Resource
    private ICreditAccountApi creditAccountApi;
    @Resource
    private ICreditTermModelQueryApi creditTermModelQueryApi;
    @Resource
    private IPolicyQueryApi policyQueryApi;
    @Resource
    private ICreditAccountQueryApi creditAccountQueryApi;

    @Override
    public void definedImport(Long organizationId, Object list, List<BaseImportInfoReqDto> errorList, Set<String> importDataUniquekeySet) {
        CreditTermModelSearchReqDto creditTermModelSearchReqDto = new CreditTermModelSearchReqDto();
        creditTermModelSearchReqDto.setPageNum(Integer.valueOf(1));
        creditTermModelSearchReqDto.setPageSize(Integer.valueOf(100));
        PageInfo modelPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.creditTermModelQueryApi.queryPage((PageDto)creditTermModelSearchReqDto));
        CreditTermModelRespDto defModelDto = null;
        if (modelPageInfo != null && CollectionUtil.isNotEmpty((Collection)modelPageInfo.getList())) {
            defModelDto = modelPageInfo.getList().stream().filter(model -> Objects.equals(model.getName(), DEFAULT_MODEL_NAME)).findFirst().orElse(null);
        }
        PolicySearchReqDto policySearchReqDto = new PolicySearchReqDto();
        policySearchReqDto.setPageNum(Integer.valueOf(1));
        policySearchReqDto.setPageSize(Integer.valueOf(1000));
        PageInfo policyInfoRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.policyQueryApi.queryPageDetail(policySearchReqDto));
        PolicyInfoRespDto defCheckRuleDto = null;
        PolicyInfoRespDto defYQRuleDto = null;
        if (policyInfoRespDtoPageInfo != null && CollectionUtil.isNotEmpty((Collection)policyInfoRespDtoPageInfo.getList())) {
            for (PolicyInfoRespDto policyInfoRespDto : policyInfoRespDtoPageInfo.getList()) {
                if (Objects.equals(policyInfoRespDto.getType(), 2) && Objects.equals(policyInfoRespDto.getName(), DEFAULT_EDJY_RULE_NAME)) {
                    defCheckRuleDto = policyInfoRespDto;
                    continue;
                }
                if (!Objects.equals(policyInfoRespDto.getType(), 1) || !Objects.equals(policyInfoRespDto.getName(), DEFAULT_YQ_RULE_NAME)) continue;
                defYQRuleDto = policyInfoRespDto;
            }
        }
        List creditApplyImportReqDtos = (List)list;
        List customerCodes = creditApplyImportReqDtos.stream().map(CreditApplyImportReqDto::getCustomerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        Map<Object, Object> creditEntityMap = Maps.newHashMap();
        Map<Object, Object> accountDtoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(customerCodes)) {
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(customerCodes));
            customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (e1, e2) -> e1));
            if (CollectionUtil.isNotEmpty((Collection)customerRespDtos)) {
                List customerIds = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
                CreditEntitySearchReqDto creditEntitySearchReqDto = new CreditEntitySearchReqDto();
                creditEntitySearchReqDto.setIds(customerIds);
                PageInfo creditEntityPageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.creditEntityQueryApi.pageCreditEntity(creditEntitySearchReqDto, Integer.valueOf(1), Integer.valueOf(customerIds.size())));
                if (creditEntityPageRespDtoPageInfo != null && CollectionUtil.isNotEmpty((Collection)creditEntityPageRespDtoPageInfo.getList())) {
                    creditEntityMap = creditEntityPageRespDtoPageInfo.getList().stream().collect(Collectors.toMap(CreditEntityPageRespDto::getId, Function.identity(), (e1, e2) -> e1));
                }
                CreditAccountSearchReqDto creditAccountSearchReqDto = new CreditAccountSearchReqDto();
                creditAccountSearchReqDto.setAccountIds(customerIds);
                List creditAccountPageRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.creditAccountQueryApi.queryAccountByEntityIds(creditAccountSearchReqDto));
                accountDtoMap = creditAccountPageRespDtos.stream().collect(Collectors.toMap(CreditAccountPageRespDto::getCreditEntityId, Function.identity(), (e1, e2) -> e1));
            }
        }
        for (CreditApplyImportReqDto creditApplyImportReqDto : creditApplyImportReqDtos) {
            CreditAccountPageRespDto creditAccountEo;
            CreditEntityPageRespDto entity;
            CustomerRespDto customerRespDto;
            StringBuilder sb = new StringBuilder(80);
            if (StringUtils.isBlank((CharSequence)creditApplyImportReqDto.getCustomerCode())) {
                sb.append("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            QuotaTypeEnum quotaTypeEnum = null;
            if (StringUtils.isBlank((CharSequence)creditApplyImportReqDto.getQuotaType())) {
                sb.append("\u989d\u5ea6\u7c7b\u578b\u4e3a\u7a7a");
            } else {
                quotaTypeEnum = QuotaTypeEnum.fromName((String)creditApplyImportReqDto.getQuotaType());
                if (quotaTypeEnum == null) {
                    sb.append("\u989d\u5ea6\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7c7b\u578b\uff1a\u5e38\u89c4\u989d\u5ea6\uff0c\u4e34\u65f6\u989d\u5ea6\uff1b");
                }
            }
            BigDecimal quota = null;
            if (!NumberUtil.isNumber((CharSequence)creditApplyImportReqDto.getQuota())) {
                sb.append("\u65b0\u589e\u6388\u4fe1\u91d1\u989d\u5fc5\u987b\u8f93\u5165\u6570\u5b57\uff1b");
            } else {
                quota = new BigDecimal(creditApplyImportReqDto.getQuota());
                if (quota.compareTo(BigDecimal.ZERO) == 0) {
                    sb.append("\u65b0\u589e\u6388\u4fe1\u91d1\u989d\u4e0d\u80fd\u4e3a0\uff1b");
                }
                if (quota.stripTrailingZeros().scale() > 2) {
                    sb.append("\u65b0\u589e\u6388\u4fe1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4e24\u4f4d\u5c0f\u6570\uff1b");
                }
            }
            Date date = new Date();
            Date startDate = null;
            if (StringUtils.isBlank((CharSequence)creditApplyImportReqDto.getStartDate())) {
                sb.append("\u989d\u5ea6\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a\uff1b");
            } else if (!super.isValidDateFormat(creditApplyImportReqDto.getStartDate())) {
                sb.append("\u989d\u5ea6\u5f00\u59cb\u65f6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528yyyy-MM-dd\u683c\u5f0f\uff1b");
            } else {
                startDate = DateUtil.parseDate((String)creditApplyImportReqDto.getStartDate(), (String)"yyyy-MM-dd");
            }
            Date endDate = null;
            if (StringUtils.isBlank((CharSequence)creditApplyImportReqDto.getEndDate())) {
                sb.append("\u989d\u5ea6\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a\uff1b");
            } else if (!super.isValidDateFormat(creditApplyImportReqDto.getEndDate())) {
                sb.append("\u989d\u5ea6\u5f00\u59cb\u65f6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528yyyy-MM-dd\u683c\u5f0f\uff1b");
            } else {
                endDate = DateUtil.parseDate((String)creditApplyImportReqDto.getEndDate(), (String)"yyyy-MM-dd");
                if (!date.before(endDate)) {
                    sb.append("\u989d\u5ea6\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u5929\uff1b");
                }
            }
            if (startDate != null && endDate != null && !startDate.before(endDate)) {
                sb.append("\u989d\u5ea6\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u989d\u5ea6\u7ed3\u675f\u65f6\u95f4\uff1b");
            }
            if ((customerRespDto = (CustomerRespDto)customerRespDtoMap.get(creditApplyImportReqDto.getCustomerCode())) == null || !Objects.equals(customerRespDto.getMerchantId(), organizationId)) {
                sb.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
            }
            if ((entity = (CreditEntityPageRespDto)creditEntityMap.get(customerRespDto.getId())) == null && AllowAddEnum.YES.getCode().equals(entity.getAllowAdd())) {
                sb.append("\u5ba2\u6237\u6388\u4fe1\u672a\u51c6\u5165\uff0c\u5148\u8fdb\u884c\u5ba2\u6237\u51c6\u5165\u64cd\u4f5c\uff1b");
            }
            if ((creditAccountEo = (CreditAccountPageRespDto)accountDtoMap.get(entity.getId())) == null) {
                if (defModelDto == null) {
                    sb.append("\u9ed8\u8ba4\u8d26\u671f\u6a21\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u5efa\u7acb\u6a21\u578b\u540d\u79f0\u4e3a'\u9ed8\u8ba4\u8d26\u671f\u6a21\u578b'\u7684\u8d26\u671f\u6a21\u578b");
                }
                if (defCheckRuleDto == null) {
                    sb.append("\u9ed8\u8ba4\u989d\u5ea6\u6821\u9a8c\u7b56\u7565\u4e0d\u5b58\u5728\uff0c\u8bf7\u5efa\u7acb\u6a21\u578b\u540d\u79f0\u4e3a'\u9ed8\u8ba4\u989d\u5ea6\u6821\u9a8c\u7b56\u7565'\u7684\u989d\u5ea6\u6821\u9a8c\u7b56\u7565");
                }
                if (defYQRuleDto == null) {
                    sb.append("\u9ed8\u8ba4\u903e\u671f\u6821\u9a8c\u7b56\u7565\u4e0d\u5b58\u5728\uff0c\u8bf7\u5efa\u7acb\u6a21\u578b\u540d\u79f0\u4e3a'\u9ed8\u8ba4\u903e\u671f\u6821\u9a8c\u7b56\u7565'\u7684\u903e\u671f\u6821\u9a8c\u7b56\u7565");
                }
            }
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                CreditApplyDetailsSaveReqDto creditApplyDetailsSaveReqDto = new CreditApplyDetailsSaveReqDto();
                creditApplyDetailsSaveReqDto.setCreditEntityCode(entity.getCode());
                creditApplyDetailsSaveReqDto.setCreditEntityName(entity.getName());
                creditApplyDetailsSaveReqDto.setStartDate(startDate);
                creditApplyDetailsSaveReqDto.setEndDate(endDate);
                creditApplyDetailsSaveReqDto.setQuota(quota);
                CreditApplySaveReqDto creditApplySaveReqDto = new CreditApplySaveReqDto();
                creditApplySaveReqDto.setCreditEntityType(entity.getType());
                creditApplySaveReqDto.setQuotaType(quotaTypeEnum.getCode());
                creditApplySaveReqDto.setReason(creditApplyImportReqDto.getReason());
                creditApplySaveReqDto.setApplyDetails((List)Lists.newArrayList((Object[])new CreditApplyDetailsSaveReqDto[]{creditApplyDetailsSaveReqDto}));
                Long applyId = (Long)RestResponseHelper.extractData((RestResponse)this.creditApplyApi.addReturn(creditApplySaveReqDto));
                CreditApplyAuditSaveReqDto creditApplyAuditSaveReqDto = new CreditApplyAuditSaveReqDto();
                creditApplyAuditSaveReqDto.setCreditApplyStatus(CreditApplyStatusEnum.SUCCESS.getCode());
                creditApplyAuditSaveReqDto.setId(applyId);
                creditApplyAuditSaveReqDto.setApproveResult(APPROVE_RESULT);
                RestResponseHelper.extractData((RestResponse)this.creditApplyApi.auditApply(creditApplyAuditSaveReqDto));
                CreditApplyQuotaItemSaveReqDto creditApplyQuotaItemSaveReqDto = new CreditApplyQuotaItemSaveReqDto();
                Long accountId = null;
                Long creditTermModelId = null;
                Long overdueStrategyId = null;
                Long ouotaStrategyId = null;
                ArrayList creditRecords = Lists.newArrayList();
                if (creditAccountEo != null) {
                    accountId = creditAccountEo.getId();
                    creditTermModelId = creditAccountEo.getCreditTermModelId();
                    overdueStrategyId = creditAccountEo.getOverdueStrategyId();
                    ouotaStrategyId = creditAccountEo.getQuotaStrategyId();
                    CreditRecordBatchSaveReqDto creditRecordBatchSaveReqDto = new CreditRecordBatchSaveReqDto();
                    creditRecordBatchSaveReqDto.setAccountQuota(quota);
                    creditRecordBatchSaveReqDto.setCreditAccountId(creditAccountEo.getId());
                    creditRecordBatchSaveReqDto.setCreditAccountStatus(creditAccountEo.getCreditAccountStatus());
                    creditRecordBatchSaveReqDto.setCreditEntityCode(entity.getCode());
                    creditRecordBatchSaveReqDto.setCreditEntityId(entity.getId());
                    creditRecordBatchSaveReqDto.setCreditRecordStatus(CreditRecordStatusEnum.GOOD.getCode());
                    creditRecordBatchSaveReqDto.setStartDate(startDate);
                    creditRecordBatchSaveReqDto.setEndDate(endDate);
                    creditRecordBatchSaveReqDto.setQuotaType(quotaTypeEnum.getCode());
                    creditRecords.add(creditRecordBatchSaveReqDto);
                } else {
                    creditTermModelId = defModelDto.getId();
                    overdueStrategyId = defYQRuleDto.getId();
                    ouotaStrategyId = defCheckRuleDto.getId();
                }
                creditApplyQuotaItemSaveReqDto.setAccountId(accountId);
                creditApplyQuotaItemSaveReqDto.setCreditAccountStatus(CreditAccountStatusEnum.GOOD.getCode());
                creditApplyQuotaItemSaveReqDto.setCreditEntityCode(entity.getCode());
                creditApplyQuotaItemSaveReqDto.setCreditEntityId(entity.getId());
                creditApplyQuotaItemSaveReqDto.setCreditTermModelId(creditTermModelId);
                creditApplyQuotaItemSaveReqDto.setStartDay(startDate);
                creditApplyQuotaItemSaveReqDto.setEndDay(endDate);
                creditApplyQuotaItemSaveReqDto.setOverdueStrategyId(overdueStrategyId);
                creditApplyQuotaItemSaveReqDto.setQuotaStrategyId(ouotaStrategyId);
                CreditDownSaveReqDto creditDownSaveReqDto = new CreditDownSaveReqDto();
                creditDownSaveReqDto.setApplyId(applyId);
                creditDownSaveReqDto.setApplyAccounts((List)Lists.newArrayList((Object[])new CreditApplyQuotaItemSaveReqDto[]{creditApplyQuotaItemSaveReqDto}));
                creditDownSaveReqDto.setCreditRecords((List)creditRecords);
                RestResponseHelper.extractData((RestResponse)this.creditAccountApi.addCreditDown(creditDownSaveReqDto));
                continue;
            }
            creditApplyImportReqDto.setErrorMsg(sb.toString());
            errorList.add(creditApplyImportReqDto);
        }
    }
}

