/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportInfoReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.CreditEntityImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.CreditEntityImportRespDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportService;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditEntityApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityDetailSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.AllowAddEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.EntityStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.EntityTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditEntityQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="creditEntityImportService")
public class CreditEntityImportService
extends ImportService {
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICreditEntityApi creditEntityApi;
    @Resource
    private ICreditEntityQueryApi creditEntityQueryApi;

    @Override
    public void definedImport(Long organizationId, Object list, List<BaseImportInfoReqDto> errorList, Set<String> singleCustomerCodes) {
        List creditEntityImportReqDtos = (List)list;
        List customerCodes = creditEntityImportReqDtos.stream().map(CreditEntityImportReqDto::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        Map<Object, Object> creditEntityMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(customerCodes)) {
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(customerCodes));
            customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (e1, e2) -> e1));
            if (CollectionUtil.isNotEmpty((Collection)customerRespDtos)) {
                List customerIds = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
                CreditEntitySearchReqDto creditEntitySearchReqDto = new CreditEntitySearchReqDto();
                creditEntitySearchReqDto.setIds(customerIds);
                PageInfo creditEntityPageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.creditEntityQueryApi.pageCreditEntity(creditEntitySearchReqDto, Integer.valueOf(1), Integer.valueOf(customerIds.size())));
                if (creditEntityPageRespDtoPageInfo != null && CollectionUtil.isNotEmpty((Collection)creditEntityPageRespDtoPageInfo.getList())) {
                    creditEntityMap = creditEntityPageRespDtoPageInfo.getList().stream().collect(Collectors.toMap(CreditEntityPageRespDto::getId, Function.identity(), (e1, e2) -> e1));
                }
            }
        }
        for (CreditEntityImportReqDto creditEntityImportReqDto : creditEntityImportReqDtos) {
            CreditEntityPageRespDto entity;
            CustomerRespDto customerRespDto;
            StringBuilder sb = new StringBuilder(80);
            if (!singleCustomerCodes.add(creditEntityImportReqDto.getCustomerCode())) {
                sb.append("\u5bfc\u5165\u5ba2\u6237\u7f16\u53f7\u91cd\u590d\uff1b");
            }
            if (StringUtils.isEmpty((CharSequence)creditEntityImportReqDto.getCustomerCode())) {
                sb.append("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            if ((customerRespDto = (CustomerRespDto)customerRespDtoMap.get(creditEntityImportReqDto.getCustomerCode())) == null || !Objects.equals(customerRespDto.getMerchantId(), organizationId)) {
                sb.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
            }
            if ((entity = (CreditEntityPageRespDto)creditEntityMap.get(customerRespDto.getId())) != null && AllowAddEnum.NO.getCode().equals(entity.getAllowAdd())) {
                sb.append("\u5ba2\u6237\u5df2\u51c6\u5165\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u51c6\u5165\uff1b");
            }
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                CreditEntitySaveReqDto creditEntitySaveReqDto = new CreditEntitySaveReqDto();
                creditEntitySaveReqDto.setName(customerRespDto.getName());
                creditEntitySaveReqDto.setEntityStatus(EntityStatusEnum.ENABLED.getCode());
                creditEntitySaveReqDto.setType(EntityTypeEnum.CUSTOMER.getCode());
                creditEntitySaveReqDto.setId(customerRespDto.getId());
                creditEntitySaveReqDto.setCustomerTypeId(customerRespDto.getCustomerTypeId());
                creditEntitySaveReqDto.setCustomerTypeName(customerRespDto.getCustomerTypeName());
                creditEntitySaveReqDto.setRegionCode(customerRespDto.getRegionCodes());
                creditEntitySaveReqDto.setRegion(customerRespDto.getRegionNames());
                creditEntitySaveReqDto.setStatusId(customerRespDto.getStatusId());
                creditEntitySaveReqDto.setStatusName(customerRespDto.getStatusName());
                CreditEntityDetailSaveReqDto creditEntityDetailSaveReqDto = new CreditEntityDetailSaveReqDto();
                BeanUtil.copyProperties((Object)creditEntitySaveReqDto, (Object)creditEntityDetailSaveReqDto, (String[])new String[0]);
                creditEntityDetailSaveReqDto.setCustomerGroupId(customerRespDto.getCustomerGroupId());
                creditEntityDetailSaveReqDto.setCustomerGroupName(customerRespDto.getCustomerGroupName());
                creditEntitySaveReqDto.setCreditList((List)Lists.newArrayList((Object[])new CreditEntityDetailSaveReqDto[]{creditEntityDetailSaveReqDto}));
                creditEntitySaveReqDto.setOrgInfoId(organizationId);
                RestResponseHelper.extractData((RestResponse)this.creditEntityApi.addCustomerCreditEntity(creditEntitySaveReqDto));
                continue;
            }
            CreditEntityImportRespDto creditEntityImportRespDto = new CreditEntityImportRespDto();
            BeanUtil.copyProperties((Object)creditEntityImportReqDto, (Object)creditEntityImportRespDto, (String[])new String[0]);
            creditEntityImportRespDto.setErrorMsg(sb.toString());
            errorList.add(creditEntityImportRespDto);
        }
    }
}

