/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.dto.constant.AmountStatusEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountGrantIsReturnEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountGrantStatus;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountResultEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountType;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountWayEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.IsMonthSettleEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.OperationTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.TradeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftGrantRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftResultReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlItemAmountRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlItemAmountRuleReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ItemAmountExportDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftGrantRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftAmountResultAllExportVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftAmountResultExportVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftGrantRecordExportVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftRecordExportVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.ItemAmountRecordVo;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftGrantRecordQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftRecordQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftResultQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlItemAmountRecordQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlItemAmountRuleQueryApi;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class ControlExportService {
    private static final Logger logger = LoggerFactory.getLogger(ControlExportService.class);
    @Resource
    private ExportService exportService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ITrControlGiftResultQueryApi trControlGiftResultQueryApi;
    @Resource
    private ITrControlGiftRecordQueryApi controlGiftRecordQueryApi;
    @Resource
    private ITrControlItemAmountRuleQueryApi iTrControlItemAmountRuleQueryApi;
    @Resource
    private ITrControlItemAmountRecordQueryApi iTrControlItemAmountRecordQueryApi;
    @Resource
    private ITrControlGiftGrantRecordQueryApi iTrControlGiftGrantRecordQueryApi;

    public RestResponse<Object> exportItemAmount(String filter, Integer pageNum, Integer pageSize) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        TrControlItemAmountRuleReqDto trControlItemAmountRuleReqDto = (TrControlItemAmountRuleReqDto)com.dtyunxi.huieryun.core.util.JSON.parseObject((String)filter, TrControlItemAmountRuleReqDto.class);
        trControlItemAmountRuleReqDto.setOrgId(orgId);
        BaseExportService baseExportService = new BaseExportService(ExportTypeEnum.ITEM_AMOUNT.getName(), ExportTypeEnum.ITEM_AMOUNT);
        baseExportService.executor(req -> {
            RestResponse pageInfoRestResponse = this.iTrControlItemAmountRuleQueryApi.queryByPage(com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)trControlItemAmountRuleReqDto), pageNum, pageSize);
            List list = ((PageInfo)pageInfoRestResponse.getData()).getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList itemAmountExportDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)itemAmountExportDtos, (Collection)list, ItemAmountExportDto.class);
                Map<String, List<TrControlItemAmountRuleRespDto>> collect = list.stream().collect(Collectors.groupingBy(c -> c.getCustomerCode() + c.getAmountTime()));
                itemAmountExportDtos.forEach(c -> {
                    List controlItemAmountRuleEos = collect.getOrDefault(c.getCustomerCode() + c.getAmountTime(), Lists.newArrayList());
                    if (CollectionUtils.isNotEmpty((Collection)controlItemAmountRuleEos)) {
                        TrControlItemAmountRuleRespDto controlItemAmountRuleRespDto = (TrControlItemAmountRuleRespDto)controlItemAmountRuleEos.stream().findFirst().get();
                        c.setStatus(AmountStatusEnum.enumOf((Integer)controlItemAmountRuleRespDto.getStatus()).getDesc());
                        c.setIsMonthSettle(IsMonthSettleEnum.enumOf((Integer)controlItemAmountRuleRespDto.getIsMonthSettle()).getDesc());
                    }
                });
                baseExportService.exportUrl(itemAmountExportDtos, ItemAmountExportDto.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.ITEM_AMOUNT.getName() + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + ExportTypeEnum.ITEM_AMOUNT.getName() + "\u6210\u529f");
    }

    public RestResponse<Object> exportItemAmountRecord(String filter, Integer pageNum, Integer pageSize) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        TrControlItemAmountRecordReqDto trControlItemAmountRecordReqDto = (TrControlItemAmountRecordReqDto)com.dtyunxi.huieryun.core.util.JSON.parseObject((String)filter, TrControlItemAmountRecordReqDto.class);
        trControlItemAmountRecordReqDto.setOrgId(orgId);
        BaseExportService baseExportService = new BaseExportService(ExportTypeEnum.ITEM_AMOUNT_RECORD.getName(), ExportTypeEnum.ITEM_AMOUNT_RECORD);
        baseExportService.executor(req -> {
            RestResponse pageInfoRestResponse = this.iTrControlItemAmountRecordQueryApi.queryByPage(com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)trControlItemAmountRecordReqDto), pageNum, pageSize);
            List list = ((PageInfo)pageInfoRestResponse.getData()).getList();
            logger.info(ExportTypeEnum.ITEM_AMOUNT_RECORD.getName() + "\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)pageInfoRestResponse));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList itemAmountRecordVos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)itemAmountRecordVos, (Collection)list, ItemAmountRecordVo.class);
                Map<String, List<TrControlItemAmountRecordRespDto>> collect = list.stream().collect(Collectors.groupingBy(c -> c.getTradeNo()));
                itemAmountRecordVos.forEach(c -> {
                    List controlItemAmountRecordEoList = collect.getOrDefault(c.getTradeNo(), Lists.newArrayList());
                    if (!CollectionUtils.isEmpty((Collection)controlItemAmountRecordEoList)) {
                        TrControlItemAmountRecordRespDto itemAmountRecordRespDto = (TrControlItemAmountRecordRespDto)controlItemAmountRecordEoList.stream().findFirst().get();
                        c.setOperationType(OperationTypeEnum.enumOf((Integer)itemAmountRecordRespDto.getOperationType()).getDesc());
                        c.setTradeType(TradeTypeEnum.enumOf((Integer)itemAmountRecordRespDto.getTradeType()).getDesc());
                        c.setAmountTime(DateUtil.formatDate((DatePattern)DatePattern.MONTH_PATTERN, (Date)itemAmountRecordRespDto.getAmountTime()));
                    }
                });
                baseExportService.exportUrl(itemAmountRecordVos, ItemAmountRecordVo.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.ITEM_AMOUNT_RECORD.getName() + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + ExportTypeEnum.ITEM_AMOUNT_RECORD.getName() + "\u6210\u529f");
    }

    public RestResponse<Object> exportGiftResult(String filter, Integer pageNum, Integer pageSize) {
        TrControlGiftResultReqDto giftResultRespDto = (TrControlGiftResultReqDto)com.dtyunxi.huieryun.core.util.JSON.parseObject((String)filter, TrControlGiftResultReqDto.class);
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        giftResultRespDto.setOrgId(orgId);
        BaseExportService baseExportService = new BaseExportService(ExportTypeEnum.GIFT_RESULT.getName(), ExportTypeEnum.GIFT_RESULT);
        baseExportService.executor(req -> {
            RestResponse pageInfoRestResponse = this.trControlGiftResultQueryApi.queryByPage(com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)giftResultRespDto), pageNum, pageSize);
            logger.info(ExportTypeEnum.GIFT_RESULT.getName() + "\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)pageInfoRestResponse));
            List list = ((PageInfo)pageInfoRestResponse.getData()).getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                if (GiftAmountResultEnum.WAY_02.getType().equals(giftResultRespDto.getType())) {
                    ArrayList giftAmountResultExportVos = Lists.newArrayList();
                    CubeBeanUtils.copyCollection((Collection)giftAmountResultExportVos, (Collection)list, GiftAmountResultAllExportVo.class);
                    Map<String, List<TrControlGiftResultRespDto>> collect = list.stream().collect(Collectors.groupingBy(c -> c.getCustomerCode()));
                    giftAmountResultExportVos.forEach(c -> {
                        List orDefault = collect.getOrDefault(c.getCustomerCode(), Lists.newArrayList());
                        TrControlGiftResultRespDto giftResultEo = (TrControlGiftResultRespDto)orDefault.stream().findFirst().get();
                        c.setFreezeAmount(giftResultEo.getAmountMoneyAll().getFreezeAmount());
                        c.setRemainAmount(giftResultEo.getAmountMoneyAll().getRemainAmount());
                        c.setUsableAmount(giftResultEo.getAmountMoneyAll().getUsableAmount());
                        c.setUsedAmount(giftResultEo.getAmountMoneyAll().getUsedAmount());
                        c.setFreezeAmountNum(giftResultEo.getAmountNumAll().getFreezeAmount());
                        c.setRemainAmountNum(giftResultEo.getAmountNumAll().getRemainAmount());
                        c.setUsableAmountNum(giftResultEo.getAmountNumAll().getUsableAmount());
                        c.setUsedAmountNum(giftResultEo.getAmountNumAll().getUsedAmount());
                    });
                    baseExportService.exportUrl(giftAmountResultExportVos, GiftAmountResultAllExportVo.class);
                } else {
                    ArrayList giftAmountResultExportVos = Lists.newArrayList();
                    CubeBeanUtils.copyCollection((Collection)giftAmountResultExportVos, (Collection)list, GiftAmountResultExportVo.class);
                    Map<String, List<TrControlGiftResultRespDto>> collect = list.stream().collect(Collectors.groupingBy(c -> c.getRuleId() + c.getCustomerCode()));
                    giftAmountResultExportVos.forEach(c -> {
                        List orDefault = collect.getOrDefault(c.getRuleId() + c.getCustomerCode(), Lists.newArrayList());
                        TrControlGiftResultRespDto giftResultEo = (TrControlGiftResultRespDto)orDefault.stream().findFirst().get();
                        c.setAmountType(GiftAmountType.enumOf((Integer)giftResultEo.getAmountType()).getDesc());
                        c.setStatus(AmountStatusEnum.enumOf((Integer)giftResultEo.getStatus()).getDesc());
                        c.setLoseTime(giftResultEo.getLoseTime());
                        c.setValidTime(giftResultEo.getValidTime());
                    });
                    baseExportService.exportUrl(giftAmountResultExportVos, GiftAmountResultExportVo.class);
                }
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.GIFT_RESULT.getName() + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + ExportTypeEnum.GIFT_RESULT.getName() + "\u6210\u529f");
    }

    public RestResponse<Object> exportGiftRecord(String filter, Integer pageNum, Integer pageSize) {
        TrControlGiftRecordReqDto giftRecordReqDto = (TrControlGiftRecordReqDto)com.dtyunxi.huieryun.core.util.JSON.parseObject((String)filter, TrControlGiftRecordReqDto.class);
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        giftRecordReqDto.setOrgId(orgId);
        BaseExportService baseExportService = new BaseExportService(ExportTypeEnum.GIFT_RECORD.getName(), ExportTypeEnum.GIFT_RECORD);
        baseExportService.executor(req -> {
            RestResponse pageInfoRestResponse = this.controlGiftRecordQueryApi.queryByPage(com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)giftRecordReqDto), pageNum, pageSize);
            logger.info(ExportTypeEnum.GIFT_RECORD.getName() + "\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)pageInfoRestResponse));
            List list = ((PageInfo)pageInfoRestResponse.getData()).getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList giftRecordExportVos = Lists.newArrayList();
                for (TrControlGiftRecordRespDto respDto : list) {
                    GiftRecordExportVo giftRecordExportVo = new GiftRecordExportVo();
                    CubeBeanUtils.copyProperties((Object)giftRecordExportVo, (Object)respDto, (String[])new String[0]);
                    GiftAmountType giftAmountType = GiftAmountType.enumOf((Integer)respDto.getAmountType());
                    GiftAmountWayEnum tradeTypeEnum = GiftAmountWayEnum.enumOf((Integer)respDto.getTradeType());
                    OperationTypeEnum operationTypeEnum = OperationTypeEnum.enumOf((Integer)respDto.getIncomeType());
                    String tradeTime = ObjectUtils.isEmpty((Object)respDto.getTradeTime()) ? "" : DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)respDto.getTradeTime());
                    giftRecordExportVo.setTradeTime(tradeTime);
                    giftRecordExportVo.setAmountType(ObjectUtils.isEmpty((Object)giftAmountType) ? "" : giftAmountType.getDesc());
                    giftRecordExportVo.setTradeType(ObjectUtils.isEmpty((Object)tradeTypeEnum) ? "" : tradeTypeEnum.getDesc());
                    giftRecordExportVo.setIncomeType(ObjectUtils.isEmpty((Object)operationTypeEnum) ? "" : operationTypeEnum.getDesc());
                    giftRecordExportVos.add(giftRecordExportVo);
                }
                baseExportService.exportUrl(giftRecordExportVos, GiftRecordExportVo.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.GIFT_RECORD.getName() + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + ExportTypeEnum.GIFT_RECORD.getName() + "\u6210\u529f");
    }

    public RestResponse<Object> exportGiftGrantRecord(String filter, Integer pageNum, Integer pageSize) {
        TrControlGiftGrantRecordReqDto giftGrantRecordRespDto = (TrControlGiftGrantRecordReqDto)JSON.parseObject((String)filter, TrControlGiftGrantRecordReqDto.class);
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        Assert.notNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        giftGrantRecordRespDto.setOrgId(orgId);
        BaseExportService baseExportService = new BaseExportService(ExportTypeEnum.GIFT_GRANT.getName(), ExportTypeEnum.GIFT_GRANT);
        baseExportService.executor(req -> {
            RestResponse pageInfoRestResponse = this.iTrControlGiftGrantRecordQueryApi.queryByPage(com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)giftGrantRecordRespDto), pageNum, pageSize);
            List list = ((PageInfo)pageInfoRestResponse.getData()).getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList giftGrantRecordExportVos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)giftGrantRecordExportVos, (Collection)list, GiftGrantRecordExportVo.class);
                Map<String, List<TrControlGiftGrantRecordRespDto>> collect = list.stream().collect(Collectors.groupingBy(c -> c.getGrantNo()));
                giftGrantRecordExportVos.forEach(c -> {
                    List orDefault = collect.getOrDefault(c.getGrantNo(), Lists.newArrayList());
                    TrControlGiftGrantRecordRespDto giftResultEo = (TrControlGiftGrantRecordRespDto)orDefault.stream().findFirst().get();
                    c.setAmountType(GiftAmountType.enumOf((Integer)giftResultEo.getAmountType()).getDesc());
                    c.setIsReturn(GiftAmountGrantIsReturnEnum.enumOf((Integer)giftResultEo.getIsReturn()).getDesc());
                    c.setStatus(GiftAmountGrantStatus.enumOf((Integer)giftResultEo.getStatus()).getDesc());
                });
                baseExportService.exportUrl(giftGrantRecordExportVos, GiftGrantRecordExportVo.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.GIFT_GRANT.getName() + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + ExportTypeEnum.GIFT_GRANT.getName() + "\u6210\u529f");
    }
}

