/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseDefinedParamDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportInfoReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.CreditAccountImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportService;
import com.dtyunxi.yundt.cube.center.credit.api.account.ICreditRepayPlanImportApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditTermModelSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PageDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PolicySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditTermModelRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.PolicyInfoRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.PolicyType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditAccountQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditEntityQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditTermModelQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.IPolicyQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.CreditAccountImportInfoReqDto;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="creditAccountImportService")
public class CreditAccountImportService
extends ImportService {
    private static final String DEFAULT_MODEL_NAME = "\u9ed8\u8ba4\u8d26\u671f\u6a21\u578b";
    private static final String DEFAULT_EDJY_RULE_NAME = "\u9ed8\u8ba4\u989d\u5ea6\u6821\u9a8c\u7b56\u7565";
    private static final String DEFAULT_YQ_RULE_NAME = "\u9ed8\u8ba4\u903e\u671f\u6821\u9a8c\u7b56\u7565";
    @Resource
    private ICreditRepayPlanImportApi creditRepayPlanImportApi;
    @Resource
    private ICreditEntityQueryApi creditEntityQueryApi;
    @Resource
    private ICreditAccountQueryApi creditAccountQueryApi;
    @Resource
    private ICreditTermModelQueryApi creditTermModelQueryApi;
    @Resource
    private IPolicyQueryApi policyQueryApi;

    @Override
    public void definedImport(BaseDefinedParamDto baseDefinedParamDto, Object list, List<BaseImportInfoReqDto> errorList, Set<String> importDataUniquekeySet) {
        Long organizationId = baseDefinedParamDto.getOrganizationId();
        CreditTermModelSearchReqDto creditTermModelSearchReqDto = new CreditTermModelSearchReqDto();
        creditTermModelSearchReqDto.setPageNum(Integer.valueOf(1));
        creditTermModelSearchReqDto.setPageSize(Integer.valueOf(100));
        PageInfo modelPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.creditTermModelQueryApi.queryPage((PageDto)creditTermModelSearchReqDto));
        CreditTermModelRespDto defModelDto = null;
        if (modelPageInfo != null && CollectionUtil.isNotEmpty((Collection)modelPageInfo.getList())) {
            defModelDto = modelPageInfo.getList().stream().filter(model -> Objects.equals(model.getName(), DEFAULT_MODEL_NAME)).findFirst().orElse(null);
        }
        PolicySearchReqDto policySearchReqDto = new PolicySearchReqDto();
        policySearchReqDto.setPageNum(Integer.valueOf(1));
        policySearchReqDto.setPageSize(Integer.valueOf(1000));
        policySearchReqDto.setType(PolicyType.LIMIT.getType());
        PageInfo policyInfoRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.policyQueryApi.queryPageDetail(policySearchReqDto));
        PolicyInfoRespDto defCheckRuleDto = null;
        if (modelPageInfo != null && CollectionUtil.isNotEmpty((Collection)modelPageInfo.getList())) {
            defCheckRuleDto = policyInfoRespDtoPageInfo.getList().stream().filter(policy -> Objects.equals(policy.getName(), DEFAULT_EDJY_RULE_NAME)).findFirst().orElse(null);
        }
        policySearchReqDto.setType(PolicyType.OVERDUE.getType());
        PageInfo yqPolicyInfoRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.policyQueryApi.queryPageDetail(policySearchReqDto));
        PolicyInfoRespDto defYQRuleDto = null;
        if (yqPolicyInfoRespDtoPageInfo != null && CollectionUtil.isNotEmpty((Collection)yqPolicyInfoRespDtoPageInfo.getList())) {
            defYQRuleDto = yqPolicyInfoRespDtoPageInfo.getList().stream().filter(policy -> Objects.equals(policy.getName(), DEFAULT_YQ_RULE_NAME)).findFirst().orElse(null);
        }
        List creditEntityImportReqDtos = (List)list;
        ArrayList creditEntityCodes = Lists.newArrayList();
        for (CreditAccountImportReqDto creditEntityImportReqDto : creditEntityImportReqDtos) {
            Optional.ofNullable(creditEntityImportReqDto.getCreditEntityCode()).ifPresent(creditEntityCodes::add);
        }
        HashMap creditEntityMap = Maps.newHashMap();
        Map<Object, Object> creditAccountEoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)creditEntityCodes)) {
            ArrayList entityIds = Lists.newArrayList();
            CreditEntitySearchReqDto creditEntitySearchReqDto = new CreditEntitySearchReqDto();
            creditEntitySearchReqDto.setCodes((List)creditEntityCodes);
            PageInfo entityPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.creditEntityQueryApi.pageCreditEntity(creditEntitySearchReqDto, Integer.valueOf(1), Integer.valueOf(creditEntityCodes.size())));
            if (entityPageInfo != null && CollectionUtil.isNotEmpty((Collection)entityPageInfo.getList())) {
                for (CreditEntityPageRespDto entityPageRespDto : entityPageInfo.getList()) {
                    creditEntityMap.put(entityPageRespDto.getCode(), entityPageRespDto);
                    entityIds.add(entityPageRespDto.getId());
                }
            }
            CreditAccountSearchReqDto creditAccountSearchReqDto = new CreditAccountSearchReqDto();
            creditAccountSearchReqDto.setAccountIds((List)entityIds);
            List creditAccountPageRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.creditAccountQueryApi.queryAccountByEntityIds(creditAccountSearchReqDto));
            creditAccountEoMap = creditAccountPageRespDtos.stream().collect(Collectors.toMap(CreditAccountPageRespDto::getCreditEntityId, Function.identity(), (e1, e2) -> e1));
        }
        ArrayList accountImportInfoReqDtos = Lists.newArrayList();
        for (CreditAccountImportReqDto accountImportReqDto : creditEntityImportReqDtos) {
            CreditEntityPageRespDto entityPageRespDto;
            StringBuilder sb = new StringBuilder(80);
            if (StringUtil.isEmpty((String)accountImportReqDto.getCreditEntityCode())) {
                sb.append("\u6388\u4fe1\u4e3b\u4f53\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            BigDecimal accountQuota = super.tryConverBigDecimalAndCheckScale(sb, accountImportReqDto.getAccountQuota(), "\u603b\u6388\u4fe1\u989d\u5ea6", DEF_SCALE, true, false);
            BigDecimal avaQuota = super.tryConverBigDecimalAndCheckScale(sb, accountImportReqDto.getAvaQuota(), "\u53ef\u7528\u989d\u5ea6", DEF_SCALE, true, false);
            if (accountQuota != null && avaQuota != null && accountQuota.compareTo(avaQuota) < 0) {
                sb.append("\u53ef\u7528\u989d\u5ea6\u4e0d\u80fd\u5927\u4e8e\u603b\u6388\u4fe1\u989d\u5ea6\uff1b");
            }
            if (!importDataUniquekeySet.add(accountImportReqDto.getCreditEntityCode())) {
                sb.append("\u5bfc\u5165\u6388\u4fe1\u4e3b\u4f53\u7f16\u53f7\u91cd\u590d\uff1b");
            }
            if ((entityPageRespDto = (CreditEntityPageRespDto)creditEntityMap.get(accountImportReqDto.getCreditEntityCode())) == null) {
                sb.append("\u6388\u4fe1\u4e3b\u4f53\u4e0d\u5b58\u5728\uff1b");
            }
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                CreditAccountPageRespDto creditAccountPageRespDto = (CreditAccountPageRespDto)creditAccountEoMap.get(entityPageRespDto.getId());
                if (creditAccountPageRespDto == null) {
                    CreditAccountImportInfoReqDto accountImportInfoReqDto = new CreditAccountImportInfoReqDto();
                    accountImportInfoReqDto.setCreditAccountName(entityPageRespDto.getName());
                    accountImportInfoReqDto.setCreditEntityId(entityPageRespDto.getId());
                    accountImportInfoReqDto.setCreditEntityName(entityPageRespDto.getName());
                    accountImportInfoReqDto.setCreditAccountStatus(YesOrNoEnum.YES.getCode());
                    accountImportInfoReqDto.setCreditTermModelId(defModelDto.getId());
                    accountImportInfoReqDto.setQuotaStrategyId(defCheckRuleDto.getId());
                    accountImportInfoReqDto.setOverdueStrategyId(defYQRuleDto.getId());
                    accountImportInfoReqDto.setAccountQuota(accountQuota);
                    accountImportInfoReqDto.setAccountUsedQuota(accountQuota.subtract(avaQuota));
                    accountImportInfoReqDto.setOrgInfoId(organizationId);
                    accountImportInfoReqDto.setOptType(Integer.valueOf(1));
                    accountImportInfoReqDtos.add(accountImportInfoReqDto);
                    continue;
                }
                BigDecimal oldAccountQuota = Optional.ofNullable(creditAccountPageRespDto.getAccountQuota()).orElse(BigDecimal.ZERO);
                BigDecimal oldAccountUsedQuota = Optional.ofNullable(creditAccountPageRespDto.getAccountUsedQuota()).orElse(BigDecimal.ZERO);
                CreditAccountImportInfoReqDto accountImportInfoReqDto = new CreditAccountImportInfoReqDto();
                accountImportInfoReqDto.setId(creditAccountPageRespDto.getId());
                accountImportInfoReqDto.setOrgInfoId(organizationId);
                accountImportInfoReqDto.setCreditEntityId(entityPageRespDto.getId());
                accountImportInfoReqDto.setAccountQuota(accountQuota);
                accountImportInfoReqDto.setAccountUsedQuota(accountQuota.subtract(avaQuota));
                accountImportInfoReqDto.setOldAccountQuota(oldAccountQuota);
                accountImportInfoReqDto.setOldAccountUsedQuota(oldAccountUsedQuota);
                accountImportInfoReqDto.setOptType(Integer.valueOf(2));
                accountImportInfoReqDtos.add(accountImportInfoReqDto);
                continue;
            }
            accountImportReqDto.setErrorMsg(sb.toString());
            errorList.add(accountImportReqDto);
        }
        if (CollectionUtil.isNotEmpty((Collection)accountImportInfoReqDtos)) {
            RestResponseHelper.extractData((RestResponse)this.creditRepayPlanImportApi.batchImportAccounts((List)accountImportInfoReqDtos));
        }
    }
}

