/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.EmployeeOrgQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.EmployeeOrgRespDto;
import com.dtyunxi.tcbj.api.query.IOrgSellerCustomerQueryApi;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.vo.user.CustomerEmployeeExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.user.EmployeeOrgExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.user.UserInfoDBExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.user.UserInfoPPExportVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserExportService {
    private static final Logger logger = LoggerFactory.getLogger(UserExportService.class);
    @Resource
    private ExportService exportService;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private IOrgSellerCustomerQueryApi orgSellerCustomerQueryApi;
    @Resource
    private IContext context;

    public RestResponse<Object> exportUser(EmployeeExtQueryReqDto reqDto, String type) {
        logger.info("\u4eba\u5458\u4fe1\u606f\u5bfc\u51fa\uff0c\u5165\u53c2\uff1areqDto={}\uff0ctype={}", (Object)JSON.toJSONString((Object)reqDto), (Object)type);
        String name = "PP".equals(type) ? "\u54c1\u724c\u4eba\u5458\u4fe1\u606f" : "\u5927B\u4eba\u5458\u4fe1\u606f";
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.USER);
        baseExportService.executor(req -> {
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(100000));
            RestResponse pageInfoRestResponse = this.employeeExpandQueryApi.queryByPage(reqDto);
            if (ObjectUtils.isNotEmpty((Object)pageInfoRestResponse.getData()) && CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
                if (type.equals("PP")) {
                    ArrayList rList = Lists.newArrayList();
                    for (EmployeeExtRespDto dto : ((PageInfo)pageInfoRestResponse.getData()).getList()) {
                        UserInfoPPExportVo vo = new UserInfoPPExportVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                        vo.setUserStatus(Objects.isNull(dto.getStatus()) ? "" : dto.getStatus() + "");
                        vo.setRoles(dto.getOrganizationNames());
                        rList.add(vo);
                    }
                    baseExportService.exportUrl(rList, UserInfoPPExportVo.class);
                } else {
                    ArrayList rList = Lists.newArrayList();
                    for (EmployeeExtRespDto dto : ((PageInfo)pageInfoRestResponse.getData()).getList()) {
                        UserInfoDBExportVo vo = new UserInfoDBExportVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                        vo.setUserStatus(Objects.isNull(dto.getStatus()) ? "" : dto.getStatus() + "");
                        vo.setRoles(dto.getOrganizationNames());
                        vo.setAreaCount(Objects.isNull(dto.getRegionNum()) ? "0" : dto.getRegionNum() + "");
                        vo.setCustomerCount(Objects.isNull(dto.getCustomerNum()) ? "0" : dto.getCustomerNum() + "");
                        rList.add(vo);
                    }
                    baseExportService.exportUrl(rList, UserInfoDBExportVo.class);
                }
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, reqDto);
        return new RestResponse("0", "\u5bfc\u51fa" + name + "\u6210\u529f");
    }

    public RestResponse<Object> exportOrgEmployee(EmployeeOrgQueryReqDto reqDto) {
        logger.info("\u7ec4\u7ec7\u4eba\u5458\u4fe1\u606f\u5bfc\u51fa\uff0c\u5165\u53c2\uff1areqDto={}", (Object)JSON.toJSONString((Object)reqDto));
        String name = "\u7ec4\u7ec7\u4eba\u5458\u4fe1\u606f";
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.ORG_EMPLOYEE);
        baseExportService.executor(req -> {
            RestResponse pageInfoRestResponse = this.orgSellerCustomerQueryApi.queryEmployeeOrgPage(reqDto);
            if (ObjectUtils.isNotEmpty((Object)pageInfoRestResponse.getData()) && CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
                ArrayList rList = Lists.newArrayList();
                for (EmployeeOrgRespDto dto : ((PageInfo)pageInfoRestResponse.getData()).getList()) {
                    EmployeeOrgExportVo vo = new EmployeeOrgExportVo();
                    CubeBeanUtils.copyProperties((Object)((Object)vo), (Object)dto, (String[])new String[0]);
                    rList.add(vo);
                }
                baseExportService.exportUrl(rList, EmployeeOrgExportVo.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, reqDto);
        return new RestResponse("0", "\u5bfc\u51fa" + name + "\u6210\u529f");
    }

    public RestResponse<Object> exportCustomerEmployee(EmployeeExtQueryReqDto reqDto) {
        logger.info("\u5ba2\u6237\u4eba\u5458\u4fe1\u606f\u5bfc\u51fa\uff0c\u5165\u53c2\uff1areqDto={}", (Object)JSON.toJSONString((Object)reqDto));
        String name = "\u5ba2\u6237\u4eba\u5458\u4fe1\u606f";
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.CUSTOMER_EMPLOYEE);
        baseExportService.executor(req -> {
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(100000));
            RestResponse pageInfoRestResponse = this.employeeExpandQueryApi.queryByPage(reqDto);
            if (ObjectUtils.isNotEmpty((Object)pageInfoRestResponse.getData()) && CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
                ArrayList rList = Lists.newArrayList();
                for (EmployeeExtRespDto dto : ((PageInfo)pageInfoRestResponse.getData()).getList()) {
                    CustomerEmployeeExportVo vo = new CustomerEmployeeExportVo();
                    CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                    vo.setUserStatus(Objects.isNull(dto.getStatus()) ? "" : dto.getStatus() + "");
                    rList.add(vo);
                }
                baseExportService.exportUrl(rList, CustomerEmployeeExportVo.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, reqDto);
        return new RestResponse("0", "\u5bfc\u51fa" + name + "\u6210\u529f");
    }
}

