/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogStatusEnum;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.CustomerUpdateImportDto;
import com.dtyunxi.tcbj.module.export.biz.impl.CustomerAddImportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportLogService;
import com.dtyunxi.tcbj.module.export.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.dao.eo.ImportLogEo;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.constant.SubjectTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerExtApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yx.demo.center.data.query.IAreaExtQueryApi;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerUpdateImportService {
    public final Logger logger = LoggerFactory.getLogger(CustomerUpdateImportService.class);
    @Resource
    private IContext context;
    @Resource
    private ImportLogService importLogService;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private ICustomerExtApi customerExtApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private CustomerAddImportService customerAddImportService;
    @Resource
    private IAreaExtQueryApi areaExtQueryApi;

    Long getTenantId() {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        if (Objects.isNull(tenantId)) {
            tenantId = 1L;
        }
        return tenantId;
    }

    Long getInstanceId() {
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        if (Objects.isNull(instanceId)) {
            instanceId = 1254039287584232622L;
        }
        return instanceId;
    }

    public void customerUpdateImport(ImportReqDto importReqDto) {
        this.logger.info("\u6279\u91cf\u5bfc\u5165\u5ba2\u6237\u4fee\u6539:{}", (Object)JSON.toJSONString((Object)importReqDto));
        String fileUrl = importReqDto.getFileUrl();
        List<Long> sellerIdList = importReqDto.getSellerIdList();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty(sellerIdList, (String)"\u5bfc\u5165\u7684\u5546\u5bb6\u4e3a\u7a7a");
        List importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, CustomerUpdateImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList((List)importDtos);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setIdList(sellerIdList);
        List sellerDtoList = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryListOnPost(sellerQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)sellerDtoList)) {
            throw new BizException("\u5bfc\u5165\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u89e3\u6790\u5931\u8d25:\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Long requestTenantId = this.getTenantId();
        Long requestInstanceId = this.getInstanceId();
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        for (SellerRespDto sellerRespDto : sellerDtoList) {
            ImportLogEo initLog = ImportLogEo.newInstance();
            initLog.setImportFileUrl(importReqDto.getFileUrl());
            String fileName = importReqDto.getFileName();
            if (StringUtils.isEmpty((CharSequence)importReqDto.getFileName())) {
                fileName = StringUtils.substringAfter((String)importReqDto.getFileUrl(), (String)"cube//");
            }
            initLog.setFileName(fileName);
            initLog.setImportType(ImportLogTypeEnum.CUSTOMER.getCode());
            initLog.setTotalNum(Integer.valueOf(importDtos.size()));
            initLog.setOrganizationId(sellerRespDto.getOrganizationId());
            initLog.setSellerId(sellerRespDto.getId());
            initLog.setInstanceId(requestInstanceId);
            initLog.setTenantId(requestTenantId);
            Long importLogId = this.importLogService.init(initLog);
            List finalImportDtos = importDtos;
            CompletableFuture.runAsync(() -> {
                try {
                    this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u5f00\u59cb,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                    this.doImportSyn(requestTenantId, requestInstanceId, finalImportDtos, importLogId, sellerRespDto.getId(), sellerRespDto.getOrganizationId());
                    this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u7ed3\u675f,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                }
                catch (Exception e) {
                    this.importLogService.fail(importLogId, e.getMessage(), "", finalImportDtos.size());
                    e.printStackTrace();
                    this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u65e5\u5fd7id[{}],\u5f02\u5e38\u4fe1\u606f{}", (Object)importLogId, (Object)e.getMessage());
                }
            });
        }
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private void doImportSyn(Long requestTenantId, Long requestInstanceId, List<CustomerUpdateImportDto> importDtos, Long importLogId, Long sellerId, Long orgId) {
        Object customerTypeDtos;
        List customerTypeList;
        this.checkData(importDtos, sellerId, orgId, requestTenantId, requestInstanceId);
        List successList = importDtos.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        this.logger.info("\u7b5b\u9009\u6210\u529f\u7684\u6570\u636e:{}", (Object)successList.size());
        Map<String, Object> customerTypeInfoMap = new HashMap<String, CustomerTypeRespDto>();
        if (CollectionUtils.isNotEmpty(successList) && CollectionUtils.isNotEmpty(customerTypeList = successList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCustomerTypeName())).map(CustomerUpdateImportDto::getCustomerTypeName).collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(customerTypeDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.getCustomerTypeByNames(customerTypeList))))) {
            customerTypeInfoMap = customerTypeDtos.stream().collect(Collectors.toMap(CustomerTypeRespDto::getName, Function.identity(), (k1, k2) -> k1));
        }
        String failReason = "";
        for (CustomerUpdateImportDto importDto : importDtos) {
            if (StringUtils.isNotEmpty((CharSequence)importDto.getErrorReason())) continue;
            try {
                this.updateCustomer(importDto, orgId, requestTenantId, requestInstanceId, customerTypeInfoMap);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.info("\u5ba2\u6237\u4fee\u6539\u5931\u8d25:{}", (Object)e.getMessage());
                importDto.setErrorReason(e.getMessage());
            }
        }
        List errorList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        int errorSize = errorList.size();
        int totalSize = importDtos.size();
        this.logger.info("\u66f4\u65b0\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u5931\u8d25\u6570:{},\u603b\u6570:{}", (Object)errorSize, (Object)totalSize);
        if (errorSize == 0) {
            this.importLogService.success(importLogId, ImportLogStatusEnum.SUCCEED, totalSize, "", "", 0);
        } else {
            String title = "\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u8fd4\u56de\u7ed3\u679c";
            String fileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
            String exportUrl = "";
            try {
                Thread.sleep(2000L);
                exportUrl = EasyPoiExportUtil.getExportUrl(importDtos, CustomerUpdateImportDto.class, null, fileName, "xls");
            }
            catch (Exception e) {
                e.printStackTrace();
                failReason = failReason + "\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage();
                this.logger.info(failReason);
            }
            if (errorSize < totalSize) {
                this.importLogService.success(importLogId, ImportLogStatusEnum.PART_SUCCESS, totalSize - errorSize, failReason, exportUrl, errorSize);
            } else {
                this.importLogService.fail(importLogId, failReason, exportUrl, errorSize);
            }
        }
    }

    private void checkData(List<CustomerUpdateImportDto> importDtos, Long sellerId, Long orgId, Long requestTenantId, Long requestInstanceId) {
        for (CustomerUpdateImportDto importDto : importDtos) {
            Integer toLegalCardType;
            StringBuffer errorMsg = new StringBuffer();
            if (StringUtils.isEmpty((CharSequence)importDto.getOrgIdStr())) {
                errorMsg.append("\u7ec4\u7ec7ID\u4e3a\u7a7a;");
            } else {
                importDto.setOrgInfoId(Long.valueOf(importDto.getOrgIdStr()));
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getSubjectType()) && StringUtils.isEmpty((CharSequence)this.toSubjectType(importDto.getSubjectType()))) {
                errorMsg.append("\u4e3b\u4f53\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessLicenseType()) && this.toBusinessLicenseType(importDto.getBusinessLicenseType()) == 0) {
                errorMsg.append("\u6267\u7167\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessTermType())) {
                String toBusinessTermType = this.toBusinessTermType(importDto.getBusinessTermType());
                if (toBusinessTermType.equals("0")) {
                    errorMsg.append("\u8425\u4e1a\u671f\u9650\u7c7b\u578b\u9519\u8bef;");
                } else if (toBusinessTermType.equals("1")) {
                    if (StringUtils.isEmpty((CharSequence)importDto.getTermBeginTime())) {
                        errorMsg.append("\u8425\u4e1a\u671f\u9650\u8d77\u4e3a\u7a7a;");
                    }
                    if (StringUtils.isEmpty((CharSequence)importDto.getTermEndTime())) {
                        errorMsg.append("\u8425\u4e1a\u671f\u9650\u6b62\u4e3a\u7a7a;");
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardType()) && (toLegalCardType = this.toLegalCardType(importDto.getLegalCardType())).equals(0)) {
                errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardType())) {
                Integer toCardEffectType = this.toCardEffectType(importDto.getCardEffectType());
                if (toCardEffectType.equals(0)) {
                    errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u6709\u6548\u671f\u7c7b\u578b\u9519\u8bef;");
                } else if (toCardEffectType.equals(1)) {
                    if (Objects.isNull(importDto.getCardEffectBeginTime())) {
                        errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u6709\u6548\u671f\u8d77\u4e3a\u7a7a;");
                    }
                    if (Objects.isNull(importDto.getCardEffectEndTime())) {
                        errorMsg.append("\u6cd5\u4eba\u8bc1\u4ef6\u6709\u6548\u671f\u6b62\u4e3a\u7a7a;");
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                importDto.setErrorReason(errorMsg.toString());
            }
            importDto.setSellerId(sellerId);
            importDto.setOrgId(orgId);
            importDto.setInstanceId(requestInstanceId);
        }
    }

    private void updateCustomer(CustomerUpdateImportDto importDto, Long orgId, Long requestTenantId, Long requestInstanceId, Map<String, CustomerTypeRespDto> customerTypeInfoMap) {
        Long customerOrgId = importDto.getOrgInfoId();
        CustomerExtReqDto customerQuery = new CustomerExtReqDto();
        customerQuery.setOrgInfoId(customerOrgId);
        customerQuery.setMerchantId(orgId);
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerInfoByOrg(customerQuery));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            throw new BizException("\u5ba2\u6237\u4e0d\u5b58\u5728\u8be5\u5546\u5bb6\u4e0b;");
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        CustomerTypeRespDto customerTypeRespDto = null;
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCustomerTypeName())) {
            if (customerTypeInfoMap.isEmpty() || !customerTypeInfoMap.containsKey(importDto.getCustomerTypeName())) {
                throw new BizException("\u5ba2\u6237\u7c7b\u578b\u6570\u636e\u9519\u8bef;");
            }
            customerTypeRespDto = customerTypeInfoMap.get(importDto.getCustomerTypeName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getRegionName())) {
            String[] areaNameArr = importDto.getRegionName().split(";");
            List<String> areaNameList = Arrays.asList(areaNameArr);
            importDto.setRegionNameList(areaNameList);
            CustomerAreaListExtReqDto customerAreaQuery = new CustomerAreaListExtReqDto();
            customerAreaQuery.setNameList(areaNameList);
            List areaList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByNames(customerAreaQuery));
            if (CollectionUtils.isEmpty((Collection)areaList)) {
                throw new BizException("\u5ba2\u6237\u533a\u57df\u6570\u636e\u9519\u8bef;");
            }
            if (CollectionUtils.isEmpty(areaList = areaList.stream().filter(dto -> dto.getOrgInfoId().compareTo(orgId) == 0).collect(Collectors.toList()))) {
                throw new BizException("\u5ba2\u6237\u533a\u57df\u7ec4\u7ec7\u6570\u636e\u9519\u8bef;");
            }
            List<String> areaCodeList = areaList.stream().map(CustomerAreaRespDto::getCode).collect(Collectors.toList());
            importDto.setRegionCodeList(areaCodeList);
        }
        List<Object> addressList = Lists.newArrayList();
        addressList.add(importDto.getProvince());
        addressList.add(importDto.getCity());
        addressList.add(importDto.getCounty());
        addressList.add(importDto.getOrgProvince());
        addressList.add(importDto.getOrgCity());
        addressList.add(importDto.getOrgDistrict());
        addressList = addressList.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s)).distinct().collect(Collectors.toList());
        Map<Object, Object> addressInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)addressList)) {
            List addressAreaList = (List)RestResponseHelper.extractData((RestResponse)this.areaExtQueryApi.getAreaByNames((List)addressList));
            if (CollectionUtils.isEmpty((Collection)addressAreaList)) {
                throw new BizException("\u5730\u533a\u540d\u79f0\u6570\u636e\u9519\u8bef;");
            }
            addressInfoMap = addressAreaList.stream().collect(Collectors.toMap(AreaDto::getName, Function.identity(), (k1, k2) -> k1));
            if (StringUtils.isNotEmpty((CharSequence)importDto.getProvince()) && !addressInfoMap.containsKey(importDto.getProvince())) {
                throw new BizException("\u6240\u5c5e\u7701\u4efd\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getCity()) && !addressInfoMap.containsKey(importDto.getCity())) {
                throw new BizException("\u6240\u5c5e\u57ce\u5e02\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getCounty()) && !addressInfoMap.containsKey(importDto.getCounty())) {
                throw new BizException("\u6240\u5c5e\u5730\u533a\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgProvince()) && !addressInfoMap.containsKey(importDto.getOrgProvince())) {
                throw new BizException("\u516c\u53f8\u6240\u5c5e\u7701\u4efd\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgCity()) && !addressInfoMap.containsKey(importDto.getOrgCity())) {
                throw new BizException("\u516c\u53f8\u6240\u5c5e\u57ce\u5e02\u6570\u636e\u9519\u8bef");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgDistrict()) && !addressInfoMap.containsKey(importDto.getOrgDistrict())) {
                throw new BizException("\u516c\u53f8\u6240\u5c5e\u5730\u533a\u6570\u636e\u9519\u8bef");
            }
        }
        CompanyInfoDto companyInfoDto = null;
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode())) {
            try {
                this.logger.info("\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801CreditCode={},orgId={},requestTenantId={},requestInstanceId={}", new Object[]{importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId});
                companyInfoDto = (CompanyInfoDto)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCompanyInfoByCreditCode(importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId, customerRespDto.getId()));
                this.logger.info("\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801\u516c\u53f8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)companyInfoDto));
            }
            catch (Exception e) {
                throw new BizException("\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801\u516c\u53f8\u4fe1\u606f:" + e.getMessage());
            }
        }
        CustomerReqDto updateCustomerDto = new CustomerReqDto();
        CubeBeanUtils.copyProperties((Object)updateCustomerDto, (Object)customerRespDto, (String[])new String[]{"companyInfoDto", "regionCodeList", "regionNameList", "salesmanIds"});
        updateCustomerDto.setId(customerRespDto.getId());
        updateCustomerDto.setMerchantId(orgId);
        updateCustomerDto.setInstanceId(requestInstanceId);
        updateCustomerDto.setTenantId(requestTenantId);
        updateCustomerDto.setOrgId(orgId);
        updateCustomerDto.setRegionCodeList(customerRespDto.getRegionCodeList());
        String regionNames = customerRespDto.getRegionNames();
        if (StringUtils.isNotEmpty((CharSequence)regionNames)) {
            String[] regionNameArr = regionNames.split(",");
            List<String> regionNameList = Arrays.asList(regionNameArr);
            updateCustomerDto.setRegionNameList(regionNameList);
        }
        if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getSalesmanIds())) {
            String[] salesmanIdArr = customerRespDto.getSalesmanIds().split(",");
            List<String> salesmanIdList = Arrays.asList(salesmanIdArr);
            List salesmanIds = salesmanIdList.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
            updateCustomerDto.setSalesmanIds(salesmanIds);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getName())) {
            updateCustomerDto.setName(importDto.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getEasCode())) {
            updateCustomerDto.setEasCode(importDto.getEasCode());
        }
        if (CollectionUtils.isNotEmpty(importDto.getRegionCodeList())) {
            updateCustomerDto.setRegionCodeList(importDto.getRegionCodeList());
        }
        if (CollectionUtils.isNotEmpty(importDto.getRegionNameList())) {
            updateCustomerDto.setRegionNameList(importDto.getRegionNameList());
        }
        if (Objects.nonNull(customerTypeRespDto)) {
            updateCustomerDto.setCustomerTypeId(customerTypeRespDto.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getProvince())) {
            updateCustomerDto.setProvince(importDto.getProvince());
            updateCustomerDto.setProvinceCode(((AreaDto)addressInfoMap.get(importDto.getProvince())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCity())) {
            updateCustomerDto.setCity(importDto.getCity());
            updateCustomerDto.setCityCode(((AreaDto)addressInfoMap.get(importDto.getCity())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCounty())) {
            updateCustomerDto.setCounty(importDto.getCounty());
            updateCustomerDto.setCountyCode(((AreaDto)addressInfoMap.get(importDto.getCounty())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getAddress())) {
            updateCustomerDto.setAddress(importDto.getAddress());
        }
        CompanyInfoDto newCompanyInfo = new CompanyInfoDto();
        CompanyInfoDto oldCompanyInfoDto = customerRespDto.getCompanyInfoDto();
        CubeBeanUtils.copyProperties((Object)newCompanyInfo, (Object)oldCompanyInfoDto, (String[])new String[0]);
        if (Objects.nonNull(companyInfoDto)) {
            CubeBeanUtils.copyProperties((Object)newCompanyInfo, (Object)companyInfoDto, (String[])new String[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgName())) {
            newCompanyInfo.setOrgName(importDto.getOrgName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getSubjectType())) {
            newCompanyInfo.setSubjectType(this.toSubjectType(importDto.getSubjectType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode())) {
            newCompanyInfo.setCreditCode(importDto.getCreditCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessLicenseType())) {
            newCompanyInfo.setBusinessLicenseType(this.toBusinessLicenseType(importDto.getBusinessLicenseType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessTermType())) {
            newCompanyInfo.setBusinessTermType(this.toBusinessTermType(importDto.getBusinessTermType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getTermBeginTime())) {
            Date termBeginTime = DateUtil.parseDate((String)importDto.getTermBeginTime(), (String)"yyyy-MM-dd");
            newCompanyInfo.setTermBeginTime(termBeginTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getTermEndTime())) {
            Date termEndTime = DateUtil.parseDate((String)importDto.getTermEndTime(), (String)"yyyy-MM-dd");
            newCompanyInfo.setTermBeginTime(termEndTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgProvince())) {
            newCompanyInfo.setProvince(importDto.getOrgProvince());
            newCompanyInfo.setProvinceCode(((AreaDto)addressInfoMap.get(importDto.getOrgProvince())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCity())) {
            newCompanyInfo.setCity(importDto.getCity());
            newCompanyInfo.setCityCode(((AreaDto)addressInfoMap.get(importDto.getCity())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgDistrict())) {
            newCompanyInfo.setDistrict(importDto.getOrgDistrict());
            newCompanyInfo.setDistrictCode(((AreaDto)addressInfoMap.get(importDto.getOrgDistrict())).getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgAddress())) {
            newCompanyInfo.setAddress(importDto.getOrgAddress());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalName())) {
            newCompanyInfo.setLegalName(importDto.getLegalName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardType())) {
            newCompanyInfo.setLegalCardType(this.toLegalCardType(importDto.getLegalCardType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLegalCardNum())) {
            newCompanyInfo.setLegalCardNum(importDto.getLegalCardNum());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCardEffectType())) {
            newCompanyInfo.setCardEffectType(this.toCardEffectType(importDto.getCardEffectType()));
        }
        if (Objects.nonNull(importDto.getCardEffectBeginTime())) {
            newCompanyInfo.setCardEffectBeginTime(importDto.getCardEffectBeginTime());
        }
        if (Objects.nonNull(importDto.getCardEffectEndTime())) {
            newCompanyInfo.setCardEffectEndTime(importDto.getCardEffectEndTime());
        }
        updateCustomerDto.setCompanyInfoDto(newCompanyInfo);
        CompanyVerifyRespDto companyVerifyRespDto = this.customerAddImportService.queryStoreVerify(newCompanyInfo.getCreditCode(), newCompanyInfo.getOrgName(), newCompanyInfo.getLegalName());
        if (1 != companyVerifyRespDto.getResult()) {
            throw new BizException(companyVerifyRespDto.getRemark());
        }
        ServiceContext.getContext().setAttachment("yes.req.tenantId", requestTenantId.toString());
        ServiceContext.getContext().setAttachment("yes.req.instanceId", requestInstanceId.toString());
        this.logger.info("\u4fee\u6539\u5ba2\u6237\u8bf7\u6c42\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)updateCustomerDto));
        RestResponseHelper.extractData((RestResponse)this.customerExtApi.update(updateCustomerDto));
    }

    private String toSubjectType(String name) {
        if (SubjectTypeEnum.COMPANY.getName().equals(name)) {
            return SubjectTypeEnum.COMPANY.getType();
        }
        if (SubjectTypeEnum.INDIVIDUAL.getName().equals(name)) {
            return SubjectTypeEnum.INDIVIDUAL.getType();
        }
        if (SubjectTypeEnum.ZOOID.getName().equals(name)) {
            return SubjectTypeEnum.ZOOID.getType();
        }
        return "";
    }

    private Integer toBusinessLicenseType(String name) {
        if ("\u591a\u8bc1\u5408\u4e00\u8425\u4e1a\u6267\u7167".equals(name)) {
            return 1;
        }
        if ("\u666e\u901a\u8425\u4e1a\u6267\u7167".equals(name)) {
            return 2;
        }
        return 0;
    }

    private String toBusinessTermType(String name) {
        if ("\u77ed\u671f\u6709\u6548".equals(name)) {
            return "1";
        }
        if ("\u957f\u671f\u6709\u6548".equals(name)) {
            return "2";
        }
        return "0";
    }

    private Integer toLegalCardType(String name) {
        if ("\u5927\u9646\u5c45\u6c11\u8eab\u4efd\u8bc1".equals(name)) {
            return 1;
        }
        if ("\u6e2f\u6fb3\u53f0\uff08\u8eab\u4efd\u8bc1\u3001\u5c45\u6c11\u901a\u884c\u8bc1\uff09".equals(name)) {
            return 2;
        }
        if ("\u62a4\u7167\uff08\u9650\u5883\u5916\u4eba\u58eb\uff09".equals(name)) {
            return 3;
        }
        return 0;
    }

    private Integer toCardEffectType(String name) {
        if ("\u77ed\u671f\u6709\u6548".equals(name)) {
            return 1;
        }
        if ("\u957f\u671f\u6709\u6548".equals(name)) {
            return 2;
        }
        return 0;
    }
}

