/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogStatusEnum;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.SaleAreaImportDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportLogService;
import com.dtyunxi.tcbj.module.export.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.dao.eo.ImportLogEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.ICustomerAreaExtApi;
import com.yx.tcbj.center.customer.api.dto.request.CustomerAreaExtReqDto;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleAreaImportService {
    public final Logger logger = LoggerFactory.getLogger(SaleAreaImportService.class);
    @Resource
    private IContext context;
    @Resource
    private ImportLogService importLogService;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Autowired
    private IObjectStorageService objectStorageService;
    @Autowired
    private ICustomerAreaExtApi customerAreaExtApi;

    Long getTenantId() {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        if (Objects.isNull(tenantId)) {
            tenantId = 1L;
        }
        return tenantId;
    }

    Long getInstanceId() {
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        if (Objects.isNull(instanceId)) {
            instanceId = 1254039287584232622L;
        }
        return instanceId;
    }

    public void saleAreaImport(ImportReqDto importReqDto) {
        this.logger.info("\u6279\u91cf\u5bfc\u5165\u5546\u5bb6\u9500\u552e\u533a\u57df:{}", (Object)JSON.toJSONString((Object)importReqDto));
        String fileUrl = importReqDto.getFileUrl();
        List<Long> sellerIdList = importReqDto.getSellerIdList();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty(sellerIdList, (String)"\u5bfc\u5165\u7684\u5546\u5bb6\u4e3a\u7a7a");
        List importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, SaleAreaImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList((List)importDtos);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u6536\u9000\u6b3e\u5355\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setIdList(sellerIdList);
        List sellerDtoList = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryListOnPost(sellerQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)sellerDtoList)) {
            throw new BizException("\u5bfc\u5165\u6536\u9000\u6b3e\u5355\u89e3\u6790\u5931\u8d25:\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Long requestTenantId = this.getTenantId();
        Long requestInstanceId = this.getInstanceId();
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        for (SellerRespDto sellerRespDto : sellerDtoList) {
            ImportLogEo initLog = ImportLogEo.newInstance();
            initLog.setImportFileUrl(importReqDto.getFileUrl());
            String fileName = importReqDto.getFileName();
            if (StringUtils.isEmpty((CharSequence)importReqDto.getFileName())) {
                fileName = StringUtils.substringAfter((String)importReqDto.getFileUrl(), (String)"cube//");
            }
            initLog.setFileName(fileName);
            initLog.setImportType(ImportLogTypeEnum.SALE_AREA.getCode());
            initLog.setTotalNum(Integer.valueOf(importDtos.size()));
            initLog.setOrganizationId(sellerRespDto.getOrganizationId());
            initLog.setSellerId(sellerRespDto.getId());
            initLog.setInstanceId(requestInstanceId);
            initLog.setTenantId(requestTenantId);
            Long importLogId = this.importLogService.init(initLog);
            List finalImportDtos = importDtos;
            CompletableFuture.runAsync(() -> {
                try {
                    this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5546\u5bb6\u9500\u552e\u533a\u57df\u5f00\u59cb,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                    this.doImportSyn(requestTenantId, requestInstanceId, finalImportDtos, importLogId, sellerRespDto.getId(), sellerRespDto.getOrganizationId());
                    this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5546\u5bb6\u9500\u552e\u533a\u57df\u7ed3\u675f,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                }
                catch (Exception e) {
                    this.importLogService.fail(importLogId, e.getMessage(), "", finalImportDtos.size());
                    e.printStackTrace();
                    this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5546\u5bb6\u9500\u552e\u533a\u57df\u5f00\u59cb,\u65e5\u5fd7id[{}],\u5f02\u5e38\u4fe1\u606f{}", (Object)importLogId, (Object)e.getMessage());
                }
            });
        }
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private void doImportSyn(Long requestTenantId, Long requestInstanceId, List<SaleAreaImportDto> importDtos, Long importLogId, Long sellerId, Long orgId) {
        this.checkData(importDtos);
        List successList = importDtos.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        this.logger.info("\u7b5b\u9009\u6210\u529f\u7684\u6570\u636e:{}", (Object)successList.size());
        for (SaleAreaImportDto dto2 : importDtos) {
            if (StringUtils.isNotEmpty((CharSequence)dto2.getErrorReason())) continue;
            ArrayList areaExtReqDtos = Lists.newArrayList();
            CustomerAreaExtReqDto addArea1 = new CustomerAreaExtReqDto();
            addArea1.setName(dto2.getLevelAreaName1());
            addArea1.setOrgInfoId(orgId);
            addArea1.setSellerId(sellerId);
            addArea1.setInstanceId(requestInstanceId);
            addArea1.setTenantId(requestTenantId);
            areaExtReqDtos.add(addArea1);
            CustomerAreaExtReqDto addArea2 = new CustomerAreaExtReqDto();
            addArea2.setName(dto2.getLevelAreaName2());
            addArea2.setOrgInfoId(orgId);
            addArea2.setSellerId(sellerId);
            addArea2.setInstanceId(requestInstanceId);
            addArea2.setTenantId(requestTenantId);
            areaExtReqDtos.add(addArea2);
            CustomerAreaExtReqDto addArea3 = new CustomerAreaExtReqDto();
            addArea3.setName(dto2.getLevelAreaName3());
            addArea3.setOrgInfoId(orgId);
            addArea3.setSellerId(sellerId);
            addArea3.setInstanceId(requestInstanceId);
            addArea3.setTenantId(requestTenantId);
            areaExtReqDtos.add(addArea3);
            if (StringUtils.isNotEmpty((CharSequence)dto2.getLevelAreaName4())) {
                CustomerAreaExtReqDto addArea4 = new CustomerAreaExtReqDto();
                addArea4.setName(dto2.getLevelAreaName4());
                addArea4.setOrgInfoId(orgId);
                addArea4.setSellerId(sellerId);
                addArea4.setInstanceId(requestInstanceId);
                addArea4.setTenantId(requestTenantId);
                areaExtReqDtos.add(addArea4);
            }
            if (StringUtils.isNotEmpty((CharSequence)dto2.getLevelAreaName5())) {
                CustomerAreaExtReqDto addArea5 = new CustomerAreaExtReqDto();
                addArea5.setName(dto2.getLevelAreaName5());
                addArea5.setOrgInfoId(orgId);
                addArea5.setSellerId(sellerId);
                addArea5.setInstanceId(requestInstanceId);
                addArea5.setTenantId(requestTenantId);
                areaExtReqDtos.add(addArea5);
            }
            this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5546\u5bb6\u9500\u552e\u533a\u57df\u65b0\u589e,\u65e5\u5fd7id[{}]={}", (Object)importLogId, JSON.toJSON((Object)areaExtReqDtos));
            try {
                RestResponseHelper.extractData((RestResponse)this.customerAreaExtApi.saveOrUpdateSaleArea((List)areaExtReqDtos));
            }
            catch (Exception e) {
                this.logger.info("\u66f4\u65b0\u5546\u5bb6\u9500\u552e\u533a\u57df\u5931\u8d25:{}", (Object)e.getMessage());
                dto2.setErrorReason("\u66f4\u65b0\u5546\u5bb6\u9500\u552e\u533a\u57df\u5931\u8d25:" + e.getMessage());
            }
        }
        List errorList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        int errorSize = errorList.size();
        int totalSize = importDtos.size();
        if (errorSize == 0) {
            this.importLogService.success(importLogId, ImportLogStatusEnum.SUCCEED, totalSize, "", "", 0);
        } else {
            String title = "\u5bfc\u5165\u5546\u5bb6\u9500\u552e\u533a\u57df\u8fd4\u56de\u7ed3\u679c";
            String fileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
            String exportUrl = "";
            String failReason = "";
            try {
                Thread.sleep(2000L);
                exportUrl = EasyPoiExportUtil.getExportUrl(importDtos, SaleAreaImportDto.class, null, fileName, "xlsx");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.info("\u5bfc\u51fa\u5f02\u5e38\uff1a{}", (Throwable)e);
                failReason = "\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage();
                this.logger.info(failReason);
            }
            if (errorSize < totalSize) {
                this.importLogService.success(importLogId, ImportLogStatusEnum.PART_SUCCESS, totalSize - errorSize, failReason, exportUrl, errorSize);
            } else {
                this.importLogService.fail(importLogId, failReason, exportUrl, errorSize);
            }
        }
    }

    private void checkData(List<SaleAreaImportDto> importDtos) {
        for (SaleAreaImportDto importDto : importDtos) {
            HashMap<String, Integer> distinctMap = new HashMap<String, Integer>(5);
            StringBuffer errorMsg = new StringBuffer();
            if (StringUtils.isEmpty((CharSequence)importDto.getLevelAreaName1())) {
                errorMsg.append("\u4e00\u7ea7\u533a\u57df\u540d\u79f0\u4e3a\u7a7a;");
            } else {
                distinctMap.put(importDto.getLevelAreaName1(), 1);
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getLevelAreaName2())) {
                errorMsg.append("\u4e8c\u7ea7\u533a\u57df\u540d\u79f0\u4e3a\u7a7a;");
            } else if (distinctMap.containsKey(importDto.getLevelAreaName2())) {
                errorMsg.append("\u533a\u57df\u540d\u79f0\u91cd\u590d;");
            } else {
                distinctMap.put(importDto.getLevelAreaName2(), 1);
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getLevelAreaName3())) {
                errorMsg.append("\u4e09\u7ea7\u533a\u57df\u540d\u79f0\u4e3a\u7a7a;");
            } else if (distinctMap.containsKey(importDto.getLevelAreaName3())) {
                errorMsg.append("\u533a\u57df\u540d\u79f0\u91cd\u590d;");
            } else {
                distinctMap.put(importDto.getLevelAreaName3(), 1);
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getLevelAreaName4())) {
                if (distinctMap.containsKey(importDto.getLevelAreaName4())) {
                    errorMsg.append("\u533a\u57df\u540d\u79f0\u91cd\u590d;");
                } else {
                    distinctMap.put(importDto.getLevelAreaName3(), 1);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)errorMsg)) continue;
            importDto.setErrorReason(errorMsg.toString());
        }
    }
}

