/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.abs.ReportExportAbstract;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.RebateUseLogExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.operation.CurrentCommonService;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.RebateUseLogExportVo;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateUseLogQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateUseLogExtRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.query.IRebateUseLogQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RebateUseLogExportService
extends ReportExportAbstract<RebateUseLogExtRespDto, RebateUseLogExportReqDto, RebateUseLogExportVo> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CurrentCommonService currentCommonService;
    @Autowired
    private ISellerExtQueryApi sellerExtQueryApi;
    @Autowired
    private IRebateUseLogQueryApi rebateUseLogQueryApi;

    @Override
    public ExportTypeEnum getExportType() {
        return ExportTypeEnum.REBATE_USE_LOG;
    }

    @Override
    public PageInfo<RebateUseLogExtRespDto> queryData(RebateUseLogExportReqDto rebateUseLogExportReqDto) {
        RebateUseLogQueryReqDto rebateUseLogQueryReqDto = new RebateUseLogQueryReqDto();
        BeanUtils.copyProperties((Object)((Object)rebateUseLogExportReqDto), (Object)rebateUseLogQueryReqDto);
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.rebateUseLogQueryApi.queryRebateUseLogByPage(rebateUseLogQueryReqDto));
    }

    @Override
    public RebateUseLogExportReqDto definePrams(RebateUseLogExportReqDto rebateUseLogExportReqDto) {
        List<Long> currentOrgId = this.currentCommonService.getCurrentOrgId();
        this.logger.info("[\u6298\u6263\u5145\u503c\u5355\u6d41\u6c34\u5bfc\u51fa]\uff0c\u7ec4\u7ec7id\uff1a{}", currentOrgId);
        if (CollectionUtils.isNotEmpty(currentOrgId)) {
            rebateUseLogExportReqDto.setOrganizationId(currentOrgId.get(0));
        }
        return rebateUseLogExportReqDto;
    }

    @Override
    public Gson buildGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }

    @Override
    public List<RebateUseLogExportVo> getExportDtoList(List<RebateUseLogExtRespDto> exportDtoList, Class<RebateUseLogExportVo> vo) {
        ArrayList rebateUseLogExportVos = Lists.newArrayList();
        for (RebateUseLogExtRespDto rebateUseLogExtRespDto : exportDtoList) {
            RebateUseLogExportVo rebateUseLogExportVo = new RebateUseLogExportVo();
            CubeBeanUtils.copyProperties((Object)((Object)rebateUseLogExportVo), (Object)rebateUseLogExtRespDto, (String[])new String[0]);
            rebateUseLogExportVo.setCreateTime(DateUtil.getDateFormat((Date)rebateUseLogExtRespDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            String effectTime = "\u957f\u671f\u6709\u6548";
            if (Objects.equals(rebateUseLogExtRespDto.getUseEffectType(), 2)) {
                String beginTime = DateUtil.getDateFormat((Date)rebateUseLogExtRespDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
                String endTime = DateUtil.getDateFormat((Date)rebateUseLogExtRespDto.getEffectEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
                effectTime = beginTime + " ~ " + endTime;
            }
            rebateUseLogExportVo.setEffectTime(effectTime);
            BigDecimal rebateAmount = Optional.of(rebateUseLogExtRespDto.getRebateAmount()).orElse(BigDecimal.ZERO);
            BigDecimal balance = Optional.of(rebateUseLogExtRespDto.getBalance()).orElse(BigDecimal.ZERO);
            rebateUseLogExportVo.setUsedBalance(rebateAmount.subtract(balance));
            RebateOrderStatusEnum rebateOrderStatusEnum = RebateOrderStatusEnum.getByCode((String)rebateUseLogExtRespDto.getStatus());
            if (rebateOrderStatusEnum != null) {
                rebateUseLogExportVo.setStatus(rebateOrderStatusEnum.getDesc());
            }
            rebateUseLogExportVos.add(rebateUseLogExportVo);
        }
        return rebateUseLogExportVos;
    }
}

