/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.EmployeeOrgQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.EmployeeOrgRespDto;
import com.dtyunxi.tcbj.api.query.IOrgSellerCustomerQueryApi;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.vo.user.CustomerEmployeeExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.user.EmployeeOrgExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.user.UserInfoDBExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.user.UserInfoPPExportVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeNumCountReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeNumCountRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.RestUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserExportService {
    private static final Logger logger = LoggerFactory.getLogger(UserExportService.class);
    @Resource
    private ExportService exportService;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private IOrgSellerCustomerQueryApi orgSellerCustomerQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;

    public RestResponse<Object> exportUser(EmployeeExtQueryReqDto reqDto, String type) {
        logger.info("\u4eba\u5458\u4fe1\u606f\u5bfc\u51fa\uff0c\u5165\u53c2\uff1areqDto={}\uff0ctype={}", (Object)JSON.toJSONString((Object)reqDto), (Object)type);
        String name = "PP".equals(type) ? "\u54c1\u724c\u4eba\u5458\u4fe1\u606f" : "\u5927B\u4eba\u5458\u4fe1\u606f";
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.USER);
        baseExportService.executor(req -> {
            try {
                RestResponse<PageInfo<EmployeeExtRespDto>> pageInfoRestResponse;
                String organizationId;
                reqDto.setPageNum(Integer.valueOf(1));
                reqDto.setPageSize(Integer.valueOf(100000));
                if (Objects.isNull(reqDto.getOrganizationId()) && StringUtils.isNotBlank((CharSequence)(organizationId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid")))) {
                    reqDto.setOrganizationId(Long.valueOf(Long.parseLong(organizationId)));
                }
                if (ObjectUtils.isNotEmpty((Object)(pageInfoRestResponse = this.queryByPage(reqDto)).getData()) && CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
                    List employeeList = ((PageInfo)pageInfoRestResponse.getData()).getList();
                    logger.info("\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f\u6570\u91cf: {}", (Object)employeeList.size());
                    if ("PP".equals(type)) {
                        this.exportPPUserData(baseExportService, employeeList);
                    } else {
                        this.exportDBUserData(baseExportService, employeeList);
                    }
                } else {
                    this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa" + name + "\u5f02\u5e38", (Throwable)e);
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5f02\u5e38: " + e.getMessage());
            }
            return null;
        }, reqDto);
        return new RestResponse("0", "\u5bfc\u51fa" + name + "\u6210\u529f");
    }

    public RestResponse<PageInfo<EmployeeExtRespDto>> queryByPage(EmployeeExtQueryReqDto reqDto) {
        List orgIdList;
        List customerRespDtos;
        logger.info("\u8bf7\u6c42\u53c2\u6570\u7ec4\u7ec7ID\uff1a{}", (Object)reqDto.getOrganizationId());
        String organizationId = String.valueOf(reqDto.getOrganizationId());
        AssertUtil.assertNotBlank((String)organizationId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        AssertUtil.assertNotNull((Object)reqDto.getInstanceId(), (String)"\u5b9e\u4f8bID[instanceId]\u4e0d\u80fd\u4e3a\u7a7a");
        Long orgId = StringUtils.isBlank((CharSequence)organizationId) ? null : Long.valueOf(Long.parseLong(organizationId));
        reqDto.setOrganizationId(orgId);
        Long tenantId = this.tenantId();
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList employeeIds = new ArrayList();
        if (Objects.nonNull(reqDto.getType()) && reqDto.getType() == 1) {
            customerRespDtos = this.getCustomerRespDtos(reqDto);
            if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                return new RestResponse((Object)dtoPageInfo);
            }
            orgIdList = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
            reqDto.setOrganizationIdList(orgIdList);
            reqDto.setOrganizationId(null);
        } else {
            customerRespDtos = Optional.ofNullable(this.getCustomerRespDtos(reqDto)).orElse(new ArrayList());
            orgIdList = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
            orgIdList.add(reqDto.getOrganizationId());
            reqDto.setOrganizationIdList(orgIdList);
            reqDto.setOrganizationId(null);
        }
        List empCustDtos = null;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerName()) || StringUtils.isNotBlank((CharSequence)reqDto.getCustomerCode())) {
            CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
            customerExtReqDto.setCode(reqDto.getCustomerCode());
            customerExtReqDto.setName(reqDto.getCustomerName());
            customerExtReqDto.setInstanceId(reqDto.getInstanceId());
            customerExtReqDto.setMerchantId(reqDto.getOrganizationId());
            logger.info("\u5f00\u59cb\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f(\u6839\u636e\u5ba2\u6237\u540d\u79f0\u3001\u5ba2\u6237\u7f16\u53f7\u67e5\u8be2)\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)customerExtReqDto));
            empCustDtos = (List)RestUtil.checkResponse((RestResponse)this.employeeCustomerQueryApi.queryEmployee(customerExtReqDto));
            logger.info("\u7ed3\u675f\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f(\u6839\u636e\u5ba2\u6237\u540d\u79f0\u3001\u5ba2\u6237\u7f16\u53f7\u67e5\u8be2)\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)empCustDtos));
            if (CollectionUtils.isEmpty((Collection)empCustDtos)) {
                return new RestResponse((Object)dtoPageInfo);
            }
            List _ids = empCustDtos.stream().map(EmployeeCustomerRespDto::getEmployeeId).collect(Collectors.toList());
            employeeIds.addAll(_ids);
        }
        if (CollectionUtils.isNotEmpty(employeeIds)) {
            reqDto.setIds(employeeIds);
        }
        PageInfo employeePage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.queryByPage(reqDto));
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)employeePage, (String[])new String[]{"list", "navigatepageNums"});
        List employeePageList = employeePage.getList();
        ArrayList dtoList = Lists.newArrayList();
        if (Objects.nonNull(reqDto.getType()) && reqDto.getType() == 1) {
            this.fillCustomInfo(dtoList, orgId);
        } else {
            this.fillCustomerAndRegionNum(dtoList, Long.valueOf(organizationId), reqDto.getInstanceId(), tenantId);
        }
        dtoPageInfo.setList((List)dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    public Long tenantId() {
        Long tenantId = this.context.tenantId();
        logger.info("tenantId >>> {}", (Object)tenantId);
        if (tenantId == null) {
            tenantId = 1L;
        }
        return tenantId;
    }

    private List<CustomerRespDto> getCustomerRespDtos(EmployeeExtQueryReqDto reqDto) {
        CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
        customerExtQuery.setMerchantId(reqDto.getOrganizationId());
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getEmpCustomerCode())) {
            customerExtQuery.setCode(reqDto.getEmpCustomerCode());
        }
        customerExtQuery.setCustomerNameLike(reqDto.getCustomerNameLike());
        customerExtQuery.setCustomerCodeLike(reqDto.getCustomerCodeLike());
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f(\u6839\u636e\u5ba2\u6237\u540d\u79f0\u6a21\u7cca\u67e5\u8be2)\uff0c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)customerExtQuery));
        return (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
    }

    private void fillCustomInfo(List<EmployeeExtRespDto> dtoList, Long merchantId) {
        List orgIdList = dtoList.stream().map(EmployeeExtRespDto::getOrganizationId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
            customerExtQuery.setMerchantId(merchantId);
            customerExtQuery.setOrgInfoIds(orgIdList);
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
            if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                return;
            }
            Map customerMap = customerRespDtos.stream().collect(Collectors.toMap(dto -> merchantId + "_" + dto.getOrgInfoId(), Function.identity()));
            for (EmployeeExtRespDto dto2 : dtoList) {
                String key = merchantId + "_" + dto2.getOrganizationId();
                if (customerMap.isEmpty() || !customerMap.containsKey(key)) continue;
                CustomerRespDto customerRespDto = (CustomerRespDto)customerMap.get(key);
                dto2.setCustomerName(customerRespDto.getName());
                dto2.setCustomerCode(customerRespDto.getCode());
            }
        }
    }

    private void fillCustomerAndRegionNum(List<EmployeeExtRespDto> dtoList, Long orgId, Long instanceId, Long tenantId) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List employeeIds = dtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(employeeIds)) {
            return;
        }
        EmployeeNumCountReqDto reqDto = new EmployeeNumCountReqDto();
        reqDto.setEmployeeIds(employeeIds);
        reqDto.setOrgId(orgId);
        RestResponse response = this.employeeCustomerQueryApi.queryCountByEmployeeId(reqDto);
        if (Objects.nonNull(response) && "0".equals(response.getResultCode()) && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            List list = (List)response.getData();
            for (EmployeeExtRespDto dto : dtoList) {
                for (EmployeeNumCountRespDto countNumDto : list) {
                    if (!Objects.nonNull(dto) || !Objects.nonNull(dto.getId()) || !Objects.nonNull(countNumDto) || !Objects.nonNull(countNumDto.getEmployeeId()) || dto.getId().longValue() != countNumDto.getEmployeeId().longValue()) continue;
                    dto.setCustomerNum(countNumDto.getCustomerNum());
                    dto.setRegionNum(countNumDto.getRegionNum());
                }
            }
        }
    }

    private void exportPPUserData(BaseExportService baseExportService, List<EmployeeExtRespDto> employeeList) {
        ArrayList exportList = Lists.newArrayList();
        for (EmployeeExtRespDto dto : employeeList) {
            UserInfoPPExportVo vo = new UserInfoPPExportVo();
            CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
            vo.setUserStatus(Objects.isNull(dto.getStatus()) ? "" : dto.getStatus() + "");
            vo.setRoles(dto.getOrganizationNames());
            vo.setPersonType(dto.getType() != null && dto.getType() == 1 ? "External" : "Internal");
            exportList.add(vo);
        }
        baseExportService.exportUrl(exportList, UserInfoPPExportVo.class);
    }

    private void exportDBUserData(BaseExportService baseExportService, List<EmployeeExtRespDto> employeeList) {
        ArrayList exportList = Lists.newArrayList();
        for (EmployeeExtRespDto dto : employeeList) {
            UserInfoDBExportVo vo = new UserInfoDBExportVo();
            CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
            vo.setUserStatus(Objects.isNull(dto.getStatus()) ? "" : dto.getStatus() + "");
            vo.setRoles(dto.getOrganizationNames());
            vo.setAreaCount(Objects.isNull(dto.getRegionNum()) ? "0" : dto.getRegionNum() + "");
            vo.setCustomerCount(Objects.isNull(dto.getCustomerNum()) ? "0" : dto.getCustomerNum() + "");
            vo.setPersonType(dto.getPersonType());
            exportList.add(vo);
        }
        baseExportService.exportUrl(exportList, UserInfoDBExportVo.class);
    }

    public RestResponse<Object> exportOrgEmployee(EmployeeOrgQueryReqDto reqDto) {
        logger.info("\u7ec4\u7ec7\u4eba\u5458\u4fe1\u606f\u5bfc\u51fa\uff0c\u5165\u53c2\uff1areqDto={}", (Object)JSON.toJSONString((Object)reqDto));
        String name = "\u7ec4\u7ec7\u4eba\u5458\u4fe1\u606f";
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.ORG_EMPLOYEE);
        baseExportService.executor(req -> {
            try {
                reqDto.setPageNum(Integer.valueOf(1));
                reqDto.setPageSize(Integer.valueOf(100000));
                RestResponse pageInfoRestResponse = this.orgSellerCustomerQueryApi.queryEmployeeOrgPage(reqDto);
                if (ObjectUtils.isNotEmpty((Object)pageInfoRestResponse.getData()) && CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
                    List employeeList = ((PageInfo)pageInfoRestResponse.getData()).getList();
                    logger.info("\u67e5\u8be2\u5230\u7ec4\u7ec7\u4eba\u5458\u4fe1\u606f\u6570\u91cf: {}", (Object)employeeList.size());
                    ArrayList exportList = Lists.newArrayList();
                    for (EmployeeOrgRespDto dto : employeeList) {
                        EmployeeOrgExportVo vo = new EmployeeOrgExportVo();
                        CubeBeanUtils.copyProperties((Object)((Object)vo), (Object)dto, (String[])new String[0]);
                        exportList.add(vo);
                    }
                    baseExportService.exportUrl(exportList, EmployeeOrgExportVo.class);
                } else {
                    this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa" + name + "\u5f02\u5e38", (Throwable)e);
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5f02\u5e38: " + e.getMessage());
            }
            return null;
        }, reqDto);
        return new RestResponse("0", "\u5bfc\u51fa" + name + "\u6210\u529f");
    }

    public RestResponse<Object> exportCustomerEmployee(EmployeeExtQueryReqDto reqDto) {
        logger.info("\u5ba2\u6237\u4eba\u5458\u4fe1\u606f\u5bfc\u51fa\uff0c\u5165\u53c2\uff1areqDto={}", (Object)JSON.toJSONString((Object)reqDto));
        String name = "\u5ba2\u6237\u4eba\u5458\u4fe1\u606f";
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.CUSTOMER_EMPLOYEE);
        baseExportService.executor(req -> {
            try {
                RestResponse pageInfoRestResponse;
                String organizationId;
                reqDto.setPageNum(Integer.valueOf(1));
                reqDto.setPageSize(Integer.valueOf(100000));
                reqDto.setType(Integer.valueOf(1));
                if (Objects.isNull(reqDto.getOrganizationId()) && StringUtils.isNotBlank((CharSequence)(organizationId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid")))) {
                    reqDto.setOrganizationId(Long.valueOf(Long.parseLong(organizationId)));
                }
                if (ObjectUtils.isNotEmpty((Object)(pageInfoRestResponse = this.employeeExpandQueryApi.queryByPage(reqDto)).getData()) && CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
                    List employeeList = ((PageInfo)pageInfoRestResponse.getData()).getList();
                    logger.info("\u67e5\u8be2\u5230\u5ba2\u6237\u4eba\u5458\u4fe1\u606f\u6570\u91cf: {}", (Object)employeeList.size());
                    ArrayList exportList = Lists.newArrayList();
                    for (EmployeeExtRespDto dto : employeeList) {
                        CustomerEmployeeExportVo vo = new CustomerEmployeeExportVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)dto, (String[])new String[0]);
                        vo.setUserStatus(Objects.isNull(dto.getStatus()) ? "" : dto.getStatus() + "");
                        exportList.add(vo);
                    }
                    baseExportService.exportUrl(exportList, CustomerEmployeeExportVo.class);
                } else {
                    this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa" + name + "\u5f02\u5e38", (Throwable)e);
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5f02\u5e38: " + e.getMessage());
            }
            return null;
        }, reqDto);
        return new RestResponse("0", "\u5bfc\u51fa" + name + "\u6210\u529f");
    }
}

