/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.company.CompanyVerifyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyResultDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyResultInfoDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.center.openapi.api.query.ICompanyQueryApi;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogStatusEnum;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.CheckCreditByCustomerCodeReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.CustomerAddImportDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportLogService;
import com.dtyunxi.tcbj.module.export.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.dao.eo.ImportLogEo;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.constant.SubjectTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsCustomerEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsDealEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreAreaLevelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreDataOriginEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.IAddressApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerExtApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerStatusReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerStatusRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.IAddressQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryProvinceReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IAuthItemRuleApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeExpandApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.dtyunxi.yundt.module.customer.biz.constant.TianyanchaProvinceEnum;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanPropertyNullUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.demo.center.data.query.IAreaExtQueryApi;
import com.yx.tcbj.center.api.ItemBrandAuthApi;
import com.yx.tcbj.center.customer.api.ICustomerExtThreeApi;
import com.yx.tcbj.center.customer.api.dto.request.CompanyCheckReqDto;
import com.yx.tcbj.center.customer.api.dto.request.ComputeCustomerNameRateReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import com.yx.tcbj.center.price.api.IPrBaseDiscountApi;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountAddEditReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import com.yx.tcbj.center.rebate.api.IOfflineBalanceAccountApi;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceAccountReqDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceAccountEnum;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class CustomerAddImportService {
    public final Logger logger = LoggerFactory.getLogger(CustomerAddImportService.class);
    @Resource
    private IContext context;
    @Resource
    private ImportLogService importLogService;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IEmployeeExpandApi employeeExpandApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private ICustomerExtApi customerExtApi;
    @Resource
    private IAddressApi addressApi;
    @Resource
    private IAddressQueryApi addressQueryApi;
    @Resource
    private ICompanyQueryApi companyQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private IStoreQueryApi storeQueryApi;
    @Resource
    private ICacheService cacheService;
    private static final String COMPANY_CASH_KEY = "COMPANY_CASH_KEY";
    @Resource
    private IAreaExtQueryApi areaExtQueryApi;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Resource
    private IOfflineBalanceAccountApi offlineBalanceAccountApi;
    @Resource
    private IStoreService storeService;
    @Resource
    private IPrBaseDiscountApi prBaseDiscountApi;
    @Resource
    private IAuthItemRuleApi authItemRuleApi;
    @Resource
    private ItemBrandAuthApi itemBrandAuthApi;
    @Resource
    private ICustomerExtThreeApi customerExtThreeApi;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;

    Long getTenantId() {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        if (Objects.isNull(tenantId)) {
            tenantId = 1L;
        }
        return tenantId;
    }

    Long getInstanceId() {
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        if (Objects.isNull(instanceId)) {
            instanceId = 1254039287584232622L;
        }
        return instanceId;
    }

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    public void customerInfoAddImport(ImportReqDto importReqDto) {
        this.logger.info("\u5ba2\u6237\u5217\u8868\u5bfc\u5165\u5ba2\u6237\u65b0\u589e:{}", (Object)JSON.toJSONString((Object)importReqDto));
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        String b2bOrgIdStr = this.getHeaderOrgId();
        if (StringUtils.isEmpty((CharSequence)b2bOrgIdStr)) {
            b2bOrgIdStr = this.nacosPropertiesOrgEntity.orgId();
            this.logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)b2bOrgIdStr);
        }
        AssertUtil.assertNotBlank((String)b2bOrgIdStr, (String)"\u8bf7\u6c42\u5934[yes-req-cus-b2b-organizationId]\u503c\u4e3a\u7a7a");
        Long b2bOrgId = Long.valueOf(b2bOrgIdStr);
        List<Object> importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, CustomerAddImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil.getAllFieldNullList((List)importDtos).stream().filter(r -> JSONObject.toJSONString((Object)r).length() > 2).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new BizException("\u5ba2\u6237\u5217\u8868\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        Long requestTenantId = this.getTenantId();
        Long requestInstanceId = this.getInstanceId();
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        ImportLogEo initLog = ImportLogEo.newInstance();
        initLog.setImportFileUrl(importReqDto.getFileUrl());
        String fileName = importReqDto.getFileName();
        if (StringUtils.isEmpty((CharSequence)importReqDto.getFileName())) {
            fileName = StringUtils.substringAfter((String)importReqDto.getFileUrl(), (String)"cube//");
        }
        initLog.setFileName(fileName);
        initLog.setImportType(ImportLogTypeEnum.CUSTOMER.getCode());
        initLog.setTotalNum(Integer.valueOf(importDtos.size()));
        initLog.setOrganizationId(b2bOrgId);
        initLog.setInstanceId(requestInstanceId);
        initLog.setTenantId(requestTenantId);
        Long importLogId = this.importLogService.init(initLog);
        Long userId = this.context.userId();
        String AccessToken = ServiceContext.getContext().getAttachment("Access-Token");
        this.logger.info("AccessToken={}", (Object)AccessToken);
        String organizationid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        Map attachments = ServiceContext.getContext().getAttachments();
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        List<Object> finalImportDtos = importDtos;
        CompletableFuture.runAsync(() -> {
            try {
                RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
                attachments.forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
                ServiceContext.getContext().setAttachment("Access-Token", AccessToken);
                ServiceContext.getContext().setAttachment("yes.req.cus.b2b.organizationid", organizationid);
                this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u5f00\u59cb,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                this.doImportSyn(requestTenantId, requestInstanceId, finalImportDtos, importLogId, null, b2bOrgId);
                this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u7ed3\u675f,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
            }
            catch (Exception e) {
                this.importLogService.fail(importLogId, e.getMessage(), "", finalImportDtos.size());
                e.printStackTrace();
                this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u65e5\u5fd7id[{}],\u5f02\u5e38\u4fe1\u606f{}", (Object)importLogId, (Object)e.getMessage());
            }
        });
    }

    public void customerAddImport(ImportReqDto importReqDto) {
        this.logger.info("\u6279\u91cf\u5bfc\u5165\u5ba2\u6237\u65b0\u589e:{}", (Object)JSON.toJSONString((Object)importReqDto));
        String fileUrl = importReqDto.getFileUrl();
        List<Long> sellerIdList = importReqDto.getSellerIdList();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty(sellerIdList, (String)"\u5bfc\u5165\u7684\u5546\u5bb6\u4e3a\u7a7a");
        List importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, CustomerAddImportDto.class);
            importDtos = objectExcelImportResult.getList();
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setIdList(sellerIdList);
        List sellerDtoList = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryListOnPost(sellerQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)sellerDtoList)) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u89e3\u6790\u5931\u8d25:\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Long requestTenantId = this.getTenantId();
        Long requestInstanceId = this.getInstanceId();
        String AccessToken = ServiceContext.getContext().getAttachment("Access-Token");
        this.logger.info("AccessToken={}", (Object)AccessToken);
        for (SellerRespDto sellerRespDto : sellerDtoList) {
            ImportLogEo initLog = ImportLogEo.newInstance();
            initLog.setImportFileUrl(importReqDto.getFileUrl());
            String fileName = importReqDto.getFileName();
            if (StringUtils.isEmpty((CharSequence)importReqDto.getFileName())) {
                fileName = StringUtils.substringAfter((String)importReqDto.getFileUrl(), (String)"cube//");
            }
            initLog.setFileName(fileName);
            initLog.setImportType(ImportLogTypeEnum.CUSTOMER.getCode());
            initLog.setTotalNum(Integer.valueOf(importDtos.size()));
            initLog.setOrganizationId(sellerRespDto.getOrganizationId());
            initLog.setSellerId(sellerRespDto.getId());
            initLog.setInstanceId(requestInstanceId);
            initLog.setTenantId(requestTenantId);
            Long importLogId = this.importLogService.init(initLog);
            Map attachments = ServiceContext.getContext().getAttachments();
            ArrayList finalImportDtos = Lists.newArrayList();
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            CubeBeanUtils.copyCollection((Collection)finalImportDtos, importDtos, CustomerAddImportDto.class);
            CompletableFuture.runAsync(() -> {
                attachments.forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
                ServiceContext.getContext().setAttachment("Access-Token", AccessToken);
                RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
                try {
                    ArrayList dtos = Lists.newArrayList();
                    CubeBeanUtils.copyCollection((Collection)dtos, (Collection)finalImportDtos, CustomerAddImportDto.class);
                    this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u5f00\u59cb,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                    this.doImportSyn(requestTenantId, requestInstanceId, dtos, importLogId, sellerRespDto.getId(), sellerRespDto.getOrganizationId());
                    this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u7ed3\u675f,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                }
                catch (Exception e) {
                    this.importLogService.fail(importLogId, e.getMessage(), "", finalImportDtos.size());
                    e.printStackTrace();
                    this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u65e5\u5fd7id[{}],\u5f02\u5e38\u4fe1\u606f{}", (Object)importLogId, (Object)e.getMessage());
                }
            });
        }
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    /*
     * WARNING - void declaration
     */
    private void doImportSyn(Long requestTenantId, Long requestInstanceId, List<CustomerAddImportDto> importDtos, Long importLogId, Long sellerId, Long orgId) {
        List typeRespDtoList;
        List customerTypeList;
        List customerTypeDtos;
        void var8_12;
        for (CustomerAddImportDto customerAddImportDto : importDtos) {
            if (!Objects.isNull(customerAddImportDto.getEffectiveTime())) continue;
            customerAddImportDto.setEffectiveTime(new Date());
        }
        this.checkData(importDtos, sellerId, orgId, requestTenantId, requestInstanceId);
        int duplicateRegionCount = 0;
        for (CustomerAddImportDto customerAddImportDto : importDtos) {
            String[] areaNameArr;
            List uniqueAreaNames;
            if (!StringUtils.isNotEmpty((CharSequence)customerAddImportDto.getRegionName()) || (uniqueAreaNames = Arrays.stream(areaNameArr = customerAddImportDto.getRegionName().split(";")).distinct().collect(Collectors.toList())).size() >= areaNameArr.length) continue;
            ++duplicateRegionCount;
        }
        if (duplicateRegionCount > 0) {
            this.logger.info("\u5bfc\u5165\u6570\u636e\u4e2d\u5b58\u5728{}\u6761\u8bb0\u5f55\u542b\u6709\u91cd\u590d\u533a\u57df\uff0c\u5c06\u81ea\u52a8\u53bb\u91cd\u5904\u7406", (Object)duplicateRegionCount);
        }
        boolean bl = false;
        for (CustomerAddImportDto importDto : importDtos) {
            if (!StringUtils.isNotEmpty((CharSequence)importDto.getBrandDiscount()) || !StringUtils.isEmpty((CharSequence)importDto.getErrorReason())) continue;
            String[] brandDiscounts = importDto.getBrandDiscount().split(",");
            boolean isValid = true;
            for (String brandDiscount : brandDiscounts) {
                if (!brandDiscount.contains(":")) {
                    isValid = false;
                    break;
                }
                String[] parts = brandDiscount.split(":");
                if (parts.length != 2) {
                    isValid = false;
                    break;
                }
                try {
                    new BigDecimal(parts[1]);
                }
                catch (NumberFormatException e) {
                    isValid = false;
                    break;
                }
            }
            if (isValid) continue;
            ++var8_12;
            if (StringUtils.isEmpty((CharSequence)importDto.getErrorReason())) {
                importDto.setErrorReason("\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u54c1\u724c\u540d\u79f0:\u6263\u7387");
                continue;
            }
            importDto.setErrorReason(importDto.getErrorReason() + "\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u54c1\u724c\u540d\u79f0:\u6263\u7387");
        }
        if (var8_12 > 0) {
            this.logger.info("\u5bfc\u5165\u6570\u636e\u4e2d\u5b58\u5728{}\u6761\u8bb0\u5f55\u7684\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef", (Object)((int)var8_12));
        }
        List list = importDtos.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        this.logger.info("\u7b5b\u9009\u6210\u529f\u7684\u6570\u636e:{}", (Object)list.size());
        Map<String, Object> customerTypeInfoMap = new HashMap<String, CustomerTypeRespDto>();
        if (CollectionUtils.isNotEmpty(list) && CollectionUtils.isNotEmpty((Collection)(customerTypeDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.getCustomerTypeByNames(customerTypeList = list.stream().map(CustomerAddImportDto::getCustomerTypeName).collect(Collectors.toList()))))) && CollUtil.isNotEmpty(typeRespDtoList = customerTypeDtos.stream().filter(c -> Objects.equals(c.getType(), 2)).collect(Collectors.toList()))) {
            customerTypeInfoMap = typeRespDtoList.stream().collect(Collectors.toMap(CustomerTypeRespDto::getName, Function.identity(), (k1, k2) -> k1));
        }
        String failReason = "";
        for (CustomerAddImportDto importDto : importDtos) {
            if (StringUtils.isNotEmpty((CharSequence)importDto.getErrorReason())) continue;
            try {
                String errorMsg = this.addCustomer(importDto, orgId, requestTenantId, requestInstanceId, customerTypeInfoMap);
                if (!StringUtils.isNotEmpty((CharSequence)errorMsg)) continue;
                this.logger.info("\u65b0\u589e\u5ba2\u6237\u5931\u8d25\u8bb0\u5f55\u65e5\u5fd7111:{}", (Object)errorMsg);
                importDto.setErrorReason(errorMsg);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.info("\u65b0\u589e\u5ba2\u6237\u5931\u8d25:{}", (Object)e.getMessage());
                importDto.setErrorReason(e.getMessage());
            }
        }
        List errorList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        int errorSize = errorList.size();
        int totalSize = importDtos.size();
        this.logger.info("\u66f4\u65b0\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u5931\u8d25\u6570:{},\u603b\u6570:{}", (Object)errorSize, (Object)totalSize);
        if (errorSize == 0) {
            this.importLogService.success(importLogId, ImportLogStatusEnum.SUCCEED, totalSize, "", "", 0);
        } else {
            String exportUrl = "";
            try {
                String title = "\u5bfc\u5165\u5ba2\u6237\u65b0\u589e\u8fd4\u56de\u7ed3\u679c";
                String fileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
                this.logger.info("\u5bfc\u51falist:{}", (Object)importDtos.size());
                exportUrl = EasyPoiExportUtil.getExportUrl(importDtos, CustomerAddImportDto.class, title, fileName, "xls");
            }
            catch (Exception e) {
                e.printStackTrace();
                failReason = failReason + "\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage();
                this.logger.info(failReason);
            }
            if (errorSize < totalSize) {
                this.importLogService.success(importLogId, ImportLogStatusEnum.PART_SUCCESS, totalSize - errorSize, failReason, exportUrl, errorSize);
            } else {
                this.importLogService.fail(importLogId, failReason, exportUrl, errorSize);
            }
        }
    }

    private void checkData(List<CustomerAddImportDto> importDtos, Long sellerId, Long orgId, Long requestTenantId, Long requestInstanceId) {
        this.logger.info("\u5f00\u59cb\u8fdb\u884c\u5ba2\u6237\u65b0\u589e\u6570\u636e\u9a8c\u8bc1\uff0c\u8bb0\u5f55\u6570: {}", (Object)importDtos.size());
        List allCustomerStatuses = null;
        try {
            CustomerStatusReqDto statusQuery = new CustomerStatusReqDto();
            statusQuery.setRecordStatus(Integer.valueOf(1));
            allCustomerStatuses = (List)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryByList(JSON.toJSONString((Object)statusQuery)));
            this.logger.info("\u83b7\u53d6\u5230\u6709\u6548\u7684\u5ba2\u6237\u72b6\u6001\u5217\u8868, \u6570\u91cf: {}", (Object)(CollectionUtils.isNotEmpty((Collection)allCustomerStatuses) ? allCustomerStatuses.size() : 0));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5ba2\u6237\u72b6\u6001\u5217\u8868\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        Set<Object> validCustomerStatusNames = new HashSet();
        if (CollectionUtils.isNotEmpty(allCustomerStatuses)) {
            validCustomerStatusNames = allCustomerStatuses.stream().map(CustomerStatusRespDto::getName).collect(Collectors.toSet());
        }
        HashSet<String> allAreaNames = new HashSet<String>();
        for (CustomerAddImportDto importDto : importDtos) {
            if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea())) {
                allAreaNames.add(importDto.getSalesArea());
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea())) {
                allAreaNames.add(importDto.getLargeArea());
            }
            if (!StringUtils.isNotEmpty((CharSequence)importDto.getRegionName())) continue;
            String[] areaNameArr = importDto.getRegionName().split(";");
            allAreaNames.addAll(Arrays.asList(areaNameArr));
        }
        Map<Object, Object> areaMap = new HashMap();
        if (!allAreaNames.isEmpty()) {
            try {
                CustomerAreaListExtReqDto areaQuery = new CustomerAreaListExtReqDto();
                areaQuery.setNameList(new ArrayList(allAreaNames));
                areaQuery.setOrgInfoId(orgId);
                List areaList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByNames(areaQuery));
                if (CollectionUtils.isNotEmpty((Collection)areaList)) {
                    areaList = areaList.stream().filter(dto -> dto.getOrgInfoId() != null && dto.getOrgInfoId().equals(orgId)).collect(Collectors.toList());
                    areaMap = areaList.stream().collect(Collectors.toMap(CustomerAreaRespDto::getName, Function.identity(), (k1, k2) -> k1));
                    this.logger.info("\u67e5\u8be2\u5230\u6709\u6548\u7684\u533a\u57df\u4fe1\u606f, \u6570\u91cf: {}", (Object)areaMap.size());
                }
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        for (CustomerAddImportDto importDto : importDtos) {
            StringBuilder errorMsg = new StringBuilder();
            if (StringUtils.isEmpty((CharSequence)importDto.getName())) {
                errorMsg.append("\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getSalesArea())) {
                errorMsg.append("\u9500\u552e\u533a\u4e3a\u7a7a;");
            } else if (!areaMap.containsKey(importDto.getSalesArea())) {
                errorMsg.append("\u9500\u552e\u533a\u4e0d\u5b58\u5728;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getLargeArea())) {
                errorMsg.append("\u5927\u533a\u4e3a\u7a7a;");
            } else if (!areaMap.containsKey(importDto.getLargeArea())) {
                errorMsg.append("\u5927\u533a\u4e0d\u5b58\u5728;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea()) && StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea()) && areaMap.containsKey(importDto.getSalesArea()) && areaMap.containsKey(importDto.getLargeArea())) {
                CustomerAreaRespDto salesAreaDto = (CustomerAreaRespDto)areaMap.get(importDto.getSalesArea());
                CustomerAreaRespDto largeAreaDto = (CustomerAreaRespDto)areaMap.get(importDto.getLargeArea());
                if (!largeAreaDto.getParentCode().equals(salesAreaDto.getCode())) {
                    errorMsg.append("\u5927\u533a\u4e0d\u5c5e\u4e8e\u6240\u9009\u9500\u552e\u533a;");
                }
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getRegionName())) {
                errorMsg.append("\u533a\u57df\u4e3a\u7a7a;");
            } else {
                String[] areaNameArr = importDto.getRegionName().split(";");
                List uniqueAreaNames = Arrays.stream(areaNameArr).distinct().collect(Collectors.toList());
                if (uniqueAreaNames.size() < areaNameArr.length) {
                    this.logger.warn("\u5ba2\u6237[{}]\u533a\u57df\u5b58\u5728\u91cd\u590d\u8bb0\u5f55: {}", (Object)importDto.getName(), (Object)importDto.getRegionName());
                    errorMsg.append("\u5ba2\u6237\u533a\u57df\u5b58\u5728\u91cd\u590d\u503c\uff0c\u5df2\u81ea\u52a8\u5904\u7406;");
                }
                boolean allRegionsExist = true;
                for (Object areaName : uniqueAreaNames) {
                    if (areaMap.containsKey(areaName)) continue;
                    allRegionsExist = false;
                    errorMsg.append("\u533a\u57df[").append((String)areaName).append("]\u4e0d\u5b58\u5728;");
                }
                if (allRegionsExist && StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea()) && areaMap.containsKey(importDto.getLargeArea())) {
                    Object areaName;
                    CustomerAreaRespDto largeAreaDto = (CustomerAreaRespDto)areaMap.get(importDto.getLargeArea());
                    areaName = uniqueAreaNames.iterator();
                    while (areaName.hasNext()) {
                        String areaName2 = (String)areaName.next();
                        CustomerAreaRespDto areaDto = (CustomerAreaRespDto)areaMap.get(areaName2);
                        if (areaDto.getParentCode().equals(largeAreaDto.getCode())) continue;
                        errorMsg.append("\u533a\u57df[").append(areaName2).append("]\u4e0d\u5c5e\u4e8e\u6240\u9009\u5927\u533a;");
                    }
                }
            }
            if (Objects.isNull(importDto.getStandardDiscountRate())) {
                errorMsg.append("\u6807\u51c6\u6263\u7387\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getAreaType())) {
                errorMsg.append("\u5730\u5740\u7c7b\u578b\u4e3a\u7a7a;");
            } else if (!"\u6536\u8d27\u5730\u5740".equals(importDto.getAreaType()) && !"\u6536\u7968\u5730\u5740".equals(importDto.getAreaType())) {
                errorMsg.append("\u5730\u533a\u7c7b\u578b\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u6536\u8d27\u5730\u5740\u6216\u6536\u7968\u5730\u5740;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBrandDiscount())) {
                String[] brandDiscounts;
                for (String brandDiscount : brandDiscounts = importDto.getBrandDiscount().split(",")) {
                    if (!brandDiscount.contains(":")) {
                        errorMsg.append("\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u54c1\u724c\u540d\u79f0:\u6263\u7387;");
                        break;
                    }
                    String[] parts = brandDiscount.split(":");
                    if (parts.length != 2) {
                        errorMsg.append("\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u54c1\u724c\u540d\u79f0:\u6263\u7387;");
                        break;
                    }
                    try {
                        importDto.setBrandDiscount(importDto.getBrandDiscount());
                    }
                    catch (NumberFormatException e) {
                        errorMsg.append("\u591a\u54c1\u724c\u6263\u7387\u5fc5\u987b\u4e3a\u6570\u5b57;");
                        break;
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getCustomerTypeName())) {
                errorMsg.append("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getSubjectType())) {
                errorMsg.append("\u4e3b\u4f53\u7c7b\u578b\u4e3a\u7a7a;");
            } else if (StringUtils.isEmpty((CharSequence)this.toSubjectType(importDto.getSubjectType()))) {
                errorMsg.append("\u4e3b\u4f53\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getCreditCode())) {
                errorMsg.append("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getBusinessLicenseType())) {
                errorMsg.append("\u6267\u7167\u7c7b\u578b\u4e3a\u7a7a;");
            } else if (this.toBusinessLicenseType(importDto.getBusinessLicenseType()) == 0) {
                errorMsg.append("\u6267\u7167\u7c7b\u578b\u9519\u8bef;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getBusinessTermType())) {
                errorMsg.append("\u8425\u4e1a\u671f\u9650\u7c7b\u578b\u4e3a\u7a7a;");
            } else {
                String toBusinessTermType = this.toBusinessTermType(importDto.getBusinessTermType());
                if (toBusinessTermType.equals("0")) {
                    errorMsg.append("\u8425\u4e1a\u671f\u9650\u7c7b\u578b\u9519\u8bef;");
                } else if (toBusinessTermType.equals("1")) {
                    if (StringUtils.isEmpty((CharSequence)importDto.getTermBeginTime())) {
                        errorMsg.append("\u8425\u4e1a\u671f\u9650\u8d77\u4e3a\u7a7a;");
                    }
                    if (StringUtils.isEmpty((CharSequence)importDto.getTermEndTime())) {
                        errorMsg.append("\u8425\u4e1a\u671f\u9650\u6b62\u4e3a\u7a7a;");
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getReceiverName())) {
                errorMsg.append("\u6536\u8d27\u4eba\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getReceiverPhone())) {
                errorMsg.append("\u6536\u8d27\u4eba\u624b\u673a\u53f7\u7801\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getReceiverProvince())) {
                errorMsg.append("\u6536\u8d27\u7701\u4efd\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getReceiverCity())) {
                errorMsg.append("\u6536\u8d27\u57ce\u5e02\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getReceiverDistrict())) {
                errorMsg.append("\u6536\u8d27\u5730\u533a\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)importDto.getReceiverAddress())) {
                errorMsg.append("\u6536\u8d27\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a;");
            }
            if (Objects.isNull(importDto.getEffectiveTime())) {
                importDto.setEffectiveTime(new Date());
            }
            if (Objects.nonNull(importDto.getExpirationTime()) && Objects.nonNull(importDto.getEffectiveTime()) && importDto.getExpirationTime().before(importDto.getEffectiveTime())) {
                errorMsg.append("\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65f6\u95f4;");
            }
            if (errorMsg.length() > 0) {
                importDto.setErrorReason(errorMsg.toString());
            }
            importDto.setSellerId(sellerId);
            importDto.setOrgId(orgId);
            importDto.setInstanceId(requestInstanceId);
        }
        long errorRecords = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).count();
        this.logger.info("\u5ba2\u6237\u65b0\u589e\u6570\u636e\u9a8c\u8bc1\u5b8c\u6210: \u603b\u8bb0\u5f55\u6570[{}], \u6709\u6548\u8bb0\u5f55\u6570[{}], \u9519\u8bef\u8bb0\u5f55\u6570[{}]", new Object[]{importDtos.size(), (long)importDtos.size() - errorRecords, errorRecords});
    }

    private String addCustomer(CustomerAddImportDto importDto, Long orgId, Long requestTenantId, Long requestInstanceId, Map<String, CustomerTypeRespDto> customerTypeInfoMap) {
        String finalLegalName;
        String finalOrgName;
        StoreRespDto storeRespDto;
        CompanyInfoDto companyInfoDto;
        Map<Object, Object> addressInfoMap;
        CustomerTypeRespDto customerTypeRespDto;
        block67: {
            if (customerTypeInfoMap.isEmpty() || !customerTypeInfoMap.containsKey(importDto.getCustomerTypeName())) {
                return "\u5ba2\u6237\u7c7b\u578b\u6570\u636e\u9519\u8bef;";
            }
            customerTypeRespDto = customerTypeInfoMap.get(importDto.getCustomerTypeName());
            ArrayList areaHierarchyList = Lists.newArrayList((Object[])new String[]{importDto.getSalesArea(), importDto.getLargeArea()});
            CustomerAreaListExtReqDto areaHierarchyQuery = new CustomerAreaListExtReqDto();
            areaHierarchyQuery.setNameList((List)areaHierarchyList);
            areaHierarchyQuery.setOrgInfoId(orgId);
            List areaHierarchyResult = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByNames(areaHierarchyQuery));
            areaHierarchyResult = areaHierarchyResult.stream().filter(r -> r.getOrgInfoId() != null && r.getOrgInfoId().equals(orgId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(areaHierarchyResult)) {
                return "\u9500\u552e\u533a\u6216\u5927\u533a\u6570\u636e\u9519\u8bef;";
            }
            Map areaHierarchyMap = areaHierarchyResult.stream().collect(Collectors.toMap(CustomerAreaRespDto::getName, Function.identity(), (k1, k2) -> k1));
            if (!areaHierarchyMap.containsKey(importDto.getSalesArea())) {
                return "\u9500\u552e\u533a\u4e0d\u5b58\u5728;";
            }
            if (!areaHierarchyMap.containsKey(importDto.getLargeArea())) {
                return "\u5927\u533a\u4e0d\u5b58\u5728;";
            }
            CustomerAreaRespDto salesAreaDto = (CustomerAreaRespDto)areaHierarchyMap.get(importDto.getSalesArea());
            CustomerAreaRespDto largeAreaDto = (CustomerAreaRespDto)areaHierarchyMap.get(importDto.getLargeArea());
            if (!largeAreaDto.getParentCode().equals(salesAreaDto.getCode())) {
                return "\u5927\u533a\u4e0d\u5c5e\u4e8e\u6240\u9009\u9500\u552e\u533a;";
            }
            String[] areaNameArr = importDto.getRegionName().split(";");
            List<String> uniqueAreaNameList = Arrays.stream(areaNameArr).distinct().collect(Collectors.toList());
            importDto.setRegionNameList(uniqueAreaNameList);
            if (uniqueAreaNameList.size() < areaNameArr.length) {
                this.logger.info("\u5ba2\u6237[{}]\u5bfc\u5165\u533a\u57df\u5b58\u5728\u91cd\u590d\u8bb0\u5f55\uff0c\u539f\u59cb\u533a\u57df\u6570\u91cf:{}, \u53bb\u91cd\u540e\u533a\u57df\u6570\u91cf:{}", new Object[]{importDto.getName(), areaNameArr.length, uniqueAreaNameList.size()});
            }
            CustomerAreaListExtReqDto customerAreaQuery = new CustomerAreaListExtReqDto();
            customerAreaQuery.setNameList(uniqueAreaNameList);
            customerAreaQuery.setOrgInfoId(orgId);
            List areaList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByNames(customerAreaQuery));
            if (CollectionUtils.isEmpty((Collection)areaList)) {
                return "\u5ba2\u6237\u533a\u57df\u6570\u636e\u9519\u8bef;";
            }
            if (CollectionUtils.isEmpty(areaList = areaList.stream().filter(dto -> dto.getOrgInfoId() != null && dto.getOrgInfoId().equals(orgId)).collect(Collectors.toList()))) {
                return "\u5ba2\u6237\u533a\u57df\u7ec4\u7ec7\u6570\u636e\u9519\u8bef;";
            }
            for (CustomerAreaRespDto areaDto : areaList) {
                if (areaDto.getParentCode().equals(largeAreaDto.getCode())) continue;
                return "\u533a\u57df[" + areaDto.getName() + "]\u4e0d\u5c5e\u4e8e\u6240\u9009\u5927\u533a;";
            }
            List<String> areaCodeList = areaList.stream().map(CustomerAreaRespDto::getCode).distinct().collect(Collectors.toList());
            if (areaCodeList.size() != uniqueAreaNameList.size()) {
                this.logger.warn("\u5ba2\u6237[{}]\u5bfc\u5165\u533a\u57df\u540d\u79f0\u4e0e\u5b9e\u9645\u67e5\u8be2\u5230\u7684\u533a\u57df\u7f16\u7801\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u533a\u57df\u540d\u79f0\u6570\u91cf:{}, \u533a\u57df\u7f16\u7801\u6570\u91cf:{}", new Object[]{importDto.getName(), uniqueAreaNameList.size(), areaCodeList.size()});
            }
            importDto.setRegionCodeList(areaCodeList);
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBrandDiscount())) {
                String[] brandDiscounts = importDto.getBrandDiscount().split(",");
                ArrayList<String> brandNameList = new ArrayList<String>();
                for (String brandDiscount : brandDiscounts) {
                    String[] parts = brandDiscount.split(":");
                    if (parts.length != 2) continue;
                    brandNameList.add(parts[0]);
                }
                if (!brandNameList.isEmpty()) {
                    try {
                        List nonExistingBrands = (List)RestResponseHelper.extractData((RestResponse)this.itemBrandAuthApi.checkBrandsExist(brandNameList));
                        if (CollectionUtils.isNotEmpty((Collection)nonExistingBrands)) {
                            this.logger.warn("\u5ba2\u6237[{}]\u591a\u54c1\u724c\u4e2d\u5305\u542b\u4e0d\u5b58\u5728\u7684\u54c1\u724c: {}", (Object)importDto.getName(), (Object)nonExistingBrands);
                            return "\u591a\u54c1\u724c\u4e2d\u5305\u542b\u4e0d\u5b58\u5728\u7684\u54c1\u724c: " + String.join((CharSequence)", ", nonExistingBrands);
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u9a8c\u8bc1\u54c1\u724c\u5f02\u5e38", (Throwable)e);
                        return "\u9a8c\u8bc1\u54c1\u724c\u5f02\u5e38: " + e.getMessage();
                    }
                }
            }
            List<Object> addressList = Lists.newArrayList();
            addressList.add(importDto.getReceiverProvince());
            addressList.add(importDto.getReceiverCity());
            addressList.add(importDto.getReceiverDistrict());
            addressList = addressList.stream().filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
            addressInfoMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)addressList)) {
                List addressAreaList = (List)RestResponseHelper.extractData((RestResponse)this.areaExtQueryApi.getAreaByNames((List)addressList));
                if (CollectionUtils.isEmpty((Collection)addressAreaList)) {
                    return "\u5730\u533a\u540d\u79f0\u6570\u636e\u9519\u8bef;";
                }
                addressInfoMap = addressAreaList.stream().collect(Collectors.toMap(AreaDto::getName, Function.identity(), (k1, k2) -> k1));
                if (!addressInfoMap.containsKey(importDto.getReceiverProvince())) {
                    return "\u6536\u8d27\u7701\u4efd\u6570\u636e\u9519\u8bef;";
                }
                if (!addressInfoMap.containsKey(importDto.getReceiverCity())) {
                    return "\u6536\u8d27\u57ce\u5e02\u6570\u636e\u9519\u8bef;";
                }
                if (!addressInfoMap.containsKey(importDto.getReceiverDistrict())) {
                    return "\u6536\u8d27\u5730\u533a\u6570\u636e\u9519\u8bef;";
                }
                String receiverProvinceCityRelation = this.validateCityBelongsToProvince(addressInfoMap, importDto.getReceiverProvince(), importDto.getReceiverCity());
                if (StringUtils.isNotEmpty((CharSequence)receiverProvinceCityRelation)) {
                    return receiverProvinceCityRelation;
                }
                String receiverCityDistrictRelation = this.validateDistrictBelongsToCity(addressInfoMap, importDto.getReceiverCity(), importDto.getReceiverDistrict());
                if (StringUtils.isNotEmpty((CharSequence)receiverCityDistrictRelation)) {
                    return receiverCityDistrictRelation;
                }
            }
            companyInfoDto = null;
            storeRespDto = null;
            this.logger.info("\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801CreditCode={},orgId={},requestTenantId={},requestInstanceId={}", new Object[]{importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId});
            try {
                ArrayList creditCodes = Lists.newArrayList((Object[])new String[]{importDto.getCreditCode()});
                List storeRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.storeQueryApi.querySocialCreditNums((List)creditCodes));
                if (CollectionUtils.isEmpty((Collection)storeRespDtos)) {
                    this.logger.info("\u901a\u8fc7\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f:{}", (Object)importDto.getCreditCode());
                    try {
                        storeRespDto = this.queryCompanyByCreditCode(importDto.getCreditCode());
                        if (storeRespDto != null && !com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil.isAllFieldNull((Object)storeRespDto)) {
                            this.logger.info("\u901a\u8fc7\u5929\u773c\u67e5\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)storeRespDto));
                            companyInfoDto = new CompanyInfoDto();
                            companyInfoDto.setOrgName(storeRespDto.getStoreName());
                            companyInfoDto.setCreditCode(storeRespDto.getSocialCreditNum());
                            companyInfoDto.setLegalName(storeRespDto.getLegalPersonName());
                            if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getProvince())) {
                                companyInfoDto.setProvince(storeRespDto.getProvince());
                                companyInfoDto.setProvinceCode(storeRespDto.getProvinceCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getCity())) {
                                companyInfoDto.setCity(storeRespDto.getCity());
                                companyInfoDto.setCityCode(storeRespDto.getCityCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getDistrict())) {
                                companyInfoDto.setDistrict(storeRespDto.getDistrict());
                                companyInfoDto.setDistrictCode(storeRespDto.getDistrictCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getStoreAddr())) {
                                companyInfoDto.setAddress(storeRespDto.getStoreAddr());
                            }
                            break block67;
                        }
                        this.logger.info("\u5929\u773c\u67e5\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f\uff0c\u5c1d\u8bd5\u901a\u8fc7\u539f\u6709\u65b9\u5f0f\u67e5\u8be2");
                        companyInfoDto = (CompanyInfoDto)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCompanyInfoByCreditCode(importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId, null));
                    }
                    catch (Exception e) {
                        this.logger.error("\u901a\u8fc7\u5929\u773c\u67e5\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                        companyInfoDto = (CompanyInfoDto)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCompanyInfoByCreditCode(importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId, null));
                    }
                    break block67;
                }
                storeRespDto = (StoreRespDto)storeRespDtos.get(0);
                companyInfoDto = new CompanyInfoDto();
                companyInfoDto.setOrgName(storeRespDto.getStoreName());
                companyInfoDto.setCreditCode(storeRespDto.getSocialCreditNum());
                companyInfoDto.setLegalName(storeRespDto.getLegalPersonName());
                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getProvince())) {
                    companyInfoDto.setProvince(storeRespDto.getProvince());
                    companyInfoDto.setProvinceCode(storeRespDto.getProvinceCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getCity())) {
                    companyInfoDto.setCity(storeRespDto.getCity());
                    companyInfoDto.setCityCode(storeRespDto.getCityCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getDistrict())) {
                    companyInfoDto.setDistrict(storeRespDto.getDistrict());
                    companyInfoDto.setDistrictCode(storeRespDto.getDistrictCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getStoreAddr())) {
                    companyInfoDto.setAddress(storeRespDto.getStoreAddr());
                }
                this.logger.info("\u901a\u8fc7\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)storeRespDto));
                this.logger.info("\u8f6c\u6362\u540e\u7684\u516c\u53f8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)companyInfoDto));
                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getProvince()) && StringUtils.isNotEmpty((CharSequence)storeRespDto.getProvinceCode())) {
                    AreaDto provinceDto = new AreaDto();
                    provinceDto.setName(storeRespDto.getProvince());
                    provinceDto.setCode(storeRespDto.getProvinceCode());
                    addressInfoMap.put(storeRespDto.getProvince(), provinceDto);
                }
                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getCity()) && StringUtils.isNotEmpty((CharSequence)storeRespDto.getCityCode())) {
                    AreaDto cityDto = new AreaDto();
                    cityDto.setName(storeRespDto.getCity());
                    cityDto.setCode(storeRespDto.getCityCode());
                    cityDto.setParentCode(storeRespDto.getProvinceCode());
                    addressInfoMap.put(storeRespDto.getCity(), cityDto);
                }
                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getDistrict()) && StringUtils.isNotEmpty((CharSequence)storeRespDto.getDistrictCode())) {
                    AreaDto districtDto = new AreaDto();
                    districtDto.setName(storeRespDto.getDistrict());
                    districtDto.setCode(storeRespDto.getDistrictCode());
                    districtDto.setParentCode(storeRespDto.getCityCode());
                    addressInfoMap.put(storeRespDto.getDistrict(), districtDto);
                }
            }
            catch (Exception e) {
                this.logger.info("\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801\u5f02\u5e38:{}", (Object)e.getMessage());
                return "\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801\u5f02\u5e38:" + e.getMessage();
            }
        }
        if (ObjectUtils.isNotEmpty((Object)storeRespDto) && IsCustomerEnum.IS_CUSTOMER.getCode().equals(storeRespDto.getIsCustomer())) {
            throw new BizException("20089", "\u5927\u5ba2\u6237\u4e0d\u80fd\u6ce8\u518c\u4e3a\u5c0fB");
        }
        try {
            CheckCreditByCustomerCodeReqDto checkDto = new CheckCreditByCustomerCodeReqDto();
            checkDto.setCreditCode(importDto.getCreditCode());
            checkDto.setOrgName(companyInfoDto.getOrgName());
            checkDto.setCusName(importDto.getName());
            this.checkCreditByCustomerCode(checkDto);
            this.logger.info("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u6821\u9a8c\u901a\u8fc7, \u4fe1\u7528\u4ee3\u7801: {}, \u516c\u53f8\u540d\u79f0: {}", (Object)importDto.getCreditCode(), (Object)companyInfoDto.getOrgName());
        }
        catch (Exception e) {
            this.logger.error("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u6821\u9a8c\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return "\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u6821\u9a8c\u5931\u8d25: " + e.getMessage();
        }
        CompanyVerifyRespDto companyVerifyRespDto = this.queryStoreVerify(importDto.getCreditCode(), storeRespDto != null ? storeRespDto.getStoreName() : companyInfoDto.getOrgName(), storeRespDto != null ? storeRespDto.getLegalPersonName() : companyInfoDto.getLegalName());
        if (1 != companyVerifyRespDto.getResult()) {
            return companyVerifyRespDto.getRemark();
        }
        List customerStatusRespDtos = Lists.newArrayList();
        CustomerStatusReqDto customerStatusReqDto = new CustomerStatusReqDto();
        customerStatusReqDto.setRecordStatus(Integer.valueOf(1));
        customerStatusReqDto.setName("\u542f\u7528");
        try {
            this.logger.info("\u67e5\u8be2\u5ba2\u6237\u72b6\u6001\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)customerStatusReqDto));
            customerStatusRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryByList(JSON.toJSONString((Object)customerStatusReqDto)));
            this.logger.info("\u67e5\u8be2\u5ba2\u6237\u72b6\u6001\u54cd\u5e94\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)customerStatusRespDtos));
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u5ba2\u6237\u72b6\u6001\u5f02\u5e38:{}", (Object)e.getMessage());
            return "\u67e5\u8be2\u5ba2\u6237\u72b6\u6001\u5f02\u5e38:" + e.getMessage();
        }
        if (CollectionUtils.isEmpty((Collection)customerStatusRespDtos)) {
            return "\u5ba2\u6237\u72b6\u6001\u6570\u636e\u7f3a\u5931;";
        }
        if (Objects.isNull(importDto.getEffectiveTime())) {
            return "\u751f\u6548\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a";
        }
        if (Objects.nonNull(importDto.getExpirationTime()) && Objects.nonNull(importDto.getEffectiveTime()) && importDto.getExpirationTime().before(importDto.getEffectiveTime())) {
            return "\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65f6\u95f4";
        }
        CustomerReqDto addCustomerDto = new CustomerReqDto();
        addCustomerDto.setName(importDto.getName());
        addCustomerDto.setMerchantId(orgId);
        addCustomerDto.setType(CustomerTypeEnum.RETAILER.getCode());
        addCustomerDto.setEasCode(importDto.getEasCode());
        addCustomerDto.setRegionCodeList(importDto.getRegionCodeList());
        addCustomerDto.setCustomerTypeId(customerTypeRespDto.getId());
        if (storeRespDto != null) {
            addCustomerDto.setProvince(storeRespDto.getProvince());
            addCustomerDto.setProvinceCode(storeRespDto.getProvinceCode());
            addCustomerDto.setCity(storeRespDto.getCity());
            addCustomerDto.setCityCode(storeRespDto.getCityCode());
            addCustomerDto.setCounty(storeRespDto.getDistrict());
            addCustomerDto.setCountyCode(storeRespDto.getDistrictCode());
            addCustomerDto.setAddress(storeRespDto.getStoreAddr());
        } else {
            addCustomerDto.setProvince(companyInfoDto.getProvince());
            addCustomerDto.setProvinceCode(companyInfoDto.getProvinceCode());
            addCustomerDto.setCity(companyInfoDto.getCity());
            addCustomerDto.setCityCode(companyInfoDto.getCityCode());
            addCustomerDto.setCounty(companyInfoDto.getDistrict());
            addCustomerDto.setCountyCode(companyInfoDto.getDistrictCode());
            addCustomerDto.setAddress(companyInfoDto.getAddress());
        }
        addCustomerDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        addCustomerDto.setStatusId(((CustomerStatusRespDto)customerStatusRespDtos.get(0)).getId());
        addCustomerDto.setInstanceId(requestInstanceId);
        addCustomerDto.setTenantId(requestTenantId);
        addCustomerDto.setOrgId(orgId);
        HashMap<String, Object> extendFields = new HashMap<String, Object>();
        extendFields.put("salesArea", importDto.getSalesArea());
        extendFields.put("largeArea", importDto.getLargeArea());
        extendFields.put("areaType", importDto.getAreaType());
        extendFields.put("standardDiscountRate", importDto.getStandardDiscountRate());
        extendFields.put("brandDiscount", importDto.getBrandDiscount());
        String extendFieldsJson = JSON.toJSONString(extendFields);
        addCustomerDto.setExtension(extendFieldsJson);
        if (Objects.nonNull(importDto.getEffectiveTime())) {
            addCustomerDto.setStartDate(importDto.getEffectiveTime());
        }
        if (Objects.nonNull(importDto.getExpirationTime())) {
            addCustomerDto.setEndDate(importDto.getExpirationTime());
        }
        CompanyInfoDto companyInfo = new CompanyInfoDto();
        if (Objects.nonNull(companyInfoDto)) {
            CubeBeanUtils.copyProperties((Object)companyInfo, (Object)companyInfoDto, (String[])new String[0]);
        }
        if (StringUtils.isEmpty((CharSequence)(finalOrgName = companyInfoDto.getOrgName()))) {
            finalOrgName = storeRespDto != null ? storeRespDto.getStoreName() : companyInfoDto.getOrgName();
        }
        companyInfo.setOrgName(finalOrgName);
        companyInfo.setOrgCode(storeRespDto != null ? storeRespDto.getStoreId() : companyInfoDto.getOrgCode());
        companyInfo.setSubjectType(this.toSubjectType(importDto.getSubjectType()));
        companyInfo.setCreditCode(importDto.getCreditCode());
        companyInfo.setBusinessLicenseType(this.toBusinessLicenseType(importDto.getBusinessLicenseType()));
        companyInfo.setBusinessTermType(this.toBusinessTermType(importDto.getBusinessTermType()));
        if (StringUtils.isNotEmpty((CharSequence)importDto.getTermBeginTime())) {
            Date termBeginTime = DateUtil.parseDate((String)importDto.getTermBeginTime(), (String)"EEE MMM dd HH:mm:ss zzz yyyy");
            companyInfo.setTermBeginTime(termBeginTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getTermEndTime())) {
            Date termEndTime = DateUtil.parseDate((String)importDto.getTermEndTime(), (String)"EEE MMM dd HH:mm:ss zzz yyyy");
            companyInfo.setTermEndTime(termEndTime);
        }
        if (storeRespDto != null) {
            companyInfo.setProvince(storeRespDto.getProvince());
            companyInfo.setProvinceCode(storeRespDto.getProvinceCode());
            companyInfo.setCity(storeRespDto.getCity());
            companyInfo.setCityCode(storeRespDto.getCityCode());
            companyInfo.setDistrict(storeRespDto.getDistrict());
            companyInfo.setDistrictCode(storeRespDto.getDistrictCode());
            companyInfo.setAddress(storeRespDto.getStoreAddr());
        }
        if (StringUtils.isEmpty((CharSequence)(finalLegalName = importDto.getLegalName()))) {
            finalLegalName = storeRespDto != null ? storeRespDto.getLegalPersonName() : companyInfoDto.getLegalName();
        }
        companyInfo.setLegalName(finalLegalName);
        companyInfo.setLegalCardType(this.toLegalCardType(importDto.getLegalCardType()));
        companyInfo.setLegalCardNum(importDto.getLegalCardNum());
        companyInfo.setCardEffectType(this.toCardEffectType(importDto.getCardEffectType()));
        if (Objects.nonNull(importDto.getCardEffectBeginTime())) {
            companyInfo.setCardEffectBeginTime(importDto.getCardEffectBeginTime());
        }
        if (Objects.nonNull(importDto.getCardEffectEndTime())) {
            companyInfo.setCardEffectEndTime(importDto.getCardEffectEndTime());
        }
        addCustomerDto.setCompanyInfoDto(companyInfo);
        this.logger.info("\u65b0\u589e\u5ba2\u6237\u8bf7\u6c42\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)addCustomerDto));
        ServiceContext.getContext().setAttachment("yes.req.tenantId", requestTenantId.toString());
        ServiceContext.getContext().setAttachment("yes.req.instanceId", requestInstanceId.toString());
        CustomerAddResultDto customerAddResultDto = null;
        try {
            customerAddResultDto = (CustomerAddResultDto)RestResponseHelper.extractData((RestResponse)this.customerExtApi.add(addCustomerDto));
            this.logger.info("\u65b0\u589e\u5ba2\u6237\u8fd4\u56de\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)customerAddResultDto));
            addCustomerDto.setId(customerAddResultDto.getCustomerId());
        }
        catch (Exception e) {
            this.logger.info("\u65b0\u589e\u5ba2\u6237\u5931\u8d25:{}", (Throwable)e);
            return "\u65b0\u589e\u5ba2\u6237\u5931\u8d25:" + e.getMessage();
        }
        CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
        customerExtQuery.setIdList((List)Lists.newArrayList((Object[])new Long[]{customerAddResultDto.getCustomerId()}));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
        this.logger.info("\u6839\u636e\u5ba2\u6237ID\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)customerRespDtos));
        AddressAddReqDto addressAddReqDto = new AddressAddReqDto();
        addressAddReqDto.setContact(importDto.getReceiverName());
        addressAddReqDto.setPhone(importDto.getReceiverPhone());
        addressAddReqDto.setProvince(importDto.getReceiverProvince());
        addressAddReqDto.setProvinceCode(((AreaDto)addressInfoMap.get(importDto.getReceiverProvince())).getCode());
        addressAddReqDto.setCity(importDto.getReceiverCity());
        addressAddReqDto.setCityCode(((AreaDto)addressInfoMap.get(importDto.getReceiverCity())).getCode());
        addressAddReqDto.setDistrict(importDto.getReceiverDistrict());
        addressAddReqDto.setDistrictCode(((AreaDto)addressInfoMap.get(importDto.getReceiverDistrict())).getCode());
        addressAddReqDto.setDetailAddr(importDto.getReceiverAddress());
        addressAddReqDto.setRegion(importDto.getReceiverProvince() + " " + importDto.getReceiverCity() + " " + importDto.getReceiverDistrict());
        addressAddReqDto.setStatus(YesNoEnum.NO.getValue());
        addressAddReqDto.setOrgInfoId(customerAddResultDto.getOrgInfoId());
        addressAddReqDto.setAddressType(((Stream)Arrays.stream(AddressTypeEnum.values()).sequential()).filter(r -> r.getDesc().equals(importDto.getAreaType())).map(AddressTypeEnum::getCode).findFirst().orElse(AddressTypeEnum.DELIVERY.getCode()));
        addressAddReqDto.setInstanceId(requestInstanceId);
        addressAddReqDto.setTenantId(requestTenantId);
        addressAddReqDto.setStartTime(importDto.getEffectiveTime());
        addressAddReqDto.setEndTime(importDto.getExpirationTime());
        addressAddReqDto.setTenantId(requestTenantId);
        this.logger.info("\u65b0\u589e\u6536\u8d27\u5730\u5740\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)addressAddReqDto));
        boolean addressExists = this.isAddressExists(customerAddResultDto.getOrgInfoId(), importDto.getReceiverProvince(), importDto.getReceiverCity(), importDto.getReceiverDistrict(), importDto.getReceiverAddress(), importDto.getAreaType());
        if (addressExists) {
            this.logger.info("\u5ba2\u6237[{}]\u5df2\u5b58\u5728\u76f8\u540c\u6536\u8d27\u5730\u5740\uff0c\u4e0d\u91cd\u590d\u6dfb\u52a0", (Object)importDto.getName());
        } else {
            RestResponseHelper.extractData((RestResponse)this.addressApi.addAddress(addressAddReqDto));
            this.logger.info("\u5ba2\u6237[{}]\u65b0\u589e\u6536\u8d27\u5730\u5740\u6210\u529f", (Object)importDto.getName());
        }
        try {
            ArrayList authItemRuleReqDtoList = Lists.newArrayList();
            AuthItemRuleReqDto authItemRuleReqDto = new AuthItemRuleReqDto();
            authItemRuleReqDto.setCustomerId(addCustomerDto.getId());
            authItemRuleReqDto.setCustomerCode(addCustomerDto.getCode());
            authItemRuleReqDto.setCustomerName(addCustomerDto.getName());
            authItemRuleReqDto.setAuthType(Integer.valueOf(0));
            authItemRuleReqDto.setOrganizationId(addCustomerDto.getMerchantId());
            authItemRuleReqDto.setTenantId(addCustomerDto.getTenantId());
            authItemRuleReqDto.setInstanceId(addCustomerDto.getInstanceId());
            authItemRuleReqDtoList.add(authItemRuleReqDto);
            this.authItemRuleApi.initAuthItemRule((List)authItemRuleReqDtoList);
        }
        catch (Exception e) {
            this.logger.info("\u5546\u54c1\u6388\u6743\u5931\u8d25:{}", (Object)e.getMessage());
            return e.getMessage();
        }
        this.addOfflineAccount(customerRespDtos, companyInfo.getOrgName(), requestTenantId, requestInstanceId);
        this.createCustomerDiscounts(((CustomerRespDto)customerRespDtos.get(0)).getId(), orgId, importDto, requestTenantId, requestInstanceId);
        return null;
    }

    private void addOfflineAccount(List<CustomerRespDto> customerRespDtos, String orgName, Long requestTenantId, Long requestInstanceId) {
        OfflineBalanceAccountReqDto offlineBalanceAccountReqDto = new OfflineBalanceAccountReqDto();
        offlineBalanceAccountReqDto.setCustomerName(customerRespDtos.get(0).getName());
        offlineBalanceAccountReqDto.setCustomerCode(customerRespDtos.get(0).getCode());
        offlineBalanceAccountReqDto.setCustomerCompany(orgName);
        offlineBalanceAccountReqDto.setCustomerId(customerRespDtos.get(0).getId());
        offlineBalanceAccountReqDto.setAccountBalance(BigDecimal.ZERO);
        offlineBalanceAccountReqDto.setAgentUse(OfflineBalanceAccountEnum.ENABLED.getValue());
        offlineBalanceAccountReqDto.setAgentView(OfflineBalanceAccountEnum.ENABLED.getValue());
        offlineBalanceAccountReqDto.setAccountStatus("ENABLED");
        offlineBalanceAccountReqDto.setAccountCode("YEZH" + customerRespDtos.get(0).getCode());
        offlineBalanceAccountReqDto.setMerchantId(customerRespDtos.get(0).getMerchantId());
        offlineBalanceAccountReqDto.setTenantId(requestTenantId);
        offlineBalanceAccountReqDto.setInstanceId(requestInstanceId);
        this.logger.info("addCustomer.createOfflineBalanceAccount->add\uff1a{}", (Object)JSON.toJSONString((Object)offlineBalanceAccountReqDto));
        RestResponseHelper.extractData((RestResponse)this.offlineBalanceAccountApi.addOfflineBalanceAccount(offlineBalanceAccountReqDto));
    }

    private void createCustomerDiscounts(Long customerId, Long orgId, CustomerAddImportDto importDto, Long requestTenantId, Long requestInstanceId) {
        try {
            List<PrBaseDiscountBrandReqDto> brandDiscounts;
            CustomerSearchExtReqDto customerQuery = new CustomerSearchExtReqDto();
            customerQuery.setIdList((List)Lists.newArrayList((Object[])new Long[]{customerId}));
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(customerQuery));
            if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                this.logger.error("\u5ba2\u6237[{}]\u521b\u5efa\u6263\u7387\u65f6\u672a\u627e\u5230\u5ba2\u6237\u4fe1\u606f", (Object)customerId);
                return;
            }
            String customerCode = ((CustomerRespDto)customerRespDtos.get(0)).getCode();
            PrBaseDiscountAddEditReqDto discountAddEditReqDto = new PrBaseDiscountAddEditReqDto();
            discountAddEditReqDto.setCustomerId(customerId);
            discountAddEditReqDto.setCustomerName(importDto.getName());
            discountAddEditReqDto.setCustomerCode(customerCode);
            discountAddEditReqDto.setOrgInfoId(((CustomerRespDto)customerRespDtos.get(0)).getOrgInfoId());
            discountAddEditReqDto.setMerchantId(((CustomerRespDto)customerRespDtos.get(0)).getMerchantId());
            discountAddEditReqDto.setStandardDiscount(importDto.getStandardDiscountRate());
            discountAddEditReqDto.setTenantId(requestTenantId);
            discountAddEditReqDto.setInstanceId(requestInstanceId);
            if (StringUtils.isNotEmpty((CharSequence)importDto.getBrandDiscount()) && !(brandDiscounts = this.parseBrandDiscounts(importDto.getBrandDiscount())).isEmpty()) {
                discountAddEditReqDto.setBrandDiscountList(brandDiscounts);
            }
            this.logger.info("\u521b\u5efa\u5ba2\u6237\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387, \u53c2\u6570: {}", (Object)JSON.toJSONString((Object)discountAddEditReqDto));
            RestResponseHelper.extractData((RestResponse)this.prBaseDiscountApi.add(discountAddEditReqDto));
            this.logger.info("\u5ba2\u6237[{}]\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387\u521b\u5efa\u6210\u529f", (Object)importDto.getName());
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u5ba2\u6237\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387\u5f02\u5e38", (Throwable)e);
        }
    }

    private List<PrBaseDiscountBrandReqDto> parseBrandDiscounts(String brandDiscountStr) {
        ArrayList<PrBaseDiscountBrandReqDto> result = new ArrayList<PrBaseDiscountBrandReqDto>();
        if (StringUtils.isEmpty((CharSequence)brandDiscountStr)) {
            return result;
        }
        try {
            String[] brandDiscounts;
            for (String brandDiscount : brandDiscounts = brandDiscountStr.split(",")) {
                String[] parts = brandDiscount.split(":");
                if (parts.length != 2) continue;
                String brandName = parts[0].trim();
                BigDecimal discountRate = new BigDecimal(parts[1].trim());
                PrBaseDiscountBrandReqDto brandDiscountDto = new PrBaseDiscountBrandReqDto();
                brandDiscountDto.setBrandName(brandName);
                brandDiscountDto.setBrandDiscount(discountRate);
                try {
                    Long brandId;
                    ArrayList<String> brandNameList = new ArrayList<String>();
                    brandNameList.add(brandName);
                    List nonExistingBrands = (List)RestResponseHelper.extractData((RestResponse)this.itemBrandAuthApi.checkBrandsExist(brandNameList));
                    if (!CollectionUtils.isEmpty((Collection)nonExistingBrands) || (brandId = this.getBrandIdByName(brandName)) == null) continue;
                    brandDiscountDto.setBrandId(brandId);
                    result.add(brandDiscountDto);
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6\u54c1\u724c[{}]ID\u5f02\u5e38: {}", (Object)brandName, (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u591a\u54c1\u724c\u6263\u7387\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return result;
    }

    private Long getBrandIdByName(String brandName) {
        try {
            JSONObject filter = new JSONObject();
            filter.put("name", (Object)brandName);
            List brands = (List)RestResponseHelper.extractData((RestResponse)this.itemBrandAuthApi.queryBrandsByName(brandName));
            if (CollectionUtils.isNotEmpty((Collection)brands)) {
                return ((BrandRespDto)brands.get(0)).getId();
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u540d\u79f0\u67e5\u8be2\u54c1\u724cID\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String toSubjectType(String name) {
        if (SubjectTypeEnum.COMPANY.getName().equals(name)) {
            return SubjectTypeEnum.COMPANY.getType();
        }
        if (SubjectTypeEnum.INDIVIDUAL.getName().equals(name)) {
            return SubjectTypeEnum.INDIVIDUAL.getType();
        }
        if (SubjectTypeEnum.ZOOID.getName().equals(name)) {
            return SubjectTypeEnum.ZOOID.getType();
        }
        return "";
    }

    private Integer toBusinessLicenseType(String name) {
        if ("\u591a\u8bc1\u5408\u4e00\u8425\u4e1a\u6267\u7167".equals(name)) {
            return 1;
        }
        if ("\u666e\u901a\u8425\u4e1a\u6267\u7167".equals(name)) {
            return 2;
        }
        return 0;
    }

    private String toBusinessTermType(String name) {
        if ("\u77ed\u671f\u6709\u6548".equals(name)) {
            return "1";
        }
        if ("\u957f\u671f\u6709\u6548".equals(name)) {
            return "2";
        }
        return "0";
    }

    private Integer toLegalCardType(String name) {
        if ("\u5927\u9646\u5c45\u6c11\u8eab\u4efd\u8bc1".equals(name)) {
            return 1;
        }
        if ("\u6e2f\u6fb3\u53f0\uff08\u8eab\u4efd\u8bc1\u3001\u5c45\u6c11\u901a\u884c\u8bc1\uff09".equals(name)) {
            return 2;
        }
        if ("\u62a4\u7167\uff08\u9650\u5883\u5916\u4eba\u58eb\uff09".equals(name)) {
            return 3;
        }
        return 0;
    }

    private Integer toCardEffectType(String name) {
        if ("\u77ed\u671f\u6709\u6548".equals(name)) {
            return 1;
        }
        if ("\u957f\u671f\u6709\u6548".equals(name)) {
            return 2;
        }
        return 0;
    }

    public CompanyVerifyRespDto queryStoreVerify(String creditCode, String orgName, String legalName) {
        CompanyCheckReqDto companyCheckReqDto = new CompanyCheckReqDto();
        companyCheckReqDto.setCode(creditCode);
        companyCheckReqDto.setName(orgName);
        companyCheckReqDto.setLegalPersonName(legalName);
        this.logger.info("\u67e5\u8be2\u8425\u9500\u901a\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)companyCheckReqDto));
        List checkRespDto = (List)RestResponseHelper.extractData((RestResponse)this.storeQueryApi.queryStoreCheck(companyCheckReqDto));
        this.logger.info("\u67e5\u8be2\u8425\u9500\u901a\u54cd\u5e94\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)checkRespDto));
        if (CollectionUtils.isNotEmpty((Collection)checkRespDto)) {
            CompanyVerifyRespDto companyVerifyRespDto = new CompanyVerifyRespDto();
            companyVerifyRespDto.setResult(Integer.valueOf(1));
            return companyVerifyRespDto;
        }
        CompanyVerifyRespDto cacheCompanyVerifyRespDto = (CompanyVerifyRespDto)this.cacheService.getCache(COMPANY_CASH_KEY + creditCode + orgName + legalName, CompanyVerifyRespDto.class);
        this.logger.info("\u67e5\u8be2\u5929\u773c\u67e5\u7f13\u5b58\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)cacheCompanyVerifyRespDto));
        if (cacheCompanyVerifyRespDto != null) {
            this.logger.info("\u67e5\u8be2\u5929\u773c\u67e5\u7684\u4fe1\u606f\uff0c\u7f13\u5b58\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u67e5\u8be2\u5929\u773c\u67e5:{}", (Object)JacksonUtil.toJson((Object)cacheCompanyVerifyRespDto));
            return cacheCompanyVerifyRespDto;
        }
        CompanyVerifyReqDto companyVerifyReqDto = new CompanyVerifyReqDto();
        companyVerifyReqDto.setCode(creditCode);
        companyVerifyReqDto.setName(orgName);
        companyVerifyReqDto.setLegalPersonName(legalName);
        this.logger.info("\u9a8c\u8bc1\u4f01\u4e1a\u4e09\u8981\u7d20\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)companyVerifyReqDto));
        cacheCompanyVerifyRespDto = (CompanyVerifyRespDto)RestResponseHelper.extractData((RestResponse)this.companyQueryApi.queryCompanyVerify(companyVerifyReqDto));
        this.logger.info("\u9a8c\u8bc1\u4f01\u4e1a\u4e09\u8981\u7d20\u54cd\u5e94\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)cacheCompanyVerifyRespDto));
        this.cacheService.setCache(COMPANY_CASH_KEY + creditCode + orgName + legalName, (Object)cacheCompanyVerifyRespDto);
        return cacheCompanyVerifyRespDto;
    }

    private String validateCityBelongsToProvince(Map<String, AreaDto> addressInfoMap, String province, String city) {
        AreaDto provinceDto = addressInfoMap.get(province);
        AreaDto cityDto = addressInfoMap.get(city);
        if (!cityDto.getParentCode().equals(provinceDto.getCode())) {
            this.logger.warn("\u57ce\u5e02[{}]\u4e0d\u5c5e\u4e8e\u7701\u4efd[{}]", (Object)city, (Object)province);
            return "\u57ce\u5e02[" + city + "]\u4e0d\u5c5e\u4e8e\u7701\u4efd[" + province + "];";
        }
        return null;
    }

    public void checkCreditByCustomerCode(CheckCreditByCustomerCodeReqDto dto) {
        RestResponseHelper.checkOrThrow((RestResponse)this.customerExtThreeApi.computeCustomerNameRate(ComputeCustomerNameRateReqDto.builder().orgName(dto.getOrgName()).cusName(dto.getCusName()).creditCode(dto.getCreditCode()).build()));
    }

    private String validateDistrictBelongsToCity(Map<String, AreaDto> addressInfoMap, String city, String district) {
        AreaDto cityDto = addressInfoMap.get(city);
        AreaDto districtDto = addressInfoMap.get(district);
        if (!districtDto.getParentCode().equals(cityDto.getCode())) {
            this.logger.warn("\u5730\u533a[{}]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[{}]", (Object)district, (Object)city);
            return "\u5730\u533a[" + district + "]\u4e0d\u5c5e\u4e8e\u57ce\u5e02[" + city + "];";
        }
        return null;
    }

    public StoreRespDto queryCompanyByCreditCode(String creditCode) {
        RestResponse companyResultDtoRestResponse = this.companyQueryApi.queryCompanyByDesc(creditCode);
        CompanyResultDto companyResultDto = (CompanyResultDto)RestResponseHelper.extractData((RestResponse)companyResultDtoRestResponse);
        this.logger.info("\u3010\u5929\u773c\u67e5\u3011\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)companyResultDto));
        AssertUtils.notNull((Object)companyResultDto, (String)"\u67e5\u8be2\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u65e0\u6570\u636e");
        CompanyResultInfoDto result = companyResultDto.getResult();
        AssertUtils.notNull((Object)result, (String)"\u67e5\u8be2\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u65e0\u6570\u636e");
        TianyanchaProvinceEnum tianyanchaProvince = TianyanchaProvinceEnum.find((String)result.getBase());
        String provinceName = tianyanchaProvince != null ? tianyanchaProvince.getProvinceName() : null;
        String provinceCode = this.getStoreAreaCodeByName(provinceName, "CN", String.valueOf(StoreAreaLevelEnum.PROVINCE.getCode()));
        String cityCode = this.getStoreAreaCodeByName(result.getCity(), provinceCode, String.valueOf(StoreAreaLevelEnum.CITY.getCode()));
        String districtCode = this.getStoreAreaCodeByName(result.getDistrict(), cityCode, String.valueOf(StoreAreaLevelEnum.DISTRICT.getCode()));
        StoreRespDto respDto = new StoreRespDto(result.getName(), result.getHistoryNames(), result.getCreditCode(), provinceName, result.getCity(), result.getDistrict(), result.getRegLocation(), result.getRegStatus(), result.getLegalPersonName());
        respDto.setProvinceCode(provinceCode);
        respDto.setCityCode(cityCode);
        respDto.setDistrictCode(districtCode);
        AssertUtil.isTrue((!BeanPropertyNullUtil.isAllFieldNull((Object)respDto) ? 1 : 0) != 0, (String)"0001", (String)"\u67e5\u8be2\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u65e0\u6570\u636e");
        StoreReqDto storeReqDto = this.companyResultDtoToStoreRespDto(companyResultDto);
        this.storeService.saveOrUpdateStore(storeReqDto);
        return respDto;
    }

    private String getStoreAreaCodeByName(String name, String parentCode, String level) {
        this.logger.info("\u6839\u636e\u533a\u57df\u540d\u79f0\u83b7\u53d6\u533a\u57dfcode\u53c2\u6570 ==> \u533a\u57df\u540d\u79f0: {}; \u533a\u57dfparentCode {}; level {}", new Object[]{name, parentCode, level});
        if (parentCode == null) {
            return null;
        }
        StoreAreaRespDto storeAreaRespDto = (StoreAreaRespDto)RestResponseHelper.extractData((RestResponse)this.storeAreaQueryApi.queryByProvince(StoreQueryProvinceReqDto.builder().parentCode(parentCode).level(level).name(name).build()));
        this.logger.info("\u6839\u636e\u533a\u57df\u540d\u79f0\u83b7\u53d6\u533a\u57dfcode\u7ed3\u679c ==> \u533a\u57dfcode: {}", (Object)storeAreaRespDto.getCode());
        return storeAreaRespDto.getCode();
    }

    private StoreReqDto companyResultDtoToStoreRespDto(CompanyResultDto companyResultDto) {
        CompanyResultInfoDto result = companyResultDto.getResult();
        StoreReqDto storeReqDto = StoreReqDto.builder().storeName(result.getName()).storeAlias(result.getHistoryNames()).socialCreditNum(result.getCreditCode()).province(result.getBase()).city(result.getCity()).district(result.getDistrict()).storeAddr(result.getRegLocation()).storeRegisterAddr(result.getRegLocation()).state(result.getRegStatus()).legalPersonName(result.getLegalPersonName()).isReplenish(IsDealEnum.NOT_DEAL.getCode()).dataOrigin(StoreDataOriginEnum.SKY_EYE_QUERY.getCode()).storeType("\u5176\u4ed6").build();
        TianyanchaProvinceEnum tianyanchaProvince = TianyanchaProvinceEnum.find((String)result.getBase());
        this.logger.info("\u5929\u773c\u67e5\u7701\u4efd\u4fe1\u606f\u6620\u5c04 ==> \u5929\u773c\u67e5\u7ed3\u679c: {}; \u6620\u5c04\u7ed3\u679c {}", (Object)result.getBase(), (Object)(tianyanchaProvince == null ? null : tianyanchaProvince.getProvinceName()));
        if (tianyanchaProvince != null) {
            storeReqDto.setProvince(tianyanchaProvince.getProvinceName());
            storeReqDto.setProvinceCode(tianyanchaProvince.getProvinceCode());
            if (TianyanchaProvinceEnum.BIG_CITY.contains(tianyanchaProvince.getProvinceName()) && "\u5e02\u8f96\u533a".equals(result.getCity())) {
                String bigCityName = tianyanchaProvince.getProvinceName() + "\u5e02";
                this.logger.info("\u5929\u773c\u67e5\u76f4\u8f96\u5e02\u6620\u5c04 ==> \u5929\u773c\u67e5\u7ed3\u679c: {}; \u6620\u5c04\u7ed3\u679c {}", (Object)result.getCity(), (Object)bigCityName);
                result.setCity(bigCityName);
                storeReqDto.setCity(bigCityName);
            }
            String cityCode = this.getStoreAreaCodeByName(result.getCity(), tianyanchaProvince.getProvinceCode(), String.valueOf(StoreAreaLevelEnum.CITY.getCode()));
            storeReqDto.setCityCode(cityCode);
            if (cityCode != null) {
                String districtCode = this.getStoreAreaCodeByName(result.getDistrict(), cityCode, String.valueOf(StoreAreaLevelEnum.DISTRICT.getCode()));
                storeReqDto.setDistrictCode(districtCode);
            }
        }
        return storeReqDto;
    }

    private boolean isAddressExists(Long orgInfoId, String province, String city, String district, String detailAddr, String addressType) {
        if (orgInfoId == null) {
            return false;
        }
        try {
            AddressQueryReqDto queryReqDto = new AddressQueryReqDto();
            queryReqDto.setOrgInfoId(orgInfoId);
            queryReqDto.setAddressType(Arrays.stream(AddressTypeEnum.values()).filter(r -> r.getDesc().equals(addressType)).map(AddressTypeEnum::getCode).findFirst().orElse(AddressTypeEnum.DELIVERY.getCode()));
            PageInfo addressPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.addressQueryApi.queryAddressByPage(queryReqDto, Integer.valueOf(1), Integer.valueOf(100)));
            if (addressPage != null && CollectionUtils.isNotEmpty((Collection)addressPage.getList())) {
                return addressPage.getList().stream().anyMatch(addr -> Objects.equals(province, addr.getProvince()) && Objects.equals(city, addr.getCity()) && Objects.equals(district, addr.getDistrict()) && Objects.equals(detailAddr, addr.getDetailAddr()));
            }
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u67e5\u5730\u5740\u662f\u5426\u5b58\u5728\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        return false;
    }
}

