/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.abs.ReportExportAbstract;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.RebateOrderExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.operation.CurrentCommonService;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.RebateOrderVo;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.query.IOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RebateOrderService
extends ReportExportAbstract<OrderRespDto, RebateOrderExportReqDto, RebateOrderVo> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderQueryApi orderQueryApi;
    @Autowired
    private CurrentCommonService currentCommonService;

    @Override
    public ExportTypeEnum getExportType() {
        return ExportTypeEnum.REBATE_ORDER;
    }

    @Override
    public PageInfo<OrderRespDto> queryData(RebateOrderExportReqDto rebateOrderExportReqDto) {
        OrderQueryReqDto orderQueryReqDto = new OrderQueryReqDto();
        BeanUtils.copyProperties((Object)((Object)rebateOrderExportReqDto), (Object)orderQueryReqDto);
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.orderQueryApi.queryOrderByPage(orderQueryReqDto, Integer.valueOf(rebateOrderExportReqDto.getPageNum()), Integer.valueOf(rebateOrderExportReqDto.getPageSize())));
    }

    @Override
    public RebateOrderExportReqDto definePrams(RebateOrderExportReqDto orderExportReqDto) {
        List<Long> currentOrgId = this.currentCommonService.getCurrentOrgId();
        this.logger.info("[\u6298\u6263\u5145\u503c\u5355\u5bfc\u51fa]\uff0c\u7ec4\u7ec7id\uff1a{}", currentOrgId);
        if (CollectionUtils.isNotEmpty(currentOrgId)) {
            orderExportReqDto.setOrganizationId(currentOrgId.get(0));
        }
        return orderExportReqDto;
    }

    @Override
    public Gson buildGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }

    @Override
    public List<RebateOrderVo> getExportDtoList(List<OrderRespDto> exportDtoList, Class<RebateOrderVo> vo) {
        ArrayList rebateOrderVos = Lists.newArrayList();
        for (OrderRespDto orderRespDto : exportDtoList) {
            RebateOrderVo rebateOrderVo = new RebateOrderVo();
            CubeBeanUtils.copyProperties((Object)rebateOrderVo, (Object)orderRespDto, (String[])new String[0]);
            rebateOrderVo.setIssueTime(DateUtil.getDateFormat((Date)orderRespDto.getIssueTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            rebateOrderVo.setCreateTime(DateUtil.getDateFormat((Date)orderRespDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            rebateOrderVo.setAuditTime(DateUtil.getDateFormat((Date)orderRespDto.getAuditTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            rebateOrderVo.setEffectDate(DateUtil.getDateFormat((Date)orderRespDto.getEffectEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            RebateOrderStatusEnum rebateOrderStatusEnum = RebateOrderStatusEnum.getByCode((String)orderRespDto.getStatus());
            if (rebateOrderStatusEnum != null) {
                rebateOrderVo.setStatusDesc(rebateOrderStatusEnum.getDesc());
            }
            rebateOrderVos.add(rebateOrderVo);
        }
        return rebateOrderVos;
    }
}

