/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.utils.MyEasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.biz.utils.ThreadPoolUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseExportService {
    private static final Logger logger = LoggerFactory.getLogger(BaseExportService.class);
    private static String ORD_ID_HEADER = "yes.req.cus.b2b.organizationid";
    private static String CUS_ID_HEADER = "yes.req.cus.b2b.customerid";
    private static String ASYNC = "yes.req.async.export";
    private static String ACCESS_TOKEN = "Access-Token";
    private Long id;
    private Long uesrId;
    private String name;
    private String fileName;
    private String excelName;
    private ExportTypeEnum exportTypeEnum;
    private IContext context;
    private ExportService exportService;
    private Long instanceId;
    private Long tenantId;
    private String orgId;
    private String customerId;
    private String token;
    private String key;

    public BaseExportService(String name, ExportTypeEnum exportTypeEnum) {
        this.name = name;
        this.exportTypeEnum = exportTypeEnum;
        this.fileName = name + "_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        this.context = (IContext)SpringBeanUtil.getBean(IContext.class);
        this.uesrId = this.context.userId();
        this.instanceId = this.context.instanceId();
        this.tenantId = this.context.tenantId();
        this.exportService = (ExportService)SpringBeanUtil.getBean(ExportService.class);
        this.id = this.exportService.init(this.fileName, exportTypeEnum);
        this.excelName = "cube/" + this.fileName;
        this.orgId = ServiceContext.getContext().getAttachment(ORD_ID_HEADER);
        this.customerId = ServiceContext.getContext().getAttachment(CUS_ID_HEADER);
        this.key = (String)ServiceContext.getContext().get("Application-Key");
        this.token = (String)ServiceContext.getContext().get(ACCESS_TOKEN);
    }

    public void initContext() {
        this.context.userId(this.uesrId);
        this.context.tenantId(this.tenantId);
        this.context.instanceId(this.instanceId);
        ServiceContext.getContext().set(ASYNC, (Object)"1");
        if (StringUtils.isNotBlank((CharSequence)this.orgId)) {
            ServiceContext.getContext().setAttachment(ORD_ID_HEADER, this.orgId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.customerId)) {
            ServiceContext.getContext().setAttachment(CUS_ID_HEADER, this.customerId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.key)) {
            ServiceContext.getContext().set("Application-Key", (Object)this.key);
        }
        if (StringUtils.isNotBlank((CharSequence)this.token)) {
            ServiceContext.getContext().set(ACCESS_TOKEN, (Object)this.token);
        }
    }

    public <T> void executor(Function<T, Void> function, T t) {
        ThreadPoolUtil.executorService.submit(() -> {
            this.initContext();
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{}", (Object)this.fileName);
            try {
                function.apply(t);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(this.id, "\u5bfc\u51fa" + this.name + "\u5217\u8868-\u9519\u8bef2:" + e);
                return;
            }
        });
    }

    public <T> void exportUrl(List<T> excelRespDtos, Class<T> tClass) {
        String exportUrl = EasyPoiExportUtil.getExportUrl(excelRespDtos, tClass, null, (String)this.excelName, (String)"xls");
        this.exportService.success(this.id, exportUrl);
    }

    public <T> void exportUrlForXlsx(List<T> excelRespDtos, Class<T> tClass) {
        String exportUrl = MyEasyPoiExportUtil.getExportUrl(excelRespDtos, tClass, null, this.excelName, "xlsx");
        this.exportService.success(this.id, exportUrl);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getExcelName() {
        return this.excelName;
    }

    public void setExcelName(String excelName) {
        this.excelName = excelName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

