/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.abs.ReportExportAbstract;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.CustomerAuthItemExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.operation.CurrentCommonService;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.CustomerAuthItemVo;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.module.bitem.biz.service.ICustomerAuthItemService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerAuthItemService
extends ReportExportAbstract<CustomerAuthItemRespDto, CustomerAuthItemExportReqDto, CustomerAuthItemVo> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICustomerAuthItemService customerAuthItemService;
    @Autowired
    private CurrentCommonService currentCommonService;

    @Override
    public ExportTypeEnum getExportType() {
        return ExportTypeEnum.CUSTOMER_ITEM_AUTH;
    }

    @Override
    public PageInfo<CustomerAuthItemRespDto> queryData(CustomerAuthItemExportReqDto customerAuthItemExportReqDto) {
        CustomerAuthItemPageReqDto customerAuthItemPageReqDto = new CustomerAuthItemPageReqDto();
        BeanUtils.copyProperties((Object)((Object)customerAuthItemExportReqDto), (Object)customerAuthItemPageReqDto);
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerAuthItemService.queryAuthItemPage(customerAuthItemPageReqDto));
    }

    @Override
    public CustomerAuthItemExportReqDto definePrams(CustomerAuthItemExportReqDto customerAuthItemExportReqDto) {
        List<Long> currentOrgId = this.currentCommonService.getCurrentOrgId();
        this.logger.info("[\u5ba2\u6237\u6388\u6743\u5546\u54c1\u5217\u8868\u5bfc\u51fa]\uff0c\u7ec4\u7ec7id\uff1a{}", currentOrgId);
        if (CollectionUtils.isNotEmpty(currentOrgId)) {
            customerAuthItemExportReqDto.setOrganizationId(currentOrgId.get(0));
        }
        return customerAuthItemExportReqDto;
    }

    @Override
    public Gson buildGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }

    @Override
    public List<CustomerAuthItemVo> getExportDtoList(List<CustomerAuthItemRespDto> exportDtoList, Class<CustomerAuthItemVo> vo) {
        if (CollectionUtils.isEmpty(exportDtoList)) {
            return Lists.newArrayList();
        }
        ArrayList itemAuthCustomerVos = Lists.newArrayList();
        for (CustomerAuthItemRespDto customerAuthItemRespDto : exportDtoList) {
            CustomerAuthItemVo customerAuthItemVo = new CustomerAuthItemVo();
            CubeBeanUtils.copyProperties((Object)customerAuthItemVo, (Object)customerAuthItemRespDto, (String[])new String[0]);
            customerAuthItemVo.setSubTypeName(SubTypeEnum.getSubTypeDesc((Integer)customerAuthItemRespDto.getSubType()));
            if (customerAuthItemRespDto.getProhibiteStatus() != null) {
                customerAuthItemVo.setProhibiteStatusName(Objects.equals(customerAuthItemRespDto.getProhibiteStatus(), 1) ? "\u542f\u552e" : "\u7981\u552e");
            }
            itemAuthCustomerVos.add(customerAuthItemVo);
        }
        return itemAuthCustomerVos;
    }
}

