/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.utils.MyEasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.biz.utils.ThreadPoolUtil;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.CustomerInfoExportTemporaryVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.enums.DeliverMethodEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtReqTemporaryDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="CustomerExportTemporaryService")
public class CustomerExportTemporaryService {
    @Resource
    private IContext context;
    @Resource
    private ExportService exportService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    private static final Logger logger = LoggerFactory.getLogger(CustomerExportTemporaryService.class);

    public RestResponse<Object> exportCustomerInfoTemporary(CustomerSearchExtReqTemporaryDto customerSearchReqTempDto) {
        block15: {
            String fileName = "\u5ba2\u6237\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            Long id = this.exportService.init(fileName, ExportTypeEnum.CUSTOMER);
            Long uesrId = this.context.userId();
            String uuid = UUID.randomUUID().toString().replace("-", "");
            ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
            this.context.userId(uesrId);
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{},UUID:{}", (Object)fileName, (Object)uuid);
            try {
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                ArrayList rList = Lists.newArrayList();
                while (total == null || (double)pageNum.intValue() <= num) {
                    ArrayList list = Lists.newArrayList();
                    customerSearchReqTempDto.setPageNum(pageNum);
                    customerSearchReqTempDto.setPageSize(pageSize);
                    String queryStr = JSONObject.toJSONString((Object)customerSearchReqTempDto);
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u5ba2\u6237\u53c2\u6570:{},UUID:{}", (Object)queryStr, (Object)uuid);
                    RestResponse customerResp = this.customerExtThreeQueryApi.queryByPageExport(customerSearchReqTempDto);
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)customerResp);
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        HashMap merchatMap = new HashMap();
                        List orgIds = pageInfo.getList().stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList());
                        for (CustomerExtRespDto customerExtRespDto : pageInfo.getList()) {
                            CustomerInfoExportTemporaryVo vo = new CustomerInfoExportTemporaryVo();
                            CubeBeanUtils.copyProperties((Object)vo, (Object)customerExtRespDto, (String[])new String[]{"companyInfoDto"});
                            CompanyInfoDto companyInfoDto = customerExtRespDto.getCompanyInfoDto();
                            if (Objects.nonNull(companyInfoDto)) {
                                vo.setSubjectType(companyInfoDto.getSubjectType() == null ? "" : companyInfoDto.getSubjectType());
                                vo.setOrgName(companyInfoDto.getOrgName() == null ? "" : companyInfoDto.getOrgName());
                                vo.setCreditCode(companyInfoDto.getCreditCode() == null ? "" : companyInfoDto.getCreditCode());
                                vo.setBusinessTermType(companyInfoDto.getBusinessTermType() == null ? "" : companyInfoDto.getBusinessTermType());
                                vo.setBusinessLicenseType(companyInfoDto.getBusinessLicenseType());
                                vo.setTermBeginTime(companyInfoDto.getTermBeginTime());
                                vo.setTermEndTime(companyInfoDto.getTermEndTime());
                                vo.setOrgAddress(companyInfoDto.getAddress());
                                vo.setOrgProvince(companyInfoDto.getProvince());
                                vo.setOrgCity(companyInfoDto.getCity());
                                vo.setOrgDistrict(companyInfoDto.getDistrict());
                                vo.setOrgAddress(companyInfoDto.getAddress());
                                vo.setLegalName(companyInfoDto.getLegalName());
                            } else {
                                vo.setSubjectType("");
                                vo.setBusinessTermType("");
                                vo.setBusinessLicenseType(0);
                            }
                            DeliverMethodEnum methodEnum = DeliverMethodEnum.enumOfKey((Integer)customerExtRespDto.getDeliverMethod());
                            if (ObjectUtils.isNotEmpty((Object)methodEnum)) {
                                vo.setDeliverMethod(methodEnum.getDesc());
                            }
                            vo.setEffectiveStartTime(DateUtil.getDateFormat((Date)customerExtRespDto.getEffectiveStartTime(), (String)"yyyy-MM-dd"));
                            vo.setEffectiveEndTime(DateUtil.getDateFormat((Date)customerExtRespDto.getEffectiveEndTime(), (String)"yyyy-MM-dd"));
                            vo.setIfWholeCasePurchase(customerExtRespDto.getIfWholeCasePurchase() == null ? 0 : customerExtRespDto.getIfWholeCasePurchase());
                            if (StringUtils.isNotBlank((String)vo.getRegionNames())) {
                                String[] split = vo.getRegionNames().split("/");
                                vo.setChannel(split[0]);
                                if (split.length >= 2) {
                                    vo.setRegion(split[1]);
                                }
                                if (split.length >= 3) {
                                    vo.setArea(split[2]);
                                }
                            }
                            rList.add(vo);
                        }
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2\u5ba2\u6237\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{uuid, total, num});
                    }
                    pageNum = pageNum + 1;
                }
                logger.info("\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{},UUID:{}", (Object)rList.size(), (Object)uuid);
                if (CollectionUtils.isNotEmpty((Collection)rList)) {
                    String excelName = "cube/" + fileName;
                    try {
                        String exportUrl = MyEasyPoiExportUtil.getExportUrl(rList, CustomerInfoExportTemporaryVo.class, null, excelName, "xls");
                        this.exportService.success(id, exportUrl);
                        break block15;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef1:{}", (Object)e.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef1:" + e);
                        return new RestResponse("30000", "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef1:" + e);
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237,\u6570\u636e\u4e3a\u7a7a");
                return new RestResponse("30000", "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237,\u6570\u636e\u4e3a\u7a7a");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef2:{}", (Object)e.toString());
                this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef2:" + e);
                return new RestResponse("30000", "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef2:" + e);
            }
        }
        return new RestResponse("0", "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237\u64cd\u4f5c\u6210\u529f");
    }

    private RestResponse<Object> exportCustomerInfoTemporaryThread(CustomerSearchExtReqTemporaryDto customerSearchReqTempDto) {
        String fileName = "\u5ba2\u6237\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.CUSTOMER);
        Long uesrId = this.context.userId();
        String organization = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationId");
        Long userId = this.context.userId();
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        Long applicationId = this.context.applicationId();
        String userCode = this.context.userName();
        String customerid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        String organizationid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        ThreadPoolUtil.executorService.submit(() -> {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
            this.context.userId(uesrId);
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{},UUID:{}", (Object)fileName, (Object)uuid);
            try {
                ServiceContext.getContext().set("yes.req.userId", (Object)userId.toString());
                ServiceContext.getContext().set("yes.req.instanceId", (Object)instanceId.toString());
                ServiceContext.getContext().set("yes.req.tenantId", (Object)tenantId.toString());
                ServiceContext.getContext().set("yes.req.applicationId", (Object)applicationId.toString());
                ServiceContext.getContext().set("yes.req.userCode", (Object)userCode);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)customerid)) {
                    ServiceContext.getContext().set("yes.req.cus.b2b.customerid", (Object)customerid);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)organizationid)) {
                    ServiceContext.getContext().set("yes.req.cus.b2b.organizationid", (Object)organizationid);
                }
                logger.info("\u3010web\u7ebf\u7a0b\u5e93\u5b58\u5bfc\u51fa\u4e0a\u4e0b\u6587={},keys={}\uff0cattachments={}\uff0ccustomerid = {}\uff0corganizationid = {}\u3011", new Object[]{ServiceContext.getContext().getKeys(), ServiceContext.getContext().getAttachments(), customerid, organizationid});
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                ArrayList rList = Lists.newArrayList();
                while (total == null || (double)pageNum.intValue() <= num) {
                    ArrayList list = Lists.newArrayList();
                    customerSearchReqTempDto.setPageNum(pageNum);
                    customerSearchReqTempDto.setPageSize(pageSize);
                    String queryStr = JSONObject.toJSONString((Object)customerSearchReqTempDto);
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u5ba2\u6237\u53c2\u6570:{},UUID:{}", (Object)queryStr, (Object)uuid);
                    RestResponse customerResp = this.customerExtThreeQueryApi.queryByPageExport(customerSearchReqTempDto);
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)customerResp);
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        HashMap merchatMap = new HashMap();
                        List orgIds = pageInfo.getList().stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList());
                        for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                            CustomerInfoExportTemporaryVo vo = new CustomerInfoExportTemporaryVo();
                            CubeBeanUtils.copyProperties((Object)vo, (Object)customerRespDto, (String[])new String[]{"companyInfoDto"});
                            CompanyInfoDto companyInfoDto = customerRespDto.getCompanyInfoDto();
                            if (Objects.nonNull(companyInfoDto)) {
                                vo.setSubjectType(companyInfoDto.getSubjectType() == null ? "" : companyInfoDto.getSubjectType());
                                vo.setOrgName(companyInfoDto.getOrgName() == null ? "" : companyInfoDto.getOrgName());
                                vo.setCreditCode(companyInfoDto.getCreditCode() == null ? "" : companyInfoDto.getCreditCode());
                                vo.setBusinessTermType(companyInfoDto.getBusinessTermType() == null ? "" : companyInfoDto.getBusinessTermType());
                                vo.setBusinessLicenseType(companyInfoDto.getBusinessLicenseType());
                                vo.setTermBeginTime(companyInfoDto.getTermBeginTime());
                                vo.setTermEndTime(companyInfoDto.getTermEndTime());
                                vo.setOrgAddress(companyInfoDto.getAddress());
                                vo.setOrgProvince(companyInfoDto.getProvince());
                                vo.setOrgCity(companyInfoDto.getCity());
                                vo.setOrgDistrict(companyInfoDto.getDistrict());
                                vo.setOrgAddress(companyInfoDto.getAddress());
                                vo.setLegalName(companyInfoDto.getLegalName());
                            } else {
                                vo.setSubjectType("");
                                vo.setBusinessTermType("");
                                vo.setBusinessLicenseType(0);
                            }
                            DeliverMethodEnum methodEnum = DeliverMethodEnum.enumOfKey((Integer)customerRespDto.getDeliverMethod());
                            if (ObjectUtils.isNotEmpty((Object)methodEnum)) {
                                vo.setDeliverMethod(methodEnum.getDesc());
                            }
                            rList.add(vo);
                        }
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2\u5ba2\u6237\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{uuid, total, num});
                    }
                    pageNum = pageNum + 1;
                }
                logger.info("\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{},UUID:{}", (Object)rList.size(), (Object)uuid);
                if (CollectionUtils.isNotEmpty((Collection)rList)) {
                    String excelName = "cube/" + fileName;
                    try {
                        String exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, CustomerInfoExportTemporaryVo.class, null, (String)excelName, (String)"xls");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef1:{}", (Object)e.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef1:" + e);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237,\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef2:{}", (Object)e.toString());
                this.exportService.fail(id, "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237-\u9519\u8bef2:" + e);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u5ba2\u5546\u7ba1\u7406\u5ba2\u6237\u64cd\u4f5c\u6210\u529f");
    }
}

