/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseDefinedParamDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportInfoReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ExchangeAccountDefinedParamDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ExchangeAdvanceImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.IExchangeBalanceAdvanceApi;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.request.ExchangeBalanceAdvanceReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceAccountRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.query.IExchangeBalanceAccountQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="exchangeAdvanceImportService")
public class ExchangeAdvanceImportService
extends ImportService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeAdvanceImportService.class);
    private static final String ACTIVITY_ID = "activityId";
    private static final String ORG_ID = "organizationId";
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IExchangeBalanceAdvanceApi exchangeBalanceAdvanceApi;
    @Resource
    private IExchangeBalanceAccountQueryApi exchangeBalanceAccountQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;

    /*
     * WARNING - void declaration
     */
    @Override
    public void definedImport(BaseDefinedParamDto baseDefinedParamDto, Object list, List<BaseImportInfoReqDto> errorList, Set<String> singleCustomerCodes) {
        Date now = new Date();
        ExchangeAccountDefinedParamDto paramDto = (ExchangeAccountDefinedParamDto)baseDefinedParamDto;
        Long organizationId = paramDto.getOrganizationId();
        Long activityId = paramDto.getActivityId();
        log.info("\u6362\u8d2d\u9884\u652f\u989d\u5ea6\u5bfc\u5165\u8bf7\u6c42 {}", (Object)JSON.toJSONString((Object)((Object)paramDto)));
        log.info("\u8bfb\u53d6\u5230\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9 {}", (Object)JSON.toJSONString((Object)list));
        ActivityRespDto activityRespDto = (ActivityRespDto)RestResponseHelper.extractData((RestResponse)this.activityQueryApi.queryActivityDetail(activityId.longValue()));
        if (activityRespDto == null) {
            throw new BizException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List exchangeAdvanceImportReqDtos = (List)list;
        List<String> customerCodes = exchangeAdvanceImportReqDtos.stream().map(ExchangeAdvanceImportReqDto::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap customerRespDtoMap = Maps.newHashMap();
        Map<Object, Object> accountRespDtoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(customerCodes)) {
            log.info("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5165\u53c2 {}", (Object)JSON.toJSONString(customerCodes));
            List<CustomerExtRespDto> customerExtRespDtos = this.queryCustomerList(customerCodes);
            log.info("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u51fa\u53c2 {}", (Object)JSON.toJSONString(customerExtRespDtos));
            ArrayList customerIds = Lists.newArrayList();
            for (CustomerRespDto customerRespDto : customerExtRespDtos) {
                customerRespDtoMap.put(customerRespDto.getCode(), customerRespDto);
                customerIds.add(customerRespDto.getId());
            }
            if (CollectionUtil.isNotEmpty((Collection)customerIds)) {
                ExchangeBalanceAccountReqDto exchangeBalanceAccountReqDto = new ExchangeBalanceAccountReqDto();
                exchangeBalanceAccountReqDto.setActivityId(activityId);
                exchangeBalanceAccountReqDto.setCustomerIds((List)customerIds);
                log.info("\u83b7\u53d6\u5ba2\u6237\u9884\u652f\u989d\u5ea6\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)exchangeBalanceAccountReqDto));
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.exchangeBalanceAccountQueryApi.queryByPage(exchangeBalanceAccountReqDto));
                log.info("\u83b7\u53d6\u5ba2\u6237\u9884\u652f\u989d\u5ea6\u51fa\u53c2 {}", (Object)JSON.toJSONString((Object)pageInfo));
                if (pageInfo != null && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
                    accountRespDtoMap = pageInfo.getList().stream().collect(Collectors.toMap(ExchangeBalanceAccountRespDto::getCustomerCode, Function.identity(), (e1, e2) -> e1));
                }
            }
        }
        log.info("\u5ba2\u6237\u83b7\u53d6\u7ed3\u679c {}", (Object)JSON.toJSONString((Object)customerRespDtoMap));
        for (ExchangeAdvanceImportReqDto advanceImportReqDto : exchangeAdvanceImportReqDtos) {
            StringBuilder sb = new StringBuilder(80);
            if (StringUtils.isEmpty((CharSequence)advanceImportReqDto.getCustomerCode())) {
                sb.append("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            Object var17_21 = null;
            if (StringUtils.isNotBlank((CharSequence)advanceImportReqDto.getAdvanceGrantTime())) {
                if (!super.isValidDateFormat(advanceImportReqDto.getAdvanceGrantTime(), "yyyy-MM-dd HH:mm:ss")) {
                    sb.append("\u989d\u5ea6\u53d1\u653e\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528yyyy-MM-dd HH:mm:ss\u683c\u5f0f\uff1b");
                } else {
                    Date date = DateUtil.parseDate((String)advanceImportReqDto.getAdvanceGrantTime(), (String)"yyyy-MM-dd HH:mm:ss");
                }
            }
            BigDecimal advanceAmount = super.tryConverBigDecimalAndCheckScaleLessZero(sb, advanceImportReqDto.getAdvanceAmount(), "\u9884\u652f\u989d\u5ea6", DEF_SCALE, false, false);
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(customerRespDtoMap.keySet().stream().filter(ld -> ld.startsWith(advanceImportReqDto.getCustomerCode() + "_")).findFirst().orElse(""));
            log.info("{} \u83b7\u53d6\u5230\u5ba2\u6237\u6620\u5c04 {}", (Object)advanceImportReqDto.getCustomerCode(), (Object)JSON.toJSONString((Object)customerRespDto));
            if (customerRespDto == null || !Objects.equals(customerRespDto.getMerchantId(), organizationId)) {
                sb.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
            }
            ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto = (ExchangeBalanceAccountRespDto)accountRespDtoMap.get(advanceImportReqDto.getCustomerCode());
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                void var17_23;
                ExchangeBalanceAdvanceReqDto exchangeBalanceAdvanceReqDto = new ExchangeBalanceAdvanceReqDto();
                if (exchangeBalanceAccountRespDto != null) {
                    exchangeBalanceAdvanceReqDto.setExchangeAccountId(exchangeBalanceAccountRespDto.getId());
                }
                exchangeBalanceAdvanceReqDto.setActivityId(activityId);
                exchangeBalanceAdvanceReqDto.setCustomerId(customerRespDto.getId());
                exchangeBalanceAdvanceReqDto.setCustomerCode(customerRespDto.getCode());
                exchangeBalanceAdvanceReqDto.setCustomerName(customerRespDto.getName());
                exchangeBalanceAdvanceReqDto.setAdvanceTime(new Date());
                exchangeBalanceAdvanceReqDto.setAdvanceAmount(advanceAmount);
                exchangeBalanceAdvanceReqDto.setAdvanceGrantTime((Date)ObjectUtil.defaultIfNull((Object)var17_23, (Object)new Date()));
                exchangeBalanceAdvanceReqDto.setSendBack(Integer.valueOf(1));
                exchangeBalanceAdvanceReqDto.setAdvanceMode(var17_23 != null ? YesOrNoEnum.YES.getCode() : YesOrNoEnum.NO.getCode());
                RestResponseHelper.extractData((RestResponse)this.exchangeBalanceAdvanceApi.addExchangeBalanceAdvance(exchangeBalanceAdvanceReqDto));
                continue;
            }
            advanceImportReqDto.setErrorMsg(sb.toString());
            errorList.add(advanceImportReqDto);
        }
    }

    @Override
    protected BaseDefinedParamDto converParamDto(BaseImportReqDto baseImportReqDto) {
        ExchangeAccountDefinedParamDto baseDefinedParamDto = new ExchangeAccountDefinedParamDto();
        baseDefinedParamDto.setOrganizationId(baseImportReqDto.getOrganizationId());
        Map<String, Object> businessDefineParam = baseImportReqDto.getBusinessDefineParam();
        Object obj = businessDefineParam.get(ACTIVITY_ID);
        if (obj == null || !StringUtils.isNumeric((CharSequence)obj.toString())) {
            throw new BizException("\u6362\u8d2d\u989d\u5ea6\u9884\u652f\u5bfc\u5165\uff0c\u6d3b\u52a8id\u5165\u53c2\u9519\u8bef");
        }
        baseDefinedParamDto.setActivityId(Long.valueOf(obj.toString()));
        if (baseDefinedParamDto.getOrganizationId() == null) {
            Object orgId = businessDefineParam.get(ORG_ID);
            if (orgId == null || !StringUtils.isNumeric((CharSequence)orgId.toString())) {
                throw new BizException("\u6362\u8d2d\u989d\u5ea6\u9884\u652f\u5bfc\u5165\uff0c\u7ec4\u7ec7id\u5165\u53c2\u9519\u8bef");
            }
            baseDefinedParamDto.setOrganizationId(Long.valueOf(orgId.toString()));
        }
        return baseDefinedParamDto;
    }

    private List<CustomerExtRespDto> queryCustomerList(List<String> customerCodes) {
        if (CollectionUtils.isEmpty(customerCodes)) {
            throw new BizException("\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        return customerCodes.stream().flatMap(ld -> {
            String filter = "{\"code\":\"" + ld + "_\",\"listFlag\":true,\"channel\":1,\"type\":2,\"customerChannelSource\":3,\"statusId\":\"\"}";
            log.info("\u5bfc\u5165\u989d\u5ea6\u8bf7\u6c42\u53c2\u6570:{}", (Object)filter);
            PageInfo extRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerExtThreeQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(100)));
            if (extRespDtoPageInfo == null || CollectionUtils.isEmpty((Collection)extRespDtoPageInfo.getList())) {
                throw new BizException("\u83b7\u53d6\u4e0d\u5230" + ld + "\u7f16\u7801\u7684\u4fe1\u606f");
            }
            return extRespDtoPageInfo.getList().stream();
        }).collect(Collectors.toList());
    }
}

