/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.biz.customer.ICustomerExportApi;
import com.dtyunxi.tcbj.api.biz.customer.dto.CustomerFullAreaDto;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaReq;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaResp;
import com.dtyunxi.tcbj.module.export.biz.abs.ReportExportAbstract;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ExchangeBalanceStatementExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.ExchangeAccountStatementVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ExchangeBalanceTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceStatementReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceStatementRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.ExchangeStatementChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.query.IExchangeBalanceStatementQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExchangeAccountStatementService
extends ReportExportAbstract<ExchangeBalanceStatementRespDto, ExchangeBalanceStatementExportReqDto, ExchangeAccountStatementVo> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExchangeBalanceStatementQueryApi exchangeBalanceStatementQueryApi;
    @Autowired
    private ICustomerExportApi customerExportApi;

    @Override
    public ExportTypeEnum getExportType() {
        return ExportTypeEnum.PROMOTION_EXCHANGE_ACCOUNT_STATEMENT;
    }

    @Override
    public PageInfo<ExchangeBalanceStatementRespDto> queryData(ExchangeBalanceStatementExportReqDto exchangeBalanceStatementExportReqDto) {
        ExchangeBalanceStatementReqDto exchangeBalanceStatementReqDto = new ExchangeBalanceStatementReqDto();
        BeanUtils.copyProperties((Object)((Object)exchangeBalanceStatementExportReqDto), (Object)exchangeBalanceStatementReqDto);
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.exchangeBalanceStatementQueryApi.queryByPage(exchangeBalanceStatementReqDto));
    }

    @Override
    public ExchangeBalanceStatementExportReqDto definePrams(ExchangeBalanceStatementExportReqDto exchangeBalanceStatementExportReqDto) {
        return exchangeBalanceStatementExportReqDto;
    }

    @Override
    public Gson buildGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }

    @Override
    public List<ExchangeAccountStatementVo> getExportDtoList(List<ExchangeBalanceStatementRespDto> exportDtoList, Class<ExchangeAccountStatementVo> vo) {
        this.logger.info("getExportDtoList exportDtoList={}, vo={}", (Object)JSON.toJSONString(exportDtoList), vo);
        if (exportDtoList == null || exportDtoList.size() == 0) {
            return new ArrayList<ExchangeAccountStatementVo>();
        }
        QueryCustomerFullAreaReq queryCustomerFullAreaReq = QueryCustomerFullAreaReq.builder().customerIds(exportDtoList.stream().map(ExchangeBalanceStatementRespDto::getCustomerId).collect(Collectors.toList())).build();
        this.logger.info("queryCustomerFullAreaReq={}", (Object)JSON.toJSONString((Object)queryCustomerFullAreaReq));
        QueryCustomerFullAreaResp queryCustomerFullAreaResp = (QueryCustomerFullAreaResp)this.customerExportApi.queryCustomerFullArea(queryCustomerFullAreaReq).getData();
        this.logger.info("queryCustomerFullAreaResp={}", (Object)JSON.toJSONString((Object)queryCustomerFullAreaResp));
        Map<Long, CustomerFullAreaDto> customerFullAreaMap = queryCustomerFullAreaResp.getCustomerFullAreaList().stream().collect(Collectors.toMap(CustomerFullAreaDto::getCustomerId, dto -> dto, (existing, replacement) -> existing));
        this.logger.info("customerFullAreaMap={}", (Object)JSON.toJSONString(customerFullAreaMap));
        ArrayList exchangeAccountStatementVos = Lists.newArrayList();
        for (ExchangeBalanceStatementRespDto exchangeBalanceStatementRespDto : exportDtoList) {
            ExchangeAccountStatementVo exchangeAccountStatementVo = new ExchangeAccountStatementVo();
            CubeBeanUtils.copyProperties((Object)exchangeAccountStatementVo, (Object)exchangeBalanceStatementRespDto, (String[])new String[0]);
            exchangeAccountStatementVo.setCreateTime(DateUtil.getDateFormat((Date)exchangeBalanceStatementRespDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            exchangeAccountStatementVo.setChangeTypeName(ExchangeStatementChangeTypeEnum.getDescByType((Integer)exchangeBalanceStatementRespDto.getChangeType()));
            exchangeAccountStatementVo.setBalanceTypeName(this.getBalanceTypeName(exchangeBalanceStatementRespDto.getBalanceType()));
            this.logger.info("exchangeBalanceStatementRespDto.getCustomerId()={}", (Object)JSON.toJSONString((Object)exchangeBalanceStatementRespDto.getCustomerId()));
            CustomerFullAreaDto customerFullAreaDto = customerFullAreaMap.get(exchangeBalanceStatementRespDto.getCustomerId());
            this.logger.info("customerFullAreaDto={}", (Object)JSON.toJSONString((Object)customerFullAreaDto));
            if (customerFullAreaDto != null) {
                exchangeAccountStatementVo.setRegion0(customerFullAreaDto.getRegion0());
                exchangeAccountStatementVo.setRegion1(customerFullAreaDto.getRegion1());
                exchangeAccountStatementVo.setRegion2(customerFullAreaDto.getRegion2());
            }
            exchangeAccountStatementVos.add(exchangeAccountStatementVo);
        }
        return exchangeAccountStatementVos;
    }

    public String getBalanceTypeName(String key) {
        for (ExchangeBalanceTypeEnum value : ExchangeBalanceTypeEnum.values()) {
            if (!value.getKey().equals(key)) continue;
            return value.getValue();
        }
        return "";
    }
}

