/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.abs;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.utils.ThreadPoolUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReportExportAbstract<T, R extends PageInfo, P> {
    private static final Logger logger = LoggerFactory.getLogger(ReportExportAbstract.class);
    @Resource
    private ExportService exportService;
    @Resource
    private IContext context;
    private static final Integer totalMax = 100000;
    private static final Integer batchNum = 5000;
    protected static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public abstract ExportTypeEnum getExportType();

    public abstract PageInfo<T> queryData(R var1);

    public abstract R definePrams(R var1);

    public Gson buildGson() {
        return new GsonBuilder().create();
    }

    public RestResponse<Object> execute(R r, Class<P> vo) {
        logger.info(this.getExportType().getName() + "\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString(r));
        r.setPageNum(1);
        r.setPageSize(1);
        r = this.definePrams(r);
        PageInfo<T> pageInfo = this.queryData(r);
        this.checkExportRestriction(pageInfo);
        String fileName = this.getExportType().getName() + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, this.getExportType());
        Long userId = this.context.userId();
        R finalR = r;
        ThreadPoolUtil.executorService.submit(() -> {
            try {
                logger.info("\u5f02\u6b65\u6267\u884c-" + this.getExportType().getName());
                String uuid = UUID.randomUUID().toString().replace("-", "");
                ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
                this.context.userId(userId);
                List pageList = null;
                ArrayList exportDtoList = new ArrayList();
                finalR.setPageSize(batchNum.intValue());
                do {
                    PageInfo<T> batchPageInfo;
                    if (CollectionUtils.isNotEmpty((Collection)(batchPageInfo = this.queryData(finalR)).getList())) {
                        exportDtoList.addAll(batchPageInfo.getList());
                    }
                    pageList = batchPageInfo.getList();
                    finalR.setPageNum(finalR.getPageNum() + 1);
                } while (CollectionUtils.isNotEmpty((Collection)pageList));
                List<P> exportVoList = this.getExportDtoList(exportDtoList, vo);
                String excelName = "cube/" + fileName;
                String exportUrl = EasyPoiExportUtil.getExportUrl(exportVoList, (Class)vo, null, (String)excelName, (String)"xls");
                this.exportService.success(id, exportUrl);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Object)(fileName + id));
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(id, "\u5bfc\u51fa\u5931\u8d25\uff1a\u7a0b\u5e8f\u5f02\u5e38");
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u64cd\u4f5c\u6210\u529f");
    }

    public List<P> getExportDtoList(List<T> exportDtoList, Class<P> vo) {
        return exportDtoList.stream().map(dto -> {
            Gson gson = this.buildGson();
            return gson.fromJson(JSON.toJSONString((Object)dto), vo);
        }).collect(Collectors.toList());
    }

    private void checkExportRestriction(PageInfo<T> pageInfo) {
        if (ObjectUtils.isEmpty(pageInfo) || ObjectUtils.isEmpty((Object)pageInfo.getTotal())) {
            throw new BizException("-1", "\u6570\u636e\u67e5\u8be2\u5f02\u5e38");
        }
        if (pageInfo.getTotal() <= 0L) {
            throw new BizException("-1", "\u65e0\u6570\u636e\u53ef\u5bfc\u51fa");
        }
        if (pageInfo.getTotal() > (long)totalMax.intValue()) {
            throw new BizException("-1", "\u5bfc\u51fa\u6570\u636e\u7684\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7" + totalMax + "\u6761");
        }
    }
}

