/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.export;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.dtyunxi.cube.biz.commons.constants.OssConstant;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractDataExport<EXPORT_TYPE> {
    protected static final Integer DEFAULT_PAGE_SIZE = 100;
    protected String exportName;
    protected EXPORT_TYPE export_type;
    protected String suffix;
    private Logger logger = LoggerFactory.getLogger(AbstractDataExport.class);
    @Resource
    private IObjectStorageService objectStorageService;

    public AbstractDataExport(String exportName, String suffix, IObjectStorageService objectStorageService) {
        this.exportName = exportName;
        this.suffix = suffix;
        this.objectStorageService = objectStorageService;
    }

    protected abstract List<EXPORT_TYPE> findExportDataList(Integer var1, Integer var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExportUrl() {
        Workbook workbook = null;
        ExportParams params = new ExportParams(null, "sheet1");
        ByteArrayOutputStream fos = null;
        String filePath = null;
        try {
            int pageIndex = 1;
            List<EXPORT_TYPE> exportDataList = this.findExportDataList(DEFAULT_PAGE_SIZE, pageIndex);
            while (!CollectionUtils.isEmpty(exportDataList)) {
                workbook = ExcelExportUtil.exportBigExcel((ExportParams)params, exportDataList.get(0).getClass(), exportDataList);
                exportDataList = this.findExportDataList(DEFAULT_PAGE_SIZE, ++pageIndex);
            }
            if (workbook == null) {
                String string = null;
                return string;
            }
            ExcelExportUtil.closeExportBigExcel();
            fos = new ByteArrayOutputStream();
            workbook.write((OutputStream)fos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fos.toByteArray());
            filePath = this.objectStorageService.put(OssConstant.BUCKET_NAME, this.exportName, (InputStream)byteArrayInputStream);
            this.logger.info("Excel\u6587\u4ef6\uff1a{}\u5df2\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668...", (Object)(OssConstant.OSS_DOWNLOAD_URL + "/" + this.exportName + this.suffix));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException var13) {
                this.logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Throwable)var13);
            }
        }
        return filePath;
    }
}

