/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.account.constant.ModelStatusConstant;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountModelReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountModelRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.exception.AccountBusinessException;
import com.dtyunxi.yundt.cube.center.credit.api.account.exception.AccountBusinessExceptionCode;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountModelService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountCustomerConfigDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountModelDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountCustomerConfigEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountModelEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrAccountModelServiceImpl
implements ICrAccountModelService {
    @Resource
    private CrAccountModelDas crAccountModelDas;
    @Resource
    private CrAccountCustomerConfigDas crAccountCustomerConfigDas;
    @Resource
    private ICreditAccountService creditAccountService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;

    @Override
    public Long addCrAccountModel(CrAccountModelReqDto addReqDto) {
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        CrAccountModelEo crAccountModelEo = new CrAccountModelEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)crAccountModelEo);
        crAccountModelEo.setOrgInfoId(orgId);
        this.crAccountModelDas.insert((BaseEo)crAccountModelEo);
        return crAccountModelEo.getId();
    }

    @Override
    public void modifyCrAccountModel(CrAccountModelReqDto modifyReqDto) {
        CrAccountModelEo crAccountModelEo = new CrAccountModelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)crAccountModelEo);
        this.crAccountModelDas.updateSelective((BaseEo)crAccountModelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCrAccountModel(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.crAccountModelDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CrAccountModelRespDto queryById(Long id) {
        CrAccountModelEo crAccountModelEo = (CrAccountModelEo)this.crAccountModelDas.selectByPrimaryKey(id);
        CrAccountModelRespDto crAccountModelRespDto = new CrAccountModelRespDto();
        DtoHelper.eo2Dto((BaseEo)crAccountModelEo, (BaseVo)crAccountModelRespDto);
        return crAccountModelRespDto;
    }

    @Override
    public PageInfo<CrAccountModelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        Long orgId;
        CrAccountModelReqDto crAccountModelReqDto = (CrAccountModelReqDto)JSON.parseObject((String)filter, CrAccountModelReqDto.class);
        CrAccountModelEo crAccountModelEo = new CrAccountModelEo();
        if (ObjectUtil.isNotEmpty((Object)crAccountModelReqDto)) {
            if (ObjectUtil.isNotEmpty((Object)crAccountModelReqDto.getStatus())) {
                crAccountModelEo.setStatus(crAccountModelReqDto.getStatus());
            }
            if (ObjectUtil.isNotEmpty((Object)crAccountModelReqDto.getModelName())) {
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.like((String)"model_name", (Object)crAccountModelReqDto.getModelName()));
                crAccountModelEo.setSqlFilters(sqlFilters);
            }
            if (ObjectUtil.isNotEmpty((Object)crAccountModelReqDto.getModelType())) {
                crAccountModelEo.setModelType(crAccountModelReqDto.getModelType());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(orgId = this.creditAccountService.queryOrgIdByUserId()))) {
            crAccountModelEo.setOrgInfoId(orgId);
        }
        PageInfo eoPageInfo = this.crAccountModelDas.selectPage((BaseEo)crAccountModelEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CrAccountModelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Integer operateCrAccountModel(String id, Integer status) {
        CrAccountModelEo crAccountModelEo = new CrAccountModelEo();
        crAccountModelEo.setId(Long.valueOf(id));
        crAccountModelEo.setStatus(status);
        if (ModelStatusConstant.STOP_USE.equals(status)) {
            CrAccountCustomerConfigEo customerConfigEo = new CrAccountCustomerConfigEo();
            customerConfigEo.setModelId(Long.valueOf(id));
            List list = this.crAccountCustomerConfigDas.select((BaseEo)customerConfigEo);
            if (!list.isEmpty()) {
                throw new AccountBusinessException(AccountBusinessExceptionCode.ACCOUNT_MODEL_STOP_FAIL);
            }
        }
        if (this.crAccountModelDas.updateSelective((BaseEo)crAccountModelEo) > 0) {
            return ModelStatusConstant.SUCCESS;
        }
        return ModelStatusConstant.FAIL;
    }
}

