/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.AccountOrderLogReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.AccountOrderLogRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.AccountOrderLogSumRespDto;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.IAccountOrderLogService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.AccountOrderLogDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.AccountOrderLogEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountOrderLogServiceImpl
implements IAccountOrderLogService {
    @Resource
    private AccountOrderLogDas accountOrderLogDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICreditAccountService creditAccountService;

    @Override
    public Long addAccountOrderLog(AccountOrderLogReqDto addReqDto) {
        AccountOrderLogEo accountOrderLogEo = new AccountOrderLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)accountOrderLogEo);
        this.accountOrderLogDas.insert((BaseEo)accountOrderLogEo);
        return accountOrderLogEo.getId();
    }

    @Override
    public void modifyAccountOrderLog(AccountOrderLogReqDto modifyReqDto) {
        AccountOrderLogEo accountOrderLogEo = new AccountOrderLogEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)accountOrderLogEo);
        this.accountOrderLogDas.updateSelective((BaseEo)accountOrderLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAccountOrderLog(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.accountOrderLogDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public AccountOrderLogRespDto queryById(Long id) {
        AccountOrderLogEo accountOrderLogEo = (AccountOrderLogEo)this.accountOrderLogDas.selectByPrimaryKey(id);
        AccountOrderLogRespDto accountOrderLogRespDto = new AccountOrderLogRespDto();
        DtoHelper.eo2Dto((BaseEo)accountOrderLogEo, (BaseVo)accountOrderLogRespDto);
        return accountOrderLogRespDto;
    }

    @Override
    public PageInfo<AccountOrderLogRespDto> queryByPage(AccountOrderLogReqDto reqDto) {
        Long orgId;
        PageInfo dtoPageInfo = new PageInfo();
        Long l = orgId = reqDto.getOrgInfoId() != null ? reqDto.getOrgInfoId() : this.creditAccountService.queryOrgIdByUserId();
        if (orgId == null) {
            return dtoPageInfo;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List customerIds = (List)this.customerExtQueryApi.queryCustomerIdByOrgId(orgIds).getData();
        if (CollectionUtil.isEmpty((Collection)customerIds)) {
            return dtoPageInfo;
        }
        AccountOrderLogEo logEo = new AccountOrderLogEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)logEo);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (ObjectUtil.isNotEmpty((Object)reqDto.getBeginTimeEnd()) && ObjectUtil.isNotEmpty((Object)reqDto.getBeginTimeStart())) {
            sqlFilterList.add(SqlFilter.ge((String)"create_time", (Object)reqDto.getBeginTimeStart()));
            sqlFilterList.add(SqlFilter.le((String)"create_time", (Object)reqDto.getBeginTimeEnd()));
        }
        sqlFilterList.add(SqlFilter.in((String)"customer_id", (Object)customerIds));
        logEo.setSqlFilters(sqlFilterList);
        logEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.accountOrderLogDas.selectPage((BaseEo)logEo, reqDto.getPageNum(), reqDto.getPageSize());
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AccountOrderLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public AccountOrderLogSumRespDto total(AccountOrderLogReqDto reqDto) {
        Long orgId;
        AccountOrderLogSumRespDto respDto = new AccountOrderLogSumRespDto();
        Long l = orgId = reqDto.getOrgInfoId() != null ? reqDto.getOrgInfoId() : this.creditAccountService.queryOrgIdByUserId();
        if (orgId == null) {
            return respDto;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List customerIds = (List)this.customerExtQueryApi.queryCustomerIdByOrgId(orgIds).getData();
        if (CollectionUtil.isEmpty((Collection)customerIds)) {
            return respDto;
        }
        List list = this.accountOrderLogDas.queryAccountOrderLogSum(reqDto, customerIds);
        for (Map map : list) {
            String tradeType = String.valueOf(map.get("tradeType"));
            BigDecimal totalAmount = new BigDecimal(String.valueOf(map.get("totalAmount")));
            if (tradeType != null && ObjectUtil.equal((Object)tradeType, (Object)"0")) {
                respDto.setPayAmountTotal(totalAmount);
            }
            if (tradeType == null || !ObjectUtil.equal((Object)tradeType, (Object)"1")) continue;
            respDto.setIncomeAmountTotal(totalAmount);
        }
        return respDto;
    }
}

