/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountConfigReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountConfigRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.exception.AccountBusinessException;
import com.dtyunxi.yundt.cube.center.credit.api.account.exception.AccountBusinessExceptionCode;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountConfigService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountConfigDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountConfigEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrAccountConfigServiceImpl
implements ICrAccountConfigService {
    @Resource
    private CrAccountConfigDas crAccountConfigDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICreditAccountService creditAccountService;

    @Override
    public Long addCrAccountConfig(CrAccountConfigReqDto addReqDto) {
        CrAccountConfigEo crAccountConfigEo = new CrAccountConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)crAccountConfigEo);
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        if (ObjectUtil.isNotEmpty((Object)orgId)) {
            crAccountConfigEo.setOrgInfoId(orgId);
        }
        if (ObjectUtil.isEmpty((Object)addReqDto.getAccountDate())) {
            throw new AccountBusinessException(AccountBusinessExceptionCode.ACCOUNT_MODEL_SETUP_FAIL);
        }
        if (addReqDto.getAccountDate() < 0) {
            throw new AccountBusinessException(AccountBusinessExceptionCode.ACCOUNT_MODEL_SET_FAIL);
        }
        this.crAccountConfigDas.insert((BaseEo)crAccountConfigEo);
        return crAccountConfigEo.getId();
    }

    @Override
    public void modifyCrAccountConfig(CrAccountConfigReqDto modifyReqDto) {
        CrAccountConfigEo crAccountConfigEo = new CrAccountConfigEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)crAccountConfigEo);
        if (ObjectUtil.isEmpty((Object)modifyReqDto.getAccountDate())) {
            throw new AccountBusinessException(AccountBusinessExceptionCode.ACCOUNT_MODEL_SETUP_FAIL);
        }
        if (modifyReqDto.getAccountDate() < 0) {
            throw new AccountBusinessException(AccountBusinessExceptionCode.ACCOUNT_MODEL_SET_FAIL);
        }
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        if (ObjectUtil.isNotEmpty((Object)orgId)) {
            crAccountConfigEo.setOrgInfoId(orgId);
        }
        this.crAccountConfigDas.updateSelective((BaseEo)crAccountConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCrAccountConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.crAccountConfigDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CrAccountConfigRespDto queryById(Long id) {
        CrAccountConfigEo crAccountConfigEo = (CrAccountConfigEo)this.crAccountConfigDas.selectByPrimaryKey(id);
        CrAccountConfigRespDto crAccountConfigRespDto = new CrAccountConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)crAccountConfigEo, (BaseVo)crAccountConfigRespDto);
        return crAccountConfigRespDto;
    }

    @Override
    public CrAccountConfigRespDto query() {
        CrAccountConfigEo crAccountConfigEo = new CrAccountConfigEo();
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        if (ObjectUtil.isNotEmpty((Object)orgId)) {
            crAccountConfigEo.setOrgInfoId(orgId);
        }
        List accountConfigEos = this.crAccountConfigDas.select((BaseEo)crAccountConfigEo);
        CrAccountConfigRespDto crAccountConfigRespDto = new CrAccountConfigRespDto();
        if (CollectionUtil.isNotEmpty((Collection)accountConfigEos)) {
            crAccountConfigEo = (CrAccountConfigEo)accountConfigEos.get(0);
            DtoHelper.eo2Dto((BaseEo)crAccountConfigEo, (BaseVo)crAccountConfigRespDto);
        }
        return crAccountConfigRespDto;
    }

    @Override
    public CrAccountConfigRespDto query(CrAccountConfigReqDto reqDto) {
        CrAccountConfigEo crAccountConfigEo = new CrAccountConfigEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)crAccountConfigEo);
        List accountConfigEos = this.crAccountConfigDas.select((BaseEo)crAccountConfigEo);
        CrAccountConfigRespDto crAccountConfigRespDto = new CrAccountConfigRespDto();
        if (CollectionUtil.isNotEmpty((Collection)accountConfigEos)) {
            crAccountConfigEo = (CrAccountConfigEo)accountConfigEos.get(0);
            DtoHelper.eo2Dto((BaseEo)crAccountConfigEo, (BaseVo)crAccountConfigRespDto);
        }
        return crAccountConfigRespDto;
    }

    @Override
    public PageInfo<CrAccountConfigRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CrAccountConfigReqDto crAccountConfigReqDto = (CrAccountConfigReqDto)JSON.parseObject((String)filter, CrAccountConfigReqDto.class);
        CrAccountConfigEo crAccountConfigEo = new CrAccountConfigEo();
        DtoHelper.dto2Eo((BaseVo)crAccountConfigReqDto, (BaseEo)crAccountConfigEo);
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        if (ObjectUtil.isNotEmpty((Object)orgId)) {
            crAccountConfigEo.setOrgInfoId(orgId);
        }
        PageInfo eoPageInfo = this.crAccountConfigDas.selectPage((BaseEo)crAccountConfigEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CrAccountConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

