/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.account.constant.AccountPeriodTypeConstant;
import com.dtyunxi.yundt.cube.center.credit.api.account.constant.OrderStatusConstant;
import com.dtyunxi.yundt.cube.center.credit.api.account.constant.TradeTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountBillReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountConfigReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountCustomerConfigReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountOrderReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountRecordReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountConfigRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountCustomerConfigRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountOrderRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.thrid.dto.AccountPeriodCreateReq;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountBillService;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountConfigService;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountCustomerConfigService;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountOrderService;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountRecordService;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.AccountOrderLogDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.AccountOrderModelDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountOrderDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.AccountOrderLogEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.AccountOrderModelEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountOrderEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrAccountOrderServiceImpl
implements ICrAccountOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrAccountOrderServiceImpl.class);
    @Resource
    private CrAccountOrderDas crAccountOrderDas;
    @Resource
    private ICrAccountRecordService accountRecordService;
    @Resource
    private ICrAccountBillService accountBillService;
    @Resource
    private ICrAccountCustomerConfigService accountCustomerConfigService;
    @Resource
    private ICrAccountConfigService accountConfigService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private AccountOrderModelDas orderModelDas;
    @Resource
    private AccountOrderLogDas accountOrderLogDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createAccountOrder(AccountPeriodCreateReq accountPeriodCreateReq) {
        CrAccountOrderEo orderEo = new CrAccountOrderEo();
        orderEo.setOrderNo(accountPeriodCreateReq.getOrderNo());
        List accountOrderEos = this.crAccountOrderDas.select((BaseEo)orderEo);
        if (CollUtil.isEmpty((Collection)accountOrderEos)) {
            CrAccountOrderReqDto addReqDto = new CrAccountOrderReqDto();
            addReqDto.setOrderNo(accountPeriodCreateReq.getOrderNo());
            addReqDto.setBillAmount(accountPeriodCreateReq.getBillAmount());
            CustomerRespDto customerRespDto = (CustomerRespDto)this.customerQueryApi.queryById(accountPeriodCreateReq.getCustomerId()).getData();
            addReqDto.setCustomerId(String.valueOf(accountPeriodCreateReq.getCustomerId()));
            if (ObjectUtil.isNotEmpty((Object)customerRespDto)) {
                addReqDto.setCustomerCode(customerRespDto.getCode());
                addReqDto.setCustomerName(customerRespDto.getName());
                addReqDto.setOrgInfoId(customerRespDto.getMerchantId());
            }
            addReqDto.setOrderAmount(accountPeriodCreateReq.getTotalAmount());
            addReqDto.setOrderType("0");
            addReqDto.setModelType(accountPeriodCreateReq.getAccountPeriodType());
            addReqDto.setShopId(accountPeriodCreateReq.getShopId());
            addReqDto.setShop(accountPeriodCreateReq.getShop());
            LOGGER.info("CrAccountOrderReqDto=[{}]", (Object)JSON.toJSONString((Object)addReqDto));
            this.addCrAccountOrder(addReqDto);
            AccountOrderLogEo logEo = new AccountOrderLogEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)logEo);
            logEo.setTradeType(Integer.valueOf(TradeTypeEnum.ORDER_PAY.getTypeCode()));
            this.addAccountOrderLog(logEo);
        }
    }

    @Override
    public void noticeAccountOrder(AccountPeriodCreateReq accountPeriodCreateReq) {
        CrAccountOrderEo orderEo = new CrAccountOrderEo();
        orderEo.setOrderNo(accountPeriodCreateReq.getOrderNo());
        List accountOrderEos = this.crAccountOrderDas.select((BaseEo)orderEo);
        if (CollUtil.isNotEmpty((Collection)accountOrderEos) && accountOrderEos.size() == 1) {
            CrAccountOrderEo accountOrderEo = (CrAccountOrderEo)accountOrderEos.get(0);
            String billNo = "ZD" + IdUtil.getSnowflake((long)1L, (long)1L).nextIdStr();
            CrAccountRecordReqDto accountRecordReqDto = new CrAccountRecordReqDto();
            DtoHelper.eo2Dto((BaseEo)accountOrderEo, (BaseVo)accountRecordReqDto);
            accountRecordReqDto.setOrderType("0");
            accountRecordReqDto.setBillNo(billNo);
            accountRecordReqDto.setSendTime(accountPeriodCreateReq.getDeliveryTime());
            LOGGER.info("CrAccountRecordReqDto=[{}]", (Object)JSON.toJSONString((Object)accountRecordReqDto));
            this.accountRecordService.addCrAccountRecord(accountRecordReqDto);
            CrAccountBillReqDto billReqDto = new CrAccountBillReqDto();
            DtoHelper.eo2Dto((BaseEo)accountOrderEo, (BaseVo)billReqDto);
            billReqDto.setBillNo(billNo);
            billReqDto.setOrgInfoId(accountOrderEo.getOrgInfoId().toString());
            billReqDto.setAlreadyRepaidAmount(BigDecimal.ZERO);
            billReqDto.setNotYetAmount(accountOrderEo.getBillAmount());
            billReqDto.setModelType(AccountPeriodTypeConstant.FIX_LENGTH_OF_TIME);
            billReqDto.setCustomerId(String.valueOf(accountOrderEo.getCustomerId()));
            billReqDto.setStatus(OrderStatusConstant.NON_PAYMENT);
            AccountOrderModelEo accountOrderModelEo = new AccountOrderModelEo();
            accountOrderModelEo.setOrderNo(accountOrderEo.getOrderNo());
            AccountOrderModelEo orderModelEo = (AccountOrderModelEo)this.orderModelDas.selectOne((BaseEo)accountOrderModelEo);
            String modelRule = orderModelEo.getModelRule();
            CrAccountConfigReqDto configReqDto = new CrAccountConfigReqDto();
            configReqDto.setOrgInfoId(accountOrderEo.getOrgInfoId());
            CrAccountConfigRespDto configRespDto = this.accountConfigService.query(configReqDto);
            if (Objects.isNull(configRespDto) || Objects.isNull(configRespDto.getAccountDate())) {
                LOGGER.info("\u7ec4\u7ec7ID[{}],\u672a\u627e\u5230\u5ba2\u6237\u8d26\u671f\u8d77\u7b97\u65e5\u8bbe\u7f6e\u4fe1\u606f");
                return;
            }
            Integer accountDate = configRespDto.getAccountDate();
            DateTime lastPayBackTime = DateUtil.offsetDay((Date)accountPeriodCreateReq.getDeliveryTime(), (int)(Integer.parseInt(modelRule) + accountDate));
            billReqDto.setLastPayBackTime((Date)lastPayBackTime);
            billReqDto.setStatementDate((Date)DateUtil.offsetDay((Date)accountPeriodCreateReq.getDeliveryTime(), (int)accountDate));
            LOGGER.info("CrAccountBillReqDto=[{}]", (Object)JSON.toJSONString((Object)billReqDto));
            this.accountBillService.addCrAccountBill(billReqDto);
        }
    }

    @Override
    public Boolean checkAccountOrder(AccountPeriodCreateReq accountPeriodCreateReq) {
        boolean result = false;
        AccountOrderModelEo acmSearchEo = new AccountOrderModelEo();
        acmSearchEo.setOrderNo(accountPeriodCreateReq.getOrderNo());
        AccountOrderModelEo orderModelEo = (AccountOrderModelEo)this.orderModelDas.selectOne((BaseEo)acmSearchEo);
        if (orderModelEo != null) {
            return true;
        }
        CrAccountOrderEo orderEo = new CrAccountOrderEo();
        orderEo.setOrderNo(accountPeriodCreateReq.getOrderNo());
        CrAccountOrderEo accountOrderEo = (CrAccountOrderEo)this.crAccountOrderDas.selectOne((BaseEo)orderEo);
        if (ObjectUtil.isNotEmpty((Object)accountOrderEo)) {
            CrAccountCustomerConfigReqDto reqDto = new CrAccountCustomerConfigReqDto();
            reqDto.setCustomerCode(accountOrderEo.getCustomerCode());
            CrAccountCustomerConfigRespDto customerConfigRespDto = this.accountCustomerConfigService.queryAccountByCustomerCode(reqDto);
            if (ObjectUtil.isNotEmpty((Object)customerConfigRespDto.getId())) {
                AccountOrderModelEo accountOrderModelEo = new AccountOrderModelEo();
                accountOrderModelEo.setOrderNo(accountPeriodCreateReq.getOrderNo());
                DtoHelper.dto2Eo((BaseVo)customerConfigRespDto, (BaseEo)accountOrderModelEo);
                accountOrderModelEo.setId(null);
                result = this.orderModelDas.insert((BaseEo)accountOrderModelEo) > 0;
            }
        }
        return result;
    }

    @Override
    public CrAccountOrderRespDto queryByOrderNo(String OrderNo) {
        CrAccountOrderEo orderEo = new CrAccountOrderEo();
        orderEo.setOrderNo(OrderNo);
        CrAccountOrderEo accountOrderEo = (CrAccountOrderEo)this.crAccountOrderDas.selectOne((BaseEo)orderEo);
        CrAccountOrderRespDto orderRespDto = null;
        if (ObjectUtil.isNotEmpty((Object)accountOrderEo)) {
            orderRespDto = new CrAccountOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)accountOrderEo, (BaseVo)orderRespDto);
        }
        return orderRespDto;
    }

    @Override
    public void delAccountOrder(AccountPeriodCreateReq accountPeriodCreateReq) {
        CrAccountOrderEo orderEo = new CrAccountOrderEo();
        orderEo.setOrderNo(accountPeriodCreateReq.getOrderNo());
        List accountOrderEos = this.crAccountOrderDas.select((BaseEo)orderEo);
        if (CollUtil.isNotEmpty((Collection)accountOrderEos)) {
            String ids = accountOrderEos.stream().map(BaseEo::getId).map(String::valueOf).collect(Collectors.joining(","));
            LOGGER.info("\u53d6\u6d88\u8ba2\u5355[{}]\uff0c\u5220\u9664\u5173\u8054\u7684\u8d26\u671f", (Object)ids);
            this.removeCrAccountOrder(ids, 0L);
            for (CrAccountOrderEo eo : accountOrderEos) {
                AccountOrderLogEo logEo = new AccountOrderLogEo();
                CubeBeanUtils.copyProperties((Object)logEo, (Object)eo, (String[])new String[0]);
                logEo.setTradeType(Integer.valueOf(TradeTypeEnum.ORDER_BACK.getTypeCode()));
                this.addAccountOrderLog(logEo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCrAccountOrder(CrAccountOrderReqDto addReqDto) {
        CrAccountOrderEo crAccountOrderEo = new CrAccountOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)crAccountOrderEo);
        this.crAccountOrderDas.insert((BaseEo)crAccountOrderEo);
        return crAccountOrderEo.getId();
    }

    private Long addAccountOrderLog(AccountOrderLogEo logEo) {
        logEo.setSerializeNo(IdUtil.getSnowflake((long)1L, (long)1L).nextIdStr());
        this.accountOrderLogDas.insert((BaseEo)logEo);
        return logEo.getId();
    }

    @Override
    public void modifyCrAccountOrder(CrAccountOrderReqDto modifyReqDto) {
        CrAccountOrderEo crAccountOrderEo = new CrAccountOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)crAccountOrderEo);
        this.crAccountOrderDas.updateSelective((BaseEo)crAccountOrderEo);
    }

    @Override
    public void removeCrAccountOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.crAccountOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CrAccountOrderRespDto queryById(Long id) {
        CrAccountOrderEo crAccountOrderEo = (CrAccountOrderEo)this.crAccountOrderDas.selectByPrimaryKey(id);
        CrAccountOrderRespDto crAccountOrderRespDto = new CrAccountOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)crAccountOrderEo, (BaseVo)crAccountOrderRespDto);
        return crAccountOrderRespDto;
    }

    @Override
    public PageInfo<CrAccountOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CrAccountOrderReqDto crAccountOrderReqDto = (CrAccountOrderReqDto)JSON.parseObject((String)filter, CrAccountOrderReqDto.class);
        CrAccountOrderEo crAccountOrderEo = new CrAccountOrderEo();
        DtoHelper.dto2Eo((BaseVo)crAccountOrderReqDto, (BaseEo)crAccountOrderEo);
        PageInfo eoPageInfo = this.crAccountOrderDas.selectPage((BaseEo)crAccountOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CrAccountOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

