/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountCustomerConfigReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountRecordReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountCustomerConfigRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountRecordRespDto;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountConfigService;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountRecordService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountCustomerConfigDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountBillEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountRecordEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrAccountRecordServiceImpl
implements ICrAccountRecordService {
    @Resource
    private CrAccountRecordDas crAccountRecordDas;
    @Resource
    private CrAccountBillDas accountBillDas;
    @Resource
    private CrAccountCustomerConfigDas accountCustomerConfigDas;
    @Resource
    private ICrAccountConfigService accountConfigService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICreditAccountService creditAccountService;

    @Override
    public Long addCrAccountRecord(CrAccountRecordReqDto addReqDto) {
        CrAccountRecordEo crAccountRecordEo = new CrAccountRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)crAccountRecordEo);
        this.crAccountRecordDas.insert((BaseEo)crAccountRecordEo);
        return crAccountRecordEo.getId();
    }

    @Override
    public void modifyCrAccountRecord(CrAccountRecordReqDto modifyReqDto) {
        CrAccountRecordEo crAccountRecordEo = new CrAccountRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)crAccountRecordEo);
        this.crAccountRecordDas.updateSelective((BaseEo)crAccountRecordEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCrAccountRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.crAccountRecordDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CrAccountRecordRespDto queryById(Long id) {
        CrAccountRecordRespDto crAccountRecordRespDto = new CrAccountRecordRespDto();
        CrAccountRecordEo crAccountRecordEo = (CrAccountRecordEo)this.crAccountRecordDas.selectByPrimaryKey(id);
        DtoHelper.eo2Dto((BaseEo)crAccountRecordEo, (BaseVo)crAccountRecordRespDto);
        return crAccountRecordRespDto;
    }

    @Override
    public PageInfo<CrAccountRecordRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CrAccountRecordReqDto crAccountRecordReqDto = (CrAccountRecordReqDto)JSON.parseObject((String)filter, CrAccountRecordReqDto.class);
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        if (ObjectUtil.isNotEmpty((Object)orgId)) {
            crAccountRecordReqDto.setOrgInfoId(orgId);
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo dtoPageInfo = PageInfo.of((List)this.crAccountRecordDas.queryAccountRecordByPage(crAccountRecordReqDto));
        Integer accountDate = this.accountConfigService.query().getAccountDate();
        CrAccountBillEo accountBillEo = new CrAccountBillEo();
        accountBillEo.setBillNo(crAccountRecordReqDto.getBillNo());
        CrAccountBillEo billEo = (CrAccountBillEo)this.accountBillDas.selectOne((BaseEo)accountBillEo);
        CrAccountCustomerConfigReqDto reqDto = new CrAccountCustomerConfigReqDto();
        reqDto.setCustomerCode(billEo.getCustomerCode());
        CrAccountCustomerConfigRespDto dto = this.accountCustomerConfigDas.queryAccountByCustomerCode(reqDto);
        dtoPageInfo.getList().stream().forEach(e -> {
            e.setAccountDate("\u53d1\u8d27\u65e5+" + accountDate);
            e.setModelName(dto.getModelName());
            e.setModelType(dto.getModelType());
            e.setModelRule(dto.getModelRule() + "\u5929");
        });
        return dtoPageInfo;
    }
}

