/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.dao.credit.das;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditApplyPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditApplyStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.QuotaTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.DateTimeUtils;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.mapper.CreditApplyMapper;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditApplyEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class CreditApplyDas
extends AbstractBaseDas<CreditApplyEo, String> {
    @Resource
    private CreditApplyMapper creditApplyMapper;

    public PageInfo<CreditApplyPageRespDto> pageCreditApply(CreditApplySearchReqDto pageRequest) {
        List<CreditApplyPageRespDto> creditApplyPageRespDtoList;
        if (pageRequest.getPageNum() != null && pageRequest.getPageSize() != null) {
            PageHelper.startPage((int)pageRequest.getPageNum(), (int)pageRequest.getPageSize());
        }
        if (!CollectionUtils.isEmpty(creditApplyPageRespDtoList = this.creditApplyMapper.pageCreditApply(pageRequest))) {
            for (CreditApplyPageRespDto creditApplyPageRespDto : creditApplyPageRespDtoList) {
                creditApplyPageRespDto.setApplyTimeString(DateTimeUtils.convertDateTimeToString((Date)creditApplyPageRespDto.getApplyTime()));
                creditApplyPageRespDto.setCreditApplyStatusName(CreditApplyStatusEnum.toName((Integer)creditApplyPageRespDto.getCreditApplyStatus()));
                creditApplyPageRespDto.setQuotaTypeName(QuotaTypeEnum.toName((Integer)creditApplyPageRespDto.getQuotaType()));
            }
        }
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)new PageInfo(creditApplyPageRespDtoList), (String[])new String[]{"list", "navigatepageNums"});
        result.setList(creditApplyPageRespDtoList);
        return result;
    }

    public List<CreditApplyPageRespDto> findCreditApply(CreditApplySearchReqDto pageRequest) {
        return this.creditApplyMapper.findCreditApply(pageRequest);
    }

    public CreditApplyEo findByApplyId(Long applyId) {
        if (applyId == null) {
            return new CreditApplyEo();
        }
        CreditApplyEo selectItem = new CreditApplyEo();
        selectItem.setId(applyId);
        selectItem.setDr(0);
        return (CreditApplyEo)this.selectOne((BaseEo)selectItem);
    }
}

