/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.cube.center.source.api.dto.request.ClueSuitAttributeReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueSuitAttributeRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IClueSuitAttributeService;
import com.dtyunxi.cube.center.source.dao.das.ClueSuitAttributeDas;
import com.dtyunxi.cube.center.source.dao.eo.ClueSuitAttributeEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueSuitAttributeServiceImpl
implements IClueSuitAttributeService {
    @Resource
    private ClueSuitAttributeDas clueSuitAttributeDas;

    @Override
    public Long addClueSuitAttribute(ClueSuitAttributeReqDto addReqDto) {
        ClueSuitAttributeEo clueSuitAttributeEo = new ClueSuitAttributeEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)clueSuitAttributeEo);
        this.clueSuitAttributeDas.insert((BaseEo)clueSuitAttributeEo);
        return clueSuitAttributeEo.getId();
    }

    @Override
    public int addClueSuitAttributeList(List<? extends ClueSuitAttributeReqDto> addReqDtoList) {
        ArrayList clueSuitAttributeEoList = new ArrayList();
        DtoHelper.dtoList2EoList(addReqDtoList, clueSuitAttributeEoList, ClueSuitAttributeEo.class);
        return this.clueSuitAttributeDas.insertBatch(clueSuitAttributeEoList);
    }

    @Override
    public void modifyClueSuitAttribute(ClueSuitAttributeReqDto modifyReqDto) {
        ClueSuitAttributeEo clueSuitAttributeEo = new ClueSuitAttributeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)clueSuitAttributeEo);
        this.clueSuitAttributeDas.updateSelective((BaseEo)clueSuitAttributeEo);
    }

    @Override
    public void modifyClueSuitAttributeBySelect(ClueSuitAttributeEo updateEo, ClueSuitAttributeEo selectEo) {
        UpdateWrapper updateWrapper = new UpdateWrapper((Object)selectEo);
        if (updateWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.clueSuitAttributeDas.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeClueSuitAttribute(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.clueSuitAttributeDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ClueSuitAttributeRespDto queryById(Long id) {
        ClueSuitAttributeEo clueSuitAttributeEo = (ClueSuitAttributeEo)this.clueSuitAttributeDas.selectByPrimaryKey(id);
        if (clueSuitAttributeEo == null) {
            return null;
        }
        ClueSuitAttributeRespDto clueSuitAttributeRespDto = new ClueSuitAttributeRespDto();
        DtoHelper.eo2Dto((BaseEo)clueSuitAttributeEo, (BaseVo)clueSuitAttributeRespDto);
        return clueSuitAttributeRespDto;
    }

    @Override
    public List<ClueSuitAttributeRespDto> queryListByClueId(Long clueId) {
        SourceAssert.notNull((Object)clueId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id"});
        return null;
    }

    @Override
    public PageInfo<ClueSuitAttributeRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ClueSuitAttributeReqDto clueSuitAttributeReqDto = (ClueSuitAttributeReqDto)JSON.parseObject((String)filter, ClueSuitAttributeReqDto.class);
        ClueSuitAttributeEo clueSuitAttributeEo = new ClueSuitAttributeEo();
        DtoHelper.dto2Eo((BaseVo)clueSuitAttributeReqDto, (BaseEo)clueSuitAttributeEo);
        PageInfo eoPageInfo = this.clueSuitAttributeDas.selectPage((BaseEo)clueSuitAttributeEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ClueSuitAttributeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ClueSuitAttributeRespDto> queryListByMatchSuitCodeList(Set<String> matchSuitCodeList) {
        SourceAssert.notEmpty(matchSuitCodeList, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u9002\u7528\u5339\u914d\u7f16\u7801\u96c6\u5408"});
        ClueSuitAttributeEo clueSuitAttributeEo = new ClueSuitAttributeEo();
        clueSuitAttributeEo.setDr(0);
        QueryWrapper clueSuitAttributeEoQueryWrapper = new QueryWrapper((Object)clueSuitAttributeEo);
        clueSuitAttributeEoQueryWrapper.in((Object)"sg_suit_match_code", matchSuitCodeList);
        clueSuitAttributeEoQueryWrapper.groupBy((Object[])new String[]{"sg_suit_match_code", "sg_clue_id"});
        List clueSuitAttributeEoList = this.clueSuitAttributeDas.getMapper().selectList((Wrapper)clueSuitAttributeEoQueryWrapper);
        ArrayList<ClueSuitAttributeRespDto> clueSuitAttributeRespDtoList = new ArrayList<ClueSuitAttributeRespDto>();
        DtoHelper.eoList2DtoList((Collection)clueSuitAttributeEoList, clueSuitAttributeRespDtoList, ClueSuitAttributeRespDto.class);
        return clueSuitAttributeRespDtoList;
    }
}

