/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.dto.request.OrderItemResultReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemResultRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IOrderItemResultService;
import com.dtyunxi.cube.center.source.dao.das.OrderItemResultDas;
import com.dtyunxi.cube.center.source.dao.eo.OrderItemResultEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderItemResultServiceImpl
implements IOrderItemResultService {
    @Resource
    private OrderItemResultDas orderItemResultDas;

    @Override
    public Long addOrderItemResult(OrderItemResultReqDto addReqDto) {
        OrderItemResultEo orderItemResultEo = new OrderItemResultEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderItemResultEo);
        this.orderItemResultDas.insert((BaseEo)orderItemResultEo);
        return orderItemResultEo.getId();
    }

    @Override
    public int addOrderItemResultList(List<? extends OrderItemResultReqDto> addReqDtoList) {
        ArrayList orderItemResultEoArrayList = new ArrayList();
        DtoHelper.dtoList2EoList(addReqDtoList, orderItemResultEoArrayList, OrderItemResultEo.class);
        return this.orderItemResultDas.insertBatch(orderItemResultEoArrayList);
    }

    @Override
    public int addOrderItemResultRespList(List<? extends OrderItemResultRespDto> addRespDtoList) {
        ArrayList orderItemResultEoArrayList = new ArrayList();
        DtoHelper.dtoList2EoList(addRespDtoList, orderItemResultEoArrayList, OrderItemResultEo.class);
        return this.orderItemResultDas.insertBatch(orderItemResultEoArrayList);
    }

    @Override
    public void modifyOrderItemResult(OrderItemResultReqDto modifyReqDto) {
        OrderItemResultEo orderItemResultEo = new OrderItemResultEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderItemResultEo);
        this.orderItemResultDas.updateSelective((BaseEo)orderItemResultEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderItemResult(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderItemResultDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OrderItemResultRespDto queryById(Long id) {
        OrderItemResultEo orderItemResultEo = (OrderItemResultEo)this.orderItemResultDas.selectByPrimaryKey(id);
        if (orderItemResultEo == null) {
            return null;
        }
        OrderItemResultRespDto orderItemResultRespDto = new OrderItemResultRespDto();
        DtoHelper.eo2Dto((BaseEo)orderItemResultEo, (BaseVo)orderItemResultRespDto);
        return orderItemResultRespDto;
    }

    @Override
    public List<OrderItemResultRespDto> queryByOrderId(Long orderId) {
        SourceAssert.notNull((Object)orderId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u5355id"});
        OrderItemResultEo queryEo = new OrderItemResultEo();
        queryEo.setSgOrderId(orderId);
        List orderItemResultEoList = this.orderItemResultDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)orderItemResultEoList)) {
            ArrayList<OrderItemResultRespDto> orderItemResultRespDtoList = new ArrayList<OrderItemResultRespDto>();
            CubeBeanUtils.copyCollection(orderItemResultRespDtoList, (Collection)orderItemResultEoList, OrderItemResultRespDto.class);
            return orderItemResultRespDtoList;
        }
        return null;
    }

    @Override
    public PageInfo<OrderItemResultRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderItemResultReqDto orderItemResultReqDto = (OrderItemResultReqDto)JSON.parseObject((String)filter, OrderItemResultReqDto.class);
        OrderItemResultEo orderItemResultEo = new OrderItemResultEo();
        DtoHelper.dto2Eo((BaseVo)orderItemResultReqDto, (BaseEo)orderItemResultEo);
        PageInfo eoPageInfo = this.orderItemResultDas.selectPage((BaseEo)orderItemResultEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderItemResultRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

