/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.ClueSuitSelectTypeEnum;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueModifyActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueSuitModifyReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueSuitReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.DistributionClueRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IDistributionClueOptService;
import com.dtyunxi.cube.center.source.biz.service.IDistributionClueService;
import com.dtyunxi.cube.center.source.biz.service.IDistributionClueSuitService;
import com.dtyunxi.cube.center.source.biz.utils.NoGenerateUtil;
import com.dtyunxi.cube.center.source.dao.eo.DistributionClueSuitEo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DistributionClueOptServiceImpl
implements IDistributionClueOptService {
    private static final Logger logger = LoggerFactory.getLogger(DistributionClueOptServiceImpl.class);
    @Resource
    private IDistributionClueService distributionClueService;
    @Resource
    private IDistributionClueSuitService distributionClueSuitService;
    @Resource
    private NoGenerateUtil noGenerateUtil;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addDistributionClueOpt(DistributionClueActReqDto addReqDto) {
        logger.info("\u3010addDistributionClueOpt\u3011\u5165\u53c2={}", (Object)JSON.toJSONString((Object)addReqDto));
        this.checkAddClueOptParam(addReqDto);
        addReqDto.setClueCode(this.noGenerateUtil.generateNo("PHR", 3));
        Long clueId = this.distributionClueService.addDistributionClue((DistributionClueReqDto)addReqDto);
        ArrayList<DistributionClueSuitReqDto> distributionClueSuitReqList = new ArrayList<DistributionClueSuitReqDto>();
        this.addAttribute(distributionClueSuitReqList, addReqDto.getSuitCustomerList());
        this.addAttribute(distributionClueSuitReqList, addReqDto.getSuitOrderTypeList());
        this.addAttribute(distributionClueSuitReqList, addReqDto.getSuitOrganizationList());
        distributionClueSuitReqList.forEach(dto -> {
            dto.setSgClueId(clueId);
            if (dto.getSgSuitSelectType().equals(ClueSuitSelectTypeEnum.ALL.getCode())) {
                dto.setSgSuitKey(ClueSuitSelectTypeEnum.ALL.getCode());
            }
            dto.setSgSuitMatchCode(dto.getSgSuitSelectType() + "_" + dto.getSgSuitType() + "_" + dto.getSgSuitKey());
        });
        this.distributionClueSuitService.addDistributionClueSuitList(distributionClueSuitReqList);
        return new RestResponse((Object)clueId);
    }

    private void checkAddClueOptParam(DistributionClueActReqDto clueActReqDto) {
        SourceAssert.notNull((Object)clueActReqDto.getClueName(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565\u540d\u79f0"});
        SourceAssert.notNull((Object)clueActReqDto.getCluePriorityLevel(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565\u4f18\u5148\u7ea7"});
    }

    @Override
    public RestResponse<Long> copyDistributionClueOpt(Long id) {
        SourceAssert.notNull((Object)id, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id"});
        DistributionClueRespDto clueRespDto = this.distributionClueService.queryById(id);
        DistributionClueReqDto clueReqDto = new DistributionClueReqDto();
        CubeBeanUtils.copyProperties((Object)clueReqDto, (Object)clueRespDto, (String[])new String[0]);
        return new RestResponse((Object)this.distributionClueService.addDistributionClue(clueReqDto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> modifyDistributionClueOpt(DistributionClueModifyActReqDto modifyActReqDto) {
        logger.info("\u3010modifyDistributionClueOpt\u3011\u5165\u53c2={}", (Object)JSON.toJSONString((Object)modifyActReqDto));
        this.checkModifyClueOptParam(modifyActReqDto);
        this.distributionClueService.modifyDistributionClue((DistributionClueReqDto)modifyActReqDto);
        ArrayList addDto = Lists.newArrayList();
        this.addAttribute((List<DistributionClueSuitReqDto>)addDto, modifyActReqDto.getSuitCustomerList());
        this.addAttribute((List<DistributionClueSuitReqDto>)addDto, modifyActReqDto.getSuitOrderTypeList());
        this.addAttribute((List<DistributionClueSuitReqDto>)addDto, modifyActReqDto.getSuitOrganizationList());
        DistributionClueSuitEo updateClueSuitAttributeEo = new DistributionClueSuitEo();
        updateClueSuitAttributeEo.setDr(1);
        DistributionClueSuitEo selectClueSuitAttributeEo = new DistributionClueSuitEo();
        selectClueSuitAttributeEo.setDr(0);
        selectClueSuitAttributeEo.setSgClueId(modifyActReqDto.getId());
        this.distributionClueSuitService.modifyDistributionClueSuitBySelect(updateClueSuitAttributeEo, selectClueSuitAttributeEo);
        addDto.forEach(dto -> {
            dto.setId(null);
            dto.setSgClueId(modifyActReqDto.getId());
            if (dto.getSgSuitSelectType().equals(ClueSuitSelectTypeEnum.ALL.getCode())) {
                dto.setSgSuitKey(ClueSuitSelectTypeEnum.ALL.getCode());
            }
            dto.setSgSuitMatchCode(dto.getSgSuitSelectType() + "_" + dto.getSgSuitType() + "_" + dto.getSgSuitKey());
        });
        this.distributionClueSuitService.addDistributionClueSuitList(addDto);
        return new RestResponse();
    }

    private void checkModifyClueOptParam(DistributionClueModifyActReqDto distributionClueModifyActReqDto) {
        SourceAssert.notNull((Object)distributionClueModifyActReqDto.getId(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id"});
    }

    @Override
    public RestResponse<Void> deleteDistributionClueOpt(List<Long> clueIdList) {
        SourceAssert.notEmpty(clueIdList, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id\u96c6\u5408"});
        this.distributionClueService.removeDistributionClue(String.join((CharSequence)",", (CharSequence[])clueIdList.stream().map(String::valueOf).toArray(String[]::new)), null);
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> openEnable(Long clueId, String enable) {
        SourceAssert.notNull((Object)clueId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id"});
        SourceAssert.notBlank((String)enable, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u542f\u7528/\u7981\u7528\u6807\u8bc6"});
        DistributionClueReqDto clueReqDto = new DistributionClueReqDto();
        clueReqDto.setId(clueId);
        clueReqDto.setClueEnableStatus(enable);
        this.distributionClueService.modifyDistributionClue(clueReqDto);
        return new RestResponse();
    }

    private void addAttribute(List<DistributionClueSuitReqDto> distributionClueSuitReqList, DistributionClueSuitModifyReqDto distributionClueSuitModifyReqDto) {
        if (Objects.nonNull(distributionClueSuitModifyReqDto)) {
            this.addAttribute(distributionClueSuitReqList, distributionClueSuitModifyReqDto.getAdd());
        }
    }

    private void addAttribute(List<DistributionClueSuitReqDto> distributionClueSuitReqDtos, List<DistributionClueSuitReqDto> addDistributionClueSuitReqDtos) {
        if (CollectionUtils.isNotEmpty(addDistributionClueSuitReqDtos)) {
            distributionClueSuitReqDtos.addAll(addDistributionClueSuitReqDtos);
        }
    }
}

