/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.dto.request.OrderAddrReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderAddrRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IOrderAddrService;
import com.dtyunxi.cube.center.source.dao.das.OrderAddrDas;
import com.dtyunxi.cube.center.source.dao.eo.OrderAddrEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderAddrServiceImpl
implements IOrderAddrService {
    @Resource
    private OrderAddrDas orderAddrDas;

    @Override
    public Long addOrderAddr(OrderAddrReqDto addReqDto) {
        OrderAddrEo orderAddrEo = new OrderAddrEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderAddrEo);
        this.orderAddrDas.insert((BaseEo)orderAddrEo);
        return orderAddrEo.getId();
    }

    @Override
    public void modifyOrderAddr(OrderAddrReqDto modifyReqDto) {
        OrderAddrEo orderAddrEo = new OrderAddrEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderAddrEo);
        this.orderAddrDas.updateSelective((BaseEo)orderAddrEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderAddr(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderAddrDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OrderAddrRespDto queryById(Long id) {
        OrderAddrEo orderAddrEo = (OrderAddrEo)this.orderAddrDas.selectByPrimaryKey(id);
        if (orderAddrEo == null) {
            return null;
        }
        OrderAddrRespDto orderAddrRespDto = new OrderAddrRespDto();
        DtoHelper.eo2Dto((BaseEo)orderAddrEo, (BaseVo)orderAddrRespDto);
        return orderAddrRespDto;
    }

    @Override
    public OrderAddrRespDto queryByOrderId(Long orderId) {
        SourceAssert.notNull((Object)orderId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u5355id"});
        OrderAddrEo queryEo = new OrderAddrEo();
        queryEo.setSgOrderId(orderId);
        OrderAddrEo orderAddrEo = (OrderAddrEo)this.orderAddrDas.selectOne((BaseEo)queryEo);
        if (Objects.nonNull(orderAddrEo)) {
            OrderAddrRespDto orderAddrRespDto = new OrderAddrRespDto();
            CubeBeanUtils.copyProperties((Object)orderAddrRespDto, (Object)orderAddrEo, (String[])new String[0]);
            return orderAddrRespDto;
        }
        return null;
    }

    @Override
    public PageInfo<OrderAddrRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderAddrReqDto orderAddrReqDto = (OrderAddrReqDto)JSON.parseObject((String)filter, OrderAddrReqDto.class);
        OrderAddrEo orderAddrEo = new OrderAddrEo();
        DtoHelper.dto2Eo((BaseVo)orderAddrReqDto, (BaseEo)orderAddrEo);
        PageInfo eoPageInfo = this.orderAddrDas.selectPage((BaseEo)orderAddrEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderAddrRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

