/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.constant.ClueSuitTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.EnableEnum;
import com.dtyunxi.cube.center.source.api.dto.request.ClueReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueSuitAttributeReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupRuleDeliveryReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupRuleReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueDeliveryWarehouseBlackRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueSuitAttributeRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupRuleDeliveryRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupRuleRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseItemBlackListRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IClueDeliveryWarehouseBlackService;
import com.dtyunxi.cube.center.source.biz.service.IClueService;
import com.dtyunxi.cube.center.source.biz.service.IClueSuitAttributeService;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseGroupRuleDeliveryService;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseGroupRuleService;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseGroupService;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseItemBlackListService;
import com.dtyunxi.cube.center.source.dao.das.ClueDas;
import com.dtyunxi.cube.center.source.dao.eo.ClueEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueServiceImpl
implements IClueService {
    @Resource
    private ClueDas clueDas;
    @Resource
    private IClueSuitAttributeService clueSuitAttributeService;
    @Resource
    private IClueWarehouseGroupService clueWarehouseGroupService;
    @Resource
    private IClueWarehouseGroupRuleService clueWarehouseGroupRuleService;
    @Resource
    private IClueWarehouseGroupRuleDeliveryService clueWarehouseGroupRuleDeliveryService;
    @Resource
    private IClueDeliveryWarehouseBlackService clueDeliveryWarehouseBlackService;
    @Resource
    private IClueWarehouseItemBlackListService clueWarehouseItemBlackListService;

    @Override
    public Long addClue(ClueReqDto addReqDto) {
        ClueEo clueEo = new ClueEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)clueEo);
        this.clueDas.insert((BaseEo)clueEo);
        return clueEo.getId();
    }

    @Override
    public void modifyClue(ClueReqDto modifyReqDto) {
        ClueEo clueEo = new ClueEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)clueEo);
        this.clueDas.updateSelective((BaseEo)clueEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeClue(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.clueDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ClueRespDto queryById(Long id) {
        ClueEo clueEo = (ClueEo)this.clueDas.selectByPrimaryKey(id);
        if (clueEo == null) {
            return null;
        }
        ClueRespDto clueRespDto = new ClueRespDto();
        DtoHelper.eo2Dto((BaseEo)clueEo, (BaseVo)clueRespDto);
        return clueRespDto;
    }

    @Override
    public PageInfo<ClueRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ClueReqDto clueReqDto = (ClueReqDto)JSON.parseObject((String)filter, ClueReqDto.class);
        ClueEo clueEo = new ClueEo();
        DtoHelper.dto2Eo((BaseVo)clueReqDto, (BaseEo)clueEo);
        PageInfo eoPageInfo = this.clueDas.selectPage((BaseEo)clueEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ClueRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public ClueActRespDto queryClueDetailById(Long id) {
        SourceAssert.notNull((Object)id, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id"});
        ClueActRespDto clueActRespDto = new ClueActRespDto();
        ClueRespDto clueRespDto = this.queryById(id);
        CubeBeanUtils.copyProperties((Object)clueActRespDto, (Object)clueRespDto, (String[])new String[0]);
        ClueSuitAttributeReqDto clueSuitAttributeReqDto = new ClueSuitAttributeReqDto();
        clueSuitAttributeReqDto.setSgClueId(id);
        PageInfo<ClueSuitAttributeRespDto> clueSuitAttributeRespDtoPageInfo = this.clueSuitAttributeService.queryByPage(JSON.toJSONString((Object)clueSuitAttributeReqDto), 1, 10000);
        Map<String, List<ClueSuitAttributeRespDto>> clueSuitAttributeMap = clueSuitAttributeRespDtoPageInfo.getList().stream().collect(Collectors.groupingBy(ClueSuitAttributeRespDto::getSgSuitType));
        clueActRespDto.setSuitChannelList(clueSuitAttributeMap.get(ClueSuitTypeEnum.HIT_CHANNEL.getCode()));
        clueActRespDto.setSuitCustomerList(clueSuitAttributeMap.get(ClueSuitTypeEnum.HIT_CUSTOMER.getCode()));
        clueActRespDto.setSuitOrderTypeList(clueSuitAttributeMap.get(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode()));
        clueActRespDto.setSuitWarehouseList(clueSuitAttributeMap.get(ClueSuitTypeEnum.HIT_WAREHOUSE.getCode()));
        clueActRespDto.setSuitOrganizationList(clueSuitAttributeMap.get(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode()));
        clueActRespDto.setSuitChannelWarehouseList(clueSuitAttributeMap.get(ClueSuitTypeEnum.HIT_CHANNEL_WAREHOUSE.getCode()));
        clueActRespDto.setSuitVirtualWarehouseList(clueSuitAttributeMap.get(ClueSuitTypeEnum.HIT_VIRTUAL_WAREHOUSE.getCode()));
        ClueWarehouseGroupReqDto queryClueWarehouseGroupReqDto = new ClueWarehouseGroupReqDto();
        queryClueWarehouseGroupReqDto.setSgClueId(id);
        PageInfo<ClueWarehouseGroupRespDto> clueRespDtoPageInfo = this.clueWarehouseGroupService.queryByPage(JSON.toJSONString((Object)queryClueWarehouseGroupReqDto), 1, 1000);
        ClueWarehouseGroupRuleReqDto clueWarehouseGroupRuleReqDto = new ClueWarehouseGroupRuleReqDto();
        clueWarehouseGroupRuleReqDto.setSgClueId(id);
        PageInfo<ClueWarehouseGroupRuleRespDto> clueWarehouseGroupRuleRespDtoPageInfo = this.clueWarehouseGroupRuleService.queryByPage(JSON.toJSONString((Object)clueWarehouseGroupRuleReqDto), 1, 1000);
        ClueWarehouseGroupRuleDeliveryReqDto clueWarehouseGroupRuleDeliveryReqDto = new ClueWarehouseGroupRuleDeliveryReqDto();
        clueWarehouseGroupRuleDeliveryReqDto.setSgClueId(id);
        PageInfo<ClueWarehouseGroupRuleDeliveryRespDto> clueWarehouseGroupRuleDeliveryRespDtoPageInfo = this.clueWarehouseGroupRuleDeliveryService.queryByPage(JSON.toJSONString((Object)clueWarehouseGroupRuleDeliveryReqDto), 1, 1000);
        Map<Long, List<ClueWarehouseGroupRuleDeliveryRespDto>> clueGroupRuleDeliveryMap = Optional.ofNullable(clueWarehouseGroupRuleDeliveryRespDtoPageInfo.getList()).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(ClueWarehouseGroupRuleDeliveryRespDto::getWarehouseGroupRuleId));
        clueWarehouseGroupRuleRespDtoPageInfo.getList().forEach(clueGroupRuleRespDto -> clueGroupRuleRespDto.setClueWarehouseGroupRuleDeliveryRespDtos((List)clueGroupRuleDeliveryMap.get(clueGroupRuleRespDto.getId())));
        Map<Long, List<ClueWarehouseGroupRuleRespDto>> clueGroupRuleMap = clueWarehouseGroupRuleRespDtoPageInfo.getList().stream().collect(Collectors.groupingBy(ClueWarehouseGroupRuleRespDto::getWarehouseGroupId));
        ArrayList clueWarehouseGroupActRespDto = new ArrayList();
        CubeBeanUtils.copyCollection(clueWarehouseGroupActRespDto, (Collection)clueRespDtoPageInfo.getList(), ClueWarehouseGroupActRespDto.class);
        clueWarehouseGroupActRespDto.forEach(clueGroupActRespDto -> clueGroupActRespDto.setClueWarehouseGroupRuleRespDtoList((List)clueGroupRuleMap.get(clueGroupActRespDto.getId())));
        clueActRespDto.setClueWarehouseGroupActRespDtoList(clueWarehouseGroupActRespDto);
        List<ClueDeliveryWarehouseBlackRespDto> blackRespDtos = this.clueDeliveryWarehouseBlackService.queryByClueId(id);
        clueActRespDto.setClueDeliveryWarehouseBlackRespDto(blackRespDtos);
        HashSet<Long> idSet = new HashSet<Long>();
        idSet.add(id);
        List<ClueWarehouseItemBlackListRespDto> clueWarehouseItemBlackListRespDtos = this.clueWarehouseItemBlackListService.queryByClueIdList(idSet);
        clueActRespDto.setClueItemBlacklist(clueWarehouseItemBlackListRespDtos);
        return clueActRespDto;
    }

    @Override
    public List<ClueActRespDto> queryOrderByClueIdList(Set<Long> clueList) {
        SourceAssert.notEmpty(clueList, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id\u96c6\u5408"});
        String now = DateUtil.getDateToString((Date)new Date());
        List clueEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.clueDas.filter().in((Object)"id", clueList)).eq((Object)"clue_enable_status", (Object)EnableEnum.ENABLE.getCode())).le((Object)"clue_enable_start_time", (Object)now)).ge((Object)"clue_enable_end_time", (Object)now)).orderByAsc((Object)"clue_priority_level")).orderByDesc((Object)"update_time")).list(Integer.valueOf(1000));
        if (CollectionUtils.isEmpty((Collection)clueEoList)) {
            return null;
        }
        Set<Long> afterClueIds = clueEoList.stream().map(BaseEo::getId).collect(Collectors.toSet());
        List<ClueWarehouseGroupRespDto> clueWarehouseGroupRespDtoList = this.clueWarehouseGroupService.queryByClueIdList(afterClueIds);
        SourceAssert.notEmpty(clueWarehouseGroupRespDtoList, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u7b56\u7565\u4ed3\u5e93\u5206\u7ec4\u5217\u8868", ""});
        List<ClueWarehouseGroupRuleRespDto> clueWarehouseGroupRuleRespDtoList = this.clueWarehouseGroupRuleService.queryByClueIdList(afterClueIds);
        SourceAssert.notEmpty(clueWarehouseGroupRuleRespDtoList, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u7b56\u7565\u4ed3\u5e93\u5206\u7ec4\u5b50\u89c4\u5219\u5217\u8868", ""});
        List<ClueWarehouseGroupRuleDeliveryRespDto> clueWarehouseGroupRuleDeliveryRespDtoList = this.clueWarehouseGroupRuleDeliveryService.queryByClueIdList(afterClueIds);
        Map<Long, List<ClueWarehouseGroupRuleDeliveryRespDto>> clueWarehouseGroupRuleDeliveryRespDtoMap = Optional.ofNullable(clueWarehouseGroupRuleDeliveryRespDtoList).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(ClueWarehouseGroupRuleDeliveryRespDto::getWarehouseGroupRuleId));
        ArrayList<ClueActRespDto> clueActRespDtoList = new ArrayList<ClueActRespDto>();
        Map<Long, ClueActRespDto> clueActRespDtoMap = clueEoList.stream().map(eo -> {
            ClueActRespDto clueActRespDto = new ClueActRespDto();
            CubeBeanUtils.copyProperties((Object)clueActRespDto, (Object)eo, (String[])new String[0]);
            clueActRespDtoList.add(clueActRespDto);
            return clueActRespDto;
        }).collect(Collectors.toMap(ClueRespDto::getId, v1 -> v1));
        HashMap groupActRespDtoMap = new HashMap();
        clueWarehouseGroupRespDtoList.sort(Comparator.comparingInt(ClueWarehouseGroupRespDto::getWarehouseGroupPriorityLevel));
        clueWarehouseGroupRespDtoList.forEach(dto -> {
            ClueActRespDto clueActRespDto = (ClueActRespDto)clueActRespDtoMap.get(dto.getSgClueId());
            SourceAssert.notNull((Object)clueActRespDto, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u5bf9\u5e94\u7b56\u7565\u4fe1\u606f", dto.getSgClueId().toString()});
            List clueWarehouseGroupActRespDtoList = Optional.ofNullable(clueActRespDto.getClueWarehouseGroupActRespDtoList()).orElse(new ArrayList());
            if (clueActRespDto.getClueWarehouseGroupActRespDtoList() == null) {
                clueActRespDto.setClueWarehouseGroupActRespDtoList(clueWarehouseGroupActRespDtoList);
            }
            ClueWarehouseGroupActRespDto warehouseGroupActRespDto = new ClueWarehouseGroupActRespDto();
            CubeBeanUtils.copyProperties((Object)warehouseGroupActRespDto, (Object)dto, (String[])new String[0]);
            clueWarehouseGroupActRespDtoList.add(warehouseGroupActRespDto);
            groupActRespDtoMap.put(warehouseGroupActRespDto.getId(), warehouseGroupActRespDto);
        });
        clueWarehouseGroupRuleRespDtoList.forEach(dto -> {
            ClueWarehouseGroupActRespDto warehouseGroupActRespDto = (ClueWarehouseGroupActRespDto)groupActRespDtoMap.get(dto.getWarehouseGroupId());
            SourceAssert.notNull((Object)warehouseGroupActRespDto, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u5bf9\u5e94\u7b56\u7565\u4ed3\u5e93\u5206\u7ec4\u4fe1\u606f", ""});
            List ruleRespDtoList = Optional.ofNullable(warehouseGroupActRespDto.getClueWarehouseGroupRuleRespDtoList()).orElse(new ArrayList());
            if (warehouseGroupActRespDto.getClueWarehouseGroupRuleRespDtoList() == null) {
                warehouseGroupActRespDto.setClueWarehouseGroupRuleRespDtoList(ruleRespDtoList);
            }
            dto.setClueWarehouseGroupRuleDeliveryRespDtos((List)Optional.ofNullable(clueWarehouseGroupRuleDeliveryRespDtoMap.get(dto.getId())).orElse(null));
            ruleRespDtoList.add(dto);
        });
        return clueActRespDtoList;
    }

    @Override
    public List<ClueActRespDto> queryOrderByClueIdList(Set<Long> clueList, String clueType) {
        SourceAssert.notEmpty(clueList, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id\u96c6\u5408"});
        String now = DateUtil.getDateToString((Date)new Date());
        List clueEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.clueDas.filter().in((Object)"id", clueList)).eq((Object)"clue_enable_status", (Object)EnableEnum.ENABLE.getCode())).eq((Object)"clue_type", (Object)clueType)).le((Object)"clue_enable_start_time", (Object)now)).ge((Object)"clue_enable_end_time", (Object)now)).orderByAsc((Object)"clue_priority_level")).orderByDesc((Object)"update_time")).list(Integer.valueOf(1000));
        if (CollectionUtils.isEmpty((Collection)clueEoList)) {
            return null;
        }
        Set<Long> afterClueIds = clueEoList.stream().map(BaseEo::getId).collect(Collectors.toSet());
        List<ClueWarehouseGroupRespDto> clueWarehouseGroupRespDtoList = this.clueWarehouseGroupService.queryByClueIdList(afterClueIds);
        SourceAssert.notEmpty(clueWarehouseGroupRespDtoList, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u7b56\u7565\u4ed3\u5e93\u5206\u7ec4\u5217\u8868", ""});
        List<ClueWarehouseGroupRuleRespDto> clueWarehouseGroupRuleRespDtoList = this.clueWarehouseGroupRuleService.queryByClueIdList(afterClueIds);
        SourceAssert.notEmpty(clueWarehouseGroupRuleRespDtoList, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u7b56\u7565\u4ed3\u5e93\u5206\u7ec4\u5b50\u89c4\u5219\u5217\u8868", ""});
        List<ClueWarehouseGroupRuleDeliveryRespDto> clueWarehouseGroupRuleDeliveryRespDtoList = this.clueWarehouseGroupRuleDeliveryService.queryByClueIdList(afterClueIds);
        Map<Long, List<ClueWarehouseGroupRuleDeliveryRespDto>> clueWarehouseGroupRuleDeliveryRespDtoMap = Optional.ofNullable(clueWarehouseGroupRuleDeliveryRespDtoList).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(ClueWarehouseGroupRuleDeliveryRespDto::getWarehouseGroupRuleId));
        ArrayList<ClueActRespDto> clueActRespDtoList = new ArrayList<ClueActRespDto>();
        Map<Long, ClueActRespDto> clueActRespDtoMap = clueEoList.stream().map(eo -> {
            ClueActRespDto clueActRespDto = new ClueActRespDto();
            CubeBeanUtils.copyProperties((Object)clueActRespDto, (Object)eo, (String[])new String[0]);
            clueActRespDtoList.add(clueActRespDto);
            return clueActRespDto;
        }).collect(Collectors.toMap(ClueRespDto::getId, v1 -> v1));
        HashMap groupActRespDtoMap = new HashMap();
        clueWarehouseGroupRespDtoList.sort(Comparator.comparingInt(ClueWarehouseGroupRespDto::getWarehouseGroupPriorityLevel));
        clueWarehouseGroupRespDtoList.forEach(dto -> {
            ClueActRespDto clueActRespDto = (ClueActRespDto)clueActRespDtoMap.get(dto.getSgClueId());
            SourceAssert.notNull((Object)clueActRespDto, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u5bf9\u5e94\u7b56\u7565\u4fe1\u606f", dto.getSgClueId().toString()});
            List clueWarehouseGroupActRespDtoList = Optional.ofNullable(clueActRespDto.getClueWarehouseGroupActRespDtoList()).orElse(new ArrayList());
            if (clueActRespDto.getClueWarehouseGroupActRespDtoList() == null) {
                clueActRespDto.setClueWarehouseGroupActRespDtoList(clueWarehouseGroupActRespDtoList);
            }
            ClueWarehouseGroupActRespDto warehouseGroupActRespDto = new ClueWarehouseGroupActRespDto();
            CubeBeanUtils.copyProperties((Object)warehouseGroupActRespDto, (Object)dto, (String[])new String[0]);
            clueWarehouseGroupActRespDtoList.add(warehouseGroupActRespDto);
            groupActRespDtoMap.put(warehouseGroupActRespDto.getId(), warehouseGroupActRespDto);
        });
        clueWarehouseGroupRuleRespDtoList.forEach(dto -> {
            ClueWarehouseGroupActRespDto warehouseGroupActRespDto = (ClueWarehouseGroupActRespDto)groupActRespDtoMap.get(dto.getWarehouseGroupId());
            SourceAssert.notNull((Object)warehouseGroupActRespDto, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u5bf9\u5e94\u7b56\u7565\u4ed3\u5e93\u5206\u7ec4\u4fe1\u606f", ""});
            List ruleRespDtoList = Optional.ofNullable(warehouseGroupActRespDto.getClueWarehouseGroupRuleRespDtoList()).orElse(new ArrayList());
            if (warehouseGroupActRespDto.getClueWarehouseGroupRuleRespDtoList() == null) {
                warehouseGroupActRespDto.setClueWarehouseGroupRuleRespDtoList(ruleRespDtoList);
            }
            dto.setClueWarehouseGroupRuleDeliveryRespDtos((List)Optional.ofNullable(clueWarehouseGroupRuleDeliveryRespDtoMap.get(dto.getId())).orElse(null));
            ruleRespDtoList.add(dto);
        });
        return clueActRespDtoList;
    }
}

