/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.dtyunxi.cube.center.source.api.dto.response.FreightCostRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.WarehouseDeliveryThresholdRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.WarehouseProvideGoodsRangeRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IFreightCostService;
import com.dtyunxi.cube.center.source.biz.service.IWarehouseDeliveryThresholdService;
import com.dtyunxi.cube.center.source.biz.service.IWarehouseProvideGoodsRangeService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GeneralDataQuery {
    private static final Logger logger = LoggerFactory.getLogger(GeneralDataQuery.class);
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;
    @Resource
    private IFreightCostService freightCostService;
    @Resource
    private IWarehouseDeliveryThresholdService warehouseDeliveryThresholdService;
    @Resource
    private IWarehouseProvideGoodsRangeService warehouseProvideGoodsRangeService;

    public List<PcpRegionRespDto> queryPcpRegionRespDtoListByCodes(List<String> codes) {
        PcpRegionReqDto query = new PcpRegionReqDto();
        query.setCodes(codes);
        List pcpRegionRespDtoList = null;
        try {
            pcpRegionRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(query));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u533a\u57df\u4fe1\u606f"});
        }
        return pcpRegionRespDtoList;
    }

    public List<FreightCostRespDto> queryListByWarehouseCodesAndRegionCode(List<String> warehouseCodes, String provinceCode, String cityCode, String areaCode) {
        List<FreightCostRespDto> freightCostRespDtoList = null;
        try {
            freightCostRespDtoList = this.freightCostService.queryListByWarehouseCodesAndRegionCode(warehouseCodes, provinceCode, cityCode, areaCode);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u533a\u57df\u4fe1\u606f"});
        }
        return freightCostRespDtoList;
    }

    public List<WarehouseDeliveryThresholdRespDto> queryListWarehouseDeliveryThresholdByWarehouseCodes(List<String> warehouseCodes) {
        List<WarehouseDeliveryThresholdRespDto> warehouseDeliveryThresholdRespDtoList = null;
        try {
            warehouseDeliveryThresholdRespDtoList = this.warehouseDeliveryThresholdService.queryByWarehouseCodes(warehouseCodes);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u53d1\u8d27\u9608\u503c"});
        }
        return warehouseDeliveryThresholdRespDtoList;
    }

    public List<WarehouseProvideGoodsRangeRespDto> queryWarehouseProvideGoodsRangeRespDtoListByWarehouseCode(List<String> warehouseCodes, String provinceCode, String cityCode, String areaCode) {
        List<WarehouseProvideGoodsRangeRespDto> warehouseProvideGoodsRangeRespDtoList = null;
        try {
            warehouseProvideGoodsRangeRespDtoList = this.warehouseProvideGoodsRangeService.queryWarehouseProvideGoodsRangeRespDtoListByWarehouseCode(warehouseCodes, provinceCode, cityCode, areaCode);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u533a\u57df\u4fe1\u606f"});
        }
        return warehouseProvideGoodsRangeRespDtoList;
    }
}

