/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.SourceItemBlackTypeEnum;
import com.dtyunxi.cube.center.source.api.dto.response.ClueItemBlackListCityDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseItemBlackListRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderAddrRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.vo.SourceExecuteContextVo;
import com.dtyunxi.cube.center.source.biz.vo.WarehouseInventoryVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.IntransitCargoQueryDto;
import com.dtyunxi.tcbj.api.dto.request.WarehouseThresholReqDto;
import com.dtyunxi.tcbj.api.dto.response.IntransitCargoRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.WarehouseThresholdRespDto;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsWarehouseAddressQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicInventoryApi;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicInventoryTotalApi;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.api.inventory.IDgPhysicsWarehouseApi;
import com.yunxi.dg.base.center.report.api.inventory.IDgWarehouseAddressApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgWarehouseAddressDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgWarehouseAddressPageReqDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WarehouseDataQuery {
    private static final Logger logger = LoggerFactory.getLogger(WarehouseDataQuery.class);
    @Resource
    private IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Resource
    private IDgLogicInventoryApi dgLogicInventoryApi;
    @Resource
    private IDgPhysicsWarehouseApi dgPhysicsWarehouseApi;
    @Resource
    private ICsInventoryExposedQueryApi csInventoryExposedQueryApi;
    @Resource
    private ICsWarehouseAddressQueryApi csWarehouseAddressQueryApi;
    @Resource
    private IDgWarehouseAddressApi dgWarehouseAddressApi;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Autowired
    private IChannelWarehouseApi channelWarehouseQueryApi;
    @Autowired
    private IVirtualWarehouseApi virtualWarehouseQueryApi;
    @Autowired
    private IDgLogicInventoryTotalApi dgLogicInventoryTotalApi;
    @Autowired
    private IOutResultOrderQueryApi outResultOrderQueryApi;
    private static final String regex_split_str = ";|\uff1b|\uff0c|,";

    public DgLogicInventoryDto queryCsLogicWarehousePageRespDtoByWarehouseId(Long warehouseId) {
        DgLogicInventoryDto logicWarehouseDetailRespDto = null;
        try {
            logicWarehouseDetailRespDto = (DgLogicInventoryDto)RestResponseHelper.extractData((RestResponse)this.dgLogicInventoryApi.get(warehouseId));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u903b\u8f91\u4ed3\u6570\u636e"});
        }
        return logicWarehouseDetailRespDto;
    }

    public CsChannelWarehouseRespDto queryChannelWarehouseRespDtoByWarehouseId(Long warehouseId) {
        CsChannelWarehouseRespDto csChannelWarehouseRespDto = new CsChannelWarehouseRespDto();
        try {
            ChannelWarehouseRespDto channelWarehouseRespDto = (ChannelWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByPrimaryKey(warehouseId));
            CubeBeanUtils.copyProperties((Object)csChannelWarehouseRespDto, (Object)channelWarehouseRespDto, (String[])new String[0]);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u6e20\u9053\u4ed3\u6570\u636e"});
        }
        return csChannelWarehouseRespDto;
    }

    public List<DgLogicInventoryDto> queryCsLogicWarehousePageRespDtoListByOrganizationId(String organizationCode) {
        List csLogicWarehousePageRespDtoList = null;
        try {
            DgLogicInventoryListReqDto csLogicWarehousePageQueryDto = new DgLogicInventoryListReqDto();
            csLogicWarehousePageQueryDto.setOrganizationCodeList((List)Lists.newArrayList((Object[])new String[]{organizationCode}));
            csLogicWarehousePageRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicInventoryApi.queryList(csLogicWarehousePageQueryDto));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u903b\u8f91\u4ed3\u5e93\u5217\u8868"});
        }
        return csLogicWarehousePageRespDtoList;
    }

    public List<DgPhysicsWarehouseDto> queryPhysicsWarehouseByIds(List<String> physicsWarehouseCodes) {
        List csRelWarehouseRespDtoList = null;
        try {
            csRelWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgPhysicsWarehouseApi.queryAll());
            if (CollectionUtils.isNotEmpty((Collection)csRelWarehouseRespDtoList)) {
                csRelWarehouseRespDtoList.stream().filter(dto -> physicsWarehouseCodes.contains(dto.getWarehouseCode())).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u4ed3\u5e93\u5173\u7cfb\u96c6\u5408\uff08id\uff09"});
        }
        return csRelWarehouseRespDtoList;
    }

    public List<CsInventoryBasicsQueryRespDto> queryCsLogicInventoryBalance(List<String> warehouseCodes, List<String> skuCodes) {
        List csInventoryBasicsQueryRespDtoList = null;
        try {
            CsInventoryBasicsQueryReqDto queryDto = new CsInventoryBasicsQueryReqDto();
            queryDto.setWarehouseCodeList(warehouseCodes);
            queryDto.setLongCodeList(skuCodes);
            queryDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
            csInventoryBasicsQueryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedQueryApi.queryCommonInventory(queryDto));
            logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u5e93\u5b58==>{}", (Object)JSON.toJSONString((Object)csInventoryBasicsQueryRespDtoList));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u903b\u8f91\u4ed3\u5e93\u5b58"});
        }
        return csInventoryBasicsQueryRespDtoList;
    }

    public List<WarehouseInventoryVo> queryCsLogicInventoryBalanceByRuleVo(List<String> warehouseCodes, List<String> skuCodes, SourceExecuteContextVo sourceExecuteContextVo) {
        ArrayList<WarehouseInventoryVo> warehouseInventoryVoList = null;
        try {
            List<IntransitCargoRespDto> intransitCargoRespDtoList = sourceExecuteContextVo.getIntransitCargoRespDtoList();
            CsInventoryBasicsQueryReqDto queryDto = new CsInventoryBasicsQueryReqDto();
            queryDto.setWarehouseCodeList(warehouseCodes);
            queryDto.setLongCodeList(skuCodes);
            queryDto.setTotalQueryFlag(Boolean.TRUE);
            queryDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
            List totalLogicInventoryList = (List)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedQueryApi.queryCommonInventory(queryDto));
            logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u603b\u53ef\u7528\u5e93\u5b58==>{}", (Object)JSON.toJSONString((Object)totalLogicInventoryList));
            logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u5bf9\u5e94\u5728\u9014\u53ef\u552e\u5e93\u5b58==>{}", (Object)JSON.toJSONString(intransitCargoRespDtoList));
            if (CollectionUtils.isEmpty((Collection)totalLogicInventoryList) && CollectionUtils.isEmpty(intransitCargoRespDtoList)) {
                return Lists.newArrayList();
            }
            Map<String, List<CsInventoryBasicsQueryRespDto>> logicWarehouseStockMap = new HashMap<String, List<CsInventoryBasicsQueryRespDto>>();
            if (CollectionUtils.isNotEmpty((Collection)totalLogicInventoryList)) {
                logicWarehouseStockMap = totalLogicInventoryList.stream().collect(Collectors.groupingBy(CsInventoryBasicsQueryRespDto::getLongCode));
            }
            sourceExecuteContextVo.setLogicWarehouseStockMap(logicWarehouseStockMap);
            List warehouseCodeList = totalLogicInventoryList.stream().map(CsInventoryBasicsQueryRespDto::getWarehouseCode).distinct().collect(Collectors.toList());
            List longCodeList = totalLogicInventoryList.stream().map(CsInventoryBasicsQueryRespDto::getLongCode).distinct().collect(Collectors.toList());
            queryDto = new CsInventoryBasicsQueryReqDto();
            queryDto.setWarehouseCodeList(warehouseCodeList);
            queryDto.setLongCodeList(longCodeList);
            queryDto.setTotalQueryFlag(Boolean.FALSE);
            queryDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
            warehouseInventoryVoList = new ArrayList<WarehouseInventoryVo>();
            HashMap<String, List<WarehouseInventoryVo>> ztWarehouseStockMap = new HashMap();
            List<WarehouseInventoryVo> ztInventoryVoList = this.toWarehouseInventoryVo(intransitCargoRespDtoList);
            if (CollectionUtils.isNotEmpty(ztInventoryVoList)) {
                warehouseInventoryVoList.addAll(ztInventoryVoList);
                List<Object> ztInventoryVoListNew = new ArrayList();
                ztInventoryVoListNew = ztInventoryVoList;
                ztWarehouseStockMap = ztInventoryVoListNew.stream().collect(Collectors.groupingBy(CsInventoryBasicsQueryRespDto::getCargoCode));
                sourceExecuteContextVo.setZtWarehouseStockMap(ztWarehouseStockMap);
            }
            logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u53ef\u7528\u5e93\u5b58\u5165\u53c2==>{}", (Object)JSON.toJSONString((Object)queryDto));
            List csInventoryBasicsQueryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedQueryApi.queryCommonInventory(queryDto));
            logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u53ef\u7528\u5e93\u5b58==>{}", (Object)JSON.toJSONString((Object)csInventoryBasicsQueryRespDtoList));
            Map<String, List<CsInventoryBasicsQueryRespDto>> logicInventoryBaseMap = csInventoryBasicsQueryRespDtoList.stream().collect(Collectors.groupingBy(dto -> dto.getWarehouseCode() + dto.getLongCode()));
            for (CsInventoryBasicsQueryRespDto totalLogicInventory : totalLogicInventoryList) {
                String key = totalLogicInventory.getWarehouseCode() + totalLogicInventory.getLongCode();
                if (!logicInventoryBaseMap.containsKey(key)) {
                    logger.info("\u903b\u8f91\u603b\u4ed3\u53ef\u7528\u5e93\u5b58\u672a\u5728\u660e\u7ec6\u8868\u5b58\u5728");
                    continue;
                }
                List<CsInventoryBasicsQueryRespDto> csInventoryBasicsQueryRespDtos = logicInventoryBaseMap.get(key);
                ArrayList logicWarehouseInventoryList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)logicWarehouseInventoryList, csInventoryBasicsQueryRespDtos, WarehouseInventoryVo.class);
                logicWarehouseInventoryList.forEach(e -> e.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode()));
                warehouseInventoryVoList.addAll(logicWarehouseInventoryList);
            }
            if (CollectionUtils.isEmpty(warehouseInventoryVoList)) {
                logger.info("\u903b\u8f91\u4ed3\u53ef\u7528\u5e93\u5b58\u672a\u5339\u914d\u5230\u603b\u4ed3\u5e93\u5b58");
                return Lists.newArrayList();
            }
            List<WarehouseInventoryVo> newAvailableStockList = this.getNewBatchStockList(warehouseInventoryVoList);
            logger.info("\u540c\u6279\u6b21\u5339\u914d\u5e93\u5b58={}", JSON.toJSON(newAvailableStockList));
            Map<String, List<WarehouseInventoryVo>> logicDetailGroupMap = newAvailableStockList.stream().collect(Collectors.groupingBy(dto -> {
                if (Objects.isNull(dto.getProduceTime())) {
                    dto.setProduceTime(DateUtil.getToday());
                }
                if (Objects.isNull(dto.getAvailable())) {
                    dto.setAvailable(BigDecimal.ZERO);
                }
                return dto.getWarehouseCode() + dto.getLongCode();
            }));
            warehouseInventoryVoList = new ArrayList();
            for (String key : logicDetailGroupMap.keySet()) {
                List<WarehouseInventoryVo> warehouseInventoryVos = logicDetailGroupMap.get(key);
                BigDecimal negativeInventoryNum = warehouseInventoryVos.stream().filter(vo -> vo.getAvailable().compareTo(BigDecimal.ZERO) < 0).map(CsInventoryBasicsQueryRespDto::getAvailable).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).negate();
                List inventoryVos = warehouseInventoryVos.stream().filter(vo -> vo.getAvailable().compareTo(BigDecimal.ZERO) > 0).sorted(Comparator.comparing(CsInventoryBasicsQueryRespDto::getProduceTime).reversed()).collect(Collectors.toList());
                List<Object> availableStockList = Lists.newArrayList();
                for (WarehouseInventoryVo inventoryVo : inventoryVos) {
                    if (negativeInventoryNum.compareTo(BigDecimal.ZERO) != 0) {
                        if (negativeInventoryNum.compareTo(inventoryVo.getAvailable()) >= 0) {
                            negativeInventoryNum = negativeInventoryNum.subtract(inventoryVo.getAvailable());
                            continue;
                        }
                        inventoryVo.setAvailable(inventoryVo.getAvailable().subtract(negativeInventoryNum));
                        negativeInventoryNum = BigDecimal.ZERO;
                    }
                    if (Objects.isNull(inventoryVo.getZtSaleable())) {
                        inventoryVo.setZtSaleable(BigDecimal.ZERO);
                    } else {
                        inventoryVo.setZtSaleable(inventoryVo.getAvailable());
                    }
                    inventoryVo.setUsedStock(BigDecimal.ZERO);
                    inventoryVo.setSurplusStock(inventoryVo.getAvailable());
                    availableStockList.add((Object)inventoryVo);
                }
                if (!CollectionUtils.isNotEmpty((Collection)availableStockList)) continue;
                availableStockList = availableStockList.stream().sorted(Comparator.comparing(CsInventoryBasicsQueryRespDto::getProduceTime)).collect(Collectors.toList());
                warehouseInventoryVoList.addAll((Collection<WarehouseInventoryVo>)availableStockList);
            }
        }
        catch (BizException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            throw SourceExceptionCode.NORMAL_EXCEPTION.buildBizException(new String[]{"\u83b7\u53d6\u903b\u8f91\u4ed3\u5e93\u5b58\u5f02\u5e38:" + e2.getMessage()});
        }
        return warehouseInventoryVoList;
    }

    private List<WarehouseInventoryVo> getNewBatchStockList(List<WarehouseInventoryVo> warehouseInventoryVoList) {
        ArrayList newAvailableStockList = Lists.newArrayList();
        Map<String, List<WarehouseInventoryVo>> batchItemGroupMap = warehouseInventoryVoList.stream().collect(Collectors.groupingBy(dto -> dto.getWarehouseCode() + "_" + dto.getCargoCode() + "_" + dto.getBatch()));
        for (List<WarehouseInventoryVo> warehouseInventoryVos : batchItemGroupMap.values()) {
            WarehouseInventoryVo vo2;
            List ztInventoryVos = warehouseInventoryVos.stream().filter(vo -> Objects.equals(vo.getWarehouseClassify(), CsWarehouseClassifyEnum.IN_TRANSIT.getCode())).collect(Collectors.toList());
            List logicInventoryVos = warehouseInventoryVos.stream().filter(vo -> Objects.equals(vo.getWarehouseClassify(), CsWarehouseClassifyEnum.LOGIC.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ztInventoryVos) && CollectionUtils.isNotEmpty(logicInventoryVos)) {
                newAvailableStockList.addAll(logicInventoryVos);
                continue;
            }
            if (CollectionUtils.isNotEmpty(ztInventoryVos) && CollectionUtils.isEmpty(logicInventoryVos)) {
                newAvailableStockList.addAll(ztInventoryVos);
                continue;
            }
            BigDecimal ztStockNum = ztInventoryVos.stream().map(CsInventoryBasicsQueryRespDto::getAvailable).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal logicStockNum = logicInventoryVos.stream().map(CsInventoryBasicsQueryRespDto::getAvailable).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (ztStockNum.compareTo(BigDecimal.ZERO) >= 0 && logicStockNum.compareTo(BigDecimal.ZERO) >= 0) {
                newAvailableStockList.addAll(logicInventoryVos);
                newAvailableStockList.addAll(ztInventoryVos);
                continue;
            }
            if (ztStockNum.compareTo(BigDecimal.ZERO) > 0 && logicStockNum.compareTo(BigDecimal.ZERO) < 0) {
                vo2 = new WarehouseInventoryVo();
                CubeBeanUtils.copyProperties((Object)((Object)vo2), ztInventoryVos.get(0), (String[])new String[0]);
                vo2.setAvailable(ztStockNum.add(logicStockNum));
                vo2.setZtSaleable(vo2.getAvailable());
                newAvailableStockList.add(vo2);
                continue;
            }
            if (ztStockNum.compareTo(BigDecimal.ZERO) < 0 && logicStockNum.compareTo(BigDecimal.ZERO) > 0) {
                vo2 = new WarehouseInventoryVo();
                CubeBeanUtils.copyProperties((Object)((Object)vo2), logicInventoryVos.get(0), (String[])new String[0]);
                vo2.setAvailable(ztStockNum.add(logicStockNum));
                newAvailableStockList.add(vo2);
                continue;
            }
            if (ztStockNum.compareTo(BigDecimal.ZERO) >= 0 || logicStockNum.compareTo(BigDecimal.ZERO) >= 0) continue;
            vo2 = new WarehouseInventoryVo();
            CubeBeanUtils.copyProperties((Object)((Object)vo2), logicInventoryVos.get(0), (String[])new String[0]);
            vo2.setAvailable(ztStockNum.add(logicStockNum));
            newAvailableStockList.add(vo2);
        }
        return newAvailableStockList;
    }

    public List<WarehouseInventoryVo> queryCsLogicInventoryGroupZt(List<WarehouseInventoryVo> inventoryVos, SourceExecuteContextVo sourceExecuteContextVo) {
        ArrayList warehouseInventoryVos = Lists.newArrayList();
        logger.info("\u903b\u8f91\u4ed3\u5e93\u5b58\u4fe1\u606f={}", (Object)JSON.toJSONString(inventoryVos));
        Map<String, List<WarehouseInventoryVo>> inventoryMap = inventoryVos.stream().collect(Collectors.groupingBy(dto -> dto.getWarehouseCode() + "-" + dto.getLongCode() + "-" + dto.getBatch()));
        List<Object> ztCargoRespDtoList = Lists.newArrayList();
        for (List<WarehouseInventoryVo> vos : inventoryMap.values()) {
            List logicWarehoouseInventoryList = vos.stream().filter(v -> !Objects.equals(v.getWarehouseClassify(), CsWarehouseClassifyEnum.IN_TRANSIT.getCode())).collect(Collectors.toList());
            WarehouseInventoryVo logicStock = new WarehouseInventoryVo();
            CubeBeanUtils.copyProperties((Object)((Object)logicStock), (Object)((Object)vos.get(0)), (String[])new String[0]);
            BigDecimal available = logicWarehoouseInventoryList.stream().map(CsInventoryBasicsQueryRespDto::getAvailable).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            logicStock.setAvailable(available);
            logicStock.setSurplusStock(available);
            if (logicWarehoouseInventoryList.size() == vos.size()) {
                logicStock.setZtSaleable(BigDecimal.ZERO);
                logicStock.setZtSurplusStock(BigDecimal.ZERO);
            } else {
                List ztWarehoouseInventoryList = vos.stream().filter(v -> Objects.equals(v.getWarehouseClassify(), CsWarehouseClassifyEnum.IN_TRANSIT.getCode())).collect(Collectors.toList());
                ztCargoRespDtoList.addAll(ztWarehoouseInventoryList);
                BigDecimal ztAvailable = ztWarehoouseInventoryList.stream().map(CsInventoryBasicsQueryRespDto::getAvailable).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                logicStock.setZtSaleable(ztAvailable);
                logicStock.setZtSurplusStock(ztAvailable);
            }
            logicStock.setSurplusStock(available.add(logicStock.getZtSaleable()));
            warehouseInventoryVos.add(logicStock);
        }
        if (CollectionUtils.isNotEmpty((Collection)ztCargoRespDtoList)) {
            ztCargoRespDtoList = ztCargoRespDtoList.stream().sorted(Comparator.comparing(CsInventoryBasicsQueryRespDto::getProduceTime)).collect(Collectors.toList());
        }
        sourceExecuteContextVo.setZtCargoRespDtoList((List<WarehouseInventoryVo>)ztCargoRespDtoList);
        logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u5bf9\u5e94\u7684\u5728\u9014\u4ed3\u5e93\u5b58\u6570\u636e:{}", (Object)JSON.toJSONString((Object)ztCargoRespDtoList));
        return warehouseInventoryVos;
    }

    public List<WarehouseInventoryVo> matchFilterItemBlackList(List<WarehouseInventoryVo> inventoryVos, SourceExecuteContextVo sourceExecuteContextVo) {
        Integer itemBlackType = sourceExecuteContextVo.getCurrentClueActRespDto().getItemBlackType();
        if (Objects.equals(itemBlackType, SourceItemBlackTypeEnum.NO.getCode())) {
            logger.info("\u5bfb\u6e90\u7b56\u7565\u672a\u914d\u7f6e\u5546\u54c1\u9ed1\u540d\u5355");
            return inventoryVos;
        }
        if (CollectionUtils.isEmpty(inventoryVos)) {
            logger.info("\u5bfb\u6e90\u5546\u54c1\u9ed1\u540d\u5355\u5339\u914d\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
            return inventoryVos;
        }
        List clueItemBlacklist = sourceExecuteContextVo.getCurrentClueActRespDto().getClueItemBlacklist();
        logger.info("\u5bfb\u6e90\u5546\u54c1\u9ed1\u540d\u5355\u4fe1\u606f={}", JSON.toJSON((Object)clueItemBlacklist));
        if (CollectionUtils.isEmpty((Collection)clueItemBlacklist)) {
            logger.info("\u5bfb\u6e90\u5546\u54c1\u9ed1\u540d\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            return inventoryVos;
        }
        List skuCodeList = inventoryVos.stream().map(CsInventoryBasicsQueryRespDto::getLongCode).distinct().collect(Collectors.toList());
        OrderAddrRespDto orderAddrRespDto = sourceExecuteContextVo.getOrderDetailRespDto().getOrderAddrRespDto();
        String provinceCode = orderAddrRespDto.getProvinceCode();
        String cityCode = orderAddrRespDto.getCityCode();
        logger.info("\u5bfb\u6e90\u5546\u54c1\u9ed1\u540d\u5355\u8ba2\u5355\u6536\u8d27\u5730\u5740\u4fe1\u606fprovinceCode={},cityCode={}", (Object)provinceCode, (Object)cityCode);
        ArrayList filterItemBlackList = Lists.newArrayList();
        for (ClueWarehouseItemBlackListRespDto itemBlack : clueItemBlacklist) {
            if (StringUtils.isEmpty((CharSequence)itemBlack.getReceiveCity())) continue;
            List receiveCityCodeList = JSON.parseArray((String)itemBlack.getReceiveCity(), ClueItemBlackListCityDto.class);
            itemBlack.setReceiveCityCodeList(receiveCityCodeList);
            if (!skuCodeList.contains(itemBlack.getSkuCode())) continue;
            for (ClueItemBlackListCityDto receiveCity : itemBlack.getReceiveCityCodeList()) {
                if (!Objects.equals(receiveCity.getCode(), provinceCode) && !Objects.equals(receiveCity.getCode(), cityCode)) continue;
                filterItemBlackList.add(itemBlack);
            }
        }
        if (CollectionUtils.isEmpty((Collection)filterItemBlackList)) {
            logger.info("\u5bfb\u6e90\u5546\u54c1\u9ed1\u540d\u5355\u8fc7\u6ee4\u540e\u4e0d\u5b58\u5728\u5546\u54c1\u4fe1\u606f");
            return inventoryVos;
        }
        Map<String, List<ClueWarehouseItemBlackListRespDto>> itemSkuBlackMap = filterItemBlackList.stream().collect(Collectors.groupingBy(ClueWarehouseItemBlackListRespDto::getSkuCode));
        HashSet<ClueWarehouseItemBlackListRespDto> hitItemBlackList = new HashSet<ClueWarehouseItemBlackListRespDto>();
        ArrayList warehouseInventoryVos = Lists.newArrayList();
        for (WarehouseInventoryVo inventoryVo : inventoryVos) {
            if (!itemSkuBlackMap.containsKey(inventoryVo.getLongCode())) {
                warehouseInventoryVos.add(inventoryVo);
                continue;
            }
            boolean hitItemBlackFlag = false;
            List<ClueWarehouseItemBlackListRespDto> itemBlackListRespDtos = itemSkuBlackMap.get(inventoryVo.getLongCode());
            for (ClueWarehouseItemBlackListRespDto itemBlackListRespDto : itemBlackListRespDtos) {
                String[] batchArry;
                if (StringUtils.isEmpty((CharSequence)itemBlackListRespDto.getBatchNo())) {
                    hitItemBlackList.add(itemBlackListRespDto);
                    hitItemBlackFlag = true;
                    continue;
                }
                if (Objects.equals(itemBlackType, SourceItemBlackTypeEnum.BY_BATCH_END.code)) {
                    for (String batchEnd : batchArry = itemBlackListRespDto.getBatchNo().split(regex_split_str)) {
                        if (!inventoryVo.getBatch().endsWith(batchEnd)) continue;
                        hitItemBlackList.add(itemBlackListRespDto);
                        hitItemBlackFlag = true;
                    }
                    continue;
                }
                if (!Objects.equals(itemBlackType, SourceItemBlackTypeEnum.BY_BATCH_NO.code)) continue;
                for (String batchNo : batchArry = itemBlackListRespDto.getBatchNo().split(regex_split_str)) {
                    if (!Objects.equals(inventoryVo.getBatch(), batchNo)) continue;
                    hitItemBlackList.add(itemBlackListRespDto);
                    hitItemBlackFlag = true;
                }
            }
            sourceExecuteContextVo.setHitItemBlackFlag(hitItemBlackFlag);
            if (hitItemBlackFlag) continue;
            warehouseInventoryVos.add(inventoryVo);
        }
        sourceExecuteContextVo.setHitClueItemBlacklist(Lists.newArrayList(hitItemBlackList));
        logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u8fc7\u6ee4\u5546\u54c1\u9ed1\u540d\u5355\u540e\u7684\u6570\u636e:{}", JSON.toJSON((Object)warehouseInventoryVos));
        return warehouseInventoryVos;
    }

    public List<DgWarehouseAddressDto> queryCsWarehouseAddressList(List<String> warehouseCodes) {
        List warehouseAddressRespDtoList = null;
        try {
            DgWarehouseAddressPageReqDto queryDto = new DgWarehouseAddressPageReqDto();
            queryDto.setWarehouseCodes(warehouseCodes.stream().distinct().collect(Collectors.toList()));
            warehouseAddressRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgWarehouseAddressApi.queryList(queryDto));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u4ed3\u5e93\u5730\u5740"});
        }
        return warehouseAddressRespDtoList;
    }

    public void queryCsVirtualWarehouseByLogicAndChannelWarehouse(CsLogicWarehouseDetailRespDto csLogicWarehouseDetailRespDto, CsChannelWarehouseRespDto channelWarehouseRespDto) {
    }

    public List<WarehouseThresholdRespDto> queryWarehouseOutboundOrder(List<String> warehouseCodeList) {
        List warehouseThresholdRespDtos = null;
        try {
            WarehouseThresholReqDto warehouseThresholReqDto = new WarehouseThresholReqDto();
            warehouseThresholReqDto.setWarehouseCodeList(warehouseCodeList);
            logger.info("\u7edf\u8ba1\u83b7\u53d6\u5f53\u5e94\u524d\u903b\u8f91\u4ed3\u5bf9\u7269\u7406\u4ed3\u7684\u51fa\u5e93\u5355\u91cf\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)warehouseThresholReqDto));
            warehouseThresholdRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryWarehouseThreshold(warehouseThresholReqDto));
            logger.info("\u7edf\u8ba1\u83b7\u53d6\u5f53\u5e94\u524d\u903b\u8f91\u4ed3\u5bf9\u7269\u7406\u4ed3\u7684\u51fa\u5e93\u5355\u91cf\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)warehouseThresholdRespDtos));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u903b\u8f91\u4ed3\u5bf9\u5e94\u7269\u7406\u4ed3\u7684\u51fa\u5e93\u5355\u91cf"});
        }
        return warehouseThresholdRespDtos;
    }

    public List<DgLogicWarehouseDto> queryLogicWarehouseByPhysicsCodes(List<String> physicsWarehouseCodes) {
        if (CollectionUtils.isEmpty(physicsWarehouseCodes)) {
            logger.info("\u67e5\u8be2\u6761\u4ef6\u7269\u7406\u4ed3\u7f16\u7801\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        List csRelWarehouseRespDtos = Lists.newArrayList();
        try {
            DgLogicWarehousePageReqDto queryLogicReqDto = new DgLogicWarehousePageReqDto();
            queryLogicReqDto.setPhysicsWarehouseCodes(physicsWarehouseCodes);
            logger.info("\u901a\u8fc7\u7269\u7406\u4ed3\u7f16\u53f7\u83b7\u53d6\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryLogicReqDto));
            csRelWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(queryLogicReqDto));
            logger.info("\u901a\u8fc7\u7269\u7406\u4ed3\u7f16\u53f7\u83b7\u53d6\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)csRelWarehouseRespDtos));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u7269\u7406\u4ed3\u7f16\u53f7\u5173\u8054\u7684\u903b\u8f91\u4ed3"});
        }
        return csRelWarehouseRespDtos;
    }

    public List<CsLogicWarehouseRespDto> queryLogicWarehouseRefByvirtualWarehouseCode(String virtualWarehouseCode) {
        List csLogicWarehouseRespDtos = Lists.newArrayList();
        try {
            logger.info("\u901a\u8fc7\u7269\u7406\u4ed3\u7f16\u53f7\u83b7\u53d6\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)virtualWarehouseCode));
            csLogicWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.virtualWarehouseQueryApi.queryLogicWarehouse(virtualWarehouseCode));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u4f9b\u8d27\u4ed3\u7f16\u53f7\u5173\u8054\u7684\u903b\u8f91\u4ed3"});
        }
        return csLogicWarehouseRespDtos;
    }

    public List<ChannelWarehouseRespDto> queryChannelWarehouseByChannelCode(String channelWarehouseCode) {
        List channelWarehouseRespDtos = Lists.newArrayList();
        try {
            HashSet channelWarehouseCodes = Sets.newHashSet((Object[])new String[]{channelWarehouseCode});
            logger.info("\u67e5\u8be2\u5171\u4eab\u4e2d\u5fc3\u6e20\u9053\u4ed3\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)channelWarehouseCodes));
            channelWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByCodes((Set)channelWarehouseCodes));
            logger.info("\u67e5\u8be2\u5171\u4eab\u4e2d\u5fc3\u6e20\u9053\u4ed3\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)channelWarehouseRespDtos));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u5171\u4eab\u4e2d\u5fc3\u6e20\u9053\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728"});
        }
        return channelWarehouseRespDtos;
    }

    public List<DgLogicWarehouseDto> queryCsLogicWarehousePageRespDtoListByCodeList(List<String> codeList) {
        List csLogicWarehousePageRespDtoList = null;
        try {
            DgLogicWarehousePageReqDto pageQueryDto = new DgLogicWarehousePageReqDto();
            pageQueryDto.setWarehouseCodes(codeList.stream().distinct().collect(Collectors.toList()));
            logger.info("\u6839\u636e\u903b\u8f91\u4ed3\u7f16\u7801\u83b7\u53d6\u903b\u8f91\u4ed3\u5e93\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)pageQueryDto));
            csLogicWarehousePageRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(pageQueryDto));
            logger.info("\u6839\u636e\u903b\u8f91\u4ed3\u7f16\u7801\u83b7\u53d6\u903b\u8f91\u4ed3\u5e93\u5217\u8868\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)csLogicWarehousePageRespDtoList));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u903b\u8f91\u4ed3\u5e93\u5217\u8868"});
        }
        return csLogicWarehousePageRespDtoList;
    }

    public List<DgLogicInventoryTotalDto> queryZtInventoryBalanceByRuleVo(List<String> warehouseCodes, List<String> skuCodes) {
        List<Object> warehouseInventoryVoList = Lists.newArrayList();
        try {
            DgLogicInventoryTotalPageReqDto queryDto = new DgLogicInventoryTotalPageReqDto();
            queryDto.setLogicWarehouseCodeList(warehouseCodes);
            queryDto.setSkuCodeList(skuCodes);
            logger.info("\u67e5\u8be2\u903b\u8f91\u4ed3\u5546\u54c1\u548c\u53ef\u7528\u5e93\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
            List totalLogicInventoryList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicInventoryTotalApi.queryList(queryDto));
            logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u603b\u53ef\u7528\u5e93\u5b58==>{}", (Object)JSON.toJSONString((Object)totalLogicInventoryList));
            if (CollectionUtils.isEmpty((Collection)totalLogicInventoryList)) {
                return warehouseInventoryVoList;
            }
            warehouseInventoryVoList = totalLogicInventoryList.stream().filter(dto -> dto.getAvailable().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)warehouseInventoryVoList)) {
                logger.info("\u903b\u8f91\u4ed3\u603b\u53ef\u7528\u5e93\u5b58\u5927\u4e8e0\u7684\u4e0d\u5b58\u5728");
                return warehouseInventoryVoList;
            }
        }
        catch (BizException e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
        return warehouseInventoryVoList;
    }

    public List<LogicWarehouseRespDto> queryZtWarehouseBylogicCode(List<String> warehouseCodes) {
        List warehouseInventoryVoList = Lists.newArrayList();
        try {
            logger.info("\u67e5\u8be2\u5728\u9014\u4ed3\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString(warehouseCodes));
            warehouseInventoryVoList = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryInTransitWarehouseByCode(warehouseCodes));
            logger.info("\u83b7\u53d6\u5728\u9014\u4ed3\u4fe1\u606f\u7ed3\u679c==>{}", (Object)JSON.toJSONString((Object)warehouseInventoryVoList));
        }
        catch (BizException e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
        return warehouseInventoryVoList;
    }

    public List<IntransitCargoRespDto> queryZtCargoBatchNum(List<String> warehouseCodes, List<String> skuCodes, Integer configDay, List<String> ztWarehouseCodes) {
        if (CollectionUtils.isEmpty(warehouseCodes) && CollectionUtils.isEmpty(ztWarehouseCodes)) {
            logger.info("\u5728\u9014\u4ed3\u7f16\u7801\u96c6\u5408\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        List warehouseInventoryVoList = Lists.newArrayList();
        IntransitCargoQueryDto queryDto = new IntransitCargoQueryDto();
        queryDto.setLogicWarehouseCodes(warehouseCodes);
        queryDto.setCargoCodes(skuCodes);
        queryDto.setConfigDay(configDay);
        queryDto.setIntransitWarehouseCodes(ztWarehouseCodes);
        try {
            logger.info("\u67e5\u8be2\u5728\u9014\u4ed3\u5e93\u5b58\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
            warehouseInventoryVoList = (List)RestResponseHelper.extractData((RestResponse)this.outResultOrderQueryApi.queryIntransitCargoNum(queryDto));
            logger.info("\u83b7\u53d6\u5728\u9014\u4ed3\u5e93\u5b58\u7ed3\u679c==>{}", (Object)JSON.toJSONString((Object)warehouseInventoryVoList));
            if (CollectionUtils.isEmpty((Collection)warehouseInventoryVoList)) {
                return warehouseInventoryVoList;
            }
        }
        catch (BizException e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
        return warehouseInventoryVoList;
    }

    public List<WarehouseInventoryVo> toWarehouseInventoryVo(List<IntransitCargoRespDto> intransitCargoRespDtos) {
        if (CollectionUtils.isEmpty(intransitCargoRespDtos)) {
            return Lists.newArrayList();
        }
        Map<String, IntransitCargoRespDto> intransitCargooMap = this.getStringIntransitCargoRespDtoMap(intransitCargoRespDtos);
        ArrayList warehouseInventoryVoList = Lists.newArrayList();
        for (IntransitCargoRespDto intransitCargoRespDto : intransitCargooMap.values()) {
            WarehouseInventoryVo warehouseInventoryVo = new WarehouseInventoryVo();
            warehouseInventoryVo.setWarehouseId(intransitCargoRespDto.getLogicWarehouseId());
            warehouseInventoryVo.setLongCode(intransitCargoRespDto.getCargoCode());
            warehouseInventoryVo.setCargoCode(intransitCargoRespDto.getCargoCode());
            warehouseInventoryVo.setCargoName(intransitCargoRespDto.getCargoName());
            warehouseInventoryVo.setWarehouseCode(intransitCargoRespDto.getLogicWarehouseCode());
            warehouseInventoryVo.setWarehouseName(intransitCargoRespDto.getLogicWarehouseName());
            warehouseInventoryVo.setBatch(intransitCargoRespDto.getBatch());
            warehouseInventoryVo.setWarehouseClassify(CsWarehouseClassifyEnum.IN_TRANSIT.getCode());
            warehouseInventoryVo.setProduceTime(intransitCargoRespDto.getProduceTime());
            warehouseInventoryVo.setExpireTime(intransitCargoRespDto.getExpireTime());
            warehouseInventoryVo.setAvailable(intransitCargoRespDto.getNum());
            warehouseInventoryVo.setUsedStock(BigDecimal.ZERO);
            warehouseInventoryVo.setSurplusStock(intransitCargoRespDto.getNum());
            warehouseInventoryVo.setZtSaleable(intransitCargoRespDto.getNum());
            warehouseInventoryVo.setZtSurplusStock(intransitCargoRespDto.getNum());
            warehouseInventoryVoList.add(warehouseInventoryVo);
        }
        return warehouseInventoryVoList;
    }

    private Map<String, IntransitCargoRespDto> getStringIntransitCargoRespDtoMap(List<IntransitCargoRespDto> intransitCargoRespDtoList) {
        return intransitCargoRespDtoList.stream().collect(Collectors.toMap(dto -> dto.getLogicWarehouseCode() + "_" + dto.getCargoCode() + "_" + dto.getBatch(), v1 -> v1, (v1, v2) -> {
            v1.setNum(v1.getNum().add(v2.getNum()));
            return v1;
        }));
    }
}

