/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.track.biz.router.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.center.track.api.dto.response.TransactionNodeRecordRespDto;
import com.dtyunxi.cube.center.track.biz.router.ITrackBizDataRouter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class TrackBizDataRouterAdapter
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static final Logger logger;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        TrackBizDataRouterAdapter.applicationContext = applicationContext;
    }

    public void routeData(TransactionNodeRecordRespDto transactionNodeRecordRespDto) {
        if (StringUtils.isBlank((CharSequence)transactionNodeRecordRespDto.getBizParams()) || transactionNodeRecordRespDto.getId() == null) {
            return;
        }
        JSONObject bizParamsMap = JSON.parseObject((String)transactionNodeRecordRespDto.getBizParams());
        String nodeBizCode = bizParamsMap.getString("transaction.track.node.biz.code");
        ITrackBizDataRouter trackBizDataRouter = null;
        try {
            trackBizDataRouter = (ITrackBizDataRouter)applicationContext.getBean(nodeBizCode, ITrackBizDataRouter.class);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (trackBizDataRouter != null) {
            trackBizDataRouter.routeData(transactionNodeRecordRespDto.getId());
        } else {
            logger.warn("TrackBizDataRouterAdapter\u9002\u914d\u4e0d\u5230{}\u6570\u636e\u6536\u96c6\u5668", (Object)nodeBizCode);
        }
    }

    static {
        logger = LoggerFactory.getLogger(TrackBizDataRouterAdapter.class);
    }
}

