/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.track.biz.router;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.center.track.api.dto.request.PcpOpenapiLogReqDto;
import com.dtyunxi.cube.center.track.api.dto.request.PcpOpenapiReqDto;
import com.dtyunxi.cube.center.track.api.dto.response.PcpOpenapiRespDto;
import com.dtyunxi.cube.center.track.biz.router.AbstractTrackBizDataRouter;
import com.dtyunxi.cube.center.track.biz.router.DingdingSender;
import com.dtyunxi.cube.center.track.biz.router.vo.TrackBizDataTransferVo;
import com.dtyunxi.cube.center.track.biz.service.IPcpOpenapiLogService;
import com.dtyunxi.cube.center.track.biz.service.IPcpOpenapiService;
import com.dtyunxi.cube.component.track.commons.constant.TransactionNodeStatusEnum;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="API_BIZ_LOG")
public class OpenApiBizLogDataRouter
extends AbstractTrackBizDataRouter {
    @Resource
    private IPcpOpenapiLogService pcpOpenapiLogService;
    @Resource
    private IPcpOpenapiService pcpOpenapiService;
    @Resource
    private DingdingSender dingdingSender;
    @Value(value="${cube.global.profile:dev}")
    private String profile;
    private static final String MSG = "\u63a5\u53e3\u5f02\u5e38\u63d0\u9192";

    @Override
    @Async
    public void routeData(Long recordId) {
        this.routeData(super.queryById(recordId));
    }

    @Override
    public void routeData(TrackBizDataTransferVo trackBizDataTransferVo) {
        PcpOpenapiLogReqDto pcpOpenapiLogReqDto = (PcpOpenapiLogReqDto)JSON.parseObject((String)trackBizDataTransferVo.getTransactionNodeRecordRespDto().getBizParams(), PcpOpenapiLogReqDto.class);
        pcpOpenapiLogReqDto.setId(null);
        pcpOpenapiLogReqDto.setNodeId(trackBizDataTransferVo.getTransactionNodeRecordRespDto().getNodeId());
        pcpOpenapiLogReqDto.setNodeRecordId(trackBizDataTransferVo.getTransactionNodeRecordRespDto().getId());
        pcpOpenapiLogReqDto.setApiAccessTime(trackBizDataTransferVo.getTransactionNodeRespDto().getAccessTime());
        pcpOpenapiLogReqDto.setApiResponseTime(trackBizDataTransferVo.getTransactionNodeRecordRespDto().getEndTime());
        if (TransactionNodeStatusEnum.N_SUCCESS.code == trackBizDataTransferVo.getTransactionNodeRecordRespDto().getNodeStatus()) {
            pcpOpenapiLogReqDto.setApiStatus(Integer.valueOf(1));
        } else {
            pcpOpenapiLogReqDto.setApiStatus(Integer.valueOf(2));
        }
        pcpOpenapiLogReqDto.setBizParams(trackBizDataTransferVo.getTransactionNodeRecordRespDto().getBizParams());
        Long id = this.pcpOpenapiLogService.addPcpOpenapiLog(pcpOpenapiLogReqDto);
        String apiCode = pcpOpenapiLogReqDto.getApiCode();
        PcpOpenapiRespDto pcpOpenapiRespDto = this.pcpOpenapiService.queryByApiCode(apiCode);
        if (pcpOpenapiRespDto == null) {
            PcpOpenapiReqDto pcpOpenapiReqDto = (PcpOpenapiReqDto)JSON.parseObject((String)trackBizDataTransferVo.getTransactionNodeRecordRespDto().getBizParams(), PcpOpenapiReqDto.class);
            this.pcpOpenapiService.addPcpOpenapi(pcpOpenapiReqDto);
        }
        this.routeDataAfter(id, pcpOpenapiLogReqDto.getApiBizNo(), pcpOpenapiRespDto, trackBizDataTransferVo);
    }

    private void routeDataAfter(Long id, String no, PcpOpenapiRespDto openapiRespDto, TrackBizDataTransferVo trackBizDataTransferVo) {
        try {
            if (TransactionNodeStatusEnum.N_SUCCESS.code == trackBizDataTransferVo.getTransactionNodeRecordRespDto().getNodeStatus()) {
                return;
            }
            if (!"pcpprod".equals(this.profile)) {
                return;
            }
            JSONObject ab = new JSONObject();
            ab.put("title", (Object)MSG);
            ab.put("\u63a5\u53e3\u4e1a\u52a1\u7c7b\u578b", (Object)openapiRespDto.getApiBizTypeName());
            ab.put("\u63a5\u53e3\u5355\u636e\u7c7b\u578b", (Object)openapiRespDto.getApiNoTypeName());
            ab.put("\u63a5\u53e3\u4e1a\u52a1\u5355\u53f7", (Object)no);
            ab.put("\u63a5\u53e3\u91cd\u8bd5id", (Object)id);
            ab.put("\u4e09\u65b9\u7cfb\u7edf", (Object)openapiRespDto.getApiSystemName());
            ab.put("\u8bf7\u6c42\u62a5\u6587", (Object)trackBizDataTransferVo.getTransactionNodeRecordRespDto().getNodeApiMethodParams());
            ab.put("\u54cd\u5e94\u62a5\u6587", (Object)trackBizDataTransferVo.getTransactionNodeRecordRespDto().getNodeApiResponse());
            DingdingSender.SendDingDingMsgReqDto sendDingDingMsgReqDto = new DingdingSender.SendDingDingMsgReqDto();
            sendDingDingMsgReqDto.setRemindType(1);
            sendDingDingMsgReqDto.setSendMessage(ab.toJSONString());
            this.dingdingSender.sendMessage(sendDingDingMsgReqDto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

