/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.dao.base.das;

import com.dtyunxi.annotation.ShardingColumn;
import com.dtyunxi.cube.framework.das.ComBaseDas;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.CamelToUnderline;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.ds.BaseMapper;
import com.dtyunxi.util.ReflectUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseDas<T extends BaseEo, P>
extends ComBaseDas<T, P> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String __VERSION__ = "_0.0.1_";
    private static List<String> ignoreField = Lists.newArrayList((Object[])new String[]{"dr", "serialVersionUID", "logger", "sqlFilters", "tenantId", "instanceId", "createPerson", "createTime", "updatePerson", "updateTime", "orderByDesc", "orderBy", "sqlOrderBys"});
    private static List<String> notValidateShardingTables = Lists.newArrayList((Object[])new String[]{"mk_coupon"});
    @Resource
    private ICacheService cacheService;
    @Resource
    private Map<String, BaseMapper> mappers;

    protected String getVersion() {
        return __VERSION__;
    }

    protected ICacheService getCacheService() {
        return this.cacheService;
    }

    protected Map<String, BaseMapper> getMappers() {
        return this.mappers;
    }

    public List<T> select(T record) {
        if (this.isEmptyEo(record)) {
            this.logger.warn("\u7a7aeo\u8fdb\u884cselect\u67e5\u8be2");
            PageMethod.clearPage();
            return Collections.emptyList();
        }
        return super.select(record);
    }

    public List<T> selectAll() {
        if (this.isShardingTable()) {
            this.logger.error("\u7981\u6b62\u5168\u8868\u67e5\u8be2");
            return Collections.emptyList();
        }
        return super.selectAll();
    }

    public T selectOne(T record) {
        if (this.isEmptyEo(record)) {
            this.logger.warn("\u7a7aeo\u8fdb\u884cselect\u67e5\u8be2");
            PageMethod.clearPage();
            return null;
        }
        return (T)super.selectOne(record);
    }

    public PageInfo<T> selectPage(T record) {
        Page localPage = PageMethod.getLocalPage();
        if (localPage == null && this.isEmptyEo(record)) {
            this.logger.warn("\u7a7aeo\u8fdb\u884cselect\u67e5\u8be2");
            PageMethod.clearPage();
            return new PageInfo(Collections.emptyList());
        }
        return super.selectPage(record);
    }

    public PageInfo<T> selectPage(T record, Integer currentPage, Integer pageSize) {
        if (pageSize == null && this.isEmptyEo(record)) {
            this.logger.warn("\u7a7aeo\u8fdb\u884cselect\u67e5\u8be2");
            PageMethod.clearPage();
            return new PageInfo(Collections.emptyList());
        }
        return super.selectPage(record, currentPage, pageSize);
    }

    public int insert(T record) {
        this.validateShardingColunm(record, DbOperationType.INSERT);
        return super.insert(record);
    }

    public int update(T record) {
        this.validateShardingColunm(record, DbOperationType.UPDATE);
        super.update(record);
        return 0;
    }

    public int updateSelective(T record) {
        this.validateShardingColunm(record, DbOperationType.UPDATE);
        if (CollectionUtils.isEmpty((Collection)record.getSqlFilters())) {
            super.updateSelective(record);
        } else {
            super.updateSelectiveSqlFilter(record);
        }
        return 0;
    }

    public int updateSelectiveSqlFilter(T record) {
        this.validateShardingColunm(record, DbOperationType.UPDATE);
        super.updateSelectiveSqlFilter(record);
        return 0;
    }

    public List<T> findListColumn(T record, String ... tableColumnName) {
        if (this.isEmptyEo(record)) {
            this.logger.warn("findListColumn");
            PageMethod.clearPage();
            return Collections.emptyList();
        }
        BaseMapper baseMapper = this.getMapper();
        return baseMapper.findListColumn(record, tableColumnName);
    }

    protected boolean isEmptyEo(T record) {
        if (record == null) {
            return true;
        }
        Boolean isEmptyEo = false;
        ShardingColumn annotation = record.getClass().getAnnotation(ShardingColumn.class);
        if (annotation != null) {
            this.validateShardingColunm(record, DbOperationType.SELECT);
            List fields = ReflectUtil.getAllFields(record.getClass());
            isEmptyEo = this.judgeEmptyEoByFields(record, fields);
            if (isEmptyEo.booleanValue()) {
                isEmptyEo = this.judgeEmptyEoBySqlfilters(record.getSqlFilters());
            }
        }
        return isEmptyEo;
    }

    private Boolean judgeEmptyEoByFields(T record, List<Field> fields) {
        Boolean isEmptyEo = true;
        for (Field field : fields) {
            if (ignoreField.contains(field.getName())) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(record);
                if (obj == null) continue;
                if (obj instanceof String) {
                    if (!StringUtils.isNotEmpty((CharSequence)((String)obj))) continue;
                    isEmptyEo = false;
                    break;
                }
                isEmptyEo = false;
                break;
            }
            catch (IllegalAccessException e) {
                this.logger.warn("\u83b7\u53d6\u6307\u5b9afield:{} \u5f02\u5e38:{}", (Object)field.getName(), (Object)e.getMessage());
            }
        }
        return isEmptyEo;
    }

    private Boolean judgeEmptyEoBySqlfilters(List<SqlFilter> filters) {
        Boolean isEmptyEo = true;
        if (CollectionUtils.isNotEmpty(filters)) {
            for (SqlFilter filter : filters) {
                Object value;
                if (ignoreField.contains(CamelToUnderline.underlineToCamel((String)filter.getProperty())) || (value = filter.getValue()) == null) continue;
                if (value instanceof String) {
                    if (!StringUtils.isNotEmpty((CharSequence)((String)value))) continue;
                    isEmptyEo = false;
                    break;
                }
                if (value instanceof List) {
                    List valueList = ((List)value).stream().filter(Objects::nonNull).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(valueList)) continue;
                    isEmptyEo = false;
                    break;
                }
                isEmptyEo = false;
                break;
            }
        }
        return isEmptyEo;
    }

    private void validateShardingColunm(T record, DbOperationType dbOperationType) {
        Class<?> tClass;
        ShardingColumn annotation;
        if (record != null && (annotation = (tClass = record.getClass()).getAnnotation(ShardingColumn.class)) != null) {
            ShardingColumn shardingColumn = annotation;
            String name = shardingColumn.name();
            String propertyName = CamelToUnderline.underlineToCamel((String)name);
            Object objectValue = null;
            try {
                Field field = ReflectUtil.getField(tClass, (String)propertyName);
                field.setAccessible(true);
                objectValue = field.get(record);
                if (objectValue == null && CollectionUtils.isNotEmpty((Collection)record.getSqlFilters())) {
                    for (SqlFilter sqlFilter : record.getSqlFilters()) {
                        String property = CamelToUnderline.underlineToCamel((String)sqlFilter.getProperty());
                        if (!propertyName.equals(property)) continue;
                        objectValue = sqlFilter.getValue();
                    }
                }
                switch (dbOperationType) {
                    case UPDATE: {
                        if (!"id".equals(propertyName) && objectValue != null) {
                            field.set(record, null);
                            List filters = record.getSqlFilters();
                            if (CollectionUtils.isEmpty((Collection)filters)) {
                                filters = Lists.newArrayList();
                            } else if (filters instanceof AbstractList) {
                                filters = Lists.newArrayList((Iterable)filters);
                            }
                            SqlFilter filter = new SqlFilter(propertyName, SqlFilter.Operator.eq, objectValue);
                            filters.add(filter);
                            record.setSqlFilters(filters);
                            break;
                        }
                    }
                    case INSERT: {
                        if ("id".equals(propertyName) || !this.isShardingTable(tClass) || objectValue != null && (!(objectValue instanceof String) || !StringUtils.isBlank((CharSequence)((String)objectValue)))) break;
                        throw new RuntimeException("\u5b9e\u4f53\u7c7b" + tClass.getSimpleName() + "\u5bf9\u5e94\u62c6\u5206\u952e\u5c5e\u6027 " + propertyName + " \u7684\u5c5e\u6027\u503c\u4e3a\u7a7a! ");
                    }
                    case SELECT: {
                        if (!this.isShardingTable(tClass) || objectValue != null && (!(objectValue instanceof String) || !StringUtils.isBlank((CharSequence)((String)objectValue)))) break;
                        throw new RuntimeException("\u5b9e\u4f53\u7c7b" + tClass.getSimpleName() + "\u5bf9\u5e94\u62c6\u5206\u952e\u5c5e\u6027 " + propertyName + " \u7684\u5c5e\u6027\u503c\u4e3a\u7a7a! ");
                    }
                }
            }
            catch (RuntimeException e1) {
                this.logger.error("\u5b9e\u4f53\u7c7b{}\u5bf9\u5e94\u62c6\u5206\u952e\u5c5e\u6027{}\u7684\u5c5e\u6027\u503c\u4e3a\u7a7a! ", (Object)tClass.getSimpleName(), (Object)propertyName);
                throw e1;
            }
            catch (Exception e2) {
                this.logger.error("\u8bbe\u7f6e\u62c6\u5206\u952e\u503c\u5931\u8d25", (Throwable)e2);
                throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u62c6\u5206\u952e\u5c5e\u6027:" + propertyName);
            }
        }
    }

    private boolean isShardingTable() {
        Class tClass = super.getTClass();
        return this.isShardingTable(tClass);
    }

    private boolean isShardingTable(Class tClass) {
        Table annotation = tClass.getAnnotation(Table.class);
        if (annotation != null) {
            ShardingColumn shardingColumn = tClass.getAnnotation(ShardingColumn.class);
            if (null == shardingColumn) {
                return false;
            }
            Table table = annotation;
            return !notValidateShardingTables.contains(table.name());
        }
        return false;
    }

    static enum DbOperationType {
        INSERT,
        UPDATE,
        SELECT;

    }
}

