package com.dtyunxi.finance.api;

import com.dtyunxi.finance.api.dto.request.ExpressCostAreaReqDto;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 快递费合同区域服务接口
 *
 * @author 天泽
 * @since 2022-11-10
 */
@Api(tags = {"快递费合同区域服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IExpressCostAreaApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/express/cost/area",
        url = "${com.dtyunxi.finance.api:}"
)
public interface IExpressCostAreaApi {

    /**
     * 新增快递费合同区域
     *
     * @param addReqDto 快递费合同区域请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增快递费合同区域", notes = "新增快递费合同区域")
    RestResponse<Long> addExpressCostArea(@RequestBody ExpressCostAreaReqDto addReqDto);

    /**
     * 修改快递费合同区域
     *
     * @param modifyReqDto 快递费合同区域请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改快递费合同区域", notes = "修改快递费合同区域")
    RestResponse<Void> modifyExpressCostArea(@RequestBody ExpressCostAreaReqDto modifyReqDto);

    /**
     * 删除快递费合同区域
     *
     * @param ids        快递费合同区域删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除快递费合同区域", notes = "删除快递费合同区域")
    RestResponse<Void> removeExpressCostArea(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);


}
