package com.dtyunxi.finance.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.StorageContractReqDto;
import com.dtyunxi.finance.api.dto.response.StorageContractRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;

import java.util.List;

/**
 * 仓储费合同表服务接口
 *
 * @author xuanxin
 * @since 2022-07-18
 */
@Api(tags = {"仓储费合同表服务"})
@FeignClient(
        contextId = "com-dtyunxi-finance-api-IStorageContractApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/storageContract",
        url = "${com.dtyunxi.finance.api:}"
)
public interface IStorageContractApi {

    /**
     * 新增仓储费合同表
     *
     * @param addReqDto 仓储费合同表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增仓储费合同表", notes = "新增仓储费合同表")
    RestResponse<List<StorageContractRespDto>> addStorageContract(@RequestBody StorageContractReqDto addReqDto);

    /**
     * 修改仓储费合同表
     *
     * @param modifyReqDto 仓储费合同表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改仓储费合同表", notes = "修改仓储费合同表")
    RestResponse<List<StorageContractRespDto>> modifyStorageContract(@RequestBody StorageContractReqDto modifyReqDto);

    /**
     * 删除仓储费合同表
     *
     * @param ids        仓储费合同表删除数据ID
     * @return 处理结果
     */
    @PostMapping("/delete")
    @ApiOperation(value = "删除仓储费合同表", notes = "删除仓储费合同表")
    RestResponse<Void> removeStorageContract(@RequestParam("ids") String ids);

    /**
     * 作废仓储费合同表
     *
     * @param ids      仓储费合同表删除数据ID
     * @param isCancel 0表示未作废，1表示作废
     */
    @PutMapping("/isCancel")
    @ApiOperation(value = "作废仓储费合同表", notes = "作废仓储费合同表")
    RestResponse<Void> modifyStorageContractOfIsCancel(@RequestParam("ids") String ids, @RequestParam("isCancel") int isCancel);
}
