package com.dtyunxi.finance.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 分摊基础配置表Eo对象
 *
 * @author jiaye
 * @since 2025-08-20
 */
@Data
@ApiModel(value = "ApportionmentConfigSaveReqDto", description = "分摊基础配置保存Dto")
public class ApportionmentConfigSaveReqDto extends ApportionmentConfigReqDto {

    @NotEmpty
    @ApiModelProperty(name = "orderBizTypeList", value = "分摊单据业务类型集合")
    private List<ApportionmentOrderBizTypeReqDto> orderBizTypeList;

    @NotEmpty
    @ApiModelProperty(name = "organizationList", value = "分摊组织集合")
    private List<ApportionmentOrganizationReqDto> organizationList;

}
