package com.dtyunxi.finance.api.dto.request.logistic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Pattern;
import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "SeasonLowestDto", description = "最低价格配置Dto")
public class SeasonVolumeDto extends TemplateCommonDto {

    @ApiModelProperty(name = "box",value = "*N-N箱")
    @Pattern(regexp = "^[1-9]\\d*$",message = "*N-N箱为正整数")
    private BigDecimal box;

    @ApiModelProperty(name = "volume01",value = "* > N < N m³")
    @Pattern(regexp = "^[1-9]\\d*$",message = "* > N < N m³为正整数")
    private BigDecimal volume01;

    @ApiModelProperty(name = "volume02",value = "* > N >= N m³")
    @Pattern(regexp = "^[1-9]\\d*$",message = "* > N >= N m³为正整数")
    private BigDecimal volume02;
}
