package com.dtyunxi.finance.api.query;

import com.dtyunxi.finance.api.dto.request.logistic.AppointAreaQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordExtReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.OilLinkQueryReqDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilChangeQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkQueryRespDto;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = {"物流费用功能模块：查询服务接口"})
@FeignClient(
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/logistic",
        url = "${com.dtyunxi.finance.api:}"
)
public interface ILogisticQueryApi {

    /**
     * 根据类型查询油价浮动配置列表
     *
     * @param type 主键
     * @return RestResponse<List<OilChangeQueryRespDto>>
     */
    @RequestMapping(value = {"/oilChange/query/{type}"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "根据类型查询油价浮动配置列表", notes = "根据类型查询油价浮动配置列表")
    RestResponse<List<OilChangeQueryRespDto>> queryByType(@PathVariable("type") String type);

    /**
     * 分页查询油价联动列表
     *
     * @param queryReqDto 查询参数
     * @return RestResponse<PageInfo<OilLinkQueryRespDto>>
     */
    @PostMapping("/oilLink/list/queryList")
    @ApiOperation(value = "分页查询油价联动列表", notes = "分页查询油价联动列表")
    RestResponse<PageInfo<OilLinkQueryRespDto>> queryOilLinkList(@RequestBody OilLinkQueryReqDto queryReqDto);

    /**
     * 分页查询物流设置列表
     *
     * @param queryReqDto 查询参数
     * @return RestResponse<PageInfo<LogisticRecordQueryRespDto>>
     */
    @PostMapping("/logisticsRecord/list/queryList")
    @ApiOperation(value = "分页查询物流设置列表", notes = "分页查询物流设置列表")
    RestResponse<PageInfo<LogisticRecordQueryRespDto>> queryLogisticsRecordList(@RequestBody LogisticRecordQueryReqDto queryReqDto);

    /**
     * 根据ID主键查询物流设置详情
     *
     * @param id 主键
     * @return RestResponse<LogisticRecordQueryRespDto>
     */
    @RequestMapping(value = {"/logisticsRecord/query/detail/{id}"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "根据ID主键查询物流设置详情", notes = "根据ID主键查询物流设置详情")
    RestResponse<LogisticRecordQueryRespDto> queryLogisticsRecordById(@PathVariable("id") String id);

    /**
     * 分页查询指定区域列表
     *
     * @param queryReqDto 查询参数
     * @return RestResponse<PageInfo<AppointAreaQueryRespDto>>
     */
    @PostMapping("/appointArea/list/queryList")
    @ApiOperation(value = "分页查询指定区域列表", notes = "分页查询指定区域列表")
    RestResponse<PageInfo<AppointAreaQueryRespDto>> queryAppointAreaList(@RequestBody AppointAreaQueryReqDto queryReqDto);


    /**
     *查询物流设置列表
     *
     * @param queryReqDto 查询参数
     * @return RestResponse<PageInfo<LogisticRecordQueryRespDto>>
     */
    @PostMapping("/query/list")
    @ApiOperation(value = "查询物流设置列表", notes = "查询物流设置列表")
    RestResponse<List<LogisticRecordQueryRespDto>> queryList(@RequestBody List<LogisticRecordExtReqDto> queryReqDto);

}
