package com.dtyunxi.finance.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.CarrierDeliveryAddressReqDto;
import com.dtyunxi.finance.api.dto.response.CarrierDeliveryAddressRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 承运方式发货地址表服务接口
*
* @author jiaye
* @since 2025-08-20
*/
@Api(tags = {"承运方式发货地址表服务"})
@FeignClient(
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/carrier/delivery",
    url = "${com.dtyunxi.finance.api:}"
)
public interface ICarrierDeliveryAddressApi {

/**
* 新增承运方式发货地址表
*
* @param addReqDto 承运方式发货地址表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增承运方式发货地址表", notes = "新增承运方式发货地址表")
RestResponse<Long> addCarrierDeliveryAddress(@RequestBody CarrierDeliveryAddressReqDto addReqDto);

    /**
    * 修改承运方式发货地址表
    *
    * @param modifyReqDto 承运方式发货地址表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改承运方式发货地址表", notes = "修改承运方式发货地址表")
    RestResponse<Void> modifyCarrierDeliveryAddress(@RequestBody CarrierDeliveryAddressReqDto modifyReqDto);

    /**
    * 删除承运方式发货地址表
    *
    * @param ids        承运方式发货地址表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除承运方式发货地址表", notes = "删除承运方式发货地址表")
    RestResponse<Void> removeCarrierDeliveryAddress(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
