package com.dtyunxi.finance.api.query;

import com.dtyunxi.finance.api.dto.request.ExpressAreaQueryReqDto;
import com.dtyunxi.finance.api.dto.request.ExpressCostContractQueryReqDto;
import com.dtyunxi.finance.api.dto.response.ExpressCostAreaRespDto;
import com.dtyunxi.finance.api.dto.response.ExpressCostContractRespDto;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 快递费用合同服务接口
 *
 * @author 天泽
 * @since 2022-11-10
 */
@Api(tags = {"快递费用合同服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-IExpressCostContractQueryApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/express/cost/contract",
        url = "${com.dtyunxi.finance.api:}"
)
public interface IExpressCostContractQueryApi {

    /**
     * 根据id查询快递费用合同
     *
     * @param id 快递费用合同id
     * @return 快递费用合同数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询快递费用合同", notes = "根据id查询快递费用合同")
    RestResponse<ExpressCostContractRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 快递费用合同分页数据
     *
     * @param reqDto 快递费用合同查询条件
     * @return 快递费用合同分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "快递费用合同分页数据", notes = "根据查询条件查询快递费用合同数据，ExpressCostContractQueryReqDto")
    RestResponse<PageInfo<ExpressCostContractRespDto>> queryByPage(@RequestBody ExpressCostContractQueryReqDto reqDto);
 /**
     * 快递费用合同分页数据
     *
     * @param reqDto 快递费用合同查询条件
     * @return 快递费用合同分页数据
     */
    @PostMapping("/area/page")
    @ApiOperation(value = "快递费用合同分页数据", notes = "根据查询条件查询快递费用合同数据，ExpressCostContractQueryReqDto")
    RestResponse<PageInfo<ExpressCostAreaRespDto>> queryAreaByPage(@RequestBody ExpressAreaQueryReqDto reqDto);


    @PostMapping("/queryAreaByAreaNames")
    @ApiOperation(value = "快递费用合同区域数据", notes = "快递费用合同区域数据")
    RestResponse<List<ExpressCostAreaRespDto>> queryAreaByAreaNames(@RequestBody ExpressAreaQueryReqDto reqDto);

}
