/**
 * @(#) SortingContractReportDetailRespDto.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.finance.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * SortingContractReportDetailRespDto
 */
@Data
@ApiModel(value = "SortingContractReportDetailRespDto", description = "")
public class SortingContractReportDetailRespDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "主键")
    @JsonProperty("id")
    private Long id;


    @ApiModelProperty(name = "contractName", value = "合同名称")
    @JsonProperty("contractName")
    private String contractName;
    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "physicalWarehouseCode", value = "仓库编码")
    @JsonProperty("physicalWarehouseCode")
    private String physicalWarehouseCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty(name = "physicalWarehouseName", value = "仓库名称")
    @JsonProperty("physicalWarehouseName")
    private String physicalWarehouseName;

    /**
     * 大箱单价
     */
    @ApiModelProperty(name = "largeBoxPrice", value = "大箱单价")
    @JsonProperty("largeBoxPrice")
    private BigDecimal largeBoxPrice;

    /**
     * 小箱单价
     */
    @ApiModelProperty(name = "smallBoxPrice", value = "小箱单价")
    @JsonProperty("smallBoxPrice")
    private BigDecimal smallBoxPrice;

    /**
     * 单品单价
     */
    @ApiModelProperty(name = "singlePrice", value = "单品单价")
    @JsonProperty("singlePrice")
    private BigDecimal singlePrice;

    /**
     * 有效时间开始日期
     */
    @ApiModelProperty(name = "saleOrderCreateStartTime", value = "有效时间开始日期")
    @JsonProperty("saleOrderCreateStartTime")
    private String saleOrderCreateStartTime;

    /**
     * 有效时间结束日期
     */
    @ApiModelProperty(name = "saleOrderCreateEndTime", value = "有效时间结束日期")
    @JsonProperty("saleOrderCreateEndTime")
    private String saleOrderCreateEndTime;


    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    @JsonProperty("remark")
    private String remark;

    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "状态")
    @JsonProperty("status")
    private Integer status;


    protected String createPerson;

    protected Date createTime;

    protected String updatePerson;

    /***
     * 修改记录
     */
    List<SortingContractChangeRecordRespDto> list = new ArrayList();

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SortingContractReportDetailRespDto that = (SortingContractReportDetailRespDto) o;

        return id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }
}

