package com.dtyunxi.finance.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.InsuranceSettingsReqDto;
import com.dtyunxi.finance.api.dto.response.InsuranceSettingsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 保险公司投保设置服务接口
*
* @author longde
* @since 2022-07-15
*/
@Api(tags = {"保险公司投保设置服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-IInsuranceSettingsApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/insurance/settings",
    url = "${com.dtyunxi.finance.api:}"
)
public interface IInsuranceSettingsApi {

/**
* 新增保险公司投保设置
*
* @param addReqDto 保险公司投保设置请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增保险公司投保设置", notes = "新增保险公司投保设置")
RestResponse<Long> addInsuranceSettings(@RequestBody InsuranceSettingsReqDto addReqDto);

    /**
    * 修改保险公司投保设置
    *
    * @param modifyReqDto 保险公司投保设置请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改保险公司投保设置", notes = "修改保险公司投保设置")
    RestResponse<Void> modifyInsuranceSettings(@RequestBody InsuranceSettingsReqDto modifyReqDto);

    /**
    * 删除保险公司投保设置
    *
    * @param id       保险公司投保设置删除数据ID
    * @param
    * @return 处理结果
    */
    @PostMapping("/{id}")
    @ApiOperation(value = "删除保险公司投保设置", notes = "删除保险公司投保设置")
    RestResponse<Void> removeInsuranceSettings(@PathVariable("id") Long id);


}
