/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.finance.api.dto.request.InsuranceSettingsReqDto;
import com.dtyunxi.finance.api.dto.response.InsuranceSettingsLogRespDto;
import com.dtyunxi.finance.api.dto.response.InsuranceSettingsRespDto;
import com.dtyunxi.finance.biz.service.IInsuranceSettingsLogService;
import com.dtyunxi.finance.biz.service.IInsuranceSettingsService;
import com.dtyunxi.finance.biz.util.AssertUtil;
import com.dtyunxi.finance.dao.das.InsuranceSettingsDas;
import com.dtyunxi.finance.dao.das.InsuranceSettingsLogDas;
import com.dtyunxi.finance.dao.das.LogisticsSettingsDas;
import com.dtyunxi.finance.dao.eo.InsuranceSettingsEo;
import com.dtyunxi.finance.dao.eo.InsuranceSettingsLogEo;
import com.dtyunxi.finance.dao.eo.LogisticsSettingsEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InsuranceSettingsServiceImpl
implements IInsuranceSettingsService {
    @Resource
    private InsuranceSettingsDas insuranceSettingsDas;
    @Resource
    private InsuranceSettingsLogDas insuranceSettingsLogDas;
    @Resource
    private LogisticsSettingsDas logisticsSettingsDas;
    @Resource
    private IInsuranceSettingsLogService InsuranceSetttingsLogService;

    @Override
    public Long addInsuranceSettings(InsuranceSettingsReqDto addReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addReqDto.getInsuranceCompanyName()), "\u6295\u4fdd\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(addReqDto.getRate()), "\u8d39\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        InsuranceSettingsEo insuranceSettingsEo = new InsuranceSettingsEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)insuranceSettingsEo);
        InsuranceSettingsEo queryResult = (InsuranceSettingsEo)this.insuranceSettingsDas.selectByLogicKey((Object)addReqDto.getInsuranceCompanyName());
        AssertUtil.isTrue(queryResult == null, "\u4fdd\u9669\u516c\u53f8\u540d\u79f0\u91cd\u590d");
        String insuranceCode = "BX" + IdGenrator.nextId((long)2L, (long)1L);
        insuranceSettingsEo.setInsuranceCode(insuranceCode);
        insuranceSettingsEo.setInsuranceName(addReqDto.getInsuranceCompanyName());
        insuranceSettingsEo.setInsuranceRate(addReqDto.getRate());
        insuranceSettingsEo.setCreateTime(new Date());
        insuranceSettingsEo.setUpdateTime(new Date());
        this.insuranceSettingsDas.insert((BaseEo)insuranceSettingsEo);
        return insuranceSettingsEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyInsuranceSettings(InsuranceSettingsReqDto modifyReqDto) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)modifyReqDto.getInsuranceCompanyName()), "\u6295\u4fdd\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(modifyReqDto.getRate()), "\u8d39\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(modifyReqDto.getId()), "id\u4e0d\u80fd\u4e3a\u7a7a");
        InsuranceSettingsEo insuranceSettingsEo = new InsuranceSettingsEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)insuranceSettingsEo);
        insuranceSettingsEo.setInsuranceName(modifyReqDto.getInsuranceCompanyName());
        insuranceSettingsEo.setInsuranceRate(modifyReqDto.getRate());
        InsuranceSettingsEo queryDto = (InsuranceSettingsEo)this.insuranceSettingsDas.selectByPrimaryKey(modifyReqDto.getId());
        if (queryDto.getInsuranceName().equals(modifyReqDto.getInsuranceCompanyName()) && queryDto.getInsuranceRate().compareTo(modifyReqDto.getRate()) == 0) {
            AssertUtil.isTrue(false, "\u6ca1\u6709\u8981\u4fee\u6539\u7684\u5b57\u6bb5");
        }
        if (!queryDto.getInsuranceName().equals(modifyReqDto.getInsuranceCompanyName())) {
            InsuranceSettingsEo queryOne = (InsuranceSettingsEo)this.insuranceSettingsDas.selectByLogicKey((Object)modifyReqDto.getInsuranceCompanyName());
            AssertUtil.isTrue(queryOne == null, "\u4fee\u6539\u7684\u4fdd\u9669\u516c\u53f8\u540d\u79f0\u91cd\u590d");
            InsuranceSettingsLogEo insuranceNameLogEo = new InsuranceSettingsLogEo();
            insuranceNameLogEo.setModifyColumn("\u4fdd\u9669\u516c\u53f8\u540d\u79f0");
            insuranceNameLogEo.setSettingsId(queryDto.getId());
            insuranceNameLogEo.setValueBefore(queryDto.getInsuranceName());
            insuranceNameLogEo.setValueAfter(modifyReqDto.getInsuranceCompanyName());
            this.insuranceSettingsLogDas.insert((BaseEo)insuranceNameLogEo);
        }
        if (queryDto.getInsuranceRate().compareTo(modifyReqDto.getRate()) != 0) {
            InsuranceSettingsLogEo insuranceRateLogEo = new InsuranceSettingsLogEo();
            insuranceRateLogEo.setModifyColumn("\u4fdd\u9669\u8d39\u7387");
            insuranceRateLogEo.setSettingsId(queryDto.getId());
            insuranceRateLogEo.setValueBefore(queryDto.getInsuranceRate().toString());
            insuranceRateLogEo.setValueAfter(modifyReqDto.getRate().toString());
            this.insuranceSettingsLogDas.insert((BaseEo)insuranceRateLogEo);
        }
        this.insuranceSettingsDas.updateSelective((BaseEo)insuranceSettingsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInsuranceSettings(Long id) {
        LogisticsSettingsEo queryLogisticsId = new LogisticsSettingsEo();
        queryLogisticsId.setInsuranceId(id);
        List logisticsSettingsEos = this.logisticsSettingsDas.selectWithColumn((BaseEo)queryLogisticsId, new String[]{"insurance_id"});
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)logisticsSettingsEos), "\u5220\u9664\u5931\u8d25\uff0c\u4fdd\u9669\u516c\u53f8\u5df2\u5173\u8054\u7269\u6d41\u516c\u53f8");
        this.insuranceSettingsDas.logicDeleteById(Long.valueOf(id));
    }

    @Override
    public InsuranceSettingsRespDto queryById(Long id) {
        InsuranceSettingsEo insuranceSettingsEo = (InsuranceSettingsEo)this.insuranceSettingsDas.selectByPrimaryKey(id);
        InsuranceSettingsRespDto insuranceSettingsRespDto = new InsuranceSettingsRespDto();
        DtoHelper.eo2Dto((BaseEo)insuranceSettingsEo, (BaseVo)insuranceSettingsRespDto);
        InsuranceSettingsLogEo insuranceSettingsLogEo = new InsuranceSettingsLogEo();
        insuranceSettingsLogEo.setSettingsId(insuranceSettingsEo.getId());
        List insuranceSettingsLogList = this.insuranceSettingsLogDas.selectList((BaseEo)insuranceSettingsLogEo);
        ArrayList<InsuranceSettingsLogRespDto> modifyRecords = new ArrayList<InsuranceSettingsLogRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)insuranceSettingsLogList)) {
            for (InsuranceSettingsLogEo insuranceSettingsLog : insuranceSettingsLogList) {
                InsuranceSettingsLogRespDto insuranceSettingsLogRespDto = new InsuranceSettingsLogRespDto();
                DtoHelper.eo2Dto((BaseEo)insuranceSettingsLog, (BaseVo)insuranceSettingsLogRespDto);
                insuranceSettingsLogRespDto.setValueBefore(insuranceSettingsLog.getValueBefore());
                insuranceSettingsLogRespDto.setValueAfter(insuranceSettingsLog.getValueAfter());
                insuranceSettingsLogRespDto.setModifyColumn(insuranceSettingsLog.getModifyColumn());
                modifyRecords.add(insuranceSettingsLogRespDto);
            }
        }
        insuranceSettingsRespDto.setModifyRecords(modifyRecords);
        return insuranceSettingsRespDto;
    }

    @Override
    public PageInfo<InsuranceSettingsRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InsuranceSettingsReqDto insuranceSettingsReqDto = (InsuranceSettingsReqDto)JSON.parseObject((String)filter, InsuranceSettingsReqDto.class);
        InsuranceSettingsEo insuranceSettingsEo = new InsuranceSettingsEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        insuranceSettingsEo.setId(insuranceSettingsReqDto.getId());
        insuranceSettingsEo.setInsuranceCode(insuranceSettingsReqDto.getInsuranceCode());
        if (StringUtils.isNotBlank((CharSequence)insuranceSettingsReqDto.getInsuranceCompanyName())) {
            sqlFilters.add(SqlFilter.like((String)"insurance_name", (Object)("%" + insuranceSettingsReqDto.getInsuranceCompanyName() + "%")));
        }
        insuranceSettingsEo.setSqlFilters(sqlFilters);
        insuranceSettingsEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.insuranceSettingsDas.selectPage((BaseEo)insuranceSettingsEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InsuranceSettingsRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<InsuranceSettingsRespDto> queryAllInsurance() {
        List insuranceSettingsEoList = this.insuranceSettingsDas.getMapper().selectList((Wrapper)new QueryWrapper().select(new String[]{"distinct insurance_name,id"}).lambda().eq(BaseEo::getDr, (Object)"0"));
        ArrayList<InsuranceSettingsRespDto> dtoList = new ArrayList<InsuranceSettingsRespDto>();
        DtoHelper.eoList2DtoList((Collection)insuranceSettingsEoList, dtoList, InsuranceSettingsRespDto.class);
        return dtoList;
    }
}

