/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.apiimpl.query;

import com.dtyunxi.finance.api.dto.request.logistic.AppointAreaQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordExtReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.OilLinkQueryReqDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilChangeQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkQueryRespDto;
import com.dtyunxi.finance.api.query.ILogisticQueryApi;
import com.dtyunxi.finance.biz.service.query.IAppointAreaQueryService;
import com.dtyunxi.finance.biz.service.query.ILogisticRecordQueryService;
import com.dtyunxi.finance.biz.service.query.IOilChangeQueryService;
import com.dtyunxi.finance.biz.service.query.IOilLinkQueryService;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="logisticQueryApi")
public class LogisticQueryApiImpl
implements ILogisticQueryApi {
    @Resource
    private IOilLinkQueryService oilLinkQueryService;
    @Resource
    private IOilChangeQueryService oilChangeQueryService;
    @Resource
    private IAppointAreaQueryService appointAreaQueryService;
    @Resource
    private ILogisticRecordQueryService logisticRecordQueryService;

    public RestResponse<List<OilChangeQueryRespDto>> queryByType(String type) {
        List<OilChangeQueryRespDto> respDtoList = this.oilChangeQueryService.selectListByType(type);
        return new RestResponse(respDtoList);
    }

    public RestResponse<PageInfo<OilLinkQueryRespDto>> queryOilLinkList(OilLinkQueryReqDto queryReqDto) {
        PageInfo<OilLinkQueryRespDto> pageInfo = this.oilLinkQueryService.queryByPage(queryReqDto);
        return new RestResponse(pageInfo);
    }

    public RestResponse<PageInfo<LogisticRecordQueryRespDto>> queryLogisticsRecordList(LogisticRecordQueryReqDto queryReqDto) {
        PageInfo<LogisticRecordQueryRespDto> pageInfo = this.logisticRecordQueryService.queryByPage(queryReqDto);
        return new RestResponse(pageInfo);
    }

    public RestResponse<LogisticRecordQueryRespDto> queryLogisticsRecordById(String id) {
        LogisticRecordQueryRespDto respDto = this.logisticRecordQueryService.queryLogisticRecordById(Long.valueOf(id));
        return new RestResponse((Object)respDto);
    }

    public RestResponse<PageInfo<AppointAreaQueryRespDto>> queryAppointAreaList(AppointAreaQueryReqDto queryReqDto) {
        PageInfo<AppointAreaQueryRespDto> pageInfo = this.appointAreaQueryService.queryByPage(queryReqDto);
        return new RestResponse(pageInfo);
    }

    public RestResponse<List<LogisticRecordQueryRespDto>> queryList(List<LogisticRecordExtReqDto> queryReqDto) {
        return new RestResponse(this.logisticRecordQueryService.queryByLst(queryReqDto));
    }
}

