/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.finance.api.dto.request.SortingContractListQueryReqDto;
import com.dtyunxi.finance.api.dto.request.SortingContractReportAddReqDto;
import com.dtyunxi.finance.api.dto.request.SortingContractReportCopyReqDto;
import com.dtyunxi.finance.api.dto.request.SortingContractReportDeleteReqDto;
import com.dtyunxi.finance.api.dto.request.SortingContractReportDetailQueryReqDto;
import com.dtyunxi.finance.api.dto.request.SortingContractReportEditReqDto;
import com.dtyunxi.finance.api.dto.request.SortingContractReportToVoidReqDto;
import com.dtyunxi.finance.api.dto.response.SortingContractChangeRecordRespDto;
import com.dtyunxi.finance.api.dto.response.SortingContractReportDetailRespDto;
import com.dtyunxi.finance.api.exception.FinanceException;
import com.dtyunxi.finance.api.exception.FinanceExceptionEnum;
import com.dtyunxi.finance.api.exception.constant.SortingContractFieldEnum;
import com.dtyunxi.finance.api.exception.constant.SortingContractStatusEnum;
import com.dtyunxi.finance.biz.service.SortingContractReportService;
import com.dtyunxi.finance.dao.das.SortingContractChangeRecordDas;
import com.dtyunxi.finance.dao.das.SortingContractDas;
import com.dtyunxi.finance.dao.eo.SortingContractChangeRecordEo;
import com.dtyunxi.finance.dao.eo.SortingContractEo;
import com.dtyunxi.finance.dao.po.SortingContractListQueryPo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class SortingContractReportServiceImpl
implements SortingContractReportService {
    private static final Logger log = LoggerFactory.getLogger(SortingContractReportServiceImpl.class);
    @Resource
    SortingContractDas sortingContractDas;
    @Resource
    SortingContractChangeRecordDas sortingContractChangeRecordDas;

    @Override
    @Transactional
    public RestResponse<List<SortingContractReportDetailRespDto>> getSortingContractReportAdd(@ApiParam(value="") @Valid @RequestBody(required=false) SortingContractReportAddReqDto sortingContractReportAddReqDto) {
        SortingContractEo sortingContractEo = new SortingContractEo();
        DtoHelper.dto2Eo((BaseVo)sortingContractReportAddReqDto, (BaseEo)sortingContractEo);
        String startTime = sortingContractReportAddReqDto.getSaleOrderCreateStartTime();
        String endTime = sortingContractReportAddReqDto.getSaleOrderCreateEndTime();
        Date startDate = DateUtil.parse((String)startTime, (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = DateUtil.parse((String)endTime, (String)"yyyy-MM-dd HH:mm:ss");
        sortingContractEo.setSaleOrderCreateStartTime(startDate);
        sortingContractEo.setSaleOrderCreateEndTime(endDate);
        if (startDate.getTime() > endDate.getTime()) {
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.INVALID_DATE);
        }
        if (endDate.getTime() < System.currentTimeMillis()) {
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.SORTING_CONTRACT_END_TIME_LOSE_EFFECT);
        }
        SortingContractEo example = new SortingContractEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        example.setSqlFilters(sqlFilters);
        sqlFilters.add(SqlFilter.eq((String)"physical_warehouse_code", (Object)sortingContractReportAddReqDto.getPhysicalWarehouseCode()));
        sqlFilters.add(SqlFilter.gt((String)"sale_order_create_end_time", (Object)new Date()));
        List validList = this.sortingContractDas.select((BaseEo)example);
        Set<SortingContractReportDetailRespDto> intersect = new HashSet<SortingContractReportDetailRespDto>();
        intersect = this.getIntersect(startDate, endDate, validList, intersect);
        if (CollectionUtils.isNotEmpty(intersect)) {
            return new RestResponse(new ArrayList<SortingContractReportDetailRespDto>(intersect));
        }
        sortingContractEo.setStatus(SortingContractStatusEnum.DEFAULT.getCode());
        sortingContractEo.setLargeBoxPrice(new BigDecimal(sortingContractReportAddReqDto.getLargeBoxPrice()));
        sortingContractEo.setSmallBoxPrice(new BigDecimal(sortingContractReportAddReqDto.getSmallBoxPrice()));
        sortingContractEo.setSinglePrice(new BigDecimal(sortingContractReportAddReqDto.getSinglePrice()));
        this.sortingContractDas.insert((BaseEo)sortingContractEo);
        return new RestResponse(new ArrayList());
    }

    private Set<SortingContractReportDetailRespDto> getIntersect(Date startDate, Date endDate, List<SortingContractEo> list, Set<SortingContractReportDetailRespDto> intersect) {
        if (CollectionUtils.isEmpty(list)) {
            return intersect;
        }
        if (startDate.getTime() < endDate.getTime()) {
            for (SortingContractEo contractEo : list) {
                if (contractEo.getStatus().equals(SortingContractStatusEnum.TO_VOID.getCode())) continue;
                this.getStatus(contractEo);
                long a = contractEo.getSaleOrderCreateStartTime().getTime();
                long b = contractEo.getSaleOrderCreateEndTime().getTime();
                long c = startDate.getTime();
                long d = endDate.getTime();
                if (a <= c && b >= c || a <= d && d <= b) {
                    SortingContractReportDetailRespDto detailRespDto = new SortingContractReportDetailRespDto();
                    BeanUtils.copyProperties((Object)contractEo, (Object)detailRespDto);
                    detailRespDto.setSaleOrderCreateStartTime(DateUtil.format((Date)contractEo.getSaleOrderCreateStartTime()));
                    detailRespDto.setSaleOrderCreateEndTime(DateUtil.format((Date)contractEo.getSaleOrderCreateEndTime()));
                    intersect.add(detailRespDto);
                }
                startDate = DateUtil.addDay((Date)startDate, (int)1);
                this.getIntersect(startDate, endDate, list, intersect);
                return intersect;
            }
        }
        return intersect;
    }

    @Override
    public RestResponse<PageInfo<Object>> getSortingContractReportCopy(@ApiParam(value="") @Valid @RequestBody(required=false) SortingContractReportCopyReqDto sortingContractReportCopyReqDto) {
        SortingContractEo sortingContractEo = new SortingContractEo();
        DtoHelper.dto2Eo((BaseVo)sortingContractReportCopyReqDto, (BaseEo)sortingContractEo);
        this.sortingContractDas.insert((BaseEo)sortingContractEo);
        return new RestResponse();
    }

    @Override
    @Transactional
    public RestResponse<PageInfo<Object>> getSortingContractReportDelete(@ApiParam(value="") @Valid @RequestBody(required=false) SortingContractReportDeleteReqDto sortingContractReportDeleteReqDto) {
        this.sortingContractDas.logicDeleteById(sortingContractReportDeleteReqDto.getId());
        return new RestResponse();
    }

    @Override
    public RestResponse<SortingContractReportDetailRespDto> getSortingContractReportDetail(@ApiParam(value="") @Valid @RequestBody(required=false) SortingContractReportDetailQueryReqDto sortingContractReportDetailQueryReqDto) {
        Long id = sortingContractReportDetailQueryReqDto.getId();
        SortingContractEo example = new SortingContractEo(id);
        example.setPhysicalWarehouseCode(sortingContractReportDetailQueryReqDto.getPhysicalWarehouseCode());
        Integer status = example.getStatus();
        if (SortingContractStatusEnum.EFFECT.getCode().equals(status)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.lt((String)"sale_order_create_start_time", (Object)new Date()));
            sqlFilters.add(SqlFilter.gt((String)"sale_order_create_end_time", (Object)new Date()));
            example.setSqlFilters(sqlFilters);
        }
        SortingContractEo sortingContractEo = (SortingContractEo)this.sortingContractDas.selectOne((BaseEo)example);
        this.validateExist(sortingContractEo);
        SortingContractReportDetailRespDto detailRespDto = new SortingContractReportDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)sortingContractEo, (BaseVo)detailRespDto);
        this.getStatus(sortingContractEo);
        detailRespDto.setStatus(sortingContractEo.getStatus());
        detailRespDto.setSaleOrderCreateStartTime(DateUtil.format((Date)sortingContractEo.getSaleOrderCreateStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        detailRespDto.setSaleOrderCreateEndTime(DateUtil.format((Date)sortingContractEo.getSaleOrderCreateEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        List<SortingContractChangeRecordRespDto> list = this.getChangeRecords(sortingContractEo);
        detailRespDto.setList(list);
        return new RestResponse((Object)detailRespDto);
    }

    private void getStatus(SortingContractEo sortingContractEo) {
        Date startDate = sortingContractEo.getSaleOrderCreateStartTime();
        Date endDate = sortingContractEo.getSaleOrderCreateEndTime();
        Integer status = sortingContractEo.getStatus();
        if (Objects.isNull(status) || !status.equals(SortingContractStatusEnum.TO_VOID.getCode())) {
            if (startDate.getTime() > System.currentTimeMillis()) {
                sortingContractEo.setStatus(SortingContractStatusEnum.WAIT_EFFECT.getCode());
            }
            if (startDate.getTime() <= System.currentTimeMillis() && endDate.getTime() > System.currentTimeMillis()) {
                sortingContractEo.setStatus(SortingContractStatusEnum.EFFECT.getCode());
            }
            if (endDate.getTime() < System.currentTimeMillis()) {
                sortingContractEo.setStatus(SortingContractStatusEnum.LOSE_EFFECT.getCode());
            }
        }
    }

    private List<SortingContractChangeRecordRespDto> getChangeRecords(SortingContractEo sortingContractEo) {
        ArrayList<SortingContractChangeRecordRespDto> list = new ArrayList<SortingContractChangeRecordRespDto>();
        SortingContractChangeRecordEo sortingContractChangeRecordEo = new SortingContractChangeRecordEo();
        sortingContractChangeRecordEo.setContractId(sortingContractEo.getId());
        List records = this.sortingContractChangeRecordDas.select((BaseEo)sortingContractChangeRecordEo);
        log.info("getChangeRecords:{}", (Object)JSON.toJSONString((Object)records));
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            for (SortingContractChangeRecordEo record : records) {
                SortingContractChangeRecordRespDto recordRespDto = new SortingContractChangeRecordRespDto();
                BeanUtils.copyProperties((Object)record, (Object)recordRespDto);
                recordRespDto.setModifyField(record.getField());
                recordRespDto.setBeforeModification(record.getFieldBeforeValue());
                recordRespDto.setAfterModification(record.getFieldAfterValue());
                recordRespDto.setContractName(sortingContractEo.getContractName());
                list.add(recordRespDto);
            }
        }
        return list;
    }

    @Override
    public RestResponse<Set<SortingContractReportDetailRespDto>> getSortingContractReportEdit(@ApiParam(value="") @Valid @RequestBody(required=false) SortingContractReportEditReqDto sortingContractReportEditReqDto) {
        log.info("\u5408\u540c\u7f16\u8f91\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)sortingContractReportEditReqDto));
        SortingContractEo example = new SortingContractEo();
        Long id = sortingContractReportEditReqDto.getId();
        example.setId(id);
        SortingContractEo sortingContractEo = (SortingContractEo)this.sortingContractDas.selectOne((BaseEo)example);
        this.validateExist(sortingContractEo);
        example = new SortingContractEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        example.setSqlFilters(sqlFilters);
        sqlFilters.add(SqlFilter.eq((String)"physical_warehouse_code", (Object)sortingContractEo.getPhysicalWarehouseCode()));
        sqlFilters.add(SqlFilter.ne((String)"id", (Object)id));
        sqlFilters.add(SqlFilter.gt((String)"sale_order_create_end_time", (Object)new Date()));
        List validList = this.sortingContractDas.select((BaseEo)example);
        String startTime = sortingContractReportEditReqDto.getSaleOrderCreateStartTime();
        String endTime = sortingContractReportEditReqDto.getSaleOrderCreateEndTime();
        Date startDate = DateUtil.parse((String)startTime, (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = DateUtil.parse((String)endTime, (String)"yyyy-MM-dd HH:mm:ss");
        Set<SortingContractReportDetailRespDto> intersect = new HashSet<SortingContractReportDetailRespDto>();
        intersect = this.getIntersect(startDate, endDate, validList, intersect);
        log.info("\u7f16\u8f91\u6821\u9a8c\u65f6\u95f4\u4ea4\u96c6\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(intersect));
        if (CollectionUtils.isNotEmpty(intersect)) {
            return new RestResponse(intersect);
        }
        ArrayList<SortingContractChangeRecordEo> list = new ArrayList<SortingContractChangeRecordEo>();
        String physicalWarehouseCodeOld = sortingContractEo.getPhysicalWarehouseCode();
        String physicalWarehouseCodeNew = sortingContractReportEditReqDto.getPhysicalWarehouseCode();
        if (Objects.nonNull(physicalWarehouseCodeNew) && !physicalWarehouseCodeNew.equals(physicalWarehouseCodeOld)) {
            SortingContractChangeRecordEo sortingContractChangeRecordEo = new SortingContractChangeRecordEo();
            sortingContractChangeRecordEo.setField(SortingContractFieldEnum.PHYSICAL_WAREHOUSE_CODE.getFieldDesc());
            sortingContractChangeRecordEo.setContractId(id);
            sortingContractChangeRecordEo.setFieldBeforeValue(physicalWarehouseCodeOld);
            sortingContractChangeRecordEo.setFieldAfterValue(physicalWarehouseCodeNew);
            list.add(sortingContractChangeRecordEo);
            sortingContractEo.setPhysicalWarehouseCode(physicalWarehouseCodeNew);
        }
        String physicalWarehouseNameOld = sortingContractEo.getPhysicalWarehouseName();
        String physicalWarehouseNameNew = sortingContractReportEditReqDto.getPhysicalWarehouseName();
        if (Objects.nonNull(physicalWarehouseNameNew) && !physicalWarehouseNameNew.equals(physicalWarehouseNameOld)) {
            SortingContractChangeRecordEo sortingContractChangeRecordEo = new SortingContractChangeRecordEo();
            sortingContractChangeRecordEo.setField(SortingContractFieldEnum.PHYSICAL_WAREHOUSE_CODE.getFieldDesc());
            sortingContractChangeRecordEo.setContractId(id);
            sortingContractChangeRecordEo.setFieldBeforeValue(physicalWarehouseNameOld);
            sortingContractChangeRecordEo.setFieldAfterValue(physicalWarehouseNameNew);
            list.add(sortingContractChangeRecordEo);
            sortingContractEo.setPhysicalWarehouseName(physicalWarehouseNameNew);
        }
        String contractNameOld = sortingContractEo.getContractName();
        String contractNameNew = sortingContractReportEditReqDto.getContractName();
        if (Objects.nonNull(contractNameNew) && !contractNameNew.equals(contractNameOld)) {
            SortingContractChangeRecordEo sortingContractChangeRecordEo = new SortingContractChangeRecordEo();
            sortingContractChangeRecordEo.setField(SortingContractFieldEnum.CONTRACT_NAME.getFieldDesc());
            sortingContractChangeRecordEo.setContractId(id);
            sortingContractChangeRecordEo.setFieldBeforeValue(contractNameOld);
            sortingContractChangeRecordEo.setFieldAfterValue(contractNameNew);
            list.add(sortingContractChangeRecordEo);
            sortingContractEo.setContractName(contractNameNew);
        }
        BigDecimal largeBoxPriceOld = sortingContractEo.getLargeBoxPrice();
        String largeBoxPriceNew = sortingContractReportEditReqDto.getLargeBoxPrice();
        if (Objects.nonNull(largeBoxPriceNew) && new BigDecimal(largeBoxPriceNew).compareTo(largeBoxPriceOld) != 0) {
            SortingContractChangeRecordEo sortingContractChangeRecordEo = new SortingContractChangeRecordEo();
            sortingContractChangeRecordEo.setField(SortingContractFieldEnum.LARGE_BOX_PRICE.getFieldDesc());
            sortingContractChangeRecordEo.setContractId(id);
            sortingContractChangeRecordEo.setFieldBeforeValue(largeBoxPriceOld.toString());
            sortingContractChangeRecordEo.setFieldAfterValue(new BigDecimal(largeBoxPriceNew).toString());
            list.add(sortingContractChangeRecordEo);
            sortingContractEo.setLargeBoxPrice(new BigDecimal(largeBoxPriceNew));
        }
        BigDecimal smallBoxPriceOld = sortingContractEo.getSmallBoxPrice();
        String smallBoxPriceNew = sortingContractReportEditReqDto.getSmallBoxPrice();
        if (Objects.nonNull(smallBoxPriceNew) && new BigDecimal(smallBoxPriceNew).compareTo(smallBoxPriceOld) != 0) {
            SortingContractChangeRecordEo sortingContractChangeRecordEo = new SortingContractChangeRecordEo();
            sortingContractChangeRecordEo.setField(SortingContractFieldEnum.SMALL_BOX_PRICE.getFieldDesc());
            sortingContractChangeRecordEo.setContractId(id);
            sortingContractChangeRecordEo.setFieldBeforeValue(smallBoxPriceOld.toString());
            sortingContractChangeRecordEo.setFieldAfterValue(new BigDecimal(smallBoxPriceNew).toString());
            list.add(sortingContractChangeRecordEo);
            sortingContractEo.setSmallBoxPrice(new BigDecimal(smallBoxPriceNew));
        }
        BigDecimal singleProductPriceOld = sortingContractEo.getSinglePrice();
        String singleProductPriceNew = sortingContractReportEditReqDto.getSinglePrice();
        if (Objects.nonNull(singleProductPriceNew) && new BigDecimal(singleProductPriceNew).compareTo(singleProductPriceOld) != 0) {
            SortingContractChangeRecordEo sortingContractChangeRecordEo = new SortingContractChangeRecordEo();
            sortingContractChangeRecordEo.setField(SortingContractFieldEnum.SINGLE_PRODUCT_PRICE.getFieldDesc());
            sortingContractChangeRecordEo.setContractId(id);
            sortingContractChangeRecordEo.setFieldBeforeValue(singleProductPriceOld.toString());
            sortingContractChangeRecordEo.setFieldAfterValue(new BigDecimal(singleProductPriceNew).toString());
            list.add(sortingContractChangeRecordEo);
            sortingContractEo.setSinglePrice(new BigDecimal(singleProductPriceNew));
        }
        Date startTimeOld = sortingContractEo.getSaleOrderCreateStartTime();
        String startNew = sortingContractReportEditReqDto.getSaleOrderCreateStartTime();
        if (Objects.nonNull(startNew) && !DateUtil.format((Date)startTimeOld, (String)"yyyy-MM-dd HH:mm:ss").equals(startNew)) {
            SortingContractChangeRecordEo sortingContractChangeRecordEo = new SortingContractChangeRecordEo();
            sortingContractChangeRecordEo.setField(SortingContractFieldEnum.SALE_ORDER_CREATE_START_TIME.getFieldDesc());
            sortingContractChangeRecordEo.setContractId(id);
            sortingContractChangeRecordEo.setFieldBeforeValue(DateUtil.format((Date)startTimeOld));
            sortingContractChangeRecordEo.setFieldAfterValue(startNew);
            list.add(sortingContractChangeRecordEo);
            sortingContractEo.setSaleOrderCreateStartTime(startDate);
        }
        Date endTimeOld = sortingContractEo.getSaleOrderCreateEndTime();
        String endTimeNew = sortingContractReportEditReqDto.getSaleOrderCreateEndTime();
        if (Objects.nonNull(endTimeNew) && !DateUtil.format((Date)endTimeOld, (String)"yyyy-MM-dd HH:mm:ss").equals(endTimeNew)) {
            SortingContractChangeRecordEo sortingContractChangeRecordEo = new SortingContractChangeRecordEo();
            sortingContractChangeRecordEo.setField(SortingContractFieldEnum.SALE_ORDER_CREATE_END_TIME.getFieldDesc());
            sortingContractChangeRecordEo.setContractId(id);
            sortingContractChangeRecordEo.setFieldBeforeValue(DateUtil.format((Date)endTimeOld));
            sortingContractChangeRecordEo.setFieldAfterValue(endTimeNew);
            list.add(sortingContractChangeRecordEo);
            sortingContractEo.setSaleOrderCreateEndTime(endDate);
        }
        String remarkOld = sortingContractEo.getRemark();
        String remarkNew = sortingContractReportEditReqDto.getRemark();
        if (Objects.nonNull(remarkNew) && !remarkNew.equals(remarkOld)) {
            SortingContractChangeRecordEo sortingContractChangeRecordEo = new SortingContractChangeRecordEo();
            sortingContractChangeRecordEo.setField(SortingContractFieldEnum.REMARK.getFieldDesc());
            sortingContractChangeRecordEo.setContractId(id);
            sortingContractChangeRecordEo.setFieldBeforeValue(remarkOld);
            sortingContractChangeRecordEo.setFieldAfterValue(remarkNew);
            list.add(sortingContractChangeRecordEo);
            sortingContractEo.setRemark(remarkNew);
        }
        sortingContractEo.setSaleOrderCreateStartTime(startDate);
        sortingContractEo.setSaleOrderCreateEndTime(endDate);
        this.sortingContractDas.updateSelective((BaseEo)sortingContractEo);
        this.sortingContractChangeRecordDas.insertBatch(list);
        return new RestResponse(intersect);
    }

    @Override
    public RestResponse<PageInfo<SortingContractReportDetailRespDto>> getSortingContractReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) SortingContractListQueryReqDto sortingContractListQueryReqDto) {
        SortingContractListQueryPo po = new SortingContractListQueryPo();
        CubeBeanUtils.copyProperties((Object)po, (Object)sortingContractListQueryReqDto, (String[])new String[0]);
        if (StringUtils.isNotBlank((CharSequence)sortingContractListQueryReqDto.getStatus()) && Objects.equals("5", sortingContractListQueryReqDto.getStatus())) {
            po.setSaleOrderCreateEndTimeExt(po.getSaleOrderCreateEndTime());
            po.setSaleOrderCreateStartTimeExt(po.getSaleOrderCreateStartTime());
            po.setSaleOrderCreateStartTime(null);
            po.setSaleOrderCreateEndTime(null);
        }
        PageInfo eoPageInfo = this.sortingContractDas.queryDataByPage(po);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<SortingContractReportDetailRespDto> dtoList = new ArrayList<SortingContractReportDetailRespDto>();
        for (SortingContractEo contractEo : eoPageInfo.getList()) {
            SortingContractReportDetailRespDto detailRespDto = new SortingContractReportDetailRespDto();
            DtoHelper.eo2Dto((BaseEo)contractEo, (BaseVo)detailRespDto);
            detailRespDto.setSaleOrderCreateStartTime(DateUtil.format((Date)contractEo.getSaleOrderCreateStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            detailRespDto.setSaleOrderCreateEndTime(DateUtil.format((Date)contractEo.getSaleOrderCreateEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.getStatus(contractEo);
            Integer nowStatus = contractEo.getStatus();
            detailRespDto.setStatus(nowStatus);
            dtoList.add(detailRespDto);
        }
        dtoPageInfo.setList(dtoList);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            for (SortingContractReportDetailRespDto detailRespDto : dtoList) {
                Long id = detailRespDto.getId();
                SortingContractChangeRecordEo recordEo = new SortingContractChangeRecordEo(id);
                List recordList = this.sortingContractChangeRecordDas.select((BaseEo)recordEo);
                List<SortingContractChangeRecordRespDto> records = this.getChangeRecordRespDtoList(recordList);
                detailRespDto.setList(records);
            }
        }
        return new RestResponse((Object)dtoPageInfo);
    }

    private List<SortingContractChangeRecordRespDto> getChangeRecordRespDtoList(List<SortingContractChangeRecordEo> recordList) {
        ArrayList<SortingContractChangeRecordRespDto> records = new ArrayList<SortingContractChangeRecordRespDto>();
        if (CollectionUtils.isNotEmpty(recordList)) {
            for (SortingContractChangeRecordEo sortingContractChangeRecordEo : recordList) {
                SortingContractChangeRecordRespDto recordRespDto = new SortingContractChangeRecordRespDto();
                BeanUtils.copyProperties((Object)sortingContractChangeRecordEo, (Object)recordRespDto);
                records.add(recordRespDto);
            }
        }
        return records;
    }

    @Override
    @Transactional
    public RestResponse<PageInfo<Object>> getSortingContractReportTovoid(@ApiParam(value="") @Valid @RequestBody(required=false) SortingContractReportToVoidReqDto sortingContractReportToVoidReqDto) {
        SortingContractEo example = new SortingContractEo();
        Long id = sortingContractReportToVoidReqDto.getId();
        example.setId(id);
        SortingContractEo sortingContractEo = (SortingContractEo)this.sortingContractDas.selectOne((BaseEo)example);
        this.validateExist(sortingContractEo);
        sortingContractEo.setStatus(SortingContractStatusEnum.TO_VOID.getCode());
        this.sortingContractDas.updateSelective((BaseEo)sortingContractEo);
        return new RestResponse();
    }

    private void validateExist(Object sortingContractEo) {
        if (Objects.isNull(sortingContractEo)) {
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.RECORD_NOT_EXIST);
        }
    }
}

