/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.constant;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;

public enum OrderSourceModelEnum {
    THIRDPARTY("THIRDPARTY", "\u7b2c\u4e09\u65b9\u8ba2\u5355"),
    INNER("INNER", "\u5185\u90e8\u8ba2\u5355"),
    B2B("B2B", "B2B\u8ba2\u5355", INNER),
    USER_SERVICE("USER_SERVICE", "\u7528\u670d", INNER),
    JD("jingdong", "\u4eac\u4e1c", THIRDPARTY),
    TB("taobao", "\u6dd8\u5b9d", THIRDPARTY),
    PDD("pdd", "\u62fc\u591a\u591a", THIRDPARTY),
    DY("douyin", "\u6296\u97f3", THIRDPARTY),
    MALL("MALL", "\u5b98\u7f51", THIRDPARTY),
    OA("OA", "OA", INNER),
    POS("POS", "POS", INNER),
    XX("XX", "\u7ebf\u4e0b", INNER);

    private String code;
    private String desc;
    private OrderSourceModelEnum source;

    private OrderSourceModelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private OrderSourceModelEnum(String code, String desc, OrderSourceModelEnum source) {
        this.code = code;
        this.desc = desc;
        this.source = source;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public OrderSourceModelEnum getSource() {
        return this.source;
    }

    public static String convertSource(String code) {
        OrderSourceModelEnum sourceModelEnum = OrderSourceModelEnum.enumOf(code);
        OrderSourceModelEnum enumSource = sourceModelEnum.getSource();
        if (enumSource != null) {
            return enumSource.getCode();
        }
        return sourceModelEnum.getCode();
    }

    public static OrderSourceModelEnum enumOf(String code) {
        for (OrderSourceModelEnum typeEnum : OrderSourceModelEnum.values()) {
            if (!typeEnum.getCode().equalsIgnoreCase(code)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", code, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }
}

