/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.constant;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusFlowTemplate;
import com.dtyunxi.yundt.cube.center.trade.api.constant.statusflows.BdInnerTradeStatusFlow;
import com.dtyunxi.yundt.cube.center.trade.api.constant.statusflows.BdThirdpartyTradeStatusFlow;
import com.dtyunxi.yundt.cube.center.trade.api.constant.statusflows.TcTradeStatusFlow;
import com.dtyunxi.yundt.cube.center.trade.api.constant.statusflows.VirtualOrderTradeStatusFlow;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import java.util.List;
import java.util.Map;

public enum TradeStatusFlowSelector {
    TC("TC"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return TcTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return TcTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    BD("BD"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return BdThirdpartyTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return BdThirdpartyTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    INNER("INNER"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return BdInnerTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return BdInnerTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    VIRTUAL("VIRTUAL"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return VirtualOrderTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return VirtualOrderTradeStatusFlow.STATUS_LIST;
        }
    };

    private String code;

    private TradeStatusFlowSelector(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static TradeStatusFlowSelector enumOf(String code) {
        for (TradeStatusFlowSelector typeEnum : TradeStatusFlowSelector.values()) {
            if (!typeEnum.getCode().equals(code)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", code, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }

    public abstract Map<String, SaleOrderStatusFlowTemplate> getLookup();

    public abstract List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList();
}

